/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Reference;

public class FhirUtil {
    public static void setVersionedIdPartLastUpdatedMeta(Class<?> resourceClass, DomainResource domainResource, Identifiable localObject) {
        domainResource.setId((IIdType)new IdDt(resourceClass.getSimpleName(), localObject.getId(), Long.toString(localObject.getLastupdate())));
        domainResource.getMeta().setLastUpdated((Date)FhirUtil.getLastUpdateAsDate(localObject.getLastupdate()).orElse(null));
        domainResource.getMeta().setVersionId(Long.toString(localObject.getLastupdate()));
    }

    public static Optional<Date> getLastUpdateAsDate(Long lastUpdate) {
        if (lastUpdate != null) {
            Date lastUpdateDate = Date.from(FhirUtil.getLastUpdateAsZonedDateTime(lastUpdate).get().toInstant());
            return Optional.of(lastUpdateDate);
        }
        return Optional.empty();
    }

    public static Optional<ZonedDateTime> getLastUpdateAsZonedDateTime(Long lastUpdate) {
        if (lastUpdate != null) {
            ZonedDateTime zonedDateTime = Instant.ofEpochMilli(lastUpdate).atZone(ZoneId.systemDefault());
            return Optional.of(zonedDateTime);
        }
        return Optional.empty();
    }

    public static Reference getReference(Identifiable identifiable) {
        if (identifiable == null) {
            return null;
        }
        String resourceType = null;
        if (identifiable instanceof IPatient) {
            resourceType = "Patient";
        } else if (identifiable instanceof IEncounter) {
            resourceType = "Encounter";
        } else if (identifiable instanceof IBilled) {
            resourceType = "ChargeItem";
        } else if (identifiable instanceof IMandator) {
            resourceType = "Practitioner";
        }
        if (resourceType != null) {
            return new Reference((IIdType)new IdDt(resourceType, identifiable.getId()));
        }
        throw new IllegalArgumentException(identifiable.getClass().getCanonicalName());
    }

    public static Optional<String> getId(Reference reference) {
        if (reference != null) {
            if (StringUtils.isNotBlank((CharSequence)reference.getReference())) {
                return Optional.of(reference.getReferenceElement().getIdPart());
            }
            if (StringUtils.isNotBlank((CharSequence)reference.getId())) {
                if (reference.getId().startsWith("/")) {
                    return Optional.of(reference.getId().substring(1));
                }
                return Optional.of(reference.getId());
            }
        }
        return Optional.empty();
    }

    public static Money toFhir(ch.rgw.tools.Money total) {
        Money money = new Money();
        money.setValue(total.doubleValue());
        money.setCurrency("CHF");
        return money;
    }

    public static Optional<String> getLocalId(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
            if (id.contains("/")) {
                if (id.contains("/_history")) {
                    id = id.substring(0, id.indexOf("/_history"));
                }
                return Optional.of(id.substring(id.lastIndexOf(47) + 1));
            }
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public static boolean isReferenceType(Reference reference, String type) {
        if (reference.getReferenceElement().hasResourceType()) {
            return reference.getReferenceElement().getResourceType().equals(type);
        }
        if (reference.hasType()) {
            return reference.getType().equals(type);
        }
        return false;
    }

    public static Optional<String> getCodeFromConceptList(String system, List<CodeableConcept> list) {
        if (list != null && !list.isEmpty()) {
            for (CodeableConcept concept : list) {
                Optional<String> found = FhirUtil.getCodeFromCodingList(system, concept.getCoding());
                if (!found.isPresent()) continue;
                return found;
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getCodeFromCodingList(String system, List<Coding> list) {
        if (list != null && !list.isEmpty()) {
            for (Coding coding : list) {
                if (!coding.getSystem().equals(system) || coding.getCode() == null) continue;
                return Optional.of(coding.getCode());
            }
        }
        return Optional.empty();
    }
}

