/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jcifs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Credentials;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={URLStreamHandlerService.class}, property={"url.handler.protocol:String=smb"})
public class SmbURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    static {
        try {
            Properties properties = new Properties();
            if (System.getProperty("jcifs.smb.client.responseTimeout") == null) {
                properties.setProperty("jcifs.smb.client.responseTimeout", "15000");
            }
            SingletonContext.init((Properties)properties);
        }
        catch (CIFSException e) {
            e.printStackTrace();
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        SingletonContext context = SingletonContext.getInstance();
        NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication((CIFSContext)context, url.getUserInfo());
        CIFSContext credentials = SingletonContext.getInstance().withCredentials((Credentials)ntlmPasswordAuthentication);
        String _url = this.replaceEach(url.toExternalForm());
        this.logger.debug("openConnection [{}] [{}]", (Object)url, (Object)_url);
        return new SmbFile(_url, credentials);
    }

    private String replaceEach(String externalForm) throws UnsupportedEncodingException {
        externalForm = externalForm.replaceAll("%25", "%");
        return URLDecoder.decode(externalForm, "UTF-8");
    }
}

