/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.ui.mediorder.MediorderEntryState;
import java.util.List;

public class MediorderPartUtil {
    /*
     * WARNING - void declaration
     */
    public static String createMediorderEntryOutreachLabel(Object object) {
        Object object2 = object;
        if (object2 instanceof IStockEntry) {
            void stockEntry;
            IStockEntry iStockEntry = (IStockEntry)object2;
            IStockEntry cfr_ignored_0 = (IStockEntry)object2;
            Double resultDays = null;
            IPatient patient = stockEntry.getStock().getOwner().asIPatient();
            List lMedication = patient.getMedication(null);
            for (IPrescription prescription : lMedication) {
                if (!prescription.getArticle().equals(stockEntry.getArticle())) continue;
                float dailyDosageAsFloat = MedicationServiceHolder.get().getDailyDosageAsFloat(prescription);
                int maximumStock = stockEntry.getMaximumStock();
                resultDays = Math.floor((float)(stockEntry.getArticle().getPackageSize() * maximumStock) / dailyDosageAsFloat);
            }
            return resultDays != null ? String.valueOf(String.valueOf(resultDays.intValue())) + " Tage" : "";
        }
        return "?";
    }

    /*
     * WARNING - void declaration
     */
    public static String createMediorderEntryStateLabel(Object object) {
        Object object2 = object;
        if (object2 instanceof IStockEntry) {
            void stockEntry;
            IStockEntry iStockEntry = (IStockEntry)object2;
            IStockEntry cfr_ignored_0 = (IStockEntry)object2;
            return MediorderPartUtil.determineState((IStockEntry)stockEntry).getLocaleText();
        }
        return "?";
    }

    public static MediorderEntryState determineState(IStockEntry stockEntry) {
        int maximumStock = stockEntry.getMaximumStock();
        int minimumStock = stockEntry.getMinimumStock();
        int currentStock = stockEntry.getCurrentStock();
        MediorderEntryState state = MediorderEntryState.INVALID;
        if (maximumStock > 0 && minimumStock > 0 && currentStock > 0) {
            state = currentStock == minimumStock ? MediorderEntryState.IN_STOCK : MediorderEntryState.PARTIALLY_IN_STOCK;
        } else if (maximumStock > 0 && minimumStock > 0 && currentStock == 0) {
            IOrderEntry order = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(stockEntry);
            if (order != null) {
                state = minimumStock == maximumStock ? MediorderEntryState.ORDERED : MediorderEntryState.PARTIALLY_ORDERED;
                state.setOrderEntry(order);
            } else {
                state = minimumStock == maximumStock ? MediorderEntryState.REQUESTED : MediorderEntryState.PARTIALLY_REQUESTED;
            }
        } else if (maximumStock == 0 && minimumStock > 0 && currentStock == 0) {
            state = MediorderEntryState.AWAITING_REQUEST;
        }
        state.setStockEntry(stockEntry);
        return state;
    }
}

