/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMedicationService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.ui.e4.dnd.GenericObjectDropTarget;
import ch.elexis.core.ui.e4.parts.IRefreshablePart;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.mediorder.MediorderPartUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MediorderPart
implements IRefreshablePart {
    @Inject
    private EPartService partService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IContextService contextService;
    @Inject
    IStockService stockService;
    @Inject
    IOrderService orderService;
    @Inject
    IStoreToStringService storeToStringService;
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    IMedicationService medicationService;
    private TableViewer tableViewer;
    private TableViewer tableViewerDetails;
    private StockComparator stockComparator;
    private MedicationComparator medicationComparator;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private WritableValue<IStock> selectedDetailStock = new WritableValue();

    @Focus
    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public void refresh(Map<Object, Object> filterParameters) {
        Object firstElement = this.tableViewer.getStructuredSelection().getFirstElement();
        this.tableViewer.setInput(this.getPatientStocksWithStockEntry());
        this.tableViewer.refresh(true);
        if (this.tableViewer.contains(firstElement)) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstElement));
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.stockComparator = new StockComparator();
        this.medicationComparator = new MedicationComparator();
        this.createPatientorderListViewer(parent);
        this.createPatientorderDetailViewer(parent);
        this.addDragAndDrop();
        menuService.registerContextMenu((Object)this.tableViewer.getTable(), "ch.elexis.core.ui.mediorder.popupmenu.viewer");
        menuService.registerContextMenu((Object)this.tableViewerDetails.getTable(), "ch.elexis.core.ui.mediorder.popupmenu.viewerdetails");
        this.tableViewer.setInput(this.getPatientStocksWithStockEntry());
    }

    private void createPatientorderListViewer(Composite parent) {
        Composite cStockTable = new Composite(parent, 0);
        cStockTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout = new TableColumnLayout();
        cStockTable.setLayout((Layout)tcLayout);
        this.tableViewer = new TableViewer(cStockTable, 65536);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setComparator((ViewerComparator)this.stockComparator);
        this.tableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            this.selectedDetailStock.setValue((Object)((IStock)selection.getFirstElement()));
        });
        TableViewerColumn tvcPatientNumber = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientNumber.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStock stock = (IStock)element;
                return stock.getOwner().getCode();
            }
        });
        TableColumn tblclmntvcPatientNumber = tvcPatientNumber.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientNumber, (ColumnLayoutData)new ColumnPixelData(70, true, true));
        tblclmntvcPatientNumber.setText("Patient-Nr");
        tblclmntvcPatientNumber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(0);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientLastName = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientLastName.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStock)e).getOwner().getLastName()));
        TableColumn tblclmntvcPatientLastName = tvcPatientLastName.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientLastName, (ColumnLayoutData)new ColumnPixelData(110, true, true));
        tblclmntvcPatientLastName.setText("Name");
        tblclmntvcPatientLastName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(1);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientFirstName = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientFirstName.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStock)e).getOwner().getFirstName()));
        TableColumn tblclmntvcPatientFirstName = tvcPatientFirstName.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientFirstName, (ColumnLayoutData)new ColumnPixelData(110, true, true));
        tblclmntvcPatientFirstName.setText("Vorname");
        tblclmntvcPatientFirstName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(2);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientBirthdate = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientBirthdate.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStock stock = (IStock)element;
                LocalDateTime birthdate = stock.getOwner().getDateOfBirth();
                return birthdate.format(MediorderPart.this.dateFormatter);
            }
        });
        TableColumn tblclmntvcPatientBirthdate = tvcPatientBirthdate.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientBirthdate, (ColumnLayoutData)new ColumnPixelData(90, true, true));
        tblclmntvcPatientBirthdate.setText("Geburtsdatum");
        tblclmntvcPatientBirthdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(3);
                MediorderPart.this.refresh();
            }
        });
    }

    private void createPatientorderDetailViewer(Composite parent) {
        Composite cDetails_table = new Composite(parent, 0);
        cDetails_table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout_cDetails = new TableColumnLayout();
        cDetails_table.setLayout((Layout)tcLayout_cDetails);
        this.tableViewerDetails = new TableViewer(cDetails_table, 65538);
        Table tableDetails = this.tableViewerDetails.getTable();
        tableDetails.setHeaderVisible(true);
        this.tableViewerDetails.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.selectedDetailStock.addChangeListener(sel -> {
            IStock stock = (IStock)this.selectedDetailStock.getValue();
            if (stock != null) {
                List lStocks = stock.getStockEntries();
                this.tableViewerDetails.setInput((Object)lStocks);
            } else {
                this.tableViewerDetails.setInput(null);
            }
        });
        this.tableViewerDetails.setComparator((ViewerComparator)this.medicationComparator);
        this.tableViewerDetails.addDoubleClickListener(event -> {
            IStockEntry entry;
            IOrderEntry orderEntry;
            Object selectedElement;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IStockEntry && (orderEntry = this.orderService.findOpenOrderEntryForStockEntry(entry = (IStockEntry)selectedElement)) != null) {
                MPart part = this.partService.findPart("ch.elexis.BestellenView");
                if (part == null) {
                    part = this.partService.showPart("ch.elexis.BestellenView", EPartService.PartState.CREATE);
                }
                this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                this.eventBroker.post("BestellenView/orderSelected", (Object)orderEntry.getOrder());
            }
        });
        TableViewerColumn tvcMedication = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedication.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStockEntry)e).getArticle().getLabel()));
        TableColumn tblclmntvcMedication = tvcMedication.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedication, (ColumnLayoutData)new ColumnPixelData(180, true, true));
        tblclmntvcMedication.setText("Medikament");
        tblclmntvcMedication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.medicationComparator.setColumn(0);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcMedicationDosage = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationDosage.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            IPatient patient = entry.getStock().getOwner().asIPatient();
            List lMedication = patient.getMedication(null);
            for (IPrescription prescription : lMedication) {
                if (!prescription.getArticle().equals(entry.getArticle())) continue;
                return prescription.getDosageInstruction();
            }
            return "";
        }));
        TableColumn tblclmntvcMedicationDosage = tvcMedicationDosage.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationDosage, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        tblclmntvcMedicationDosage.setText("Dosis");
        TableViewerColumn tvcMedicationClearance = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationClearance.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            return String.valueOf(entry.getMaximumStock());
        }));
        tvcMedicationClearance.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewerDetails){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MediorderPart.this.tableViewerDetails.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                IStockEntry entry = (IStockEntry)element;
                return String.valueOf(entry.getMaximumStock());
            }

            protected void setValue(Object element, Object value) {
                IStockEntry entry = (IStockEntry)element;
                String amount = (String)value;
                entry.setMaximumStock(Integer.parseInt(amount));
                MediorderPart.this.coreModelService.save((Identifiable)entry);
                MediorderPart.this.tableViewerDetails.refresh(true);
            }
        });
        TableColumn tblclmntvcMedicationClearance = tvcMedicationClearance.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationClearance, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        tblclmntvcMedicationClearance.setImage(Images.IMG_TICK.getImage());
        tblclmntvcMedicationClearance.setText("Freigabe");
        tblclmntvcMedicationClearance.setToolTipText("Anzahl zur Anforderung freigegeben");
        TableViewerColumn tvcMedicationAmount = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationAmount.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            return String.valueOf(entry.getMinimumStock());
        }));
        tvcMedicationAmount.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewerDetails){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MediorderPart.this.tableViewerDetails.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                IStockEntry entry = (IStockEntry)element;
                return String.valueOf(entry.getMinimumStock());
            }

            protected void setValue(Object element, Object value) {
                IStockEntry entry = (IStockEntry)element;
                String amount = (String)value;
                entry.setMinimumStock(Integer.parseInt(amount));
                MediorderPart.this.coreModelService.save((Identifiable)entry);
                MediorderPart.this.tableViewerDetails.refresh(true);
            }
        });
        TableColumn tblclmntvcMedicationAmount = tvcMedicationAmount.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationAmount, (ColumnLayoutData)new ColumnPixelData(70, true, true));
        tblclmntvcMedicationAmount.setText("Angefordert");
        tblclmntvcMedicationAmount.setImage(Images.IMG_ACHTUNG.getImage());
        tblclmntvcMedicationAmount.setToolTipText("Anzahl angefordert");
        TableViewerColumn tvcMediorderEntryOutreach = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMediorderEntryOutreach.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(MediorderPartUtil::createMediorderEntryOutreachLabel));
        TableColumn tblclmntvcMedicationAmountDay = tvcMediorderEntryOutreach.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationAmountDay, (ColumnLayoutData)new ColumnPixelData(90, true, true));
        tblclmntvcMedicationAmountDay.setText("Verbrauchsdauer");
        TableViewerColumn tvcMediorderEntryState = new TableViewerColumn(this.tableViewerDetails, 0);
        TableColumn tblclmntvcMedicationOrdered = tvcMediorderEntryState.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationOrdered, (ColumnLayoutData)new ColumnPixelData(130, true, true));
        tblclmntvcMedicationOrdered.setText("Bestellt");
        tblclmntvcMedicationOrdered.setImage(Images.IMG_PERSPECTIVE_ORDERS.getImage());
        tblclmntvcMedicationOrdered.setToolTipText("Anzahl bestellt");
        tvcMediorderEntryState.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(MediorderPartUtil::createMediorderEntryStateLabel));
    }

    private void addDragAndDrop() {
        new GenericObjectDropTarget(this.storeToStringService, (Control)this.tableViewer.getTable(), (list, event) -> {
            list.forEach(entry -> {
                Object object = entry;
                if (object instanceof IArticle) {
                    void article;
                    IArticle iArticle = (IArticle)object;
                    IArticle cfr_ignored_0 = (IArticle)object;
                    this.addMedicationOrderEntryToStock(null, (IArticle)article);
                }
            });
            this.refresh();
        });
        new GenericObjectDropTarget(this.storeToStringService, (Control)this.tableViewerDetails.getTable(), (list, event) -> {
            list.forEach(entry -> {
                Object object = entry;
                if (object instanceof IArticle) {
                    void article;
                    IArticle iArticle = (IArticle)object;
                    IArticle cfr_ignored_0 = (IArticle)object;
                    IStock selectedStock = (IStock)this.tableViewer.getStructuredSelection().getFirstElement();
                    this.addMedicationOrderEntryToStock(selectedStock, (IArticle)article);
                }
            });
            this.refresh();
        });
    }

    private void addMedicationOrderEntryToStock(IStock stock, IArticle article) {
        IStockEntry stockEntry;
        if (StringUtils.isBlank((CharSequence)article.getGtin())) {
            return;
        }
        if (stock == null) {
            IPatient patient = (IPatient)this.contextService.getActivePatient().get();
            this.stockService.setEnablePatientStock(patient, true);
            stock = (IStock)this.stockService.getPatientStock(patient).get();
        }
        if ((stockEntry = this.stockService.findStockEntryForArticleInStock(stock, article)) != null) {
            int value = stockEntry.getMinimumStock() + 1;
            stockEntry.setMinimumStock(value);
            value = stockEntry.getMaximumStock() + 1;
            stockEntry.setMaximumStock(value);
        } else {
            stockEntry = this.stockService.storeArticleInStock(stock, article);
            stockEntry.setCurrentStock(0);
            stockEntry.setMinimumStock(1);
            stockEntry.setMaximumStock(1);
        }
        this.coreModelService.save((Identifiable)stockEntry);
    }

    private List<IStock> getPatientStocksWithStockEntry() {
        ArrayList<IStock> lStockWithEntry = new ArrayList<IStock>();
        IQuery query = this.coreModelService.getQuery(IStock.class);
        query.and("id", IQuery.COMPARATOR.LIKE, (Object)"PatientStock-%");
        List lStock = query.execute();
        for (IStock stock : lStock) {
            if (stock.getStockEntries().isEmpty()) continue;
            lStockWithEntry.add(stock);
        }
        return lStockWithEntry;
    }

    public List<IStockEntry> getSelectedStockEntries() {
        return this.tableViewerDetails.getStructuredSelection().toList();
    }

    public IStock getSelectedStock() {
        return (IStock)this.selectedDetailStock.getValue();
    }

    public class MedicationComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private int direction = -1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IStockEntry stockEntry1 = (IStockEntry)o1;
            IStockEntry stockEntry2 = (IStockEntry)o2;
            switch (this.propertyIndex) {
                case 0: {
                    String articleName1 = stockEntry1.getArticle().getName();
                    String articleName2 = stockEntry2.getArticle().getName();
                    return Objects.compare(articleName1, articleName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
            }
            return super.compare(viewer, o1, o2);
        }
    }

    public class StockComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private int direction = -1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IStock ts1 = (IStock)o1;
            IStock ts2 = (IStock)o2;
            switch (this.propertyIndex) {
                case 0: {
                    Integer patientNr1 = Integer.valueOf(ts1.getId().substring(13));
                    Integer patientNr2 = Integer.valueOf(ts2.getId().substring(13));
                    return Objects.compare(patientNr1, patientNr2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 1: {
                    String patientName1 = ts1.getOwner().getLastName();
                    String patientName2 = ts2.getOwner().getLastName();
                    return Objects.compare(patientName1, patientName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 2: {
                    String patientFirstName1 = ts1.getOwner().getFirstName();
                    String patientFirstName2 = ts2.getOwner().getFirstName();
                    return Objects.compare(patientFirstName1, patientFirstName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 3: {
                    LocalDateTime birthDate1 = ts1.getOwner().getDateOfBirth();
                    return birthDate1.compareTo(ts2.getOwner().getDateOfBirth()) * this.direction;
                }
            }
            return super.compare(viewer, o1, o2);
        }
    }
}

