/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Presets {
    private static final String IMPORT_XID = "elexis.ch/importPresets";
    private static final String KONTAKTID = "elexis.ch/importPresets/KID";
    private static Logger log = LoggerFactory.getLogger(Presets.class);
    public static final String INSURANCE = Messages.Core_Costbearer;
    public static final String INSURANCE_NUMBER = Messages.Core_Insurance_Number;

    static {
        Xid.localRegisterXIDDomainIfNotExists((String)KONTAKTID, (String)Messages.Presets_PreviousID, (int)1);
    }

    public static final boolean importUniversal(ExcelWrapper exw, boolean bKeepID, IProgressMonitor moni) {
        exw.setFieldTypes(new Class[]{Integer.class, Integer.class, Integer.class, String.class, String.class, String.class, String.class, TimeTool.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class});
        int first = exw.getFirstRow();
        int last = exw.getLastRow();
        moni.beginTask(Messages.Presets_ImportingContacts, last - first);
        int counter = 0;
        int i = exw.getFirstRow() + 1;
        while (i <= exw.getLastRow()) {
            block10: {
                Organisation k;
                String natel;
                String ort;
                String plz;
                String strasse;
                String EAN;
                String[] row;
                block12: {
                    Patient pat;
                    String zusatz;
                    String bez2;
                    String bez1;
                    String titel;
                    String ispat;
                    String ID;
                    block11: {
                        row = exw.getRow(i).toArray(new String[0]);
                        if (row == null) break block10;
                        ID = StringTool.getSafe((String[])row, (int)0);
                        EAN = StringTool.getSafe((String[])row, (int)18);
                        if (StringTool.isNothing((Object)ID)) {
                            ID = EAN;
                        }
                        String typ = StringTool.getSafe((String[])row, (int)1);
                        ispat = StringTool.getSafe((String[])row, (int)2);
                        titel = StringTool.getSafe((String[])row, (int)3);
                        bez1 = StringTool.getSafe((String[])row, (int)4);
                        bez2 = StringTool.getSafe((String[])row, (int)5);
                        zusatz = StringTool.getSafe((String[])row, (int)6);
                        strasse = StringTool.getSafe((String[])row, (int)14);
                        plz = StringTool.getSafe((String[])row, (int)15);
                        ort = StringTool.getSafe((String[])row, (int)16);
                        natel = StringTool.getSafe((String[])row, (int)13);
                        k = null;
                        if (!StringTool.isNothing((Object)typ) && !typ.equals("0")) break block11;
                        k = KontaktMatcher.findOrganisation((String)bez1, null, (String)strasse, (String)plz, (String)ort, (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.CREATE);
                        if (k == null) break block10;
                        k.set("Zusatz1", bez2);
                        k.set("Bezeichnung3", zusatz);
                        break block12;
                    }
                    String sex = StringTool.getSafe((String[])row, (int)8);
                    String gebdat = StringTool.getSafe((String[])row, (int)7);
                    if (ispat.equalsIgnoreCase("1") && (pat = (Patient)Xid.findObject((String)KONTAKTID, (String)ID)) == null) {
                        pat = new Patient(bez1, bez2, gebdat, sex.toLowerCase().startsWith("m") ? "m" : "w");
                        pat.set("PatientNr", ID);
                        pat.addXid(KONTAKTID, ID, false);
                    }
                    if ((k = KontaktMatcher.findPerson((String)bez1, (String)bez2, (String)gebdat, (String)sex, (String)strasse, (String)plz, (String)ort, (String)natel, (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.CREATE)) == null) break block10;
                    k.set("Titel", titel);
                    k.set("Zusatz", zusatz);
                }
                moni.subTask(k.getLabel());
                k.set(new String[]{"E-Mail", "Website", "Telefon1", "Telefon2", "Natel", "Strasse", "Plz", "Ort", "Anschrift"}, new String[]{StringTool.getSafe((String[])row, (int)9), StringTool.getSafe((String[])row, (int)10), StringTool.getSafe((String[])row, (int)11), StringTool.getSafe((String[])row, (int)12), natel, strasse, plz, ort, StringTool.getSafe((String[])row, (int)17)});
                if (EAN.matches("[0-9]{13,13}")) {
                    k.addXid("www.xid.ch/id/ean", EAN, true);
                }
                moni.worked(1);
                if (moni.isCanceled()) {
                    return false;
                }
                if (counter++ > 200) {
                    PersistentObject.clearCache();
                    System.gc();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    counter = 0;
                }
            }
            ++i;
        }
        moni.done();
        return true;
    }

    public static boolean importHertel(ExcelWrapper exw, boolean bKeepID, IProgressMonitor moni) {
        exw.setFieldTypes(new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, TimeTool.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, TimeTool.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, TimeTool.class, String.class, String.class, String.class, String.class});
        int first = exw.getFirstRow();
        int last = exw.getLastRow();
        moni.beginTask("Import Patientendaten Hertel", last - first);
        int i = first + 1;
        while (i < last) {
            Fall fall;
            Kontakt k;
            List res;
            Query qbe;
            String[] row = exw.getRow(i).toArray(new String[0]);
            String name = StringTool.getSafe((String[])row, (int)1);
            String vorname = StringTool.getSafe((String[])row, (int)2);
            String sex = StringTool.getSafe((String[])row, (int)3);
            String anrede = StringTool.getSafe((String[])row, (int)4);
            String zivilstand = StringTool.getSafe((String[])row, (int)5);
            String titel = StringTool.getSafe((String[])row, (int)6);
            String gebdat = StringTool.getSafe((String[])row, (int)7);
            String arzt = StringTool.getSafe((String[])row, (int)8);
            String strasse = StringTool.getSafe((String[])row, (int)9);
            String telp1 = StringTool.getSafe((String[])row, (int)10);
            String telp2 = StringTool.getSafe((String[])row, (int)11);
            String tel3 = StringTool.getSafe((String[])row, (int)12);
            String tel4 = StringTool.getSafe((String[])row, (int)13);
            String email = StringTool.getSafe((String[])row, (int)14);
            String zusatz = StringTool.getSafe((String[])row, (int)15);
            String patsel = StringTool.getSafe((String[])row, (int)16);
            String briefanr = StringTool.getSafe((String[])row, (int)17);
            String letzerk = StringTool.getSafe((String[])row, (int)18);
            String frei1 = StringTool.getSafe((String[])row, (int)19);
            String frei2 = StringTool.getSafe((String[])row, (int)20);
            String frei3 = StringTool.getSafe((String[])row, (int)21);
            String reiter = StringTool.getSafe((String[])row, (int)22);
            String ort = StringTool.getSafe((String[])row, (int)23);
            String plz = StringTool.getSafe((String[])row, (int)24);
            String land = StringTool.getSafe((String[])row, (int)25);
            String unfallnr = StringTool.getSafe((String[])row, (int)26);
            String kknr = StringTool.getSafe((String[])row, (int)27);
            String ivnr = StringTool.getSafe((String[])row, (int)28);
            String zusatznr = StringTool.getSafe((String[])row, (int)29);
            String ahvnr = StringTool.getSafe((String[])row, (int)30);
            String covercardnr = StringTool.getSafe((String[])row, (int)31);
            String covercardzus = StringTool.getSafe((String[])row, (int)32);
            String erfasstam = StringTool.getSafe((String[])row, (int)33);
            String arztn = StringTool.getSafe((String[])row, (int)34);
            String unfallvers = StringTool.getSafe((String[])row, (int)35);
            String kk = StringTool.getSafe((String[])row, (int)36);
            String iv = StringTool.getSafe((String[])row, (int)37);
            Patient pat = (Patient)Xid.findObject((String)KONTAKTID, (String)row[0]);
            if (pat == null) {
                pat = new Patient(name, vorname, gebdat, sex.toLowerCase().startsWith("m") ? "m" : "w");
                pat.set("PatientNr", row[0]);
                pat.addXid(KONTAKTID, row[0], false);
            }
            moni.subTask(pat.getLabel());
            pat.set(new String[]{"Strasse", "Plz", "Ort", "Land", "Telefon1", "Telefon2", "Natel", "E-Mail", "Titel", "Gruppe", "Zusatz"}, new String[]{strasse, plz, ort, land.equalsIgnoreCase(Messages.Presets_Switzerland) ? "CH" : "", telp1, telp2, tel3, email, titel, arztn, zusatz});
            if (!StringTool.isNothing((Object)ahvnr)) {
                pat.addXid("www.ahv.ch/xid", ahvnr, true);
            }
            if (!StringTool.isNothing((Object)kk)) {
                qbe = new Query(Kontakt.class);
                qbe.add("Bezeichnung1", "=", kk);
                res = qbe.execute();
                k = null;
                if (!res.isEmpty()) {
                    k = (Kontakt)res.get(0);
                } else {
                    k = new Organisation(kk, Messages.Core_KK_Short);
                    k.set("Kuerzel", Messages.Core_KK_Short);
                }
                fall = pat.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Messages.Case_KVG_Short);
                fall.setGarant((Kontakt)pat);
                fall.setRequiredContact(INSURANCE, k);
                fall.setRequiredString(INSURANCE_NUMBER, kknr);
            }
            if (!StringTool.isNothing((Object)unfallvers)) {
                qbe = new Query(Kontakt.class);
                qbe.add("Bezeichnung1", "=", unfallvers);
                res = qbe.execute();
                k = null;
                if (!res.isEmpty()) {
                    k = (Kontakt)res.get(0);
                } else {
                    k = new Organisation(unfallvers, Messages.Case_UVG_Short);
                    k.set("Kuerzel", Messages.Case_UVG_Short);
                }
                fall = pat.neuerFall(Messages.Core_Accident, Messages.Core_Accident, Messages.Case_UVG_Short);
                fall.setGarant(k);
                fall.setRequiredContact(INSURANCE, k);
                fall.setRequiredString(Messages.Core_Accidentnumber, unfallnr);
            }
            moni.worked(1);
            ++i;
        }
        moni.done();
        return true;
    }

    public static boolean importRussi(ExcelWrapper exw, boolean bKeepID, IProgressMonitor moni) {
        exw.setFieldTypes(new Class[]{Integer.class, String.class, TimeTool.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
        int first = exw.getFirstRow();
        int last = exw.getLastRow();
        moni.beginTask("Import Patientendaten Russi", last - first);
        int i = first + 1;
        while (i < last) {
            String[] row = exw.getRow(i).toArray(new String[0]);
            if (Xid.findObject((String)KONTAKTID, (String)row[0]) == null) {
                Fall fall;
                Organisation org;
                String[] name = StringTool.getSafe((String[])row, (int)1).split("\\s", 2);
                String gdraw = StringTool.getSafe((String[])row, (int)2);
                String gebdat = new TimeTool(gdraw).toString(4);
                String gender = StringTool.getSafe((String[])row, (int)9).startsWith("W") ? "w" : "m";
                Patient pat = new Patient(name[0], name.length > 1 ? name[1] : "-", gebdat, gender);
                String patcode = pat.getLabel() + pat.getPatCode();
                moni.subTask(patcode);
                log.info(patcode);
                pat.addXid(KONTAKTID, row[0], false);
                Anschrift an = pat.getAnschrift();
                an.setStrasse(StringTool.getSafe((String[])row, (int)3));
                an.setPlz(StringTool.getSafe((String[])row, (int)4));
                an.setOrt(StringTool.getSafe((String[])row, (int)5));
                pat.setAnschrift(an);
                pat.set("Telefon1", StringTool.getSafe((String[])row, (int)6));
                pat.set("Natel", StringTool.getSafe((String[])row, (int)7));
                pat.set("Telefon2", StringTool.getSafe((String[])row, (int)8));
                if (!StringTool.isNothing((Object)StringTool.getSafe((String[])row, (int)10))) {
                    org = KontaktMatcher.findOrganisation((String)row[10], null, (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.CREATE);
                    fall = pat.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Messages.Case_KVG_Short);
                    fall.setRequiredContact(Messages.Core_Costbearer, (Kontakt)org);
                    fall.setGarant((Kontakt)pat);
                }
                if (!StringTool.isNothing((Object)StringTool.getSafe((String[])row, (int)11))) {
                    org = KontaktMatcher.findOrganisation((String)row[11], null, (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.CREATE);
                    fall = pat.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Messages.Case_UVG_Short);
                    fall.setRequiredContact(Messages.Core_Costbearer, (Kontakt)org);
                    fall.setGarant((Kontakt)org);
                }
                moni.worked(1);
            }
            ++i;
        }
        moni.done();
        return true;
    }
}

