/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.data.service.PoCodeElementServiceHolder;
import ch.elexis.core.data.services.ICodeElementService;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.elexis.data.dto.CodeElementDTO;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Leistungsblock
extends PersistentObject
implements ICodeElement {
    public static final String TABLENAME = "LEISTUNGSBLOCK";
    public static final String VERSION_ID = "Version";
    public static final String FLD_MANDANT_ID = "MandantID";
    public static final String FLD_NAME = "Name";
    public static final String FLD_LEISTUNGEN = "Leistungen";
    public static final String FLD_MACRO = "Macro";
    public static final String FLD_CODEELEMENTS = "codeelements";
    public static final String XIDDOMAIN = "www.xid.ch/id/elexis_leistungsblock";
    public static final String XIDDOMAIN_SIMPLENAME = "Leistungsblock";
    private static final String SEPARATOR = ":=:";

    static {
        Leistungsblock.addMapping(TABLENAME, FLD_MANDANT_ID, FLD_NAME, FLD_LEISTUNGEN, FLD_MACRO, FLD_CODEELEMENTS);
        Xid.localRegisterXIDDomainIfNotExists(XIDDOMAIN, XIDDOMAIN_SIMPLENAME, 5);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    private static List<ICodeElement> getLeistungen(Leistungsblock leistungsblock) {
        ArrayList<ICodeElement> lst = new ArrayList<ICodeElement>();
        try {
            lst = new ArrayList();
            byte[] compressed = leistungsblock.getBinary(FLD_LEISTUNGEN);
            if (compressed != null) {
                String storable = new String(CompEx.expand((byte[])compressed), "UTF-8");
                String[] stringArray = storable.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    ICodeElement iCodeElement = (ICodeElement)((Object)CoreHub.poFactory.createFromString(p));
                    if (iCodeElement != null) {
                        lst.add(iCodeElement);
                    } else {
                        LoggerFactory.getLogger(Leistungsblock.class).warn("Could not load code [" + p + "]");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return lst;
    }

    protected Leistungsblock(String id) {
        super(id);
    }

    protected Leistungsblock() {
    }

    public Leistungsblock(String Name, String mandatorId) {
        this.create(null);
        String[] f = new String[]{FLD_NAME, FLD_MANDANT_ID, FLD_MACRO};
        this.set(f, Name, mandatorId, Name);
    }

    public static Leistungsblock load(String id) {
        return new Leistungsblock(id);
    }

    public String getName() {
        return Leistungsblock.checkNull(this.get(FLD_NAME));
    }

    public void setName(String name) {
        this.set(FLD_NAME, name);
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        String macro = this.getMacro();
        if (macro.length() == 0 || macro.equals(name)) {
            return name;
        }
        return String.valueOf(name) + " [" + macro + "]";
    }

    @Override
    public String getText() {
        return this.get(FLD_NAME);
    }

    @Override
    public String getCode() {
        return this.get(FLD_NAME);
    }

    public String getMacro() {
        String[] vals = this.get(true, FLD_MACRO, FLD_NAME);
        if (vals[0].length() == 0) {
            return vals[1];
        }
        return vals[0];
    }

    public void setMacro(String macro) {
        this.set(FLD_MACRO, macro);
    }

    public List<ICodeElement> getElements() {
        String codeelements;
        ICodeElementService service = PoCodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && !(codeelements = this.get(FLD_CODEELEMENTS)).isEmpty()) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Optional<ICodeElement> created = service.createFromString(part, CodeElementServiceHolder.createContext());
                created.ifPresent(c -> {
                    boolean bl = ret.add((ICodeElement)c);
                });
                ++n2;
            }
        }
        return ret;
    }

    public List<ICodeElement> getElements(Konsultation kons) {
        String codeelements;
        ICodeElementService service = PoCodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && !(codeelements = this.get(FLD_CODEELEMENTS)).isEmpty()) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Optional<ICodeElement> created = service.createFromString(part, CodeElementServiceHolder.createContext(kons));
                created.ifPresent(c -> {
                    boolean bl = ret.add((ICodeElement)c);
                });
                ++n2;
            }
        }
        return ret;
    }

    public List<ICodeElement> getElementReferences() {
        String codeelements;
        ICodeElementService service = PoCodeElementServiceHolder.get();
        ArrayList<ICodeElement> ret = new ArrayList<ICodeElement>();
        if (service != null && !(codeelements = this.get(FLD_CODEELEMENTS)).isEmpty()) {
            String[] parts;
            String[] stringArray = parts = codeelements.split("\\:=:");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] elementParts = service.getStoreToStringParts(part);
                if (elementParts != null && elementParts.length > 1) {
                    CodeElementDTO reference = new CodeElementDTO(elementParts[0], elementParts[1]);
                    if (elementParts.length > 2) {
                        reference.setText(elementParts[2]);
                    }
                    ret.add(reference);
                }
                ++n2;
            }
        }
        return ret;
    }

    public List<ICodeElement> getDiffToReferences(List<ICodeElement> elements) {
        List<ICodeElement> references = this.getElementReferences();
        if (references.size() > elements.size()) {
            ICodeElement[] iCodeElementArray = references.toArray(new ICodeElement[references.size()]);
            int n = iCodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICodeElement reference = iCodeElementArray[n2];
                for (ICodeElement element : elements) {
                    if (!this.isMatchingCodeElement(element, reference)) continue;
                    references.remove(reference);
                }
                ++n2;
            }
        } else {
            references.clear();
        }
        return references;
    }

    private int getIndexOf(List<ICodeElement> elements, ICodeElement element) {
        if (element != null && elements != null) {
            int i = 0;
            while (i < elements.size()) {
                if (this.isMatchingCodeElement(element, elements.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean isMatchingCodeElement(ICodeElement left, ICodeElement right) {
        String lCodeSystemName = left.getCodeSystemName();
        String rCodeSystemName = right.getCodeSystemName();
        String lCode = left.getCode();
        String rCode = right.getCode();
        return lCodeSystemName != null && rCodeSystemName != null && lCode != null && rCode != null && lCodeSystemName.equals(rCodeSystemName) && lCode.equals(rCode);
    }

    public void addElement(ICodeElement element) {
        if (element != null) {
            List<ICodeElement> elements = this.getElementReferences();
            int index = this.getIndexOf(elements, element);
            if (index != -1) {
                elements.add(index, element);
            } else {
                elements.add(element);
            }
            this.storeElements(elements);
        }
    }

    private void storeElements(List<ICodeElement> elements) {
        ICodeElementService service = PoCodeElementServiceHolder.get();
        if (service != null) {
            StringBuilder sb = new StringBuilder();
            for (ICodeElement element : elements) {
                if (sb.length() > 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(service.storeToString(element));
            }
            this.set(FLD_CODEELEMENTS, sb.toString());
        }
    }

    public void removeElement(ICodeElement element) {
        if (element != null) {
            List<ICodeElement> elements = this.getElementReferences();
            int index = this.getIndexOf(elements, element);
            if (index != -1) {
                elements.remove(index);
            }
            this.storeElements(elements);
        }
    }

    public void moveElement(ICodeElement element, boolean direction) {
        if (element != null) {
            this.groupElements();
            List<ICodeElement> elements = this.getElementReferences();
            long count = this.getNumberOf(element);
            int index = this.getIndexOf(elements, element);
            if (direction) {
                int offset = -1;
                if (index + offset >= 0) {
                    ICodeElement pervElement = elements.get(index + offset);
                    long nextElementCount = this.getNumberOf(pervElement);
                    if (nextElementCount > 1L) {
                        offset = (int)nextElementCount * -1;
                    }
                    Collections.rotate(elements.subList(index + offset, (int)((long)index + count)), offset);
                    this.storeElements(elements);
                }
            } else {
                int offset = 1;
                if ((long)index + count + (long)offset <= (long)elements.size()) {
                    ICodeElement nextElement;
                    long nextElementCount;
                    if (offset == 1 && (nextElementCount = this.getNumberOf(nextElement = elements.get((int)((long)index + (count - 1L) + (long)offset)))) > 1L) {
                        offset = (int)nextElementCount;
                    }
                    Collections.rotate(elements.subList(index, (int)((long)index + count + (long)offset)), offset);
                    this.storeElements(elements);
                }
            }
        }
    }

    private long getNumberOf(ICodeElement element) {
        List<ICodeElement> elements = this.getElementReferences();
        return elements.stream().filter(e -> this.isMatchingCodeElement((ICodeElement)e, element)).count();
    }

    private void groupElements() {
        ArrayList<ArrayList<ICodeElement>> order = new ArrayList<ArrayList<ICodeElement>>();
        HashMap<String, ArrayList<ICodeElement>> group = new HashMap<String, ArrayList<ICodeElement>>();
        List<ICodeElement> elements = this.getElementReferences();
        for (ICodeElement iCodeElement : elements) {
            String key = String.valueOf(iCodeElement.getCodeSystemName()) + iCodeElement.getCode();
            ArrayList<ICodeElement> list = (ArrayList<ICodeElement>)group.get(key);
            if (list == null) {
                list = new ArrayList<ICodeElement>();
                list.add(iCodeElement);
                group.put(key, list);
                order.add(list);
                continue;
            }
            list.add(iCodeElement);
        }
        ArrayList<ICodeElement> sortedGrouped = new ArrayList<ICodeElement>();
        for (List list : order) {
            sortedGrouped.addAll(list);
        }
        this.storeElements(sortedGrouped);
    }

    public String toString(List<ICodeElement> lst) {
        StringBuilder st = new StringBuilder();
        for (ICodeElement v : lst) {
            st.append(((PersistentObject)((Object)v)).storeToString()).append(",");
        }
        return st.toString().replaceFirst(",$", "");
    }

    @Override
    public String getCodeSystemName() {
        return "Block";
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    @NonNull
    public static List<Leistungsblock> findMacrosValidForCurrentMandator(@Nullable String macro) {
        Mandant selectedMandator = ElexisEventDispatcher.getSelectedMandator();
        if (macro == null || selectedMandator == null) {
            return Collections.emptyList();
        }
        Query qbe = new Query(Leistungsblock.class);
        qbe.add("id", "<>", VERSION_ID);
        qbe.startGroup();
        qbe.add(FLD_NAME, "=", macro);
        qbe.or();
        qbe.add(FLD_MACRO, "=", macro);
        qbe.endGroup();
        qbe.and();
        qbe.startGroup();
        qbe.add(FLD_MANDANT_ID, "=", selectedMandator.getId());
        qbe.or();
        qbe.add(FLD_MANDANT_ID, "=", "");
        qbe.or();
        qbe.addToken("MandantID IS NULL");
        qbe.endGroup();
        List execute = qbe.execute();
        ArrayList<Leistungsblock> ret = new ArrayList<Leistungsblock>();
        for (Leistungsblock lb : execute) {
            String macro2 = Leistungsblock.checkNull(lb.getMacro());
            if (!macro.equals(macro2) && macro2.length() != 0) continue;
            ret.add(lb);
        }
        return ret;
    }

    public boolean isEmpty() {
        return Leistungsblock.checkNull(this.get(FLD_CODEELEMENTS)).isEmpty();
    }
}

