/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.constants.Preferences;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.interfaces.ITransferable;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.AUF;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Messages;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.dto.FallDTO;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.LoggerFactory;

public class Fall
extends PersistentObject
implements IFall,
ITransferable<FallDTO> {
    public static final String TABLENAME = "FAELLE";
    public static final String FLD_BEHANDLUNGEN = "Behandlungen";
    public static final String FLD_KOSTENTRAEGER = "Kostentraeger";
    public static final String FLD_RECHNUNGSSTELLER_ID = "RechnungsstellerID";
    public static final String FLD_DATUM_BIS = "DatumBis";
    public static final String FLD_DATUM_VON = "DatumVon";
    public static final String FLD_RN_PLANUNG = "RnPlanung";
    public static final String FLD_FALL_NUMMER = "FallNummer";
    public static final String FLD_VERS_NUMMER = "VersNummer";
    public static final String FLD_BEZEICHNUNG = "Bezeichnung";
    public static final String FLD_GARANT_ID = "GarantID";
    public static final String FLD_GRUND = "Grund";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_BILLINGSYSTEM = "Gesetz";
    public static final String FLD_RES = "res";
    public static final String FLD_EXT_COPY_FOR_PATIENT = "CopyForPatient";
    public static final String FLD_EXT_KOSTENTRAEGER = "Kostentr\u00e4ger";
    public static final String FLD_EXT_RECHNUNGSEMPFAENGER = "Rechnungsempf\u00e4nger";
    public static final String DEFAULT_RNOUTPUTTER = "QR-PDF-Rechnungsdrucker.Rechnung1";

    static {
        Fall.addMapping(TABLENAME, FLD_PATIENT_ID, "res=Diagnosen", "DatumVon=S:D:DatumVon", "DatumBis=S:D:DatumBis", FLD_GARANT_ID, "Behandlungen=LIST:FallID:BEHANDLUNGEN:Datum", FLD_BEZEICHNUNG, FLD_GRUND, FLD_BILLINGSYSTEM, "Kostentraeger=KostentrID", FLD_VERS_NUMMER, FLD_FALL_NUMMER, "RnPlanung=BetriebsNummer", "ExtInfo");
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public Tiers getTiersType() {
        Kontakt kostentraeger = this.getCostBearer();
        Kontakt rnAdressat = this.getGarant();
        if (kostentraeger != null && kostentraeger.isValid() && kostentraeger.istOrganisation() && rnAdressat.equals(kostentraeger)) {
            return Tiers.PAYANT;
        }
        return Tiers.GARANT;
    }

    @Override
    public TimeTool getBillingDate() {
        String r = this.get(FLD_RN_PLANUNG);
        if (StringTool.isNothing((Object)r)) {
            return null;
        }
        TimeTool ret = new TimeTool();
        if (ret.set(r)) {
            return ret;
        }
        return null;
    }

    @Override
    public void setBillingDate(TimeTool dat) {
        this.set(FLD_RN_PLANUNG, dat == null ? null : dat.toString(4));
    }

    @Override
    public boolean isValid() {
        IRnOutputter outputter;
        if (!super.isValid()) {
            return false;
        }
        Patient p = Patient.load(this.get(FLD_PATIENT_ID));
        if (p == null || !p.isValid()) {
            return false;
        }
        String reqs = BillingSystem.getRequirements(this.getAbrechnungsSystem());
        if (reqs != null) {
            String[] stringArray = reqs.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String req = stringArray[n2];
                String localReq = "";
                String[] r = req.split(":");
                if (r != null && r.length > 1) {
                    Kontakt k;
                    if (r[1].equalsIgnoreCase("X") && r.length > 2) {
                        String[] items = r[2].split("\t");
                        if (items.length > 1) {
                            int rIx = 0;
                            while (rIx < items.length) {
                                localReq = this.getInfoString(String.valueOf(r[0]) + "_" + items[rIx]);
                                if (StringTool.isNothing((Object)localReq)) {
                                    return false;
                                }
                                ++rIx;
                            }
                        }
                    } else {
                        localReq = this.getInfoString(r[0]);
                        if (StringTool.isNothing((Object)localReq)) {
                            return false;
                        }
                    }
                    if (r[1].equals("K") && !(k = Kontakt.load(localReq)).isValid()) {
                        return false;
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Invalid requirements [" + reqs + "] on billing system [" + this.getAbrechnungsSystem() + "]");
                }
                ++n2;
            }
        }
        if ((outputter = this.getOutputter()) == null) {
            return false;
        }
        return outputter.canBill(this);
    }

    protected Fall() {
    }

    protected Fall(String id) {
        super(id);
    }

    Fall(String PatientID, String Bezeichnung, String Grund, String Abrechnungsmethode) {
        if (Abrechnungsmethode == null) {
            Abrechnungsmethode = Fall.getDefaultCaseLaw();
        }
        String[] fields = new String[]{FLD_PATIENT_ID, FLD_BEZEICHNUNG, FLD_GRUND, FLD_DATUM_VON, FLD_BILLINGSYSTEM};
        String[] values = new String[]{PatientID, Bezeichnung, Grund, new TimeTool().toString(9), Abrechnungsmethode};
        this.create(null, fields, values);
    }

    public static Fall load(String id) {
        Fall ret = new Fall(id);
        return ret;
    }

    @Override
    public String getBeginnDatum() {
        return Fall.checkNull(this.get(FLD_DATUM_VON));
    }

    @Override
    public String getBezeichnung() {
        return Fall.checkNull(this.get(FLD_BEZEICHNUNG));
    }

    @Override
    public void setBezeichnung(String t) {
        this.set(FLD_BEZEICHNUNG, t);
    }

    @Override
    public void setBeginnDatum(String dat) {
        this.set(FLD_DATUM_VON, dat);
    }

    @Override
    public String getEndDatum() {
        return Fall.checkNull(this.get(FLD_DATUM_BIS));
    }

    @Override
    public void setEndDatum(String dat) {
        this.set(FLD_DATUM_BIS, dat);
    }

    @Override
    @Nullable
    public Kontakt getCostBearer() {
        Kontakt costBearer;
        String costBearerId = this.get(FLD_KOSTENTRAEGER);
        if (costBearerId != null && costBearerId.length() > 0 && (costBearer = Kontakt.load(costBearerId)).isAvailable()) {
            return costBearer;
        }
        return null;
    }

    @Override
    public void setCostBearer(Kontakt costBearer) {
        this.set(FLD_KOSTENTRAEGER, costBearer != null ? costBearer.getId() : null);
    }

    @Override
    public Kontakt getGarant() {
        Kontakt ret = Kontakt.load(this.get(FLD_GARANT_ID));
        if (ret == null || !ret.isValid()) {
            ret = this.getPatient();
        }
        return ret;
    }

    @Override
    public void setGarant(Kontakt garant) {
        this.set(FLD_GARANT_ID, garant.getId());
    }

    @Nullable
    public Kontakt getInvoiceRecipient() {
        Kontakt legalGuardian;
        Patient patient;
        Kontakt invoiceReceiver;
        Kontakt ret = null;
        Tiers paymentMode = this.getTiersType();
        ret = paymentMode == Tiers.PAYANT ? this.getCostBearer() : (paymentMode == Tiers.GARANT ? ((invoiceReceiver = this.getGarant()).equals(patient = this.getPatient()) ? ((legalGuardian = patient.getLegalGuardian()) != null ? legalGuardian : patient) : invoiceReceiver) : this.getGarant());
        return ret;
    }

    public Rechnungssteller getRechnungssteller() {
        Rechnungssteller ret = Rechnungssteller.load(this.getInfoString(FLD_RECHNUNGSSTELLER_ID));
        if (!ret.isValid()) {
            ret = null;
        }
        return ret;
    }

    public void setRechnungssteller(Kontakt r) {
        this.setInfoString(FLD_RECHNUNGSSTELLER_ID, r.getId());
    }

    @Override
    public boolean getCopyForPatient() {
        return "1".equals(this.getInfoString(FLD_EXT_COPY_FOR_PATIENT));
    }

    @Override
    public void setCopyForPatient(boolean copy) {
        this.setInfoString(FLD_EXT_COPY_FOR_PATIENT, copy ? "1" : "0");
    }

    @Nullable
    public Kontakt getRequiredContact(String name) {
        String kid = this.getInfoString(name);
        if (kid.equals("")) {
            return null;
        }
        return Kontakt.load(kid);
    }

    @Override
    public void setRequiredContact(String name, Kontakt k) {
        String[] req;
        int idx;
        String r = this.getRequirements();
        if (!StringTool.isNothing((Object)r) && (idx = StringTool.getIndex((String[])(req = r.split(";")), (String)(String.valueOf(name) + ":K"))) != -1 && req[idx].endsWith(":K")) {
            this.setInfoString(name, k.getId());
        }
    }

    public BillingLaw getConfiguredBillingSystemLaw() {
        String value = BillingSystem.getConfigurationValue(this.getAbrechnungsSystem(), "defaultBillingLaw", BillingLaw.KVG.name());
        if ("MVG".equals(value)) {
            value = "MV";
        }
        if ("IVG".equals(value)) {
            value = "IV";
        }
        return BillingLaw.valueOf((String)value);
    }

    public String getRequiredString(String name) {
        String kid = this.getInfoString(name);
        if (StringTool.isNothing((Object)kid)) {
            kid = BillingSystem.getBillingSystemConstant(this.getAbrechnungsSystem(), name);
        }
        return kid;
    }

    @Override
    public void setRequiredString(String name, String val) {
        String[] req = this.getRequirements().split(";");
        int idx = StringTool.getIndex((String[])req, (String)(String.valueOf(name) + ":T"));
        if (idx != -1) {
            this.setInfoString(name, val);
        }
    }

    public String getFallNummer() {
        return Fall.checkNull(this.get(FLD_FALL_NUMMER));
    }

    public void setFallNummer(String nr) {
        this.set(FLD_FALL_NUMMER, nr);
    }

    public boolean isOpen() {
        return this.getEndDatum().equals("");
    }

    @Override
    public void setAbrechnungsSystem(String system) {
        this.set(FLD_BILLINGSYSTEM, system);
    }

    @Override
    public String getAbrechnungsSystem() {
        String ret = this.get(FLD_BILLINGSYSTEM);
        if (StringTool.isNothing((Object)ret)) {
            String[] systeme = BillingSystem.getAbrechnungsSysteme();
            ret = systeme[0];
            this.setAbrechnungsSystem(ret);
        }
        return ret;
    }

    public String getCodeSystemName() {
        return BillingSystem.getCodeSystem(this.getAbrechnungsSystem());
    }

    public String getRequirements() {
        String req = BillingSystem.getRequirements(this.getAbrechnungsSystem());
        return req == null ? "" : req;
    }

    @Override
    public String getOptionals() {
        String req = BillingSystem.getOptionals(this.getAbrechnungsSystem());
        return req == null ? "" : req;
    }

    @Override
    public String getUnused() {
        String req = BillingSystem.getUnused(this.getAbrechnungsSystem());
        return req == null ? "" : req;
    }

    public String getOutputterName() {
        return BillingSystem.getDefaultPrintSystem(this.getAbrechnungsSystem());
    }

    public IRnOutputter getOutputter() {
        String outputterName = this.getOutputterName();
        if (outputterName.length() > 0) {
            IRnOutputter ret = this.getRnOutputter(outputterName);
            if (ret == null || outputterName.equals("Fall-Standard")) {
                ret = this.getRnOutputter(DEFAULT_RNOUTPUTTER);
                if (ret != null) {
                    BillingSystem.setConfigurationValue(this.getAbrechnungsSystem(), "standardausgabe", DEFAULT_RNOUTPUTTER);
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Default rn outputter [QR-PDF-Rechnungsdrucker.Rechnung1] not found");
                }
            }
            return ret;
        }
        return null;
    }

    private IRnOutputter getRnOutputter(String extensionName) {
        List<IConfigurationElement> list = Extensions.getExtensions("ch.elexis.core.data.RechnungsManager");
        for (IConfigurationElement ic : list) {
            if (!ic.getAttribute("name").equals(extensionName)) continue;
            try {
                IRnOutputter ret = (IRnOutputter)ic.createExecutableExtension("outputter");
                return ret;
            }
            catch (CoreException e) {
                ExHandler.handle((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Konsultation[] getBehandlungen(boolean sortReverse) {
        List<String> list = this.getList(FLD_BEHANDLUNGEN, sortReverse);
        int i = 0;
        Konsultation[] ret = new Konsultation[list.size()];
        for (String id : list) {
            Konsultation kons = Konsultation.load(id);
            kons.setDBConnection(this.getDBConnection());
            ret[i++] = kons;
        }
        return ret;
    }

    public Konsultation getLetzteBehandlung() {
        List<String> list = this.getList(FLD_BEHANDLUNGEN, true);
        if (!list.isEmpty()) {
            return Konsultation.load(list.get(0));
        }
        return null;
    }

    public Konsultation neueKonsultation() {
        if (!this.isOpen()) {
            MessageEvent.fireError((String)Messages.Core_Case_is_closed, (String)Messages.Core_Cannot_add_consultation_to_closed_case);
            return null;
        }
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (!activeMandator.isPresent()) {
            MessageEvent.fireError((String)Messages.Fall_NoMandatorCaption, (String)Messages.Fall_NoMandatorText);
            return null;
        }
        return new Konsultation(this);
    }

    @Override
    public Patient getPatient() {
        return Patient.load(this.get(FLD_PATIENT_ID));
    }

    @Override
    public String getGrund() {
        return Fall.checkNull(this.get(FLD_GRUND));
    }

    @Override
    public void setGrund(String g) {
        this.set(FLD_GRUND, g);
    }

    @Override
    public String getLabel() {
        String[] f = new String[]{FLD_GRUND, FLD_BEZEICHNUNG, FLD_DATUM_VON, FLD_DATUM_BIS};
        String[] v = new String[f.length];
        this.get(f, v);
        StringBuilder ret = new StringBuilder();
        if (!this.isOpen()) {
            ret.append(Messages.Fall_CLOSED);
        }
        String ges = this.getAbrechnungsSystem();
        ret.append(ges).append(": ").append(v[0]).append(" - ");
        ret.append(v[1]).append("(");
        String ed = v[3];
        if (ed == null || StringTool.isNothing((Object)ed.trim())) {
            ed = Messages.Fall_Open;
        }
        ret.append(v[2]).append("-").append(ed).append(")");
        return ret.toString();
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean force) {
        if (!this.hasDependent() || force && AccessControlServiceHolder.get().evaluate((EvaluatableACE)new ObjectEvaluatableACE(ICoverage.class, Right.REMOVE, StoreToStringServiceHolder.getStoreToString(this)))) {
            Konsultation[] konsultationArray = this.getBehandlungen(false);
            int n = konsultationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation b = konsultationArray[n2];
                b.delete(true);
                ++n2;
            }
            this.delete_dependent();
            return super.delete();
        }
        return false;
    }

    private boolean hasDependent() {
        Konsultation[] bh = this.getBehandlungen(false);
        Query qAUF = new Query(AUF.class);
        qAUF.add("FallID", "=", this.getId());
        Query qRn = new Query(Rechnung.class);
        qRn.add("FallID", "=", this.getId());
        return bh.length != 0 || !qAUF.execute().isEmpty() || !qRn.execute().isEmpty();
    }

    private boolean delete_dependent() {
        Query qAUF = new Query(AUF.class);
        qAUF.add("FallID", "=", this.getId());
        for (AUF auf : qAUF.execute()) {
            auf.delete();
        }
        Query qRn = new Query(Rechnung.class);
        qRn.add("FallID", "=", this.getId());
        for (Rechnung rn : qRn.execute()) {
            rn.delete();
        }
        return true;
    }

    @Override
    public String getInfoString(String name) {
        Map extinfo = this.getMap("ExtInfo");
        if (name == null || extinfo.get(name) == null) {
            return "";
        }
        if (extinfo.get(name) instanceof String) {
            return Fall.checkNull(extinfo.get(name));
        }
        log.warn("Invalid object in Fall.getInfoString(" + name + "), not castable to String: " + extinfo.get(name), new Throwable("Invalid object"));
        return "";
    }

    @Override
    public void setInfoString(String name, String wert) {
        Map extinfo = this.getMap("ExtInfo");
        extinfo.put(name, wert);
        this.setMap("ExtInfo", extinfo);
    }

    public void clearInfoString(String string) {
        Map extinfo = this.getMap("ExtInfo");
        extinfo.remove(string);
        this.setMap("ExtInfo", extinfo);
    }

    public Object getInfoElement(String name) {
        Map extinfo = this.getMap("ExtInfo");
        return extinfo.get(name);
    }

    public void setInfoElement(String name, Object elem) {
        Map extinfo = this.getMap("ExtInfo");
        extinfo.put(name, elem);
        this.setMap("ExtInfo", extinfo);
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    public static String getDefaultCaseLabel() {
        return ConfigServiceHolder.getUser((String)"fall/std_label", (String)Preferences.USR_DEFCASELABEL_DEFAULT);
    }

    public static String getDefaultCaseReason() {
        return ConfigServiceHolder.getUser((String)"fall/std_grund", (String)Preferences.USR_DEFCASEREASON_DEFAULT);
    }

    public static String getDefaultCaseLaw() {
        return ConfigServiceHolder.getUser((String)"fall/std_gesetz", (String)BillingSystem.getAbrechnungsSysteme()[0]);
    }

    public String getRequirements(String billingSystem) {
        String req = BillingSystem.getRequirements(this.getAbrechnungsSystem());
        return req == null ? "" : req;
    }

    public PersistentObject getReferencedObject(String field) {
        Kontakt kontakt = this.getRequiredContact(field);
        if (kontakt != null) {
            if (kontakt.exists()) {
                if (kontakt.istPerson()) {
                    kontakt = Person.load(kontakt.getId());
                } else if (kontakt.istOrganisation()) {
                    kontakt = Organisation.load(kontakt.getId());
                }
                return kontakt;
            }
            return null;
        }
        return null;
    }

    public FallDTO getDTO() {
        return new FallDTO(this);
    }

    public void persistDTO(FallDTO dto) throws ElexisException {
        if (this.getId() == null || !this.exists()) {
            throw new UnsupportedOperationException("fall creation of dto is currently not supported!");
        }
        this.setGrund(dto.getGrund());
        this.setBeginnDatum(dto.getBeginnDatum());
        this.setEndDatum(dto.getEndDatum());
        this.setBillingDate(dto.getBillingDate());
        this.setGarant(dto.getGarant());
        this.setMap("ExtInfo", dto.getMap("ExtInfo"));
        this.setCopyForPatient(dto.getCopyForPatient());
        this.setAbrechnungsSystem(dto.getAbrechnungsSystem());
        this.setBezeichnung(dto.getBezeichnung());
    }

    public Fall createCopy() {
        Patient pat = this.getPatient();
        Fall clone = pat.neuerFall(this.getBezeichnung(), this.getGrund(), this.getAbrechnungsSystem());
        String[] fields = new String[]{FLD_GARANT_ID, FLD_KOSTENTRAEGER, FLD_FALL_NUMMER, FLD_RN_PLANUNG, FLD_RES, FLD_DATUM_VON, "ExtInfo", FLD_BILLINGSYSTEM};
        String[] values = new String[]{this.getGarant().getId(), this.get(FLD_KOSTENTRAEGER), this.getFallNummer(), this.get(FLD_RN_PLANUNG), this.get(FLD_RES), this.getBeginnDatum(), this.get("ExtInfo"), this.getAbrechnungsSystem()};
        clone.set(fields, values);
        clone.setMap("ExtInfo", new Hashtable<Object, Object>());
        List<String> keys = this.loadFieldKeys(this.getRequirements());
        for (String key : keys) {
            clone.setInfoString(key, this.getRequiredString(key));
        }
        return clone;
    }

    private List<String> loadFieldKeys(String fieldString) {
        String[] fields;
        ArrayList<String> keys = new ArrayList<String>();
        String[] stringArray = fields = fieldString.split(";");
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String[] nameType = field.split(":");
            keys.add(nameType[0]);
            ++n2;
        }
        return keys;
    }

    public static enum Tiers {
        PAYANT,
        GARANT;

    }
}

