/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.services.IConflictHandler;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.utils.FileUtil;
import ch.rgw.tools.MimeTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.time.DateUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class LocalDocumentService
implements ILocalDocumentService {
    private HashMap<Object, File> managedFiles = new HashMap();
    private HashMap<Object, LockResponse> managedLocks = new HashMap();
    private HashMap<Class<?>, ILocalDocumentService.ISaveHandler> registeredSaveHandler = new HashMap();
    private HashMap<Class<?>, ILocalDocumentService.ILoadHandler> registeredLoadHandler = new HashMap();

    public Optional<File> getTempFile(Object documentSource) {
        if (documentSource != null) {
            ILocalDocumentService.ILoadHandler loadHandler = this.getRegisteredLoadHandler(documentSource.getClass());
            if (loadHandler == null) {
                throw new IllegalStateException("No load handler for [" + documentSource + "]");
            }
            String fileName = String.valueOf(System.currentTimeMillis()) + "_" + this.getFileName(documentSource);
            InputStream in = loadHandler.load(documentSource);
            if (in != null) {
                return this.writeLocalTempFile(fileName, in);
            }
        }
        return Optional.empty();
    }

    public Optional<File> add(Object documentSource, IConflictHandler conflictHandler) throws IllegalStateException {
        boolean readOnly = false;
        if (documentSource != null) {
            LockResponse result = LocalLockServiceHolder.get().acquireLock(documentSource);
            if (result.isOk()) {
                this.managedLocks.put(documentSource, result);
            } else {
                readOnly = true;
            }
            ILocalDocumentService.ILoadHandler loadHandler = this.getRegisteredLoadHandler(documentSource.getClass());
            if (loadHandler == null) {
                throw new IllegalStateException("No load handler for [" + documentSource + "]");
            }
            String fileName = this.getFileName(documentSource);
            InputStream in = loadHandler.load(documentSource);
            if (in != null) {
                Optional<File> ret = this.writeLocalFile(fileName, in, conflictHandler, readOnly);
                ret.ifPresent(file -> this.managedFiles.put(documentSource, (File)file));
                return ret;
            }
        }
        return Optional.empty();
    }

    private ILocalDocumentService.ILoadHandler getRegisteredLoadHandler(Class<? extends Object> clazz) {
        ILocalDocumentService.ILoadHandler matchingHandler = this.registeredLoadHandler.get(clazz);
        if (matchingHandler == null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaze = classArray[n2];
                matchingHandler = this.registeredLoadHandler.get(interfaze);
                if (matchingHandler != null) break;
                ++n2;
            }
        }
        return matchingHandler;
    }

    public void remove(Object documentSource, IConflictHandler conflictHandler) {
        File file = this.managedFiles.get(documentSource);
        if (file != null && file.exists()) {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            boolean deleted = false;
            while (!(deleted = this.tryDelete(path))) {
                IConflictHandler.Result result = conflictHandler.getResult();
                if (result != IConflictHandler.Result.OVERWRITE) break;
            }
            if (deleted) {
                this.removeManaged(documentSource);
            }
        } else {
            this.removeManaged(documentSource);
        }
    }

    public void remove(Object documentSource, boolean delete) {
        File file = this.managedFiles.get(documentSource);
        if (delete && file != null && file.exists()) {
            this.tryDelete(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        this.removeManaged(documentSource);
    }

    private void removeManaged(Object documentSource) {
        LockResponse lock = this.managedLocks.get(documentSource);
        if (lock != null) {
            LocalLockServiceHolder.get().releaseLock(documentSource);
            this.managedLocks.remove(documentSource);
        }
        this.managedFiles.remove(documentSource);
    }

    private boolean tryDelete(Path path) {
        try {
            if (this.tryBackup(path)) {
                Files.delete(path);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean tryBackup(Path path) {
        try {
            File src = path.toFile();
            File backupDir = new File(String.valueOf(this.getDocumentCachePath()) + File.separator + "backup");
            this.deleteBackupFilesOlderThen(backupDir, 90);
            FileUtils.copyFile((File)src, (File)new File(backupDir, "bak_" + System.currentTimeMillis() + "_" + src.getName()));
            return true;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Cannot create backup for file.", (Throwable)e);
            return false;
        }
    }

    private void deleteBackupFilesOlderThen(File backupDir, int days) {
        try {
            if (backupDir.isDirectory()) {
                Collection filesToDelete = FileUtils.listFiles((File)backupDir, (IOFileFilter)new AgeFileFilter(DateUtils.addDays((Date)new Date(), (int)(days * -1))), (IOFileFilter)TrueFileFilter.TRUE);
                for (File file : filesToDelete) {
                    boolean success = FileUtils.deleteQuietly((File)file);
                    if (success) continue;
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot delete old backup file at: " + file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Cannot delete old backup files.", (Throwable)e);
        }
    }

    public boolean contains(Object documentSource) {
        return this.managedFiles.containsKey(documentSource);
    }

    public Optional<InputStream> getContent(Object documentSource) {
        File file = this.managedFiles.get(documentSource);
        if (file != null) {
            try {
                return Optional.of(new ByteArrayInputStream(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]))));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error reading file", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private Optional<File> writeLocalFile(String fileName, InputStream content, IConflictHandler conflictHandler, boolean readOnly) {
        Path filePath;
        Path dirPath = Paths.get(this.getDocumentCachePath(), new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not create directory", (Throwable)e);
                return Optional.empty();
            }
        }
        if (Files.exists(filePath = Paths.get(String.valueOf(this.getDocumentCachePath()) + File.separator, fileName), new LinkOption[0])) {
            IConflictHandler.Result result = conflictHandler.getResult();
            if (result == IConflictHandler.Result.ABORT) {
                return Optional.empty();
            }
            if (result == IConflictHandler.Result.KEEP) {
                return Optional.of(filePath.toFile());
            }
            if (result == IConflictHandler.Result.OVERWRITE) {
                return Optional.ofNullable(this.writeFile(filePath, content, readOnly, false));
            }
        } else {
            return Optional.ofNullable(this.writeFile(filePath, content, readOnly, false));
        }
        return Optional.empty();
    }

    private Optional<File> writeLocalTempFile(String fileName, InputStream content) {
        Path dirPath = Paths.get(this.getDocumentTempPath(), new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not create directory", (Throwable)e);
                return Optional.empty();
            }
        }
        Path filePath = Paths.get(String.valueOf(this.getDocumentTempPath()) + File.separator, fileName);
        return Optional.ofNullable(this.writeFile(filePath, content, true, true));
    }

    public String getDocumentCachePath() {
        return String.valueOf(CoreHub.getWritableUserDir().getAbsolutePath()) + File.separator + ".localdoc";
    }

    private String getDocumentTempPath() {
        return String.valueOf(CoreHub.getWritableUserDir().getAbsolutePath()) + File.separator + ".localdoctemp";
    }

    private File writeFile(Path path, InputStream content, boolean readOnly, boolean deleteOnExit) {
        try {
            Files.deleteIfExists(path);
            Path newFile = Files.createFile(path, new FileAttribute[0]);
            Files.copy(content, newFile, StandardCopyOption.REPLACE_EXISTING);
            File ret = newFile.toFile();
            ret.setWritable(!readOnly);
            if (deleteOnExit) {
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error writing file", (Throwable)e);
            return null;
        }
    }

    private String getFileName(Object documentSource) {
        Method method;
        int n;
        int n2;
        Method[] methodArray;
        Method[] methods;
        StringBuilder sb = new StringBuilder("_");
        try {
            Method nameMethod = null;
            methodArray = methods = documentSource.getClass().getMethods();
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                method = methodArray[n];
                if (this.isGetNameMethod(method)) {
                    nameMethod = method;
                    break;
                }
                ++n;
            }
            if (nameMethod != null) {
                sb.append(nameMethod.invoke(documentSource, new Object[0]));
            } else {
                sb.append(this.getDefaultFileName());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            sb.append(this.getDefaultFileName());
        }
        try {
            Method idMethod = null;
            methodArray = methods = documentSource.getClass().getMethods();
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                method = methodArray[n];
                if (this.isGetIdMethod(method)) {
                    idMethod = method;
                    break;
                }
                ++n;
            }
            if (idMethod != null) {
                sb.append("[" + idMethod.invoke(documentSource, new Object[0]) + "]");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException idMethod) {
            // empty catch block
        }
        sb.append("_");
        try {
            Method mimeMethod = null;
            methodArray = methods = documentSource.getClass().getMethods();
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                method = methodArray[n];
                if (method.getName().toLowerCase().contains("mime") && method.getReturnType() == String.class) {
                    mimeMethod = method;
                    break;
                }
                ++n;
            }
            if (mimeMethod != null) {
                sb.append("." + this.getFileEnding((String)mimeMethod.invoke(documentSource, new Object[0])));
            } else {
                sb.append(this.getDefaultFileEnding());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            sb.append(this.getDefaultFileEnding());
        }
        return FileUtil.removeInvalidChars((String)sb.toString());
    }

    private boolean isGetIdMethod(Method method) {
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        String lowerName = method.getName().toLowerCase();
        return lowerName.equals("getid");
    }

    private boolean isGetNameMethod(Method method) {
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        String lowerName = method.getName().toLowerCase();
        return lowerName.contains("betreff") || lowerName.contains("titel") || lowerName.contains("title");
    }

    private String getFileEnding(String mime) {
        if (mime != null) {
            if (mime.length() < 5) {
                return mime;
            }
            String ret = MimeTool.getExtension((String)mime);
            if (ret.length() > 5) {
                return this.getDefaultFileEnding();
            }
            if (ret.isEmpty()) {
                return FilenameUtils.getExtension((String)mime);
            }
            return ret;
        }
        return this.getDefaultFileEnding();
    }

    private String getDefaultFileEnding() {
        return ".tmp";
    }

    private Object getDefaultFileName() {
        return "localFile" + System.currentTimeMillis();
    }

    public List<Object> getAll() {
        return new ArrayList<Object>(this.managedFiles.keySet());
    }

    public void registerSaveHandler(Class<?> clazz, ILocalDocumentService.ISaveHandler saveHandler) {
        this.registeredSaveHandler.put(clazz, saveHandler);
    }

    public void registerLoadHandler(Class<?> clazz, ILocalDocumentService.ILoadHandler saveHandler) {
        this.registeredLoadHandler.put(clazz, saveHandler);
    }

    private ILocalDocumentService.ISaveHandler getRegisteredSaveHandler(Class<? extends Object> clazz) {
        ILocalDocumentService.ISaveHandler matchingHandler = this.registeredSaveHandler.get(clazz);
        if (matchingHandler == null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaze = classArray[n2];
                matchingHandler = this.registeredSaveHandler.get(interfaze);
                if (matchingHandler != null) break;
                ++n2;
            }
        }
        return matchingHandler;
    }

    public boolean save(Object documentSource) throws IllegalStateException {
        ILocalDocumentService.ISaveHandler saveHandler = this.getRegisteredSaveHandler(documentSource.getClass());
        if (saveHandler != null) {
            return saveHandler.save(documentSource, (ILocalDocumentService)this);
        }
        throw new IllegalStateException("No save handler for [" + documentSource + "]");
    }
}

