/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.AccessToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Base64;
import java.util.Date;
import org.keycloak.representations.AccessTokenResponse;

public class AccessTokenUtil {
    static AccessToken load(AccessTokenResponse obtainAccessToken) {
        Gson gson = new Gson();
        String accessToken = obtainAccessToken.getToken();
        String[] accessTokenParts = accessToken.split("\\.");
        JsonObject payload = (JsonObject)gson.fromJson(AccessTokenUtil.decode(accessTokenParts[1]), JsonObject.class);
        long accessTokenExp = payload.get("exp").getAsLong();
        Date accessTokenExpirationTime = new Date(accessTokenExp * 1000L);
        String username = payload.get("preferred_username").getAsString();
        String refreshToken = obtainAccessToken.getRefreshToken();
        Date refreshTokenExpirationDate = null;
        if (refreshToken != null) {
            String[] refreshTokenParts = refreshToken.split("\\.");
            JsonObject refreshTokenPayload = (JsonObject)gson.fromJson(AccessTokenUtil.decode(refreshTokenParts[1]), JsonObject.class);
            long refreshTokenExp = refreshTokenPayload.get("exp").getAsLong();
            refreshTokenExpirationDate = new Date(refreshTokenExp * 1000L);
        }
        AccessToken keycloakAccessToken = new AccessToken(accessToken, accessTokenExpirationTime, username, refreshToken, refreshTokenExpirationDate);
        return keycloakAccessToken;
    }

    private static String decode(String encodedString) {
        return new String(Base64.getUrlDecoder().decode(encodedString));
    }
}

