/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IRecipeBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.prescription.Methods;
import ch.elexis.core.services.IMedicationService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class MedicationService
implements IMedicationService {
    private static final String special_num_at_start = "^(~|)[0-9]/[0-9][ a-zA-Z]*$";

    public float getDailyDosageAsFloat(IPrescription prescription) {
        float total = 0.0f;
        List<Float> res = this.getDosageAsFloats(prescription);
        int j = 0;
        while (j < res.size()) {
            total += res.get(j).floatValue();
            ++j;
        }
        return total;
    }

    public List<Float> getDosageAsFloats(IPrescription prescription) {
        ArrayList<Float> list = new ArrayList<Float>();
        ArrayList<Object> sub_list = new ArrayList();
        float num = 0.0f;
        String dosis = prescription.getDosageInstruction();
        if (dosis != null) {
            if (dosis.matches(special_num_at_start)) {
                list.add(Float.valueOf(this.getNum(dosis.replace("~", ""))));
            } else if (dosis.matches("[0-9\u00bd\u00bc]+([xX][0-9]+(/[0-9]+)?|)")) {
                String[] dose = dosis.split("[xX]");
                float count = this.getNum(dose[0]);
                num = dose.length > 1 ? this.getNum(dose[1]) * count : this.getNum(dose[0]);
                list.add(Float.valueOf(num));
            } else {
                sub_list = this.getDosageAsFloats(dosis, "-");
                if (StringUtils.countMatches((CharSequence)dosis, (CharSequence)"-") > 1 && !sub_list.isEmpty()) {
                    return sub_list;
                }
                sub_list = this.getDosageAsFloats(dosis, "/");
                if (StringUtils.countMatches((CharSequence)dosis, (CharSequence)"/") > 1 && !sub_list.isEmpty()) {
                    return sub_list;
                }
                if (dosis.indexOf(45) != -1 || dosis.indexOf(47) != -1) {
                    String[] dos = dosis.split("[- /]");
                    if (dos.length > 2) {
                        String[] stringArray = dos;
                        int n = dos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String d = stringArray[n2];
                            boolean hasDigit = d.matches("^[~/.]*[\u00bd\u00bc0-9].*");
                            if (d.indexOf(32) != -1) {
                                list.add(Float.valueOf(this.getNum(d.substring(0, d.indexOf(32)))));
                            } else if (d.length() > 0 && hasDigit) {
                                list.add(Float.valueOf(this.getNum(d)));
                            }
                            if (list.size() >= 4) {
                                return list;
                            }
                            ++n2;
                        }
                    } else if (dos.length > 1) {
                        list.add(Float.valueOf(this.getNum(dos[1])));
                    }
                }
            }
        }
        return list;
    }

    private ArrayList<Float> getDosageAsFloats(String dosis, String trennzeichen) {
        ArrayList<Float> list = new ArrayList<Float>();
        if (dosis.indexOf(45) != -1 || dosis.indexOf(47) != -1) {
            String[] dos = dosis.split(trennzeichen);
            if (dos.length > 2) {
                String[] stringArray = dos;
                int n = dos.length;
                int n2 = 0;
                while (n2 < n) {
                    String d = stringArray[n2];
                    boolean hasDigit = d.matches("^[~/.]*[\u00bd\u00bc0-9].*");
                    if (d.indexOf(32) != -1) {
                        list.add(Float.valueOf(this.getNum(d.substring(0, d.indexOf(32)))));
                    } else if (d.length() > 0 && hasDigit) {
                        list.add(Float.valueOf(this.getNum(d)));
                    } else if (d.length() == 0) {
                        list.add(Float.valueOf(0.0f));
                    }
                    if (list.size() >= 4) {
                        return list;
                    }
                    ++n2;
                }
            } else if (dos.length > 1) {
                list.add(Float.valueOf(this.getNum(dos[1])));
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private float getNum(String num) {
        try {
            String n = num.trim();
            if (n.matches(special_num_at_start)) {
                return this.getNum(n.substring(0, 1)) / this.getNum(n.substring(2));
            }
            if (n.equalsIgnoreCase("\u00bd")) {
                return 0.5f;
            }
            if (n.equalsIgnoreCase("\u00bc")) {
                return 0.25f;
            }
            if (n.equalsIgnoreCase("1\u00bd")) {
                return 1.5f;
            }
            if (n.indexOf(47) != -1) {
                if (n.length() == 1) {
                    return 0.0f;
                }
                String[] bruch = n.split("/");
                if (bruch.length < 2) {
                    return 0.0f;
                }
                float zaehler = Float.parseFloat(bruch[0]);
                float nenner = Float.parseFloat(bruch[1]);
                if (nenner != 0.0f) return zaehler / nenner;
                return 0.0f;
            }
            if (n.toLowerCase().matches("^[0-9][,.]*[0-9]*x[0-9][,.]*[0-9]*$")) {
                n = n.replace("\\s", "");
                String[] nums = n.toLowerCase().split("x");
                float num1 = Float.parseFloat(nums[0].replace(",", "."));
                float num2 = Float.parseFloat(nums[1].replace(",", "."));
                return num1 * num2;
            }
            if (n.matches("^[0-9,]")) {
                n = n.replace(",", ".");
                return Float.parseFloat(n);
            }
            n = n.replace(",", ".");
            if ((n = n.replaceAll("[^\\d.]", "")).endsWith(".")) {
                n = n.substring(0, n.length() - 1);
            }
            if (!n.isEmpty()) return Float.parseFloat(n);
            return 0.0f;
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error getting number for [" + num + "]");
            return 0.0f;
        }
    }

    public Optional<IArticleDefaultSignature> getDefaultSignature(IArticle article) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IArticleDefaultSignature.class);
        query.and("article", IQuery.COMPARATOR.LIKE, (Object)("%" + StoreToStringServiceHolder.getStoreToString(article)));
        Optional<IArticleDefaultSignature> ret = query.executeSingleResult();
        if (!ret.isPresent()) {
            ret = this.getDefaultSignature(article.getAtcCode());
        }
        return ret;
    }

    public Optional<IArticleDefaultSignature> getDefaultSignature(String atcCode) {
        if (StringUtils.isNotBlank((CharSequence)atcCode)) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IArticleDefaultSignature.class);
            query.and("atccode", IQuery.COMPARATOR.LIKE, (Object)atcCode);
            return query.executeSingleResult();
        }
        return Optional.empty();
    }

    public IArticleDefaultSignature getTransientDefaultSignature(IArticle article) {
        IArticleDefaultSignature ret = (IArticleDefaultSignature)CoreModelServiceHolder.get().create(IArticleDefaultSignature.class);
        ret.setArticle(article);
        return ret;
    }

    public IPrescription createPrescriptionCopy(IPrescription prescription) {
        IPrescription ret = (IPrescription)CoreModelServiceHolder.get().create(IPrescription.class);
        ret.setArticle(prescription.getArticle());
        ret.setPatient(prescription.getPatient());
        ret.setDosageInstruction(prescription.getDosageInstruction());
        ret.setDisposalComment(prescription.getDisposalComment());
        ret.setEntryType(prescription.getEntryType());
        ret.setRemark(prescription.getRemark());
        ret.setDateFrom(LocalDateTime.now());
        ret.setPrescriptor((IContact)ContextServiceHolder.get().getActiveUserContact().orElse(null));
        return ret;
    }

    public void stopPrescription(IPrescription prescription, LocalDateTime stopDateTime, String stopReason) {
        if (stopDateTime == null) {
            stopDateTime = LocalDateTime.now();
        }
        prescription.setDateTo(stopDateTime);
        if (ContextServiceHolder.get().getActiveUserContact().isPresent()) {
            prescription.setExtInfo((Object)"stopper", (Object)((IContact)ContextServiceHolder.get().getActiveUserContact().get()).getId());
        }
        if (stopReason != null) {
            prescription.setStopReason(stopReason);
        }
    }

    public IRecipe createRecipe(IPatient patient, List<IPrescription> prescRecipes) {
        LocalDateTime now = LocalDateTime.now();
        ArrayList<IPrescription> entries = new ArrayList<IPrescription>();
        IRecipe ret = (IRecipe)new IRecipeBuilder(CoreModelServiceHolder.get(), patient, (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)).build();
        int i = 0;
        while (i < prescRecipes.size()) {
            IPrescription iPrescription = prescRecipes.get(i);
            IPrescription copy = this.createPrescriptionCopy(iPrescription);
            copy.setEntryType(EntryType.RECIPE);
            copy.setDateTo(now);
            copy.setRecipe(ret);
            copy.setExtInfo((Object)"recipeOrder", (Object)Integer.toString(i));
            entries.add(copy);
            ++i;
        }
        CoreModelServiceHolder.get().save((Identifiable)ret);
        CoreModelServiceHolder.get().save(entries);
        return ret;
    }

    private int getNextRecipeOrder(IRecipe recipe) {
        List prescriptions = recipe.getPrescriptions();
        if (prescriptions != null && !prescriptions.isEmpty()) {
            return prescriptions.stream().mapToInt(p -> this.getRecipeOrder((IPrescription)p)).max().orElse(0) + 1;
        }
        return 0;
    }

    private int getRecipeOrder(IPrescription prescription) {
        String orderString = (String)prescription.getExtInfo((Object)"recipeOrder");
        if (orderString != null && !orderString.isEmpty()) {
            try {
                return Integer.valueOf(orderString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String[] getSignatureAsStringArray(String signature) {
        return Methods.getSignatureAsStringArray((String)signature);
    }
}

