/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IDocumentService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.internal.text.RecipeDocumentTemplateReplacement;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.text.ITextPlugin;
import ch.elexis.core.text.ReplaceCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class DocumentService
implements IDocumentService {
    public static final String MATCH_DIRECTTEMPLATE = "\\[[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_]+\\]";
    @Reference
    private ITextPlugin textPlugin;
    @Reference
    private ITextReplacementService textReplacementService;
    @Reference
    private List<IDocumentStore> documentStores;
    private Map<String, IDocumentService.IDirectTemplateReplacement> directTemplateReplacement;

    @Activate
    public void activate() {
        this.directTemplateReplacement = new HashMap<String, IDocumentService.IDirectTemplateReplacement>();
        this.addDirectTemplateReplacement("[Rezeptzeilen]", new RecipeDocumentTemplateReplacement("[Rezeptzeilen]", false, false));
        this.addDirectTemplateReplacement("[RezeptzeilenExt]", new RecipeDocumentTemplateReplacement("[RezeptzeilenExt]", false, true));
        this.addDirectTemplateReplacement("[Medikamentenliste]", new RecipeDocumentTemplateReplacement("[Medikamentenliste]", true, false));
        this.addDirectTemplateReplacement("[MedikamentenlisteExt]", new RecipeDocumentTemplateReplacement("[MedikamentenlisteExt]", true, true));
    }

    public ObjectStatus<IDocument> createDocument(IDocumentTemplate template, IContext context) {
        try {
            IDocumentStore documentStore = this.getDocumentStore(template.getStoreId());
            if (!this.textPlugin.loadFromStream(template.getContent(), true)) {
                return ObjectStatus.ERROR((String)("Could not load template " + template.getTitle()));
            }
            this.textPlugin.findOrReplace("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]", in -> this.textReplacementService.performReplacement(context, in));
            this.textPlugin.findOrReplace("\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]", in -> this.textReplacementService.performReplacement(context, in));
            this.textPlugin.findOrReplace("\\[[*]?[-_a-zA-Z0-9]+:[-a-zA-Z0-9]+:[-a-zA-Z0-9\\.]+:[-a-zA-Z0-9\\.]:?[^\\]]*\\]", in -> this.textReplacementService.performReplacement(context, in));
            List matches = this.textPlugin.findMatching(MATCH_DIRECTTEMPLATE);
            for (String string : matches) {
                IDocumentService.IDirectTemplateReplacement templateReplacement = this.directTemplateReplacement.get(string);
                if (templateReplacement == null) continue;
                templateReplacement.replace(this.textPlugin, context);
            }
            IDocument document = documentStore.createDocument(this.getPatientId(context), this.getTitle(template, context), this.getCategory(template, context));
            document.setMimeType(template.getMimeType());
            documentStore.saveDocument(document, (InputStream)new ByteArrayInputStream(this.textPlugin.storeToByteArray()));
            return ObjectStatus.OK((Object)document);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating document from template {}", (Object)template.getTitle(), (Object)e);
            return ObjectStatus.ERROR((String)("Error creating document from template " + template.getTitle()), (Throwable)e);
        }
    }

    public Map<String, Boolean> validateTemplate(IDocumentTemplate template, final IContext context) {
        try {
            final HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            if (this.textPlugin.loadFromStream(template.getContent(), true)) {
                this.textPlugin.findOrReplace("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]", new ReplaceCallback(){

                    public Object replace(String in) {
                        String replacement = DocumentService.this.textReplacementService.performReplacement(context, in);
                        result.put(in, DocumentService.this.validateIsReplaced(replacement));
                        return "";
                    }
                });
                this.textPlugin.findOrReplace("\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]", new ReplaceCallback(){

                    public Object replace(String in) {
                        String replacement = DocumentService.this.textReplacementService.performReplacement(context, in);
                        result.put(in, DocumentService.this.validateIsReplaced(replacement));
                        return "";
                    }
                });
                this.textPlugin.findOrReplace("\\[[*]?[-_a-zA-Z0-9]+:[-a-zA-Z0-9]+:[-a-zA-Z0-9\\.]+:[-a-zA-Z0-9\\.]:?[^\\]]*\\]", new ReplaceCallback(){

                    public Object replace(String in) {
                        String replacement = DocumentService.this.textReplacementService.performReplacement(context, in);
                        result.put(in, DocumentService.this.validateIsReplaced(replacement));
                        return "";
                    }
                });
                List matches = this.textPlugin.findMatching(MATCH_DIRECTTEMPLATE);
                for (String string : matches) {
                    IDocumentService.IDirectTemplateReplacement templateReplacement = this.directTemplateReplacement.get(string);
                    if (templateReplacement == null) continue;
                    result.put(string, templateReplacement.replace(this.textPlugin, context));
                }
                return result;
            }
            LoggerFactory.getLogger(this.getClass()).error("Could not load template " + template.getTitle());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error validating template " + template.getTitle(), (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private Boolean validateIsReplaced(String replacement) {
        if (replacement != null && !"?".equals(replacement) && !"???".equals(replacement)) {
            return true;
        }
        return false;
    }

    private String getTitle(IDocumentTemplate template, IContext context) {
        return context.getNamed("title").orElse(template.getTitle());
    }

    private String getCategory(IDocumentTemplate template, IContext context) {
        return context.getNamed("category").orElse("Allg.");
    }

    private String getPatientId(IContext context) {
        return context.getTyped(IPatient.class).map(p -> p.getId()).orElse(null);
    }

    private IDocumentStore getDocumentStore(String storeId) {
        if (storeId != null) {
            return this.documentStores.stream().filter(ds -> storeId.equals(ds.getId())).findAny().orElse(null);
        }
        return null;
    }

    public void addDirectTemplateReplacement(String template, IDocumentService.IDirectTemplateReplacement textTemplateConsumer) {
        if (this.directTemplateReplacement.containsKey(template)) {
            LoggerFactory.getLogger(this.getClass()).warn("Direct template consumer [" + template + "] replaced with [" + textTemplateConsumer + "]");
        }
        this.directTemplateReplacement.put(template, textTemplateConsumer);
    }
}

