/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.constants.Preferences;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.BillingSystemServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class CoverageService
implements ICoverageService {
    public boolean isValid(ICoverage coverage) {
        if (coverage.getPatient() == null) {
            return false;
        }
        String reqs = BillingSystemServiceHolder.get().getRequirements(coverage.getBillingSystem());
        if (StringUtils.isNotBlank((CharSequence)reqs)) {
            String[] stringArray = reqs.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String req = stringArray[n2];
                String localReq = "";
                String[] r = req.split(":");
                if (r != null && r.length > 1) {
                    Optional contact;
                    if (r[1].equalsIgnoreCase("X") && r.length > 2) {
                        String[] items = r[2].split("\t");
                        if (items.length > 1) {
                            int rIx = 0;
                            while (rIx < items.length) {
                                localReq = (String)coverage.getExtInfo((Object)(String.valueOf(r[0]) + "_" + items[rIx]));
                                if (StringTool.isNothing((Object)localReq)) {
                                    return false;
                                }
                                ++rIx;
                            }
                        }
                    } else {
                        localReq = (String)coverage.getExtInfo((Object)r[0]);
                        if (StringTool.isNothing((Object)localReq)) {
                            return false;
                        }
                    }
                    if (r[1].equals("K") && !(contact = CoreModelServiceHolder.get().load(localReq, IContact.class)).isPresent()) {
                        return false;
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Invalid requirements [" + reqs + "] on billing system [" + coverage.getBillingSystem() + "]");
                }
                ++n2;
            }
        }
        return true;
    }

    public String getRequiredString(ICoverage coverage, String name) {
        String value = (String)coverage.getExtInfo((Object)name);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = BillingSystemServiceHolder.get().getBillingSystemConstant(coverage.getBillingSystem(), name);
        }
        return value;
    }

    public void setRequiredString(ICoverage coverage, String name, String value) {
        String[] req;
        int idx;
        String requirements = BillingSystemServiceHolder.get().getRequirements(coverage.getBillingSystem());
        if (!StringTool.isNothing((Object)requirements) && (idx = StringTool.getIndex((String[])(req = requirements.split(";")), (String)(String.valueOf(name) + ":T"))) != -1) {
            coverage.setExtInfo((Object)name, (Object)value);
        }
    }

    public IContact getRequiredContact(ICoverage coverage, String name) {
        String id = (String)coverage.getExtInfo((Object)name);
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return CoreModelServiceHolder.get().load(id, IContact.class).orElse(null);
    }

    public void setRequiredContact(ICoverage coverage, String name, IContact value) {
        String[] req;
        int idx;
        String requirements = BillingSystemServiceHolder.get().getRequirements(coverage.getBillingSystem());
        if (!StringTool.isNothing((Object)requirements) && (idx = StringTool.getIndex((String[])(req = requirements.split(";")), (String)(String.valueOf(name) + ":K"))) != -1 && req[idx].endsWith(":K")) {
            coverage.setExtInfo((Object)name, (Object)value.getId());
        }
    }

    public ICoverageService.Tiers getTiersType(ICoverage coverage) {
        IContact costBearer = coverage.getCostBearer();
        IContact guarantor = coverage.getGuarantor();
        if (costBearer != null && costBearer.isOrganization() && guarantor.equals(costBearer)) {
            return ICoverageService.Tiers.PAYANT;
        }
        return ICoverageService.Tiers.GARANT;
    }

    public boolean getCopyForPatient(ICoverage coverage) {
        return "1".equals(coverage.getExtInfo((Object)"CopyForPatient"));
    }

    public void setCopyForPatient(ICoverage coverage, boolean copy) {
        coverage.setExtInfo((Object)"CopyForPatient", (Object)(copy ? "1" : "0"));
    }

    public String getDefaultCoverageLabel() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)userContact.get(), "fall/std_label", Preferences.USR_DEFCASELABEL_DEFAULT);
        }
        return Preferences.USR_DEFCASELABEL_DEFAULT;
    }

    public String getDefaultCoverageReason() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)userContact.get(), "fall/std_grund", Preferences.USR_DEFCASEREASON_DEFAULT);
        }
        return Preferences.USR_DEFCASEREASON_DEFAULT;
    }

    public String getDefaultCoverageLaw() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)userContact.get(), "fall/std_gesetz", "defaultBillingSystem");
        }
        return "defaultBillingSystem";
    }

    public ICoverage createCopy(ICoverage coverage) {
        ICoverage ret = (ICoverage)new ICoverageBuilder(CoreModelServiceHolder.get(), coverage).guarantor(coverage.getGuarantor()).costBearer(coverage.getCostBearer()).billingProposalDate(coverage.getBillingProposalDate()).dateFrom(coverage.getDateFrom()).build();
        this.copyExtInfoFields(this.loadFieldKeys(BillingSystemServiceHolder.get().getRequirements(coverage.getBillingSystem())), coverage, ret);
        this.copyExtInfoFields(this.loadFieldKeys(BillingSystemServiceHolder.get().getOptionals(coverage.getBillingSystem())), coverage, ret);
        CoreModelServiceHolder.get().save((Identifiable)ret);
        return ret;
    }

    private void copyExtInfoFields(List<String> fieldKeys, ICoverage from, ICoverage to) {
        for (String fieldKey : fieldKeys) {
            to.setExtInfo((Object)fieldKey, from.getExtInfo((Object)fieldKey));
        }
    }

    private List<String> loadFieldKeys(String fieldString) {
        ArrayList<String> keys = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)fieldString)) {
            String[] fields;
            String[] stringArray = fields = fieldString.split(";");
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String[] nameType = field.split(":");
                keys.add(nameType[0]);
                ++n2;
            }
        }
        return keys;
    }

    public Optional<IEncounter> getLatestEncounter(ICoverage coverage) {
        List encounters = coverage.getEncounters();
        if (encounters != null && !encounters.isEmpty()) {
            if (encounters.size() > 1) {
                Collections.sort(encounters, (l, r) -> {
                    int ret = r.getDate().compareTo(l.getDate());
                    if (ret == 0) {
                        ret = r.getTimeStamp().compareTo(l.getTimeStamp());
                    }
                    return ret;
                });
            }
            return Optional.of((IEncounter)encounters.get(0));
        }
        return Optional.empty();
    }

    public Optional<ICoverage> getLatestOpenCoverage(IPatient patient) {
        IQuery openCoverageQuery = CoreModelServiceHolder.get().getQuery(ICoverage.class);
        openCoverageQuery.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        openCoverageQuery.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__DATE_TO, IQuery.COMPARATOR.EQUALS, null);
        openCoverageQuery.orderBy((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__DATE_FROM, IQuery.ORDER.DESC);
        List openCoverages = openCoverageQuery.execute();
        if (!openCoverages.isEmpty()) {
            return Optional.of((ICoverage)openCoverages.get(0));
        }
        return Optional.empty();
    }

    public ICoverage createDefaultCoverage(IPatient patient) {
        return new ICoverageBuilder(CoreModelServiceHolder.get(), patient, this.getDefaultCoverageLabel(), this.getDefaultCoverageReason(), this.getDefaultCoverageLaw()).buildAndSave();
    }
}

