/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts.handlers;

import ch.elexis.core.pdfbox.ui.parts.PdfPreviewPartLoadHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFTextHighlighter {
    private static PDDocument pdDocument;
    private boolean pageSet = false;
    private static List<MatchPosition> foundPositions;
    private static int currentPosition;

    static {
        foundPositions = new ArrayList<MatchPosition>();
        currentPosition = -1;
    }

    public PDFTextHighlighter(PDDocument pdDocument) {
        PDFTextHighlighter.pdDocument = pdDocument;
    }

    public void highlightSearchTextInPDF(final String searchText) throws IOException {
        if (pdDocument == null) {
            throw new IOException("pdDocument is null");
        }
        currentPosition = 0;
        foundPositions.clear();
        final boolean isExactPhrase = searchText.contains("+");
        final String searchPattern = isExactPhrase ? searchText.replaceAll("\\+", " ") : searchText;
        PDFTextStripper stripper = new PDFTextStripper(){

            protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
                String stringLower = string.toLowerCase();
                if (isExactPhrase) {
                    int lastPlusIndex = searchText.lastIndexOf(43);
                    if (lastPlusIndex != -1) {
                        String afterLastPlus = searchText.substring(lastPlusIndex + 1);
                        String combinedSearchPattern = String.valueOf(searchText.substring(0, lastPlusIndex).replaceAll(".*\\s", "")) + " " + afterLastPlus;
                        combinedSearchPattern = combinedSearchPattern.replace("+", " ").toLowerCase();
                        this.highlightForExactPhrase(stringLower, combinedSearchPattern, textPositions);
                    } else {
                        this.highlightForExactPhrase(stringLower, searchPattern, textPositions);
                    }
                } else {
                    this.highlightForIndividualWords(stringLower, searchPattern, textPositions);
                }
            }

            private void highlightForExactPhrase(String stringLower, String searchPattern2, List<TextPosition> textPositions) throws IOException {
                String searchRegex = PDFTextHighlighter.escapeRegexSpecialCharacters(searchPattern2);
                Pattern pattern = Pattern.compile(searchRegex);
                Matcher matcher = pattern.matcher(stringLower);
                while (matcher.find()) {
                    PDFTextHighlighter.this.highlightMatch(textPositions, matcher, pdDocument, this.getCurrentPageNo());
                }
            }

            private void highlightForIndividualWords(String stringLower, String searchPattern2, List<TextPosition> textPositions) throws IOException {
                String[] stringArray = searchPattern2.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    String regex = PDFTextHighlighter.escapeRegexSpecialCharacters(word);
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(stringLower);
                    while (matcher.find()) {
                        PDFTextHighlighter.this.highlightMatch(textPositions, matcher, pdDocument, this.getCurrentPageNo());
                    }
                    ++n2;
                }
            }
        };
        stripper.setSortByPosition(true);
        stripper.getText(pdDocument);
    }

    private void highlightMatch(List<TextPosition> textPositions, Matcher matcher, PDDocument document, int pageNo) throws IOException {
        int textIndex = matcher.start();
        int endIndex = matcher.end();
        PDPage page = document.getPage(pageNo - 1);
        PDRectangle cropBox = page.getCropBox();
        float pageHeight = cropBox.getHeight();
        TextPosition start = textPositions.get(textIndex);
        TextPosition end = textPositions.get(endIndex - 1);
        float tolerance = 2.0f;
        float width = end.getEndX() - start.getXDirAdj() + tolerance;
        float height = start.getHeightDir() * 2.5f;
        float newY = pageHeight - start.getYDirAdj();
        PDAnnotationTextMarkup markup = new PDAnnotationTextMarkup("Highlight");
        markup.setRectangle(new PDRectangle(start.getXDirAdj(), newY, width, height));
        markup.setQuadPoints(new float[]{start.getXDirAdj(), newY, start.getXDirAdj() + width, newY, start.getXDirAdj(), newY + height, start.getXDirAdj() + width, newY + height});
        MatchPosition matchPosition = new MatchPosition(start.getXDirAdj(), newY - height, start.getXDirAdj() + width, newY, pageNo);
        foundPositions.add(matchPosition);
        markup.setColor(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        page.getAnnotations().add(markup);
        if (!this.pageSet) {
            PdfPreviewPartLoadHandler.setCurrentPageNo(pageNo);
            this.pageSet = true;
        }
    }

    private static String escapeRegexSpecialCharacters(String word) {
        String escapedWord = word.replaceAll("([\\\\\\[\\](){}.*+?^$|])", "\\\\$1").replace("ue", "(\u00fc|ue)").replace("oe", "(\u00f6|oe)").replace("ae", "(\u00e4|ae)").replace("ss", "(\u00df|ss)");
        return escapedWord;
    }

    public static MatchPosition getNextMatch() throws IOException {
        if (currentPosition >= foundPositions.size() - 1) {
            return null;
        }
        MatchPosition nextMatch = foundPositions.get(++currentPosition);
        PDFTextHighlighter.highlightCurrentMatch(nextMatch);
        return nextMatch;
    }

    public static MatchPosition getPreviousMatch() throws IOException {
        if (currentPosition <= 0) {
            return null;
        }
        MatchPosition previousMatch = foundPositions.get(--currentPosition);
        PDFTextHighlighter.highlightCurrentMatch(previousMatch);
        return previousMatch;
    }

    public static void resetHighlighting() throws IOException {
        for (PDPage page : pdDocument.getPages()) {
            ArrayList<PDAnnotationTextMarkup> annotationsToRemove = new ArrayList<PDAnnotationTextMarkup>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDAnnotationTextMarkup textMarkup;
                if (!(annotation instanceof PDAnnotationTextMarkup) || !(textMarkup = (PDAnnotationTextMarkup)annotation).getSubtype().equals("Highlight")) continue;
                annotationsToRemove.add(textMarkup);
            }
            page.getAnnotations().removeAll(annotationsToRemove);
        }
    }

    public static void highlightCurrentMatch(MatchPosition currentMatch) throws IOException {
        if (currentMatch == null) {
            return;
        }
        PDFTextHighlighter.resetHighlighting();
        PDPage page = pdDocument.getPage(currentMatch.pageNo - 1);
        PDAnnotationTextMarkup annotation = new PDAnnotationTextMarkup("Highlight");
        PDRectangle rect = new PDRectangle();
        rect.setLowerLeftX(currentMatch.startX);
        rect.setLowerLeftY(currentMatch.startY);
        rect.setUpperRightX(currentMatch.endX);
        rect.setUpperRightY(currentMatch.endY);
        annotation.setRectangle(rect);
        annotation.setQuadPoints(new float[]{currentMatch.startX, currentMatch.endY, currentMatch.endX, currentMatch.endY, currentMatch.startX, currentMatch.startY, currentMatch.endX, currentMatch.startY});
        annotation.setColor(new PDColor(new float[]{1.0f, 1.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
        page.getAnnotations().add(annotation);
        PdfPreviewPartLoadHandler.setCurrentPageNo(currentMatch.pageNo);
    }

    public void reapplyHighlights() {
        try {
            PDFTextHighlighter.resetHighlighting();
            float cmToPointsFactor = 28.346457f;
            float adjustmentHeight = 11.338583f;
            int i = 0;
            while (i < foundPositions.size()) {
                MatchPosition match = foundPositions.get(i);
                PDPage page = pdDocument.getPage(match.pageNo - 1);
                PDAnnotationTextMarkup annotation = new PDAnnotationTextMarkup("Highlight");
                float adjustedStartY = match.startY + 11.338583f;
                float adjustedEndY = match.endY + 11.338583f;
                PDRectangle rect = new PDRectangle();
                rect.setLowerLeftX(match.startX);
                rect.setLowerLeftY(adjustedStartY);
                rect.setUpperRightX(match.endX);
                rect.setUpperRightY(adjustedEndY);
                annotation.setRectangle(rect);
                float[] quadPoints = new float[]{match.startX, adjustedEndY, match.endX, adjustedEndY, match.startX, adjustedStartY, match.endX, adjustedStartY};
                annotation.setQuadPoints(quadPoints);
                if (i == currentPosition) {
                    annotation.setColor(new PDColor(new float[]{0.0f, 1.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
                } else {
                    annotation.setColor(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
                }
                page.getAnnotations().add(annotation);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class MatchPosition {
        public float startX;
        public float startY;
        public float endX;
        public float endY;
        public int pageNo;
        public List<TextPosition> textPositions;

        public MatchPosition(float startX, float startY, float endX, float endY, int pageNo) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.pageNo = pageNo;
            this.textPositions = new ArrayList<TextPosition>();
        }
    }
}

