/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.pdfbox.ui.parts.handlers.PDFLabelMouseListener;
import ch.elexis.core.pdfbox.ui.parts.handlers.PDFTextExtractor;
import ch.elexis.core.pdfbox.ui.parts.handlers.PDFTextHighlighter;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.slf4j.LoggerFactory;

public class PdfPreviewPartLoadHandler {
    private static ExecutorService loader = Executors.newSingleThreadExecutor();
    private final ScrolledComposite scrolledComposite;
    private final Composite previewComposite;
    private PDFTextExtractor pdfTextExtractor;
    private PDFLabelMouseListener pDFLabelMouseListener;
    private float scalingFactor;
    private Label headLabel;
    private int numberOfPages;
    private Image[] images;
    private PDDocument pdDocument;
    private String searchText;
    private static int currentPageNo;
    private Image[] labelBackgrounds;
    private GC[] gcBackgrounds;
    private Map<Integer, List<Rectangle>> markedAreasPerPage = new HashMap<Integer, List<Rectangle>>();
    private Label label;

    public PdfPreviewPartLoadHandler(InputStream pdfInputStream, Float scalingFactor, Composite previewComposite, ScrolledComposite scrolledComposite) {
        this.previewComposite = previewComposite;
        this.scrolledComposite = scrolledComposite;
        this.scalingFactor = scalingFactor != null ? scalingFactor.floatValue() : 1.0f;
        this.labelBackgrounds = new Image[0];
        this.gcBackgrounds = new GC[0];
        this.previewComposite.setFocus();
        loader.submit(new LoaderRunnable(pdfInputStream));
    }

    protected void unloadDocument() throws IOException {
        if (this.pdDocument != null) {
            this.pdDocument.close();
            this.pdDocument = null;
        }
    }

    public void changeScalingFactor(Float scalingFactor) {
        this.scalingFactor = scalingFactor.floatValue();
        loader.submit(() -> {
            Display.getDefault().syncExec(() -> {
                Control[] controlArray = this.previewComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
            });
            this.renderPdfWithHighlights();
        });
    }

    public void close() {
        if (this.pdDocument != null) {
            try {
                this.pdDocument.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Excepton closing PDDocument", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    private void renderPdfWithHighlights() {
        try {
            if (this.pdDocument != null) {
                PDFRenderer renderer = new PDFRenderer(this.pdDocument);
                if (StringUtils.isNotBlank((CharSequence)this.searchText)) {
                    PDFTextHighlighter highlighter = new PDFTextHighlighter(this.pdDocument);
                    highlighter.reapplyHighlights();
                }
                this.numberOfPages = this.pdDocument.getNumberOfPages();
                this.images = new Image[this.numberOfPages];
                this.labelBackgrounds = new Image[this.numberOfPages];
                this.gcBackgrounds = new GC[this.numberOfPages];
                this.pdfTextExtractor = new PDFTextExtractor(this.pdDocument, this.images, this.markedAreasPerPage);
                this.pDFLabelMouseListener = new PDFLabelMouseListener(this.markedAreasPerPage, this.images, this.labelBackgrounds, this.gcBackgrounds, this.pdfTextExtractor);
                int i = 0;
                while (i < this.numberOfPages) {
                    int j = i;
                    BufferedImage bufferedImage = renderer.renderImage(i, this.scalingFactor);
                    ImageData imageData = this.convertToSWT(bufferedImage);
                    this.images[j] = new Image((Device)this.previewComposite.getDisplay(), imageData);
                    Display.getDefault().syncExec(() -> {
                        Label label = new Label(this.previewComposite, 0);
                        label.setImage(this.images[j]);
                        label.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
                        label.addDisposeListener(e -> this.images[j].dispose());
                        int pageIndex = j;
                        this.addMouseListenersToLabel(label, pageIndex, j);
                    });
                    ++i;
                }
                Display.getDefault().syncExec(() -> {
                    this.previewComposite.layout(true);
                    this.scrolledComposite.layout(true);
                    this.scrolledComposite.setMinSize(this.previewComposite.computeSize(-1, -1));
                    if (StringUtils.isNotBlank((CharSequence)this.searchText)) {
                        this.centerContentHorizontally();
                        this.centerContentOnPage(currentPageNo);
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void centerContentHorizontally() {
        this.previewComposite.getDisplay().asyncExec(() -> {
            if (!this.scrolledComposite.isDisposed() && !this.previewComposite.isDisposed()) {
                int contentWidth = this.previewComposite.computeSize((int)-1, (int)-1).x;
                int clientWidth = this.scrolledComposite.getClientArea().width;
                int hScrollPos = (contentWidth - clientWidth) / 2;
                if (hScrollPos > 0) {
                    this.scrolledComposite.getHorizontalBar().setSelection(hScrollPos);
                }
                this.scrolledComposite.setOrigin(hScrollPos, this.scrolledComposite.getOrigin().y);
            }
        });
    }

    private void centerContentOnPage(int targetPage) {
        this.previewComposite.getDisplay().asyncExec(() -> {
            if (!this.scrolledComposite.isDisposed() && !this.previewComposite.isDisposed()) {
                int contentWidth = this.previewComposite.computeSize((int)-1, (int)-1).x;
                int clientWidth = this.scrolledComposite.getClientArea().width;
                int hScrollPos = (contentWidth - clientWidth) / 2;
                if (hScrollPos > 0) {
                    this.scrolledComposite.getHorizontalBar().setSelection(hScrollPos);
                }
                Control[] children = this.previewComposite.getChildren();
                int yOffset = 0;
                int i = 0;
                while (i < targetPage - 1 && i < children.length) {
                    yOffset += children[i].getSize().y;
                    ++i;
                }
                int remainingSpace = 0;
                if (targetPage - 1 >= 0 && targetPage - 1 < children.length) {
                    remainingSpace = (this.scrolledComposite.getClientArea().height - children[n - 1].getSize().y) / 2;
                }
                int newVScrollPos = yOffset - remainingSpace;
                newVScrollPos = Math.max(0, newVScrollPos);
                this.scrolledComposite.setOrigin(hScrollPos, newVScrollPos);
            }
        });
    }

    public static void setCurrentPageNo(int pageNo) {
        currentPageNo = pageNo;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void reloadPdf() {
        loader.submit(() -> {
            Display.getDefault().syncExec(() -> {
                Control[] controlArray = this.previewComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
            });
            this.renderPdfWithHighlights();
        });
    }

    private void addMouseListenersToLabel(Label label, int pageIndex, int j) {
        this.pDFLabelMouseListener.addMouseListenersToLabel(label, pageIndex, j);
    }

    private class LoaderRunnable
    implements Runnable {
        private InputStream pdfInputStream;

        public LoaderRunnable(InputStream pdfInputStream) {
            this.pdfInputStream = pdfInputStream;
        }

        @Override
        public void run() {
            try {
                PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().syncExec(() -> {
                    Control[] children;
                    PdfPreviewPartLoadHandler.this.headLabel = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                    PdfPreviewPartLoadHandler.this.headLabel.setText(Messages.PdfPreview_NoPDFSelected);
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                    Control[] controlArray = children = PdfPreviewPartLoadHandler.this.previewComposite.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (!PdfPreviewPartLoadHandler.this.headLabel.equals(control)) {
                            control.dispose();
                        }
                        ++n2;
                    }
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                });
                if (PdfPreviewPartLoadHandler.this.pdDocument == null) {
                    if (this.pdfInputStream != null) {
                        PdfPreviewPartLoadHandler.this.pdDocument = PDDocument.load((InputStream)this.pdfInputStream);
                        this.pdfInputStream.close();
                        if (StringUtils.isNotBlank((CharSequence)PdfPreviewPartLoadHandler.this.searchText)) {
                            PDFTextHighlighter highlighter = new PDFTextHighlighter(PdfPreviewPartLoadHandler.this.pdDocument);
                            highlighter.highlightSearchTextInPDF(PdfPreviewPartLoadHandler.this.searchText.toLowerCase());
                        }
                        PdfPreviewPartLoadHandler.this.numberOfPages = PdfPreviewPartLoadHandler.this.pdDocument.getNumberOfPages();
                        PdfPreviewPartLoadHandler.this.images = new Image[PdfPreviewPartLoadHandler.this.numberOfPages];
                        PdfPreviewPartLoadHandler.this.labelBackgrounds = new Image[PdfPreviewPartLoadHandler.this.numberOfPages];
                        PdfPreviewPartLoadHandler.this.gcBackgrounds = new GC[PdfPreviewPartLoadHandler.this.numberOfPages];
                        PdfPreviewPartLoadHandler.this.pdfTextExtractor = new PDFTextExtractor(PdfPreviewPartLoadHandler.this.pdDocument, PdfPreviewPartLoadHandler.this.images, PdfPreviewPartLoadHandler.this.markedAreasPerPage);
                        PdfPreviewPartLoadHandler.this.pDFLabelMouseListener = new PDFLabelMouseListener(PdfPreviewPartLoadHandler.this.markedAreasPerPage, PdfPreviewPartLoadHandler.this.images, PdfPreviewPartLoadHandler.this.labelBackgrounds, PdfPreviewPartLoadHandler.this.gcBackgrounds, PdfPreviewPartLoadHandler.this.pdfTextExtractor);
                    } else if (this.pdfInputStream == null && PdfPreviewPartLoadHandler.this.pdDocument == null) {
                        return;
                    }
                }
                PDFRenderer renderer = new PDFRenderer(PdfPreviewPartLoadHandler.this.pdDocument);
                int i = 0;
                while (i < PdfPreviewPartLoadHandler.this.numberOfPages) {
                    int j = i;
                    BufferedImage bufferedImage = renderer.renderImage(i, PdfPreviewPartLoadHandler.this.scalingFactor);
                    ImageData imageData = PdfPreviewPartLoadHandler.this.convertToSWT(bufferedImage);
                    PdfPreviewPartLoadHandler.this.images[j] = new Image((Device)PdfPreviewPartLoadHandler.this.previewComposite.getDisplay(), imageData);
                    PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().asyncExec(() -> {
                        if (j == 0) {
                            PdfPreviewPartLoadHandler.this.headLabel.setText("");
                            PdfPreviewPartLoadHandler.this.headLabel.setImage(PdfPreviewPartLoadHandler.this.images[j]);
                            PdfPreviewPartLoadHandler.this.headLabel.addDisposeListener(dl -> PdfPreviewPartLoadHandler.this.images[j].dispose());
                            final int pageIndex = j;
                            PdfPreviewPartLoadHandler.this.addMouseListenersToLabel(PdfPreviewPartLoadHandler.this.headLabel, pageIndex, j);
                            PdfPreviewPartLoadHandler.this.previewComposite.addKeyListener((KeyListener)new KeyAdapter(){

                                public void keyPressed(KeyEvent e) {
                                    if (e.keyCode == 27) {
                                        ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.pDFLabelMouseListener.clearSelection(pageIndex);
                                        ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.previewComposite.redraw();
                                        if (!((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.headLabel.isDisposed()) {
                                            ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.headLabel.redraw();
                                        }
                                    }
                                }
                            });
                            PdfPreviewPartLoadHandler.this.previewComposite.setFocus();
                        } else {
                            PdfPreviewPartLoadHandler.this.label = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                            PdfPreviewPartLoadHandler.this.label.setImage(PdfPreviewPartLoadHandler.this.images[j]);
                            PdfPreviewPartLoadHandler.this.label.addDisposeListener(dl -> PdfPreviewPartLoadHandler.this.images[j].dispose());
                            final int pageIndex = j;
                            PdfPreviewPartLoadHandler.this.addMouseListenersToLabel(PdfPreviewPartLoadHandler.this.label, pageIndex, j);
                            PdfPreviewPartLoadHandler.this.previewComposite.addKeyListener((KeyListener)new KeyAdapter(){

                                public void keyPressed(KeyEvent e) {
                                    if (e.keyCode == 27) {
                                        ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.pDFLabelMouseListener.clearSelection(pageIndex);
                                        ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.previewComposite.redraw();
                                        if (!((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.label.isDisposed()) {
                                            ((LoaderRunnable)LoaderRunnable.this).PdfPreviewPartLoadHandler.this.label.redraw();
                                        }
                                    }
                                }
                            });
                        }
                        PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                        PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                        PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                        if (StringUtils.isNotBlank((CharSequence)PdfPreviewPartLoadHandler.this.searchText)) {
                            PdfPreviewPartLoadHandler.this.centerContentHorizontally();
                            PdfPreviewPartLoadHandler.this.centerContentOnPage(currentPageNo);
                        }
                    });
                    ++i;
                }
            }
            catch (IOException e) {
                PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().asyncExec(() -> {
                    if (PdfPreviewPartLoadHandler.this.headLabel != null) {
                        PdfPreviewPartLoadHandler.this.headLabel.dispose();
                    }
                    PdfPreviewPartLoadHandler.this.headLabel = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                    PdfPreviewPartLoadHandler.this.headLabel.setText(e.getMessage());
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                });
            }
        }
    }
}

