/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.views.PatFilterImpl;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.rgw.tools.IFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ConsultationExport {
    public String doExport(String dir, String stickerName) {
        try {
            Query qbe = new Query(Patient.class);
            if (stickerName != null) {
                List ls = new Query(Sticker.class, "Name", stickerName).execute();
                if (ls != null && !ls.isEmpty()) {
                    final Sticker sticker = (Sticker)ls.get(0);
                    final PatFilterImpl pf = new PatFilterImpl();
                    IFilter flt = new IFilter(){

                        public boolean select(Object element) {
                            return pf.accept((Patient)element, (PersistentObject)sticker) == 1;
                        }
                    };
                    qbe.addPostQueryFilter(flt);
                } else {
                    return "Sticker " + stickerName + " nicht gefunden.";
                }
            }
            for (Patient pat : qbe.execute()) {
                Element e = new Element("Patient");
                e.setAttribute("ID", pat.getId());
                e.setAttribute("Name", pat.get("Name"));
                e.setAttribute("Vorname", pat.get("Vorname"));
                e.setAttribute("GebDat", pat.get("Geburtsdatum"));
                Fall[] fallArray = pat.getFaelle();
                int n = fallArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Kontakt costBearer;
                    Fall fall = fallArray[n2];
                    Element f = new Element("Fall");
                    e.addContent((Content)f);
                    f.setAttribute("ID", fall.getId());
                    f.setAttribute("Bezeichnung", fall.getBezeichnung());
                    f.setAttribute("BeginnDatum", fall.getBeginnDatum());
                    f.setAttribute("EndDatum", fall.getEndDatum());
                    f.setAttribute("Gesetz", fall.getConfiguredBillingSystemLaw().name());
                    f.setAttribute("Abrechnungssystem", fall.getAbrechnungsSystem());
                    Kontakt k = fall.getGarant();
                    if (k != null) {
                        f.setAttribute("Garant", fall.getGarant().getLabel());
                    }
                    if ((costBearer = fall.getCostBearer()) != null) {
                        f.setAttribute("Kostentraeger", costBearer.getLabel());
                        f.setAttribute("Versicherungsnummer", fall.getRequiredString("Versicherungsnummer"));
                    }
                    Konsultation[] konsultationArray = fall.getBehandlungen(false);
                    int n3 = konsultationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Konsultation kons = konsultationArray[n4];
                        Element kel = new Element("Konsultation");
                        f.addContent((Content)kel);
                        kel.setAttribute("ID", kons.getId());
                        kel.setAttribute("Datum", kons.getDatum());
                        kel.setAttribute("Label", kons.getVerboseLabel());
                        Samdas samdas = new Samdas(kons.getEintrag().getHead());
                        kel.setText(samdas.getRecordText());
                        ++n4;
                    }
                    ++n2;
                }
                Document doc = new Document();
                doc.setRootElement(e);
                FileOutputStream fout = new FileOutputStream(new File(dir, String.valueOf(pat.getId()) + ".xml"));
                OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                xout.output(doc, (Writer)cout);
                cout.close();
                fout.close();
            }
            return "ok";
        }
        catch (Exception ex) {
            return String.valueOf(ex.getClass().getName()) + ":" + ex.getMessage();
        }
    }
}

