/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.wizards;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.wizards.DBImportSecondPage;
import ch.elexis.core.ui.wizards.DBImportWizard;
import ch.elexis.core.ui.wizards.Messages;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DBImportFirstPage
extends WizardPage {
    List dbTypes;
    Text server;
    Text dbName;
    String defaultUser;
    String defaultPassword;
    JdbcLink j = null;
    static final String[] supportedDB = new String[]{"mySQl", "PostgreSQL", "H2", "ODBC"};
    static final int MYSQL = 0;
    static final int POSTGRESQL = 1;
    static final int ODBC = 3;
    static final int H2 = 2;

    public DBImportFirstPage(String pageName) {
        super(Messages.Core_Connection, Messages.Core_Database_Type, Images.IMG_LOGO.getImageDescriptor(ImageSize._75x66_TitleDialogIconSize));
        this.setMessage(String.valueOf(Messages.DBImportFirstPage_selectType) + Messages.DBImportFirstPage_enterNameODBC);
        this.setDescription(Messages.Core_the_description);
    }

    public DBImportFirstPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        DBImportWizard wiz = (DBImportWizard)this.getWizard();
        FormToolkit tk = UiDesk.getToolkit();
        Form form = tk.createForm(parent);
        form.setText(Messages.Core_Database_Connectiondetails);
        Composite body = form.getBody();
        body.setLayout((Layout)new TableWrapLayout());
        tk.createLabel(body, Messages.Core_Enter_Typename);
        this.dbTypes = new List(body, 2048);
        this.dbTypes.setItems(supportedDB);
        this.dbTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int it = DBImportFirstPage.this.dbTypes.getSelectionIndex();
                switch (it) {
                    case 0: 
                    case 1: {
                        DBImportFirstPage.this.server.setEnabled(true);
                        DBImportFirstPage.this.dbName.setEnabled(true);
                        DBImportFirstPage.this.defaultUser = "";
                        DBImportFirstPage.this.defaultPassword = "";
                        break;
                    }
                    case 2: {
                        DBImportFirstPage.this.server.setEnabled(false);
                        DBImportFirstPage.this.dbName.setEnabled(true);
                        DBImportFirstPage.this.defaultUser = "sa";
                        DBImportFirstPage.this.defaultPassword = "";
                        break;
                    }
                    case 3: {
                        DBImportFirstPage.this.server.setEnabled(false);
                        DBImportFirstPage.this.dbName.setEnabled(true);
                        DBImportFirstPage.this.defaultUser = "sa";
                        DBImportFirstPage.this.defaultPassword = "";
                        break;
                    }
                }
                DBImportSecondPage sec = (DBImportSecondPage)DBImportFirstPage.this.getNextPage();
                sec.name.setText(DBImportFirstPage.this.defaultUser);
                sec.pwd.setText(DBImportFirstPage.this.defaultPassword);
            }
        });
        tk.adapt((Control)this.dbTypes, true, true);
        tk.createLabel(body, Messages.DBImportFirstPage_serverAddress);
        this.server = tk.createText(body, "", 2048);
        TableWrapData twr = new TableWrapData(256);
        this.server.setLayoutData((Object)twr);
        tk.createLabel(body, Messages.Core_Database_Name);
        this.dbName = tk.createText(body, "", 2048);
        TableWrapData twr2 = new TableWrapData(256);
        this.dbName.setLayoutData((Object)twr2);
        if (wiz.preset != null && wiz.preset.length > 1) {
            int idx = StringTool.getIndex((String[])supportedDB, (String)wiz.preset[0]);
            if (idx < this.dbTypes.getItemCount()) {
                this.dbTypes.select(idx);
            }
            this.server.setText(wiz.preset[1]);
            this.dbName.setText(wiz.preset[2]);
        }
        this.setControl((Control)form);
    }
}

