/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem;

import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.views.textsystem.AbstractProperties;
import ch.elexis.core.ui.views.textsystem.KategorieProperties;
import ch.elexis.core.ui.views.textsystem.Messages;
import ch.elexis.core.ui.views.textsystem.PlatzhalterTreeData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public class PlatzhalterProperties
extends AbstractProperties {
    private static final long serialVersionUID = -6366568655870957480L;
    private static Log log = Log.get("PlatzhalterProperties");
    private static final String PLATZHALTER_FILENAME = "Platzhalter.txt";

    @Override
    protected String getFilename() {
        return PLATZHALTER_FILENAME;
    }

    public List<PlatzhalterTreeData> getList() {
        PlatzhalterTreeData root = new PlatzhalterTreeData("root", "", "");
        PlatzhalterTreeData noKategorie = new PlatzhalterTreeData(Messages.PlatzhalterProperties_label_no_category, "", Messages.PlatzhalterProperties_tooltip_no_category);
        KategorieProperties katProperties = new KategorieProperties();
        HashMap<String, PlatzhalterTreeData> catTreeMap = new HashMap<String, PlatzhalterTreeData>();
        catTreeMap.put(noKategorie.getName(), noKategorie);
        Enumeration<Object> keyEnumeration = this.keys();
        while (keyEnumeration.hasMoreElements()) {
            String keyString = (String)keyEnumeration.nextElement();
            String value = this.getProperty(keyString);
            String category = noKategorie.getName();
            String name = "";
            int openBracket = keyString.indexOf("[");
            int closeBracket = keyString.lastIndexOf("]");
            int firstPoint = keyString.indexOf(".");
            if (firstPoint < 0) {
                firstPoint = keyString.indexOf(":");
            }
            if (firstPoint == 0) {
                keyString = keyString.substring(1);
            }
            if (openBracket < 0) {
                if (closeBracket > 0) {
                    keyString = keyString.substring(0, closeBracket);
                }
                name = keyString;
                category = firstPoint < 0 ? keyString : keyString.substring(0, firstPoint);
            } else if (closeBracket < 0) {
                name = keyString.substring(openBracket + 1);
            } else {
                name = keyString.substring(openBracket + 1, closeBracket);
                category = keyString.substring(0, openBracket);
                if (category.endsWith(".") || category.endsWith(":")) {
                    category = category.substring(0, category.length() - 1);
                }
            }
            if (name != null && name.length() > 0) {
                String displayName;
                boolean startsWithCat;
                PlatzhalterTreeData categoryPtd = null;
                int categoryLength = 0;
                if (category == null || category.length() == 0) {
                    categoryPtd = noKategorie;
                } else {
                    categoryLength = category.length();
                    categoryPtd = (PlatzhalterTreeData)catTreeMap.get(category);
                }
                if (categoryPtd == null) {
                    String description = katProperties.getDescription(category);
                    categoryPtd = new PlatzhalterTreeData(category, "", description);
                    catTreeMap.put(category, categoryPtd);
                    root.addChild(categoryPtd);
                }
                boolean bl = startsWithCat = (displayName = name).startsWith(String.valueOf(category) + ".") || displayName.startsWith(String.valueOf(category) + ":");
                if (startsWithCat && displayName.length() > categoryLength && ((displayName = displayName.substring(categoryLength)).startsWith(".") || displayName.startsWith(":"))) {
                    displayName = displayName.substring(1);
                }
                if (value == null || value.length() == 0) {
                    value = displayName;
                }
                categoryPtd.addChild(new PlatzhalterTreeData(displayName, "[" + name + "]", value));
                continue;
            }
            log.log(Messages.PlatzhalterProperties_message_empty, 4);
        }
        if (!noKategorie.getChildren().isEmpty()) {
            root.addChild(noKategorie);
        }
        return root.getChildren();
    }
}

