/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.HistoryLoader;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.controls.PagingComposite;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class HistoryDisplay
extends Composite
implements BackgroundJob.BackgroundJobListener {
    FormText text;
    ArrayList<IEncounter> lKons;
    private HistoryLoader loader;
    private final ScrolledComposite scrolledComposite;
    boolean multiline = false;
    private static final int PAGING_FETCHSIZE = 20;
    private PagingComposite pagingComposite;
    private IPatient actPatient;

    public HistoryDisplay(Composite parent, IViewSite site) {
        this(parent, site, false);
    }

    public HistoryDisplay(Composite parent, IViewSite site, boolean multiline) {
        super(parent, 0);
        this.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        this.setLayoutData(new GridData(0x1000000, 128, true, true));
        this.pagingComposite = new PagingComposite(this, 0){

            @Override
            public void runPaging() {
                HistoryDisplay.this.start();
            }
        };
        this.scrolledComposite = new ScrolledComposite((Composite)this, 512);
        this.scrolledComposite.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.multiline = multiline;
        this.lKons = new ArrayList(20);
        this.text = UiDesk.getToolkit().createFormText((Composite)this.scrolledComposite, false);
        this.text.setWhitespaceNormalized(true);
        this.text.setColor("blau", UiDesk.getColorRegistry().get("blau"));
        this.text.setColor("gruen", UiDesk.getColorRegistry().get("hellgrau"));
        this.text.setColor("dunkelgrau", UiDesk.getColorRegistry().get("dunkelgrau"));
        this.text.setFont(UiDesk.getFont("anwender/stdfont"));
        this.scrolledComposite.setContent((Control)this.text);
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String id = (String)e.getHref();
                java.util.Optional loaded = CoreModelServiceHolder.get().load(id, IEncounter.class);
                if (loaded.isPresent()) {
                    ContextServiceHolder.get().setTyped(loaded.get());
                } else {
                    ContextServiceHolder.get().removeTyped(IEncounter.class);
                }
            }
        });
        this.text.setText(Messages.Core_No_patient_selected, false, false);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(HistoryDisplay.this.scrolledComposite.getSize().x - 15, -1));
            }
        });
        CoreUiUtil.injectServicesWithContext((Object)this);
    }

    public void dispose() {
        this.scrolledComposite.dispose();
    }

    public void setFilter(KonsFilter f) {
        this.stop();
        this.loader.setFilter(f);
    }

    public void start() {
        this.start(null);
    }

    public void start(KonsFilter f) {
        this.stop();
        if (f == null) {
            this.loader = new HistoryLoader(new StringBuilder(), this.lKons, this.multiline, this.pagingComposite.getCurrentPage(), this.pagingComposite.getFetchSize());
        } else {
            this.pagingComposite.reset();
            this.loader = new HistoryLoader(new StringBuilder(), this.lKons, this.multiline, 0, 0);
        }
        this.loader.setFilter(f);
        this.loader.addListener(this);
        this.loader.schedule();
    }

    public void stop() {
        if (this.loader != null) {
            this.loader.removeListener(this);
            this.loader.cancel();
        }
    }

    public void load(ICoverage fall, boolean clear) {
        if (clear) {
            this.lKons.clear();
        }
        if (fall != null) {
            for (IEncounter k : fall.getEncounters()) {
                if (!AccessControlServiceHolder.get().evaluate(EvACE.of(IEncounter.class, (Right)Right.READ, (String)StoreToStringServiceHolder.getStoreToString((Object)k)).and(Right.VIEW))) continue;
                this.lKons.add(k);
            }
        }
    }

    public void showLoading() {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!HistoryDisplay.this.isDisposed()) {
                    HistoryDisplay.this.scrolledComposite.setOrigin(0, 0);
                    if (!HistoryDisplay.this.lKons.isEmpty()) {
                        HistoryDisplay.this.text.setText("wird geladen...", false, false);
                        HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(HistoryDisplay.this.scrolledComposite.getSize().x - 10, -1));
                    }
                }
            }
        });
    }

    public synchronized void load(IPatient pat) {
        int page = 1;
        if (this.actPatient != null && this.actPatient.equals(pat)) {
            page = this.pagingComposite.getCurrentPage();
        }
        if (pat != null) {
            this.lKons.clear();
            for (ICoverage f : pat.getCoverages()) {
                this.load(f, false);
            }
            this.pagingComposite.setup(page, this.lKons.size(), 20);
        }
        this.actPatient = pat;
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String s = (String)HistoryDisplay.this.loader.getData();
                if (!HistoryDisplay.this.isDisposed()) {
                    if (s != null) {
                        int idxFrom = s.indexOf("<form>");
                        int idxTo = s.indexOf("</form>");
                        if (idxFrom != -1 && idxTo != -1) {
                            s = s.substring(idxFrom + 6, s.indexOf("</form>"));
                            HistoryDisplay.this.text.setText("<form>" + this.getDateFromToText() + s + "</form>", true, true);
                        }
                    } else {
                        HistoryDisplay.this.text.setText(ContextServiceHolder.get().getActivePatient().orElse(null) != null ? "" : Messages.Core_No_patient_selected, false, false);
                    }
                    HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(HistoryDisplay.this.scrolledComposite.getSize().x - 10, -1));
                }
            }

            public String getDateFromToText() {
                if (HistoryDisplay.this.loader.getlKons() != null && !HistoryDisplay.this.loader.getlKons().isEmpty()) {
                    IEncounter firstKons = HistoryDisplay.this.loader.getlKons().get(HistoryDisplay.this.loader.getlKons().size() - 1);
                    IEncounter lastKons = HistoryDisplay.this.loader.getlKons().get(0);
                    String fromDate = firstKons != null ? firstKons.getDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) : "-";
                    String toDate = lastKons != null ? lastKons.getDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) : "-";
                    return "<p><span color=\"dunkelgrau\">von " + fromDate + " bis " + toDate + "</span></p>";
                }
                return "";
            }
        });
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> this.adaptForUser(user));
    }

    private void adaptForUser(IUser user) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setFont(UiDesk.getFont("anwender/stdfont"));
        }
    }
}

