/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.wizards.DBImportWizard;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ImporterPage
implements IExecutableExtension {
    protected Log log = Log.get("Import");
    public String[] results;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void run(boolean waitUntilFinished) {
        ImporterJob job = new ImporterJob();
        job.schedule();
        if (waitUntilFinished) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ExHandler.handle((Throwable)e);
            }
        }
    }

    public abstract IStatus doImport(IProgressMonitor var1) throws Exception;

    public abstract String getTitle();

    public abstract String getDescription();

    public abstract List<String> getObjectClass();

    public void collect() {
    }

    public abstract Composite createPage(Composite var1);

    public static class DBBasedImporter
    extends Composite {
        public Text tSource;
        ImporterPage h;

        public DBBasedImporter(Composite parent, final ImporterPage home) {
            super(parent, 0);
            this.h = home;
            this.setLayout((Layout)new GridLayout());
            Label lSource = new Label((Composite)this, 0);
            final String[] preset = CoreHub.localCfg.getStringArray("ImporterPage/" + home.getTitle() + "/database");
            this.tSource = new Text((Composite)this, 2048);
            lSource.setText(Messages.ImporterPage_source);
            this.tSource.setEditable(false);
            lSource.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tSource.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tSource.setText("");
            if (preset != null) {
                this.tSource.setText(preset[0]);
            }
            home.results = new String[5];
            int i = 0;
            while (i < home.results.length) {
                home.results[i] = null;
                ++i;
            }
            Button bSource = new Button((Composite)this, 8);
            bSource.setText(Messages.ImporterPage_selectDB);
            bSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBImportWizard wizard = new DBImportWizard(preset);
                    WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)wizard);
                    if (wd.open() == 0) {
                        String type = wizard.getType();
                        tSource.setText(type);
                        home.results[0] = type;
                        home.results[1] = wizard.getServer();
                        home.results[2] = wizard.getDb();
                        home.results[3] = wizard.getUser();
                        home.results[4] = wizard.getPassword();
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/database", StringTool.join((String[])home.results, (String)","));
                        CoreHub.localCfg.flush();
                    }
                }
            });
        }

        public Result<JdbcLink> getConnection() {
            JdbcLink ret = null;
            if (this.h.results[0].equalsIgnoreCase("mysql")) {
                ret = JdbcLink.createMySqlLink((String)this.h.results[1], (String)this.h.results[2]);
            } else if (this.h.results[0].equalsIgnoreCase("postgresql")) {
                ret = JdbcLink.createPostgreSQLLink((String)this.h.results[1], (String)this.h.results[2]);
            } else if (this.h.results[0].equalsIgnoreCase("h2")) {
                ret = JdbcLink.createH2Link((String)this.h.results[1]);
            } else if (this.h.results[0].equalsIgnoreCase("odbc")) {
                ret = JdbcLink.createODBCLink((String)this.h.results[1]);
            } else {
                return new Result(Result.SEVERITY.ERROR, 1, Messages.ImporterPage_unknownType, null, true);
            }
            if (ret != null) {
                try {
                    ret.connect(this.h.results[3], this.h.results[4]);
                    return new Result((Object)ret);
                }
                catch (JdbcLinkException jdbcLinkException) {
                    // empty catch block
                }
            }
            return new Result(Result.SEVERITY.ERROR, 2, Messages.ImporterPage_couldntConnect, (Object)ret, true);
        }
    }

    public static class DirectoryBasedImporter
    extends Composite {
        public Text tFname;

        public DirectoryBasedImporter(final Composite parent, final ImporterPage home) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(1, false));
            Label lFile = new Label((Composite)this, 0);
            this.tFname = new Text((Composite)this, 2048);
            lFile.setText(Messages.ImporterPage_dir);
            lFile.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tFname.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tFname.setText(CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/dirname", ""));
            home.results = new String[1];
            home.results[0] = this.tFname.getText();
            Button bFile = new Button((Composite)this, 8);
            bFile.setText(Messages.ImporterPage_browse);
            bFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog fdl = new DirectoryDialog(parent.getShell(), 4096);
                    String filename = fdl.open();
                    if (filename != null) {
                        tFname.setText(filename);
                        home.results[0] = filename;
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/dirname", filename);
                    }
                }
            });
        }
    }

    public static class FileBasedImporter
    extends Composite {
        public Text tFname;
        private String[] filterExts = new String[]{"*"};
        private String[] filterNames = new String[]{Messages.Core_All_Files};

        public FileBasedImporter(Composite parent, ImporterPage home) {
            this(parent, home, false);
        }

        public FileBasedImporter(final Composite parent, final ImporterPage home, final boolean supportMultiFileSelection) {
            super(parent, 2048);
            this.setLayout((Layout)new GridLayout(1, false));
            Label lFile = new Label((Composite)this, 0);
            this.tFname = new Text((Composite)this, 2048);
            this.tFname.setText(CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/filename", ""));
            home.results = new String[1];
            home.results[0] = this.tFname.getText();
            lFile.setText(Messages.ImporterPage_file);
            lFile.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tFname.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tFname.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String filename = tFname.getText();
                    if (new File(filename).isFile()) {
                        home.results[0] = filename;
                    }
                }
            });
            Button bFile = new Button((Composite)this, 8);
            bFile.setText(Messages.ImporterPage_browse);
            bFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int style = supportMultiFileSelection ? 4098 : 4096;
                    FileDialog fdl = new FileDialog(parent.getShell(), style);
                    fdl.setFilterExtensions(filterExts);
                    fdl.setFilterNames(filterNames);
                    fdl.open();
                    String[] fileNames = fdl.getFileNames();
                    if (fileNames != null && fileNames.length > 0) {
                        if (fileNames.length > 1) {
                            tFname.setText(String.valueOf(fileNames[0]) + " and more ...");
                        } else {
                            tFname.setText(fileNames[0]);
                        }
                        home.results = new String[fileNames.length];
                        int i = 0;
                        while (i < fileNames.length) {
                            home.results[i] = String.valueOf(fdl.getFilterPath()) + File.separator + fileNames[i];
                            ++i;
                        }
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", fileNames[0]);
                    }
                }
            });
        }

        public void setFilter(String[] extensions, String[] names) {
            this.filterExts = extensions;
            this.filterNames = names;
        }
    }

    public class ImporterJob
    extends Job {
        ImporterJob() {
            super(ImporterPage.this.getTitle());
            this.setPriority(30);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                List<String> objectClass = ImporterPage.this.getObjectClass();
                boolean allRightsOk = objectClass.stream().map(type -> AccessControlServiceHolder.get().evaluate(new ObjectEvaluatableACE(type, Right.IMPORT).and(Right.CREATE).and(Right.UPDATE).and(Right.DELETE).and(Right.READ))).allMatch(n -> n);
                if (!allRightsOk) {
                    throw new Exception("Insufficient rights [requires crudi] on objects " + objectClass);
                }
                return ImporterPage.this.doImport(monitor);
            }
            catch (Exception e) {
                return new Status(4, "ch.elexis.core.ui", String.valueOf(Messages.Core_Error_while_importing) + " " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class ODBCBasedImporter
    extends Composite {
        public Text tSource;

        public ODBCBasedImporter(final Composite parent, final ImporterPage home) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            Label lSource = new Label((Composite)this, 0);
            this.tSource = new Text((Composite)this, 2048);
            lSource.setText(Messages.ImporterPage_source);
            this.tSource.setEditable(false);
            lSource.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tSource.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tSource.setText(CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/ODBC-Source", ""));
            home.results = new String[1];
            home.results[0] = this.tSource.getText();
            Button bSource = new Button((Composite)this, 8);
            bSource.setText(Messages.ImporterPage_enter);
            bSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog in = new InputDialog(parent.getShell(), Messages.ImporterPage_odbcSource, Messages.ImporterPage_pleaseEnterODBC, null, null);
                    if (in.open() == 0) {
                        tSource.setText(in.getValue());
                        home.results[0] = in.getValue();
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/ODBC-Source", home.results[0]);
                    }
                }
            });
        }
    }
}

