/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextTemplateComposite
extends Composite {
    @Inject
    private ITextReplacementService replacementService;
    private Text replacementProposals;
    private StyledText templateText;
    private Text subjectText;
    private ITextTemplate template;

    public TextTemplateComposite(Composite parent, int style) {
        super(parent, style);
        CoreUiUtil.injectServices((Object)((Object)this));
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.replacementProposals = new Text((Composite)this, 2048);
        this.replacementProposals.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ContentProposalAdapter toAddressProposalAdapter = new ContentProposalAdapter((Control)this.replacementProposals, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ReplacementProposalProvider(), null, null);
        toAddressProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                boolean insertSpace = false;
                if (TextTemplateComposite.this.templateText.getCaretOffset() > 0) {
                    String beforeChar = TextTemplateComposite.this.templateText.getText(TextTemplateComposite.this.templateText.getCaretOffset() - 1, TextTemplateComposite.this.templateText.getCaretOffset() - 1);
                    insertSpace = !" ".equals(beforeChar) && !"\n".equals(beforeChar);
                }
                String insertText = String.valueOf(insertSpace ? " [" : "[") + proposal.getContent() + "]";
                TextTemplateComposite.this.templateText.insert(insertText);
                TextTemplateComposite.this.templateText.setCaretOffset(TextTemplateComposite.this.templateText.getCaretOffset() + insertText.length());
                TextTemplateComposite.this.replacementProposals.setText("");
            }
        });
        this.replacementProposals.setMessage("Platzhalter Suche und Auswahl");
        this.subjectText = new Text((Composite)this, 2048);
        this.subjectText.setMessage("Betreff");
        this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.templateText = new StyledText((Composite)this, 2050);
        this.templateText.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void setTemplate(ITextTemplate template) {
        this.template = template;
        if (template != null && template.getTemplate() != null) {
            this.templateText.setText(template.getTemplate());
            if (template.getExtInfo((Object)"subject") != null) {
                this.subjectText.setText((String)template.getExtInfo((Object)"subject"));
            } else {
                this.subjectText.setText("");
            }
            return;
        }
        this.templateText.setText("");
    }

    public void updateModel() {
        if (this.template != null) {
            this.template.setTemplate(this.templateText.getText());
            this.template.setExtInfo((Object)"subject", (Object)this.subjectText.getText());
        }
    }

    public void save() {
        if (this.template != null) {
            this.updateModel();
            CoreModelServiceHolder.get().save((Identifiable)this.template);
        }
    }

    private class ReplacementProposalProvider
    implements IContentProposalProvider {
        private ReplacementProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            contents = contents.toLowerCase();
            ArrayList<Object> proposals = new ArrayList<Object>();
            for (ITextPlaceholderResolver resolver : TextTemplateComposite.this.replacementService.getResolvers()) {
                List attributes = resolver.getSupportedAttributes();
                for (PlaceholderAttribute attribute : attributes) {
                    String proposalText = String.valueOf(attribute.getTypeName()) + "." + attribute.getAttributeName();
                    if (!proposalText.toLowerCase().contains(contents)) continue;
                    proposals.add(new ContentProposal(proposalText));
                }
            }
            proposals.sort(new Comparator<IContentProposal>(){

                @Override
                public int compare(IContentProposal arg0, IContentProposal arg1) {
                    return arg0.getLabel().compareTo(arg1.getLabel());
                }
            });
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }
}

