/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AllOrNoneLockRequestingRestrictedAction<T extends PersistentObject>
extends RestrictedAction {
    private List<T> objects;

    public AllOrNoneLockRequestingRestrictedAction(EvaluatableACE evaluatableAce, String text) {
        super(evaluatableAce, text);
    }

    public AllOrNoneLockRequestingRestrictedAction(EvaluatableACE evaluatableAce, String text, int val) {
        super(evaluatableAce, text, val);
    }

    @Override
    public void doRun() {
        if (!AccessControlServiceHolder.get().evaluate(this.evaluatableAce)) {
            return;
        }
        this.objects = this.getTargetedObjects();
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        ArrayList<LockInfo> acquiredLocks = new ArrayList<LockInfo>();
        for (PersistentObject object : this.objects) {
            LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)object);
            if (lr.isOk()) {
                acquiredLocks.add(lr.getLockInfo());
                continue;
            }
            LockResponseHelper.showInfo(lr, object, log);
            this.releaseAllAcquiredLocks(acquiredLocks);
            return;
        }
        this.doRun(this.objects);
        this.releaseAllAcquiredLocks(acquiredLocks);
    }

    private void releaseAllAcquiredLocks(List<LockInfo> acquiredLocks) {
        for (LockInfo lockInfo : acquiredLocks) {
            LockResponse lockResponse = LocalLockServiceHolder.get().releaseLock(lockInfo);
            if (lockResponse.isOk()) continue;
            log.warn("Could not release lock for [{}] with lock response [{}]", (Object)(String.valueOf(lockInfo.getElementType()) + "::" + lockInfo.getElementId()), (Object)lockResponse.getStatus());
        }
    }

    public abstract List<T> getTargetedObjects();

    public abstract void doRun(List<T> var1);
}

