/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.AnschriftEingabeDialog;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import ch.elexis.data.Mandant;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class KontaktErfassenDialog
extends TitleAreaDialog {
    private Button bOrganisation;
    private Button bLabor;
    private Button bPerson;
    private Button bPatient;
    private Button bAnwender;
    private Button bMandant;
    Kontakt newKontakt = null;
    String[] fld;
    Text tName;
    Text tVorname;
    Text tZusatz;
    Text tGebDat;
    Text tStrasse;
    Text tPlz;
    Text tOrt;
    Text tMobile;
    Text tFax;
    Text tEmail;
    Combo cbSex;
    Label lName;
    Label lVorname;
    Label lZusatz;
    Hyperlink hlAnschrift;

    public KontaktErfassenDialog(Shell parent, String[] fields) {
        super(parent);
        this.fld = fields;
    }

    protected Control createDialogArea(Composite parent) {
        Composite typeComp = new Composite(parent, 0);
        typeComp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        typeComp.setLayout((Layout)new GridLayout(1, false));
        Composite cTypes = UiDesk.getToolkit().createComposite(typeComp, 2048);
        cTypes.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        cTypes.setLayout((Layout)new FillLayout());
        this.bOrganisation = UiDesk.getToolkit().createButton(cTypes, Messages.Core_Organisation, 32);
        this.bOrganisation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bOrganisationChanged(KontaktErfassenDialog.this.bOrganisation.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        this.bLabor = UiDesk.getToolkit().createButton(cTypes, Messages.Core_Laboratory, 32);
        this.bLabor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bLaborChanged(KontaktErfassenDialog.this.bLabor.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        this.bPerson = UiDesk.getToolkit().createButton(cTypes, Messages.Core_Person, 32);
        this.bPerson.setSelection(true);
        this.bPerson.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bPersonChanged(KontaktErfassenDialog.this.bPerson.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        this.bPatient = UiDesk.getToolkit().createButton(cTypes, Messages.Core_Patient, 32);
        this.bPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bPatientChanged(KontaktErfassenDialog.this.bPatient.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        if (this.fld.length > 11 && !StringTool.isNothing((Object)this.fld[11])) {
            this.bPatient.setSelection(true);
        }
        this.bAnwender = UiDesk.getToolkit().createButton(cTypes, Messages.Core_User, 32);
        this.bAnwender.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bAnwenderChanged(KontaktErfassenDialog.this.bAnwender.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        this.bMandant = UiDesk.getToolkit().createButton(cTypes, Messages.Core_Mandator, 32);
        this.bMandant.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktErfassenDialog.this.bMandantChanged(KontaktErfassenDialog.this.bMandant.getSelection());
                KontaktErfassenDialog.this.updateOkButtonState();
            }
        });
        if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IUser.class, (Right)Right.UPDATE))) {
            this.bMandant.setEnabled(false);
            this.bAnwender.setEnabled(false);
        }
        if (CoreUtil.isMac()) {
            new Label(cTypes, 0);
            typeComp.pack();
        }
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(2, false));
        this.lName = new Label(ret, 0);
        this.lName.setText(Messages.Core_Name);
        this.tName = new Text(ret, 2048);
        this.tName.setText(this.fld[0]);
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tName.setTextLimit(80);
        this.lVorname = new Label(ret, 0);
        this.lVorname.setText(Messages.Core_Firstname);
        this.tVorname = new Text(ret, 2048);
        this.tVorname.setText(this.fld[1] == null ? "" : this.fld[1]);
        this.tVorname.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tVorname.setTextLimit(80);
        this.tName.addModifyListener(e -> this.updateOkButtonState());
        this.tVorname.addModifyListener(e -> this.updateOkButtonState());
        this.lZusatz = new Label(ret, 0);
        this.lZusatz.setText(Messages.Core_Additional);
        this.tZusatz = new Text(ret, 2048);
        this.tZusatz.setText(this.fld.length > 7 ? this.fld[7] : "");
        this.tZusatz.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.Sex);
        this.cbSex = new Combo(ret, 4);
        this.cbSex.setItems(new String[]{Messages.KontaktErfassenDialog_male, Messages.KontaktErfassenDialog_female});
        if (this.fld.length <= 10 || this.fld[10].length() == 0) {
            if (StringTool.isNothing((Object)this.fld[1])) {
                this.cbSex.select(0);
            } else {
                this.cbSex.select(StringTool.isFemale((String)this.fld[1]) ? 1 : 0);
            }
        } else {
            this.cbSex.select(this.fld[10].equals("m") ? 0 : 1);
        }
        new Label(ret, 0).setText(Messages.Core_Enter_Birthdate);
        this.tGebDat = new Text(ret, 2048);
        this.tGebDat.setText(this.fld[2] == null ? "" : this.fld[2]);
        this.tGebDat.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tGebDat.setTextLimit(8);
        new Label(ret, 0).setText(Messages.Core_Street);
        this.tStrasse = new Text(ret, 2048);
        this.tStrasse.setText(this.fld.length > 3 ? this.fld[3] : "");
        this.tStrasse.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tStrasse.setTextLimit(80);
        new Label(ret, 0).setText(Messages.Core_Postal_code);
        this.tPlz = new Text(ret, 2048);
        this.tPlz.setText(this.fld.length > 4 ? this.fld[4] : "");
        this.tPlz.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tPlz.setTextLimit(6);
        new Label(ret, 0).setText(Messages.Core_City);
        this.tOrt = new Text(ret, 2048);
        this.tOrt.setText(this.fld.length > 5 ? this.fld[5] : "");
        this.tOrt.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tOrt.setTextLimit(50);
        new Label(ret, 0).setText(Messages.Core_Mobilephone);
        this.tMobile = new Text(ret, 2048);
        this.tMobile.setText(this.fld.length > 6 ? this.fld[6] : "");
        this.tMobile.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tMobile.setTextLimit(30);
        new Label(ret, 0).setText(Messages.Core_Fax);
        this.tFax = new Text(ret, 2048);
        this.tFax.setText(this.fld.length > 8 ? this.fld[8] : "");
        this.tFax.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tFax.setTextLimit(30);
        new Label(ret, 0).setText(Messages.KontaktErfassenDialog_email);
        this.tEmail = new Text(ret, 2048);
        this.tEmail.setText(this.fld.length > 9 ? this.fld[9] : "");
        this.tEmail.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tEmail.setTextLimit(80);
        new Label(ret, 0).setText(Messages.Core_Postal_Address);
        this.hlAnschrift = UiDesk.getToolkit().createHyperlink(ret, Messages.KontaktErfassenDialog_postalempty, 0);
        this.hlAnschrift.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                KontaktErfassenDialog.this.createKontakt();
                AnschriftEingabeDialog aed = new AnschriftEingabeDialog(KontaktErfassenDialog.this.getShell(), KontaktErfassenDialog.this.newKontakt);
                aed.create();
                SWTHelper.center(KontaktErfassenDialog.this.getShell(), aed.getShell());
                aed.open();
                KontaktErfassenDialog.this.hlAnschrift.setText(KontaktErfassenDialog.this.newKontakt.getPostAnschrift(false));
            }
        });
        this.hlAnschrift.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        return ret;
    }

    public void create() {
        super.create();
        this.updateOkButtonState();
        this.setMessage(Messages.KontaktErfassenDialog_message);
        this.setTitle(Messages.KontaktErfassenDialog_subTitle);
        this.getShell().setText(Messages.KontaktErfassenDialog_title);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void bOrganisationChanged(boolean isSelected) {
        this.bOrganisation.setSelection(isSelected);
        if (isSelected) {
            this.bPersonChanged(false);
            this.lName.setText(Messages.Core_Description);
            this.lVorname.setText(Messages.Core_Additional);
            this.lZusatz.setText(Messages.ContactPerson);
            this.cbSex.setEnabled(false);
            this.lName.getParent().layout();
        } else {
            this.bLaborChanged(false);
        }
    }

    protected void bLaborChanged(boolean isSelected) {
        this.bLabor.setSelection(isSelected);
        if (isSelected) {
            this.bOrganisationChanged(true);
            this.lZusatz.setText(Messages.Core_Laboratory_Admin);
            this.lName.getParent().layout();
        }
    }

    protected void bPersonChanged(boolean isSelected) {
        this.bPerson.setSelection(isSelected);
        if (isSelected) {
            this.bOrganisationChanged(false);
            this.lName.setText(Messages.Core_Name);
            this.lVorname.setText(Messages.Core_Firstname);
            this.lZusatz.setText(Messages.Core_Additional);
            this.cbSex.setEnabled(true);
            this.lName.getParent().layout();
        } else {
            this.bAnwenderChanged(false);
            this.bMandantChanged(false);
            this.bPatientChanged(false);
        }
    }

    protected void bAnwenderChanged(boolean isSelected) {
        this.bAnwender.setSelection(isSelected);
        if (isSelected) {
            this.bPatientChanged(false);
            this.bPersonChanged(true);
        } else {
            this.bMandantChanged(false);
        }
    }

    protected void bMandantChanged(boolean isSelected) {
        this.bMandant.setSelection(isSelected);
        if (isSelected) {
            this.bAnwenderChanged(true);
        }
    }

    protected void bPatientChanged(boolean isSelected) {
        this.bPatient.setSelection(isSelected);
        if (isSelected) {
            this.bAnwenderChanged(false);
            this.bPersonChanged(true);
        }
    }

    private void createKontakt() {
        String[] ret = new String[8];
        ret[0] = this.tName.getText();
        ret[1] = this.tVorname.getText();
        int idx = this.cbSex.getSelectionIndex();
        if (idx == -1) {
            SWTHelper.showError(Messages.KontaktErfassenDialog_geschlechtFehlt_title, Messages.KontaktErfassenDialog_geschlechtFehlt_msg);
            return;
        }
        ret[2] = this.cbSex.getItem(idx);
        ret[3] = this.tGebDat.getText();
        try {
            if (!StringTool.isNothing((Object)ret[3])) {
                new TimeTool(ret[3], true);
            }
            ret[4] = this.tStrasse.getText();
            ret[5] = this.tPlz.getText();
            ret[6] = this.tOrt.getText();
            ret[7] = this.tMobile.getText();
            if (this.newKontakt == null) {
                Query qbe = new Query(Kontakt.class);
                qbe.add("Bezeichnung1", "=", ret[0]);
                qbe.add("Bezeichnung2", "=", ret[1]);
                List list = qbe.execute();
                if (list != null && !list.isEmpty()) {
                    Kontakt k = (Kontakt)list.get(0);
                    if (this.bOrganisation.getSelection() && k.istOrganisation()) {
                        if (this.bLabor.getSelection()) {
                            k.set("istOrganisation", "1");
                        }
                        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.KontaktErfassenDialog_organisationExistiert_title, (String)Messages.KontaktErfassenDialog_organisationExistiert_msg)) {
                            super.okPressed();
                            return;
                        }
                    }
                    if (k.istPerson()) {
                        if (this.bAnwender.getSelection()) {
                            k.set("istAnwender", "1");
                        }
                        if (this.bMandant.getSelection()) {
                            k.set("istMandant", "1");
                        }
                        if (this.bPatient.getSelection()) {
                            k.set("istPatient", "1");
                        }
                        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.KontaktErfassenDialog_personExisitiert_title, (String)Messages.KontaktErfassenDialog_personExisitiert_msg)) {
                            super.okPressed();
                            return;
                        }
                    }
                }
                if (this.bMandant.getSelection()) {
                    this.newKontakt = new Mandant(ret[0], ret[1], ret[3], ret[2]);
                    this.newKontakt.set("Zusatz", this.tZusatz.getText());
                } else if (this.bAnwender.getSelection()) {
                    this.newKontakt = new Anwender(ret[0], ret[1], ret[3], ret[2]);
                    this.newKontakt.set("Zusatz", this.tZusatz.getText());
                } else if (this.bPatient.getSelection()) {
                    this.newKontakt = new Patient(ret[0], ret[1], ret[3], ret[2]);
                    this.newKontakt.set("Zusatz", this.tZusatz.getText());
                } else if (this.bPerson.getSelection()) {
                    this.newKontakt = new Person(ret[0], ret[1], ret[3], ret[2]);
                    this.newKontakt.set("Zusatz", this.tZusatz.getText());
                } else if (this.bLabor.getSelection()) {
                    this.newKontakt = new Labor(ret[0], ret[0]);
                    this.newKontakt.set("Zusatz1", ret[1]);
                    this.newKontakt.set("Ansprechperson", this.tZusatz.getText());
                } else if (this.bOrganisation.getSelection()) {
                    this.newKontakt = new Organisation(ret[0], ret[1]);
                    this.newKontakt.set("Ansprechperson", this.tZusatz.getText());
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.KontaktErfassenDialog_unbekannterTyp_title, (String)Messages.KontaktErfassenDialog_unbekannterTyp_msg);
                    return;
                }
            }
            if (LocalLockServiceHolder.get().acquireLock((Object)this.newKontakt).isOk()) {
                this.newKontakt.set(new String[]{"Strasse", "Plz", "Ort", "NatelNr", "Fax", "E-Mail"}, new String[]{ret[4], ret[5], ret[6], ret[7], this.tFax.getText(), this.tEmail.getText()});
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)this.newKontakt);
                LocalLockServiceHolder.get().releaseLock((Object)this.newKontakt);
            }
        }
        catch (TimeTool.TimeFormatException e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError(Messages.KontaktErfassenDialog_falschesDatum_title, Messages.KontaktErfassenDialog_falschesDatum_msg);
            return;
        }
    }

    protected void okPressed() {
        this.createKontakt();
        super.okPressed();
    }

    @Deprecated
    public Kontakt getResult() {
        return this.newKontakt;
    }

    public Optional<IContact> getContact() {
        if (this.newKontakt != null && this.newKontakt.exists()) {
            return CoreModelServiceHolder.get().load(this.newKontakt.getId(), IContact.class);
        }
        return Optional.empty();
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateOkButtonState() {
        Button okButton;
        IValidator notEmptyValidator = value -> {
            if (value == null || value.trim().isEmpty()) {
                return ValidationStatus.error((String)"Eingabefeld darf nicht leer sein.");
            }
            return ValidationStatus.ok();
        };
        IStatus statusName = notEmptyValidator.validate((Object)this.tName.getText());
        IStatus statusVorname = ValidationStatus.ok();
        if (!this.bOrganisation.getSelection()) {
            statusVorname = notEmptyValidator.validate((Object)this.tVorname.getText());
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(statusName.isOK() && statusVorname.isOK());
        }
    }
}

