/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.views.BriefAuswahl;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.core.ui.views.controls.GenericSearchSelectionDialog;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class BriefNewHandler
extends AbstractHandler
implements IHandler {
    public static final String CMD_ID = "ch.elexis.core.ui.commands.BriefNew";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Konsultation selectedKonsultation;
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat == null) {
            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)ch.elexis.core.l10n.Messages.Core_No_patient_selected, (String)ch.elexis.core.l10n.Messages.Core_No_patient_selected);
            return null;
        }
        Fall selectedFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        if (selectedFall == null) {
            SelectFallDialog sfd = new SelectFallDialog(UiDesk.getTopShell());
            sfd.open();
            if (sfd.result != null) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)sfd.result);
            } else {
                MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)ch.elexis.core.l10n.Messages.TextView_NoCaseSelected, (String)ch.elexis.core.l10n.Messages.TextView_SaveNotPossibleNoCaseAndKonsSelected);
                return null;
            }
        }
        if ((selectedKonsultation = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)) == null) {
            Konsultation k = pat.getLetzteKons(false);
            if (k == null) {
                k = ((Fall)ElexisEventDispatcher.getSelected(Fall.class)).neueKonsultation();
                k.setMandant(ContextServiceHolder.getActiveMandatorOrNull());
            }
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
        }
        TextView tv = null;
        try {
            Query qbe = new Query(Brief.class);
            qbe.add("Typ", "=", "Vorlagen");
            qbe.add("BehandlungsID", "<>", "SYS");
            qbe.startGroup();
            qbe.add("DestID", "=", ElexisEventDispatcher.getSelectedMandator().getId());
            qbe.or();
            qbe.add("DestID", "=", "");
            qbe.endGroup();
            List lBrief = qbe.execute();
            GenericSearchSelectionDialog dialog = new GenericSearchSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), lBrief, ch.elexis.core.l10n.Messages.DocumentSelectDialog_schooseTemplateForLetter, Messages.DocumentSelectDialog_createLetterWithTemplate, Messages.DocumentSelectDialog_pleaseSelectTemplateFromList, null, 4);
            String subject = null;
            Kontakt address = null;
            if (dialog.open() == 0) {
                Brief result;
                tv = (TextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.TextView");
                IStructuredSelection sel = dialog.getSelection();
                if (sel != null && !sel.isEmpty() && StringTool.isNothing((Object)(subject = (result = (Brief)sel.getFirstElement()).getBetreff()))) {
                    subject = result.getBetreff();
                }
                if (dialog.getSelection() != null) {
                    if (DocumentSelectDialog.getDontAskForAddresseeForThisTemplate((Brief)dialog.getSelection().getFirstElement())) {
                        address = Kontakt.load((String)"-1");
                    }
                    tv.createDocument((Brief)dialog.getSelection().getFirstElement(), subject, address);
                    tv.setName();
                    IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.elexis.BriefAuswahlView");
                    if (viewPart instanceof BriefAuswahl) {
                        ((BriefAuswahl)viewPart).refreshCV(CommonViewer.Message.update_keeplabels);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return null;
    }
}

