/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.dialogs.NeuerFallDialog;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockedAction;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.util.Importer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.TemplateDrucker;
import ch.elexis.core.ui.views.TemplatePrintView;
import ch.elexis.core.ui.wizards.DBConnectWizard;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalActions {
    public static final String RENAME_COMMAND = "org.eclipse.ui.edit.rename";
    public static final String DELETE_COMMAND = "org.eclipse.ui.edit.delete";
    public static final String PROPERTIES_COMMAND = "org.eclipse.ui.file.properties";
    public static final String DEFAULTPERSPECTIVECFG = "/default_perspective";
    public static ActionFactory.IWorkbenchAction exitAction;
    public static ActionFactory.IWorkbenchAction newWindowAction;
    public static ActionFactory.IWorkbenchAction copyAction;
    public static ActionFactory.IWorkbenchAction cutAction;
    public static ActionFactory.IWorkbenchAction pasteAction;
    public static IAction loginAction;
    public static IAction importAction;
    public static IAction aboutAction;
    public static IAction helpAction;
    public static IAction prefsAction;
    public static IAction connectWizardAction;
    public static IAction savePerspectiveAction;
    public static IAction savePerspectiveAsAction;
    public static IAction savePerspectiveAsDefaultAction;
    public static IAction resetPerspectiveAction;
    public static IAction homeAction;
    public static IAction fixLayoutAction;
    public static IAction printEtikette;
    public static IAction printBlatt;
    public static IAction printAdresse;
    public static IAction printVersionedEtikette;
    public static IAction showBlatt;
    public static IAction printRoeBlatt;
    public static IAction openFallaction;
    public static IAction closeFallAction;
    public static IAction filterAction;
    public static IAction makeBillAction;
    public static IAction planeRechnungAction;
    public static RestrictedAction delKonsAction;
    public static RestrictedAction delFallAction;
    public static RestrictedAction reopenFallAction;
    public static LockedAction<Konsultation> moveBehandlungAction;
    public static LockedAction<Konsultation> redateAction;
    public static IAction neuerFallAction;
    public static MenuManager perspectiveMenu;
    public static MenuManager viewMenu;
    public static IContributionItem viewList;
    public IWorkbenchWindow mainWindow;
    public static Action printKontaktEtikette;
    private static IWorkbenchHelpSystem help;
    private static Logger logger;
    private static ICommandService cmdService;

    public GlobalActions(IWorkbenchWindow window) {
        if (Hub.mainActions != null) {
            return;
        }
        logger = LoggerFactory.getLogger(this.getClass());
        cmdService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        this.mainWindow = window;
        help = Hub.plugin.getWorkbench().getHelpSystem();
        exitAction = ActionFactory.QUIT.create(window);
        exitAction.setText(Messages.GlobalActions_MenuExit);
        newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        newWindowAction.setText(Messages.GlobalActions_NewWindow);
        copyAction = ActionFactory.COPY.create(window);
        copyAction.setText(Messages.GlobalActions_Copy);
        cutAction = ActionFactory.CUT.create(window);
        cutAction.setText(Messages.GlobalActions_Cut);
        pasteAction = ActionFactory.PASTE.create(window);
        pasteAction.setText(Messages.GlobalActions_Paste);
        aboutAction = ActionFactory.ABOUT.create(window);
        aboutAction.setText(Messages.GlobalActions_MenuAbout);
        prefsAction = new OpenPreferencesAction(window);
        prefsAction.setText(Messages.GlobalActions_Preferences);
        savePerspectiveAction = new Action(Messages.GlobalActions_SavePerspective){
            {
                this.setId("savePerspektive");
                this.setToolTipText(Messages.GlobalActions_SavePerspectiveToolTip);
                this.setImageDescriptor(Images.IMG_DISK.getImageDescriptor());
            }

            public void run() {
                IWorkbenchPage page = GlobalActions.this.mainWindow.getActivePage();
                if (page != null && page.getPerspective() != null) {
                    page.savePerspectiveAs(page.getPerspective());
                }
            }
        };
        helpAction = new Action(Messages.GlobalActions_ac_handbook){
            {
                this.setImageDescriptor(Images.IMG_BOOK.getImageDescriptor());
                this.setToolTipText(Messages.GlobalActions_ac_openhandbook);
            }

            public void run() {
                Desktop desktop = Desktop.getDesktop();
                String url = ConfigServiceHolder.getGlobal((String)"org.iatrix.help.wiki/handbook", (String)"https://wiki.elexis.info/Deutsches_Handbuch_3.1");
                if (Desktop.isDesktopSupported()) {
                    try {
                        desktop.browse(new URI(url));
                    }
                    catch (Exception e) {
                        logger.warn("failed to open default browser :" + e);
                        MessageDialog.openError((Shell)GlobalActions.this.mainWindow.getShell(), (String)Messages.Core_Error, (String)Messages.GlobalActions_PreferencesHandbook_URL);
                        ExHandler.handle((Throwable)e);
                    }
                } else {
                    logger.warn("isDesktopSupported was false.");
                }
            }
        };
        savePerspectiveAsAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        resetPerspectiveAction = new Action(Messages.GlobalActions_Home){

            public void run() {
                ContextServiceHolder.get().sendEvent("info/elexis/ui/accesscontrol/reset", ContextServiceHolder.get().getActiveUser().orElse(null));
                EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
                GlobalActions.removeModelOfParts(GlobalActions.getActivePerspective(modelService), modelService);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().resetPerspective();
                GlobalActions.updateModelOfParts(GlobalActions.getActivePerspective(modelService), modelService);
                boolean value = ConfigServiceHolder.getUser((String)"perspectives/fix_layout", (boolean)false);
                ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)(!value ? 1 : 0));
                ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)value);
                ContextServiceHolder.get().sendEvent("info/elexis/ui/accesscontrol/update", (Object)GlobalActions.getActivePerspective(modelService));
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_REFRESH.getImageDescriptor();
            }
        };
        homeAction = new Action(Messages.GlobalActions_Home){
            {
                this.setId("home");
                this.setActionDefinitionId("ch.elexis.core.ui.commands.home");
                this.setImageDescriptor(Images.IMG_HOME.getImageDescriptor());
                this.setToolTipText(Messages.GlobalActions_HomeToolTip);
                help.setHelp((IAction)this, "ch.elexis.globalactions.homeAction");
            }

            public void run() {
                String perspektive = CoreHub.localCfg.get(CoreHub.getLoggedInContact() + GlobalActions.DEFAULTPERSPECTIVECFG, null);
                if (StringTool.isNothing((Object)perspektive)) {
                    perspektive = "ch.elexis.PatientPerspective";
                }
                try {
                    EPartService partService = (EPartService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(EPartService.class);
                    GlobalActions.addModelOfParts(partService);
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    PlatformUI.getWorkbench().showPerspective(perspektive, win);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        savePerspectiveAsDefaultAction = new Action(Messages.GlobalActions_saveasstartperspective){
            {
                this.setId("start");
            }

            public void run() {
                IPerspectiveDescriptor p = GlobalActions.this.mainWindow.getActivePage().getPerspective();
                CoreHub.localCfg.set(CoreHub.getLoggedInContact() + GlobalActions.DEFAULTPERSPECTIVECFG, p.getId());
            }
        };
        loginAction = new RestrictedAction(EvACE.of((String)"ch.elexis.core.ui.login"), Messages.GlobalActions_Login){
            {
                this.setId("login");
                this.setActionDefinitionId("ch.elexis.core.ui.commands.login");
            }

            @Override
            public void doRun() {
                try {
                    IWorkbenchWindow[] wins;
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchWindow[] iWorkbenchWindowArray = wins = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = wins.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow w = iWorkbenchWindowArray[n2];
                        if (!w.equals(win)) {
                            w.close();
                        }
                        ++n2;
                    }
                    String loginUserName = System.getProperty("ch.elexis.username");
                    System.clearProperty("ch.elexis.username");
                    boolean performLogin = CoreOperationAdvisorHolder.get().performLogin((Object)win.getShell());
                    if (loginUserName != null) {
                        System.setProperty("ch.elexis.username", loginUserName);
                    }
                    if (!performLogin) {
                        exitAction.run();
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        importAction = new Action(Messages.GlobalActions_Import){
            {
                this.setId("import");
                this.setActionDefinitionId("ch.elexis.core.ui.commands.import");
            }

            public void run() {
                Importer imp = new Importer(GlobalActions.this.mainWindow.getShell(), "ch.elexis.core.ui.FremdDatenImport");
                imp.create();
                imp.setMessage(Messages.Core_Choose_Import_Source);
                imp.getShell().setText(Messages.Core_Importer);
                imp.setTitle(Messages.GlobalActions_ImportDlgTitle);
                imp.open();
            }
        };
        connectWizardAction = new RestrictedAction(EvACE.of((String)"ACL_DBCONNECTION_CONFIG"), Messages.GlobalActions_Connection){
            {
                this.setId("connectWizard");
                this.setActionDefinitionId("ch.elexis.core.ui.commands.connectWizard");
            }

            @Override
            public void doRun() {
                WizardDialog wd = new WizardDialog(GlobalActions.this.mainWindow.getShell(), (IWizard)new DBConnectWizard());
                wd.open();
            }
        };
        printKontaktEtikette = new Action(Messages.Print_AddressLabel){
            {
                this.setToolTipText(Messages.GlobalActions_PrintContactLabelToolTip);
                this.setImageDescriptor(Images.IMG_ADRESSETIKETTE.getImageDescriptor());
            }

            public void run() {
                Command cmd = cmdService.getCommand("ch.elexis.core.ui.commands.printContactLabel");
                try {
                    cmd.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    logger.error("Failed to execute command ch.elexis.core.ui.commands.printContactLabel", (Throwable)e);
                }
            }
        };
        printAdresse = new Action(Messages.Print_AddressLabel){
            {
                this.setImageDescriptor(Images.IMG_ADRESSETIKETTE.getImageDescriptor());
                this.setToolTipText(Messages.GlobalActions_PrintAddressLabelToolTip);
            }

            public void run() {
                Command cmd = cmdService.getCommand("ch.elexis.core.ui.commands.printAddressLabel");
                try {
                    cmd.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    logger.error("Failed to execute command ch.elexis.core.ui.commands.printAddressLabel", (Throwable)e);
                }
            }
        };
        printVersionedEtikette = new Action(Messages.Core_Print_versioned_Label){
            {
                this.setToolTipText(Messages.GlobalActions_PrintVersionedLabelToolTip);
                this.setImageDescriptor(Images.IMG_VERSIONEDETIKETTE.getImageDescriptor());
            }

            public void run() {
                Command cmd = cmdService.getCommand("ch.elexis.core.ui.commands.printVersionedLabel");
                try {
                    cmd.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    logger.error("Failed to execute command ch.elexis.core.ui.commands.printVersionedLabel", (Throwable)e);
                }
            }
        };
        printEtikette = new Action(Messages.Core_Print_Patient_Label){
            {
                this.setImageDescriptor(Images.IMG_PATIENTETIKETTE.getImageDescriptor());
                this.setToolTipText(Messages.Core_Print_Patient_Label);
            }

            public void run() {
                Command cmd = cmdService.getCommand("ch.elexis.core.ui.commands.printPatientLabel");
                try {
                    cmd.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    logger.error("Failed to execute command ch.elexis.core.ui.commands.printPatientLabel", (Throwable)e);
                }
            }
        };
        printBlatt = new Action(Messages.GlobalActions_PrintEMR){

            public void run() {
                Patient actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                String printer = CoreHub.localCfg.get("Drucker/Einzelblatt/Name", null);
                String tray = CoreHub.localCfg.get("Drucker/Einzelblatt/Schacht", null);
                new TemplateDrucker("KG-Deckblatt", printer, tray).doPrint(actPatient);
            }
        };
        showBlatt = new Action(Messages.GlobalActions_ShowEMR){

            public void run() {
                Patient actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                try {
                    TemplatePrintView tpw = (TemplatePrintView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.views.TemplatePrintView");
                    tpw.doShow(actPatient, "KG-Deckblatt");
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Konnte View nicht \u00f6ffnen");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error showing ch.elexis.views.TemplatePrintView", (Throwable)e);
                }
            }
        };
        printRoeBlatt = new Action(Messages.GlobalActions_PrintXRay){

            public void run() {
                Patient actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                String printer = CoreHub.localCfg.get("Drucker/A4/Name", null);
                String tray = CoreHub.localCfg.get("Drucker/A4/Schacht", null);
                new TemplateDrucker("Roentgen-Blatt", printer, tray).doPrint(actPatient);
            }
        };
        fixLayoutAction = new Action(Messages.GlobalActions_LockPerspectives, 2){
            {
                this.setToolTipText(Messages.GlobalActions_LockPerspectivesToolTip);
                boolean state = ConfigServiceHolder.getUser((String)"perspectives/fix_layout", (boolean)false);
                this.setChecked(state);
                ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)state);
            }

            public void run() {
                boolean state = fixLayoutAction.isChecked();
                ConfigServiceHolder.setUser((String)"perspectives/fix_layout", (boolean)state);
                ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)state);
            }
        };
        makeBillAction = new Action(Messages.GlobalActions_MakeBill){

            public void run() {
                ICoverage actFall = ContextServiceHolder.get().getActiveCoverage().orElse(null);
                IMandator mnd = ContextServiceHolder.get().getActiveMandator().orElse(null);
                if (actFall != null && mnd != null) {
                    String rsId = mnd.getBiller().getId();
                    List bhdl = actFall.getEncounters();
                    ArrayList<IEncounter> lBehdl = new ArrayList<IEncounter>();
                    for (IEncounter b : bhdl) {
                        IInvoice rn = b.getInvoice();
                        if (rn != null || !b.getMandator().getBiller().getId().equals(rsId)) continue;
                        lBehdl.add(b);
                    }
                    Map sortedByYears = BillingUtil.getSortedEncountersByYear(lBehdl);
                    if (!BillingUtil.canBillYears(new ArrayList(sortedByYears.keySet()))) {
                        StringJoiner sj = new StringJoiner(", ");
                        sortedByYears.keySet().forEach(i -> {
                            StringJoiner stringJoiner2 = sj.add(Integer.toString(i));
                        });
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Rechnung Validierung", (String)("Die Leistungen sind aus Jahren die nicht kombinierbar sind.\n\nWollen Sie separate Rechnungen f\u00fcr die Jahre " + sj.toString() + " erstellen?"))) {
                            for (Integer year : sortedByYears.keySet()) {
                                Result res = InvoiceServiceHolder.get().invoice((List)sortedByYears.get(year));
                                if (res.isOK()) continue;
                                ErrorDialog.openError((Shell)GlobalActions.this.mainWindow.getShell(), (String)Messages.Core_Error, (String)Messages.GlobalActions_BillErrorMessage, (IStatus)ResultAdapter.getResultAsStatus((Result)res));
                            }
                        }
                    } else {
                        Result res = InvoiceServiceHolder.get().invoice(lBehdl);
                        if (!res.isOK()) {
                            ErrorDialog.openError((Shell)GlobalActions.this.mainWindow.getShell(), (String)Messages.Core_Error, (String)Messages.GlobalActions_BillErrorMessage, (IStatus)ResultAdapter.getResultAsStatus((Result)res));
                        }
                    }
                }
            }
        };
        moveBehandlungAction = new LockedAction<Konsultation>(Messages.GlobalActions_AssignCase){

            @Override
            public Konsultation getTargetedObject() {
                return (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            }

            @Override
            public void doRun(Konsultation element) {
                Fall f;
                SelectFallDialog dlg = new SelectFallDialog(GlobalActions.this.mainWindow.getShell());
                if (dlg.open() == 0 && (f = dlg.result) != null) {
                    Result result = EncounterServiceHolder.get().transferToCoverage((IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)element, IEncounter.class).get(), (ICoverage)NoPoUtil.loadAsIdentifiable((PersistentObject)f, ICoverage.class).get(), false);
                    if (!result.isOK()) {
                        SWTHelper.alert("Error", result.toString());
                    }
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)f);
                }
            }
        };
        redateAction = new LockedAction<Konsultation>(Messages.GlobalActions_Redate){

            @Override
            public Konsultation getTargetedObject() {
                return (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            }

            @Override
            public void doRun(Konsultation element) {
                DateSelectorDialog dlg = new DateSelectorDialog(GlobalActions.this.mainWindow.getShell());
                if (dlg.open() == 0) {
                    TimeTool date = dlg.getSelectedDate();
                    element.setDatum(date.toString(4), false);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)element, Konsultation.class, 4)});
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)element);
                }
            }
        };
        delFallAction = new LockedRestrictedAction<Fall>((EvaluatableACE)EvACE.of(ICoverage.class, (Right)Right.DELETE), Messages.GlobalActions_DeleteCase){

            @Override
            public void doRun(Fall element) {
                if (!element.delete(false)) {
                    SWTHelper.alert(Messages.GlobalActions_CouldntDeleteCaseMessage, Messages.GlobalActions_CouldntDeleteCaseExplanation);
                }
                ElexisEventDispatcher.reload(Fall.class);
            }

            @Override
            public Fall getTargetedObject() {
                return (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            }
        };
        delKonsAction = new LockedRestrictedAction<Konsultation>((EvaluatableACE)EvACE.of(IEncounter.class, (Right)Right.DELETE), Messages.GlobalActions_DeleteKons){

            @Override
            public void doRun(Konsultation element) {
                if (!element.delete(false)) {
                    SWTHelper.alert(Messages.GlobalActions_CouldntDeleteKons, String.valueOf(Messages.GlobalActions_CouldntDeleteKonsExplanation) + Messages.GlobalActions_97);
                }
                ElexisEventDispatcher.clearSelection(Konsultation.class);
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)element.getFall());
            }

            @Override
            public Konsultation getTargetedObject() {
                return (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            }
        };
        openFallaction = new Action(Messages.Core_Edit_Case){

            public void run() {
                try {
                    Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.FallDetailView");
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        closeFallAction = new LockedAction<Fall>(Messages.GlobalActions_CloseCase){

            @Override
            public Fall getTargetedObject() {
                return (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            }

            @Override
            public void doRun(Fall fall) {
                DateSelectorDialog dsd;
                int retVal;
                if (GlobalActions.this.hasUnbilledConsultations(fall)) {
                    Display display = Display.getDefault();
                    Shell shell = new Shell(display);
                    MessageBox dialog = new MessageBox(shell, 200);
                    dialog.setText(Messages.GlobalActions_CloseCaseDialogTitel);
                    dialog.setMessage(((String)Messages.GlobalActions_CloseCaseDialog).replace("{0}", fall.getLabel()));
                    int response = dialog.open();
                    if (response == 128) {
                        return;
                    }
                }
                if ((retVal = (dsd = new DateSelectorDialog(UiDesk.getTopShell(), null, Messages.GlobalActions_CloseCase_SelectCloseDate)).open()) == 0) {
                    TimeTool endDate = dsd.getSelectedDate();
                    fall.setEndDatum(new TimeTool(endDate.getTime()).toString(4));
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)fall, Fall.class, 4)});
                }
            }
        };
        reopenFallAction = new LockedRestrictedAction<Fall>(EvACE.of(ICoverage.class, (Right)Right.DELETE).and(Right.EXECUTE), Messages.GlobalActions_ReopenCase){

            @Override
            public void doRun(Fall element) {
                element.setEndDatum("");
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)element, Fall.class, 4)});
            }

            @Override
            public Fall getTargetedObject() {
                return (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            }
        };
        neuerFallAction = new Action(Messages.Core_New_Case){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.Core_Create_new_case);
            }

            public void run() {
                Patient pat = ElexisEventDispatcher.getSelectedPatient();
                if (pat != null) {
                    NeuerFallDialog nfd = new NeuerFallDialog(GlobalActions.this.mainWindow.getShell(), null);
                    nfd.open();
                }
            }
        };
        planeRechnungAction = new Action(Messages.GlobalActions_plaBill){

            public void run() {
            }
        };
    }

    public boolean hasUnbilledConsultations(Fall fall) {
        Konsultation[] konsultationen;
        Konsultation[] konsultationArray = konsultationen = fall.getBehandlungen(false);
        int n = konsultationen.length;
        int n2 = 0;
        while (n2 < n) {
            Konsultation kons = konsultationArray[n2];
            Rechnung rechnung = kons.getRechnung();
            if (rechnung == null || rechnung.getInvoiceState() == InvoiceState.CANCELLED) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void printPatient(Patient patient) {
        PrinterData pd = this.getPrinterData("Etiketten");
        if (pd != null) {
            Printer prn;
            Integer iOrientation = -1;
            String sOrientation = CoreHub.localCfg.get("Drucker/Etiketten/Ausrichtung", null);
            try {
                iOrientation = Integer.parseInt(sOrientation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (iOrientation != -1) {
                pd.orientation = iOrientation;
            }
            if ((prn = new Printer(pd)).startJob(Messages.GlobalActions_PrintLabelJobName)) {
                GC gc = new GC((Drawable)prn);
                int y = 0;
                prn.startPage();
                gc.drawString(String.valueOf(Messages.GlobalActions_PatientIDLabelText) + patient.getPatCode(), 0, 0);
                FontMetrics fmt = gc.getFontMetrics();
                String pers = patient.getPersonalia();
                gc.drawString(pers, 0, y += fmt.getHeight());
                gc.drawString(patient.getAnschrift().getEtikette(false, false), 0, y += fmt.getHeight());
                StringBuilder tel = new StringBuilder();
                tel.append(Messages.GlobalActions_PhoneHomeLabelText).append(patient.get("Telefon1")).append(Messages.GlobalActions_PhoneWorkLabelText).append(patient.get("Telefon2")).append(Messages.GlobalActions_PhoneMobileLabelText).append(patient.get("Natel"));
                gc.drawString(tel.toString(), 0, y += fmt.getHeight());
                gc.dispose();
                prn.endPage();
                prn.endJob();
                prn.dispose();
            } else {
                MessageDialog.openError((Shell)this.mainWindow.getShell(), (String)Messages.GlobalActions_PrinterErrorTitle, (String)Messages.GlobalActions_PrinterErrorMessage);
            }
        }
    }

    protected void printPatientAuftragsnummer(Patient patient) {
        PrinterData pd = this.getPrinterData("Etiketten");
        if (pd != null) {
            Printer prn;
            Integer iOrientation = -1;
            String sOrientation = CoreHub.localCfg.get("Drucker/Etiketten/Ausrichtung", null);
            try {
                iOrientation = Integer.parseInt(sOrientation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (iOrientation != -1) {
                pd.orientation = iOrientation;
            }
            if ((prn = new Printer(pd)).startJob(Messages.GlobalActions_PrintLabelJobName)) {
                GC gc = new GC((Drawable)prn);
                int y = 0;
                prn.startPage();
                String pid = String.valueOf(StringTool.addModulo10((String)patient.getPatCode())) + "-" + new TimeTool().toString(8);
                gc.drawString(String.valueOf(Messages.Order_ID) + ": " + pid, 0, 0);
                FontMetrics fmt = gc.getFontMetrics();
                String pers = patient.getPersonalia();
                gc.drawString(pers, 0, y += fmt.getHeight());
                gc.drawString(patient.getAnschrift().getEtikette(false, false), 0, y += fmt.getHeight());
                StringBuilder tel = new StringBuilder();
                tel.append(Messages.GlobalActions_PhoneHomeLabelText).append(patient.get("Telefon1")).append(Messages.GlobalActions_PhoneWorkLabelText).append(patient.get("Telefon2")).append(Messages.GlobalActions_PhoneMobileLabelText).append(patient.get("Natel"));
                gc.drawString(tel.toString(), 0, y += fmt.getHeight());
                gc.dispose();
                prn.endPage();
                prn.endJob();
                prn.dispose();
            } else {
                MessageDialog.openError((Shell)this.mainWindow.getShell(), (String)Messages.GlobalActions_PrinterErrorTitle, (String)Messages.GlobalActions_PrinterErrorMessage);
            }
        }
    }

    protected void printAdr(Kontakt k) {
        PrinterData pd = this.getPrinterData("Etiketten");
        if (pd != null) {
            Printer prn;
            Integer iOrientation = -1;
            String sOrientation = CoreHub.localCfg.get("Drucker/Etiketten/Ausrichtung", null);
            try {
                iOrientation = Integer.parseInt(sOrientation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (iOrientation != -1) {
                pd.orientation = iOrientation;
            }
            if ((prn = new Printer(pd)).startJob("Etikette drucken")) {
                String[] lines;
                GC gc = new GC((Drawable)prn);
                int y = 0;
                prn.startPage();
                FontMetrics fmt = gc.getFontMetrics();
                String pers = k.getPostAnschrift(true);
                String[] stringArray = lines = pers.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    gc.drawString(line, 0, y);
                    y += fmt.getHeight();
                    ++n2;
                }
                gc.dispose();
                prn.endPage();
                prn.endJob();
                prn.dispose();
            } else {
                MessageDialog.openError((Shell)this.mainWindow.getShell(), (String)Messages.GlobalActions_PrinterErrorTitle, (String)Messages.GlobalActions_PrinterErrorMessage);
            }
        }
    }

    private PrinterData getPrinterData(String type) {
        String cfgPrefix = "Drucker/" + type + "/";
        PrinterData pd = null;
        String printer = CoreHub.localCfg.get(String.valueOf(cfgPrefix) + "Name", null);
        String driver = CoreHub.localCfg.get(String.valueOf(cfgPrefix) + "Driver", null);
        boolean choose = CoreHub.localCfg.get(String.valueOf(cfgPrefix) + "Choose", false);
        if (choose || StringTool.isNothing((Object)printer) || StringTool.isNothing((Object)driver)) {
            Shell shell = UiDesk.getTopShell();
            PrintDialog pdlg = new PrintDialog(shell);
            pd = pdlg.open();
        } else {
            pd = new PrinterData(driver, printer);
        }
        return pd;
    }

    private boolean isDirectPrint() {
        return !CoreHub.localCfg.get("Drucker/Etiketten/Choose", true);
    }

    public static void registerActionHandler(ViewPart part, IAction action) {
        String commandId = action.getActionDefinitionId();
        if (!StringTool.isNothing((Object)commandId)) {
            IHandlerService handlerService = (IHandlerService)part.getSite().getService(IHandlerService.class);
            ActionHandler handler = new ActionHandler(action);
            handlerService.activateHandler(commandId, (IHandler)handler);
        }
    }

    public static void updateModelOfParts(MPerspective activePerspective, EModelService modelService) {
        if (activePerspective.getTags().stream().filter(t -> t.toLowerCase().contains("actionset")).findFirst().isPresent()) {
            List mParts = modelService.findElements((MUIElement)GlobalActions.getActivePerspective(modelService), null, MPart.class);
            for (MPart mPart : mParts) {
                if (mPart.getToolbar() == null) continue;
                mPart.getToolbar().setVisible(true);
            }
        }
    }

    public static void addModelOfParts(EPartService partService) {
        for (MPart mPart : partService.getParts()) {
            if (mPart.isToBeRendered() || !mPart.getTags().contains("GlobalActions:deleted")) continue;
            partService.showPart(mPart, EPartService.PartState.CREATE);
            mPart.getTags().remove("GlobalActions:deleted");
        }
    }

    public static void removeModelOfParts(MPerspective mPerspective, EModelService modelService) {
        List mParts = modelService.findElements((MUIElement)mPerspective, null, MPart.class);
        for (MPart mPart : mParts) {
            if (!(mPart.getWidget() instanceof Composite)) continue;
            try {
                mPart.getTags().add("GlobalActions:deleted");
                modelService.deleteModelElement((MUIElement)mPart);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static MPerspective getActivePerspective(EModelService modelService) {
        MTrimmedWindow mWindow = GlobalActions.getActiveWindow(modelService);
        if (mWindow != null) {
            return modelService.getActivePerspective((MWindow)mWindow);
        }
        return null;
    }

    private static MTrimmedWindow getActiveWindow(EModelService modelService) {
        List windows;
        MApplication mApplication = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        MTrimmedWindow mWindow = (MTrimmedWindow)modelService.find("IDEWindow", (MUIElement)mApplication);
        if (mWindow == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
            mWindow = (MTrimmedWindow)windows.get(0);
        }
        return mWindow;
    }

    private class OpenPreferencesAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        private IWorkbenchWindow workbenchWindow;

        public OpenPreferencesAction() {
            this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }

        public OpenPreferencesAction(IWorkbenchWindow window) {
            super(WorkbenchMessages.OpenPreferences_text);
            if (window == null) {
                throw new IllegalArgumentException();
            }
            this.workbenchWindow = window;
            this.setToolTipText(WorkbenchMessages.OpenPreferences_toolTip);
            window.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.open_preferences_action_context");
        }

        public void run() {
            if (this.workbenchWindow == null) {
                return;
            }
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
            dialog.getShell().setSize(1240, 700);
            dialog.open();
        }

        public String getActionDefinitionId() {
            return "org.eclipse.ui.window.preferences";
        }

        public void dispose() {
            this.workbenchWindow = null;
        }
    }
}

