/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.util;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.rgw.tools.MimeTool;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLetterUtil {
    private static Logger logger = LoggerFactory.getLogger(DocumentLetterUtil.class);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static IVirtualFilesystemService.IVirtualFilesystemHandle getExternalHandleIfApplicable(IDocument document) {
        IVirtualFilesystemService.IVirtualFilesystemHandle externalStoragePath;
        if (document == null) {
            return null;
        }
        if (!ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false)) {
            return null;
        }
        String path = PreferencesUtil.getOsSpecificPreference((String)"briefe/Textmodul_Extern_File_Path", (IConfigService)ConfigServiceHolder.get());
        if (path == null) {
            logger.error("External storage path is [null]");
            return null;
        }
        try {
            externalStoragePath = VirtualFilesystemServiceHolder.get().of(path);
        }
        catch (IOException e) {
            logger.error("Invalid external storage path [{}]", (Object)path, (Object)e.getMessage());
            return null;
        }
        try {
            IDocument iDocument = document;
            if (iDocument instanceof IDocumentLetter) {
                void documentLetter;
                IDocumentLetter e = (IDocumentLetter)iDocument;
                IDocumentLetter cfr_ignored_0 = (IDocumentLetter)iDocument;
                if (documentLetter.getPatient() != null) {
                    return DocumentLetterUtil.getDocumentLetterFilePath(externalStoragePath, (IDocumentLetter)documentLetter);
                }
                if (documentLetter.isTemplate()) {
                    IDocumentTemplate documentTemplate = (IDocumentTemplate)CoreModelServiceHolder.get().load(documentLetter.getId(), IDocumentTemplate.class).orElseThrow();
                    documentTemplate.setTitle(documentLetter.getTitle());
                    documentTemplate.setMimeType(documentLetter.getMimeType());
                    return DocumentLetterUtil.getDocumentTemplateFilePath(externalStoragePath, documentTemplate);
                }
                logger.warn("No patient set in IDocumentLetter and is no template [{}]", (Object)documentLetter.getId());
            } else if (document instanceof IDocumentTemplate) {
                return DocumentLetterUtil.getDocumentTemplateFilePath(externalStoragePath, (IDocumentTemplate)document);
            }
        }
        catch (IOException e) {
            logger.warn("Error loading letter [{}]", (Object)document.getId(), (Object)e);
        }
        return null;
    }

    private static IVirtualFilesystemService.IVirtualFilesystemHandle getDocumentLetterFilePath(IVirtualFilesystemService.IVirtualFilesystemHandle externalStoragePath, IDocumentLetter documentLetter) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle patientSubDir = externalStoragePath.subDir(documentLetter.getPatient().getPatientNr());
        if (!patientSubDir.exists()) {
            if (!externalStoragePath.canRead() || !externalStoragePath.canWrite()) {
                logger.error("External storage path [{}] does not exist or is not read/writable", (Object)externalStoragePath);
                return null;
            }
            logger.info("mkdir [{}]", (Object)IVirtualFilesystemService.hidePasswordInUrlString((String)patientSubDir.toURL().toString()));
            patientSubDir.mkdir();
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle filePath = patientSubDir.subFile(String.valueOf(documentLetter.getId()) + "." + DocumentLetterUtil.evaluateFileExtension(documentLetter.getMimeType()));
        return filePath;
    }

    private static IVirtualFilesystemService.IVirtualFilesystemHandle getDocumentTemplateFilePath(IVirtualFilesystemService.IVirtualFilesystemHandle externalStoragePath, IDocumentTemplate documentTemplate) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle targetDirectory;
        IVirtualFilesystemService.IVirtualFilesystemHandle templatesSubDir = externalStoragePath.subDir("templates");
        String _templatesSubDir = "SYS".equals(documentTemplate.getTemplateTyp()) ? "system" : "custom";
        IVirtualFilesystemService.IVirtualFilesystemHandle typedTemplatesSubDir = templatesSubDir.subDir(_templatesSubDir);
        IVirtualFilesystemService.IVirtualFilesystemHandle mandatorTypedTemplatesSubDir = null;
        if (documentTemplate.getMandator() != null) {
            mandatorTypedTemplatesSubDir = typedTemplatesSubDir.subDir(documentTemplate.getMandator().getLabel());
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle iVirtualFilesystemHandle = targetDirectory = mandatorTypedTemplatesSubDir != null ? mandatorTypedTemplatesSubDir : typedTemplatesSubDir;
        if (!targetDirectory.canRead()) {
            if (!externalStoragePath.canRead() || !externalStoragePath.canWrite()) {
                logger.error("External storage path [{}] does not exist or is not read/writable", (Object)externalStoragePath);
                return null;
            }
            if (!templatesSubDir.exists()) {
                logger.info("mkdir [{}]", (Object)IVirtualFilesystemService.hidePasswordInUrlString((String)templatesSubDir.toURL().toString()));
                templatesSubDir.mkdir();
            }
            if (!typedTemplatesSubDir.exists()) {
                logger.info("mkdir [{}]", (Object)IVirtualFilesystemService.hidePasswordInUrlString((String)typedTemplatesSubDir.toURL().toString()));
                typedTemplatesSubDir.mkdir();
            }
            if (mandatorTypedTemplatesSubDir != null && !mandatorTypedTemplatesSubDir.exists()) {
                logger.info("mkdir [{}]", (Object)IVirtualFilesystemService.hidePasswordInUrlString((String)mandatorTypedTemplatesSubDir.toURL().toString()));
                mandatorTypedTemplatesSubDir.mkdir();
            }
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle targetFile = targetDirectory.subFile(String.valueOf(documentTemplate.getId()) + "_" + documentTemplate.getTitle() + "." + DocumentLetterUtil.evaluateFileExtension(documentTemplate.getMimeType()));
        return targetFile;
    }

    public static String evaluateFileExtension(String input) {
        String ext = MimeTool.getExtension((String)input);
        if (StringUtils.isEmpty((CharSequence)ext) && StringUtils.isEmpty((CharSequence)(ext = FilenameUtils.getExtension((String)input)))) {
            ext = input;
        }
        return ext;
    }
}

