/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.DefaultSignature;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.time.LocalDate;
import java.util.Map;

public class ArticleDefaultSignature
extends AbstractIdDeleteModelAdapter<DefaultSignature>
implements IdentifiableWithXid,
IArticleDefaultSignature {
    private LocalDate startDate;
    private LocalDate endDate;

    public ArticleDefaultSignature(DefaultSignature entity) {
        super((EntityWithId)entity);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public String getAtcCode() {
        return ((DefaultSignature)this.getEntity()).getAtccode();
    }

    public void setAtcCode(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setAtccode(value);
    }

    public String getMorning() {
        return ((DefaultSignature)this.getEntity()).getMorning();
    }

    public void setMorning(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setMorning(value);
    }

    public String getNoon() {
        return ((DefaultSignature)this.getEntity()).getNoon();
    }

    public void setNoon(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setNoon(value);
    }

    public String getEvening() {
        return ((DefaultSignature)this.getEntity()).getEvening();
    }

    public void setEvening(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setEvening(value);
    }

    public String getNight() {
        return ((DefaultSignature)this.getEntity()).getNight();
    }

    public void setNight(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setNight(value);
    }

    public String getComment() {
        return ((DefaultSignature)this.getEntity()).getComment();
    }

    public void setComment(String value) {
        ((DefaultSignature)this.getEntityMarkDirty()).setComment(value);
    }

    public void setArticle(IArticle article) {
        String articleString = String.valueOf(article.getGtin()) + "$" + article.getCode() + "$" + StoreToStringServiceHolder.getStoreToString((Object)article);
        ((DefaultSignature)this.getEntityMarkDirty()).setArticle(articleString);
    }

    public String getFreeText() {
        return (String)this.getExtInfo("textSignature");
    }

    public void setFreeText(String value) {
        if (value == null) {
            value = "";
        }
        this.setExtInfo("textSignature", value);
    }

    public EntryType getMedicationType() {
        String typeNumber = (String)this.getExtInfo("medicationType");
        if (typeNumber != null && !typeNumber.isEmpty()) {
            return EntryType.byNumeric((int)Integer.parseInt(typeNumber));
        }
        return EntryType.UNKNOWN;
    }

    public void setMedicationType(EntryType value) {
        this.setExtInfo("medicationType", Integer.toString(value.numericValue()));
    }

    public EntryType getDisposalType() {
        String typeNumber = (String)this.getExtInfo("disposalType");
        if (typeNumber != null && !typeNumber.isEmpty()) {
            return EntryType.byNumeric((int)Integer.parseInt(typeNumber));
        }
        return EntryType.UNKNOWN;
    }

    public void setDisposalType(EntryType value) {
        this.setExtInfo("disposalType", Integer.toString(value.numericValue()));
    }

    public boolean isAtc() {
        return this.getAtcCode() != null && !this.getAtcCode().isEmpty();
    }

    public String getSignatureAsDosisString() {
        String freeText = this.getFreeText();
        if (freeText != null && !freeText.isEmpty()) {
            return freeText;
        }
        String[] values = new String[]{this.getMorning(), this.getNoon(), this.getEvening(), this.getNight()};
        StringBuilder sb = new StringBuilder();
        if (this.signatureInfoExists(values)) {
            int i = 0;
            while (i < values.length) {
                String string;
                String string2 = string = values[i] == null || values[i].isEmpty() ? "0" : values[i];
                if (i > 0) {
                    sb.append("-");
                }
                sb.append(string);
                ++i;
            }
        }
        return sb.toString();
    }

    private boolean signatureInfoExists(String[] values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (val != null && !val.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate value) {
        this.endDate = value;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate value) {
        this.startDate = value;
    }
}

