/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.help.wiki.views;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.rgw.tools.StringTool;
import com.equo.chromium.swt.Browser;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class WikiView
extends ViewPart {
    public static final String ID = "org.iatrix.help.wiki.views.WikiView";
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.initialize();
    }

    public void setPage(String page) {
        if (page != null) {
            String wikiName = this.getWikiName(page);
            this.browser.setUrl(String.valueOf(this.getBaseUrl()) + wikiName);
        }
    }

    private String getWikiName(String name) {
        String normalized = name.replaceAll("[._]+", ".");
        String[] tokens = name.split("[.]");
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokens[i].toLowerCase();
            tokens[i] = String.valueOf(tokens[i].substring(0, 1).toUpperCase()) + tokens[i].substring(1);
            ++i;
        }
        String wikiName = StringTool.join((String[])tokens, (String)"");
        return wikiName;
    }

    private String getBaseUrl() {
        return ConfigServiceHolder.getGlobal((String)"org.iatrix.help.wiki/base_url", (String)"http://wiki.elexis.info/");
    }

    private String getStartPage() {
        return ConfigServiceHolder.getGlobal((String)"org.iatrix.help.wiki/start_page", (String)"Hauptseite");
    }

    private String getHandbookUri() {
        return ConfigServiceHolder.getGlobal((String)"org.iatrix.help.wiki/handbook", (String)"https://wiki.elexis.info/Deutsches_Handbuch_3.1");
    }

    public void initialize() {
        this.setPage(this.getStartPage());
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

