/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;

public class VersionedResource {
    ArrayList<ResourceItem> items = new ArrayList();

    private VersionedResource(byte[] in) {
        if (in == null || in.length == 0) {
            return;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(in);
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.items = (ArrayList)ois.readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            this.update(new String(in), "(k)");
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
        }
    }

    public static VersionedResource load(byte[] src) {
        byte[] exp = CompEx.expand(src);
        return new VersionedResource(exp);
    }

    public boolean update(String newValue, String remark) {
        if (!this.items.isEmpty() && this.getHead().equals(newValue)) {
            return false;
        }
        return this.items.add(new ResourceItem(0, newValue, remark));
    }

    public String getHead() {
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.get((int)(this.items.size() - 1)).data;
    }

    public int getHeadVersion() {
        return this.items.size() - 1;
    }

    public ResourceItem getVersion(int v) {
        if (v < 0 || v >= this.items.size()) {
            return null;
        }
        return this.items.get(v);
    }

    public byte[] serialize() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.items);
            return CompEx.Compress(baos.toByteArray(), -1610612736);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public void purge() {
        if (!this.items.isEmpty()) {
            ResourceItem head = this.items.get(this.items.size() - 1);
            this.items.clear();
            this.items.add(head);
        }
    }

    public static class ResourceItem
    implements Serializable {
        private static final long serialVersionUID = -7214215925169803335L;
        static final int REPLACE = 0;
        static final int DIFF1 = 1;
        int mode;
        public long timestamp;
        public String remark;
        public String data;

        ResourceItem(int mode, String data, String remark) {
            this.mode = mode;
            this.data = data;
            this.remark = remark;
            this.timestamp = System.currentTimeMillis();
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append(new TimeTool(this.timestamp).toString(0)).append(" - ").append(this.remark);
            return sb.toString();
        }
    }
}

