/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.compress.CompEx;
import ch.rgw.compress.GLZInputStream;
import ch.rgw.compress.GLZOutputStream;
import ch.rgw.compress.HuffmanInputStream;
import ch.rgw.compress.HuffmanOutputStream;
import ch.rgw.compress.HuffmanTree;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Log;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.bzip2.CBZip2InputStream;
import org.apache.commons.compress.bzip2.CBZip2OutputStream;

public class StringTool {
    private static String default_charset = "utf-8";
    public static final String leer = "";
    public static final String space = " ";
    public static final String equals = "=";
    public static final String crlf = "\r\n";
    public static final String lf = "\n";
    public static final String slash = "/";
    public static final String backslash = "\\";
    public static final String numbers = "[0-9]+";
    public static final String wordSeparatorChars = "\n\r\t.,;:!? ";
    public static final String wordSeparators = "[\\t ,\\.:\\?!\\n\\r]";
    public static final String lineSeparators = "[\\n\\r\\.\\?!;]";
    public static final String ipv4address = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
    public static final String ipv6address = "((([0-9a-f]{1,4}+:){7}+[0-9a-f]{1,4}+)|(:(:[0-9a-f]{1,4}+){1,6}+)|(([0-9a-f]{1,4}+:){1,6}+:)|(::)|(([0-9a-f]{1,4}+:)(:[0-9a-f]{1,4}+){1,5}+)|(([0-9a-f]{1,4}+:){1,2}+(:[0-9a-f]{1,4}+){1,4}+)|(([0-9a-f]{1,4}+:){1,3}+(:[0-9a-f]{1,4}+){1,3}+)|(([0-9a-f]{1,4}+:){1,4}+(:[0-9a-f]{1,4}+){1,2}+)|(([0-9a-f]{1,4}+:){1,5}+(:[0-9a-f]{1,4}+))|(((([0-9a-f]{1,4}+:)?([0-9a-f]{1,4}+:)?([0-9a-f]{1,4}+:)?([0-9a-f]{1,4}+:)?)|:)(:(([0-9]{1,3}+\\.){3}+[0-9]{1,3}+)))|(:(:[0-9a-f]{1,4}+)*:([0-9]{1,3}+\\.){3}+[0-9]{1,3}+))(/[0-9]+)?";
    public static final String wordChars = "\\p{L}'";
    private static int ipHash;
    private static long sequence;
    public static final int LEFT = 1;
    public static final int RIGHTS = 2;
    public static final String flattenSeparator = "~#<";
    public static final int NONE = 0;
    public static final int HUFF = 1;
    public static final int BZIP = 2;
    public static final int GLZ = 3;
    public static final int ZIP = 4;
    public static final int GUESS = 99;
    private static final int[][] mod10Checksum;
    private static final char[] salties;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[11];
        nArray[1] = 9;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 2;
        nArray[6] = 7;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 5;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[11];
        nArray2[0] = 9;
        nArray2[1] = 4;
        nArray2[2] = 6;
        nArray2[3] = 8;
        nArray2[4] = 2;
        nArray2[5] = 7;
        nArray2[6] = 1;
        nArray2[7] = 3;
        nArray2[8] = 5;
        nArray2[10] = 9;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[11];
        nArray3[0] = 4;
        nArray3[1] = 6;
        nArray3[2] = 8;
        nArray3[3] = 2;
        nArray3[4] = 7;
        nArray3[5] = 1;
        nArray3[6] = 3;
        nArray3[7] = 5;
        nArray3[9] = 9;
        nArray3[10] = 8;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[11];
        nArray4[0] = 6;
        nArray4[1] = 8;
        nArray4[2] = 2;
        nArray4[3] = 7;
        nArray4[4] = 1;
        nArray4[5] = 3;
        nArray4[6] = 5;
        nArray4[8] = 9;
        nArray4[9] = 4;
        nArray4[10] = 7;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[11];
        nArray5[0] = 8;
        nArray5[1] = 2;
        nArray5[2] = 7;
        nArray5[3] = 1;
        nArray5[4] = 3;
        nArray5[5] = 5;
        nArray5[7] = 9;
        nArray5[8] = 4;
        nArray5[9] = 6;
        nArray5[10] = 6;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[1] = 7;
        nArray6[2] = 1;
        nArray6[3] = 3;
        nArray6[4] = 5;
        nArray6[6] = 9;
        nArray6[7] = 4;
        nArray6[8] = 6;
        nArray6[9] = 8;
        nArray6[10] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[11];
        nArray7[0] = 7;
        nArray7[1] = 1;
        nArray7[2] = 3;
        nArray7[3] = 5;
        nArray7[5] = 9;
        nArray7[6] = 4;
        nArray7[7] = 6;
        nArray7[8] = 8;
        nArray7[9] = 2;
        nArray7[10] = 4;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[11];
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 5;
        nArray8[4] = 9;
        nArray8[5] = 4;
        nArray8[6] = 6;
        nArray8[7] = 8;
        nArray8[8] = 2;
        nArray8[9] = 7;
        nArray8[10] = 3;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[11];
        nArray9[0] = 3;
        nArray9[1] = 5;
        nArray9[3] = 9;
        nArray9[4] = 4;
        nArray9[5] = 6;
        nArray9[6] = 8;
        nArray9[7] = 2;
        nArray9[8] = 7;
        nArray9[9] = 1;
        nArray9[10] = 2;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[11];
        nArray10[0] = 5;
        nArray10[2] = 9;
        nArray10[3] = 4;
        nArray10[4] = 6;
        nArray10[5] = 8;
        nArray10[6] = 2;
        nArray10[7] = 7;
        nArray10[8] = 1;
        nArray10[9] = 3;
        nArray10[10] = 1;
        nArrayArray[9] = nArray10;
        mod10Checksum = nArrayArray;
        salties = new char[]{'q', 'w', 'e', 'r', 't', 'z', 'u', 'o', 'i', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'y', 'x', 'c', 'v', 'b', 'n', 'm', 'Q', 'A', 'Y', 'W', 'E', 'D', 'C', 'R', 'F', 'V', 'T', 'G', 'B', 'Z', 'H', 'N', 'U', 'J', 'M', 'I', 'K', 'O', 'L', 'P'};
    }

    public static final String Version() {
        return "2.0.4";
    }

    public static void setDefaultCharset(String charset_name) {
        default_charset = charset_name;
    }

    public static String getDefaultCharset() {
        return default_charset;
    }

    public static String createString(byte[] bytes) {
        try {
            return new String(bytes, default_charset);
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return null;
        }
    }

    public static byte[] getBytes(String string) {
        try {
            return string.getBytes(default_charset);
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return null;
        }
    }

    @Deprecated
    public static Rectangle2D getStringBounds(String s, Graphics g) {
        if (StringTool.isNothing(s)) {
            return new Rectangle(0, 0);
        }
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        Font fnt = g.getFont();
        Rectangle2D r = fnt.getStringBounds(s, frc);
        return r;
    }

    @Deprecated
    public static String[] split(String m, String delim) {
        Vector v = StringTool.splitV(m, delim);
        if (v == null) {
            return null;
        }
        String[] ret = v.toArray(new String[1]);
        return ret;
    }

    public static Vector splitV(String m, String delim) {
        String mi = m;
        if (mi.equals(leer)) {
            return null;
        }
        Vector<String> v = new Vector<String>(30, 30);
        int i = 0;
        int j = 0;
        while (true) {
            if ((j = mi.indexOf(delim, i)) == -1) break;
            String l = mi.substring(i, j).trim();
            if (!l.equals(leer)) {
                v.add(l);
            }
            i = j + 1;
        }
        v.add(mi.substring(i));
        return v;
    }

    public static List<String> splitAL(String m, String delim) {
        ArrayList<String> al = new ArrayList<String>();
        String mi = m;
        int i = 0;
        int j = 0;
        while (true) {
            if ((j = mi.indexOf(delim, i)) == -1) break;
            String l = mi.substring(i, j).trim();
            if (!l.equals(leer)) {
                al.add(l);
            }
            i = j + 1;
        }
        al.add(mi.substring(i));
        return al;
    }

    public static String flattenStrings(Hashtable h) {
        return StringTool.flattenStrings(h, null);
    }

    public static String flattenStrings(Hashtable<Object, Object> h, flattenFilter fil) {
        if (h == null) {
            return null;
        }
        Enumeration<Object> keys = h.keys();
        StringBuffer res = new StringBuffer(1000);
        res.append("FS1").append(flattenSeparator);
        while (keys.hasMoreElements()) {
            Object ko = keys.nextElement();
            if (fil != null && !fil.accept(ko)) continue;
            String v = StringTool.ObjectToString(h.get(ko));
            String k = StringTool.ObjectToString(ko);
            if (k == null || v == null || k.matches(".*=.*")) {
                return null;
            }
            res.append(k).append(equals).append(v).append(flattenSeparator);
        }
        String r = res.toString();
        return r.replaceFirst("~#<$", leer);
    }

    public static byte[] pack(Collection<String> strings) {
        String res = StringTool.join(strings, lf);
        return CompEx.Compress(res, -1610612736);
    }

    public static byte[] pack(String[] strings) {
        String res = StringTool.join(strings, lf);
        return CompEx.Compress(res, -1610612736);
    }

    public static List<String> unpack(byte[] pack) {
        try {
            String raw = new String(CompEx.expand(pack), default_charset);
            return StringTool.splitAL(raw, lf);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static byte[] flatten(Hashtable hash, int compressMode, Object ExtInfo) {
        ByteArrayOutputStream baos = null;
        OutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream(hash.size() * 30);
            switch (compressMode) {
                case 4: 
                case 99: {
                    os = new ZipOutputStream(baos);
                    ((ZipOutputStream)os).putNextEntry(new ZipEntry("hash"));
                    break;
                }
                case 2: {
                    os = new CBZip2OutputStream(baos);
                    break;
                }
                case 1: {
                    os = new HuffmanOutputStream(baos, (HuffmanTree)ExtInfo, 0);
                    break;
                }
                case 3: {
                    os = new GLZOutputStream(baos, hash.size() * 30);
                    break;
                }
                default: {
                    os = baos;
                }
            }
            oos = new ObjectOutputStream(os);
            oos.writeObject(hash);
            if (os != null) {
                os.close();
            }
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static Hashtable fold(byte[] flat, int compressMode, Object ExtInfo) {
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(flat);
            switch (compressMode) {
                case 2: {
                    ois = new ObjectInputStream(new CBZip2InputStream(bais));
                    break;
                }
                case 1: {
                    ois = new ObjectInputStream(new HuffmanInputStream(bais));
                    break;
                }
                case 3: {
                    ois = new ObjectInputStream(new GLZInputStream(bais));
                    break;
                }
                case 4: {
                    ZipInputStream zis = new ZipInputStream(bais);
                    zis.getNextEntry();
                    ois = new ObjectInputStream(zis);
                    break;
                }
                case 99: {
                    Hashtable res = StringTool.fold(flat, 4, null);
                    if (res == null && (res = StringTool.fold(flat, 3, null)) == null && (res = StringTool.fold(flat, 2, null)) == null && (res = StringTool.fold(flat, 1, ExtInfo)) == null) {
                        return null;
                    }
                    return res;
                }
                default: {
                    ois = new ObjectInputStream(bais);
                }
            }
            Hashtable res = (Hashtable)ois.readObject();
            ois.close();
            bais.close();
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String ObjectToString(Object o) {
        if (o instanceof String) {
            return "A" + (String)o;
        }
        if (o instanceof Integer) {
            return "B" + ((Integer)o).toString();
        }
        if (o instanceof Serializable) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                oos.close();
                byte[] ret = baos.toByteArray();
                return "Z" + StringTool.enPrintable(ret);
            }
            catch (IOException e) {
                ExHandler.handle(e);
                return null;
            }
        }
        return null;
    }

    private static Object StringToObject(String s) {
        String sx = s.substring(1);
        char pref = s.charAt(0);
        switch (pref) {
            case 'A': {
                return sx;
            }
            case 'B': {
                return Integer.parseInt(sx);
            }
            case 'Z': {
                byte[] b = StringTool.dePrintable(sx);
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    Object ret = ois.readObject();
                    ois.close();
                    bais.close();
                    return ret;
                }
                catch (Exception ex) {
                    ExHandler.handle(ex);
                    return null;
                }
            }
        }
        return null;
    }

    public static Hashtable foldStrings(String s) {
        Hashtable<Object, Object> h = new Hashtable<Object, Object>();
        if (StringTool.isNothing(s)) {
            return h;
        }
        String[] elems = s.split(flattenSeparator);
        if (!elems[0].equals("FS1")) {
            return null;
        }
        int i = 1;
        while (i < elems.length) {
            String[] elem = elems[i].split(equals, 2);
            if (elem.length != 2) {
                return null;
            }
            Object k = StringTool.StringToObject(elem[0].trim());
            Object v = StringTool.StringToObject(elem[1].trim());
            if (k == null || v == null) {
                return null;
            }
            h.put(k, v);
            ++i;
        }
        return h;
    }

    public static boolean isNothing(Object n) {
        if (n == null) {
            return true;
        }
        if (n instanceof String) {
            return ((String)n).trim().equals(leer);
        }
        return true;
    }

    public static boolean isEmpty(String[] f) {
        if (f == null) {
            return true;
        }
        int i = 0;
        while (i < f.length) {
            if (!StringTool.isNothing(f[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean compare(byte[] a, byte[] b) {
        if (a.length == b.length) {
            int i = 0;
            while (i < a.length) {
                if (a[i] != b[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static int getIndex(String[] arr, String val) {
        int i = 0;
        while (i < arr.length) {
            if (val.equalsIgnoreCase(arr[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String pad(int where, char chr, String src, int size) {
        int diff = size - src.length();
        if (diff > 0) {
            StringBuffer s = new StringBuffer(diff);
            int i = 0;
            while (i < diff) {
                s.append(chr);
                ++i;
            }
            if (where == 1) {
                return s + src;
            }
            return String.valueOf(src) + s;
        }
        return src.substring(0, size);
    }

    public static String filler(String str, int num) {
        StringBuilder s = new StringBuilder(num);
        while (num-- > 0) {
            s.append(str);
        }
        return s.toString();
    }

    public static int compareNumericStrings(String first, String seconds) {
        int i1 = 0;
        int i2 = 0;
        boolean a1 = StringTool.isNumeric(first);
        boolean a2 = StringTool.isNumeric(seconds);
        if (a1 && a2) {
            i1 = Integer.parseInt(first);
            i2 = Integer.parseInt(seconds);
            return Integer.compare(i1, i2);
        }
        return Boolean.compare(a1, a2);
    }

    public static boolean isNumeric(String str) {
        if (str != null) {
            return str.matches("-?\\d+");
        }
        return false;
    }

    public static String RectangleToString(int x, int y, int w, int h) {
        StringBuilder sb = new StringBuilder();
        sb.append(x).append(",").append(y).append(",").append(w).append(",").append(h);
        return sb.toString();
    }

    public static String join(String[] arr, String tren) {
        if (arr == null || arr.length == 0) {
            return leer;
        }
        StringBuffer res = new StringBuffer(100);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] != null) {
                res.append(arr[i]).append(tren);
            }
            ++i;
        }
        String r2 = res.toString();
        return r2.replaceFirst(String.valueOf(tren) + "$", leer);
    }

    public static String join(Iterable<String> i, String tren) {
        StringBuilder ret = new StringBuilder();
        Iterator<String> it = i.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(tren);
        }
        return ret.toString();
    }

    public static String enPrintable(byte[] src) {
        return StringTool.enPrintable(src, 70);
    }

    public static String enPrintable(byte[] src, int offset) {
        byte[] out = new byte[src.length * 2];
        int i = 0;
        while (i < src.length) {
            out[2 * i] = (byte)((src[i] >> 4) + offset);
            out[2 * i + 1] = (byte)((src[i] & 0xF) + offset);
            ++i;
        }
        try {
            return new String(out, default_charset);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static byte[] dePrintable(String src) {
        return StringTool.dePrintable(src, 70);
    }

    public static byte[] dePrintable(String src, int offset) {
        byte[] input = null;
        try {
            input = src.getBytes(default_charset);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        byte[] out = new byte[input.length / 2];
        int i = 0;
        while (i < out.length) {
            out[i] = (byte)((input[2 * i] - offset) * 16 + (input[2 * i + 1] - offset));
            ++i;
        }
        return out;
    }

    public static String enPrintableStrict(byte[] src) {
        if (src == null) {
            return null;
        }
        byte[] out = new byte[(src.length << 1) + 3];
        try {
            out[0] = 69;
            out[1] = 80;
            out[2] = 49;
            int i = 0;
            while (i < src.length) {
                int i1 = (src[i] & 0xFF) >> 4;
                byte o1 = (byte)(i1 + 65);
                byte o2 = (byte)((src[i] & 0xF) + 65);
                out[2 * i + 3] = o1;
                out[2 * i + 4] = o2;
                ++i;
            }
            return new String(out, default_charset);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static byte[] dePrintableStrict(String src) {
        byte[] input = null;
        try {
            input = src.getBytes(default_charset);
            if (input[0] != 69 || input[1] != 80) {
                return null;
            }
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        byte[] out = new byte[input.length - 3 >> 1];
        int i = 0;
        while (i < out.length) {
            int o1 = input[2 * i + 3] - 65;
            int o2 = input[2 * i + 4] - 65;
            out[i] = (byte)((o1 << 4) + o2);
            ++i;
        }
        return out;
    }

    public static String unNull(String in) {
        return in == null ? leer : in;
    }

    public static boolean isFemale(String name) {
        String[] suffices;
        if (StringTool.isNothing(name)) {
            return false;
        }
        String[] stringArray = suffices = new String[]{"a", "is", "e", "id", "ah", "eh", "th"};
        int n = suffices.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (name.endsWith(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMailAddress(String in) {
        if (StringTool.isNothing(in)) {
            return false;
        }
        return in.matches("\\w[\\w|\\.\\-]+@\\w[\\w\\.\\-]+\\.[a-zA-Z]{2,7}");
    }

    public static boolean isIPAddress(String in) {
        if (in.matches(ipv4address)) {
            return true;
        }
        return in.matches(ipv6address);
    }

    public static String getFirstWord(String in) {
        if (StringTool.isNothing(in)) {
            return leer;
        }
        String[] words = in.split(wordSeparators);
        return words[0];
    }

    public static String getFirstLine(String in, int maxChars) {
        return StringTool.getFirstLine(in, maxChars, lineSeparators);
    }

    public static String getFirstLine(String in, int maxChars, String separators) {
        String[] lines;
        if (StringTool.isNothing(in)) {
            return leer;
        }
        if (separators == null) {
            separators = lineSeparators;
        }
        if ((lines = in.split(separators))[0].length() > maxChars) {
            int ix = lines[0].lastIndexOf(32, maxChars);
            return lines[0].substring(0, ix);
        }
        return lines[0];
    }

    public static String getWordAtIndex(String text, int index) {
        char c;
        if (index < 0 || text == null || index > text.length()) {
            return leer;
        }
        int start = index - 1;
        while (start >= 0) {
            c = text.charAt(start);
            if (wordSeparatorChars.indexOf(c) != -1) {
                ++start;
                break;
            }
            --start;
        }
        if (start < 0) {
            start = 0;
        }
        int end = index;
        while (end < text.length()) {
            c = text.charAt(end);
            if (wordSeparatorChars.indexOf(c) != -1) break;
            ++end;
        }
        if (end > text.length()) {
            end = text.length() + 1;
        }
        return text.substring(start, end);
    }

    public static void dumpHashtable(Log log, Hashtable table) {
        Set keys = table.keySet();
        log.log("Dump Hashtable\n", 4);
        for (String key : keys) {
            log.log(String.valueOf(key) + ": " + table.get(key).toString(), 4);
        }
        log.log("End dump\n", 4);
    }

    public static String normalizeCase(String orig) {
        if (orig == null) {
            return leer;
        }
        if (orig.length() < 2) {
            return orig;
        }
        return String.valueOf(orig.substring(0, 1).toUpperCase()) + orig.substring(1).toLowerCase();
    }

    public static String capitalize(String orig) {
        if (orig == null) {
            return leer;
        }
        if (orig.length() < 2) {
            return orig;
        }
        return String.valueOf(orig.substring(0, 1).toUpperCase()) + orig.substring(1);
    }

    public static int compareWithNull(String a, String b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static String limitLength(String orig, int len) {
        if (orig == null) {
            return leer;
        }
        if (orig.length() > len) {
            return orig.substring(0, len);
        }
        return orig;
    }

    public static String getSafe(String[] array, int index) {
        if (index > -1 && array.length > index) {
            return array[index];
        }
        return leer;
    }

    public static int parseSafeInt(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double parseSafeDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static String unambiguify(String in) {
        String ret = in.toLowerCase();
        ret = ret.replaceAll("([^a-z]|ue|oe|ae)", "_");
        ret = ret.replaceAll("__+", "_");
        return ret;
    }

    public static String convertEncoding(String src, String srcEncoding) {
        try {
            byte[] bytes = src.getBytes();
            return new String(bytes, srcEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return src;
        }
    }

    public static String[] convertEncoding(String[] src, String srcEncoding) {
        String[] ret = new String[src.length];
        int i = 0;
        while (i < src.length) {
            ret[i] = StringTool.convertEncoding(src[i], srcEncoding);
            ++i;
        }
        return ret;
    }

    public static String addModulo10(String number) {
        int row = 0;
        String nr = number.replaceAll("[^0-9]", leer);
        int i = 0;
        while (i < nr.length()) {
            int col = Integer.parseInt(nr.substring(i, i + 1));
            row = mod10Checksum[row][col];
            ++i;
        }
        return String.valueOf(number) + Integer.toString(mod10Checksum[row][10]);
    }

    public static String checkModulo10(String number) {
        String check = number.substring(0, number.length() - 1);
        String should = StringTool.addModulo10(check);
        if (should.equals(number)) {
            return check;
        }
        return null;
    }

    public static interface flattenFilter {
        public boolean accept(Object var1);
    }

    public static class tokenizer {
        public static final int DOUBLE_QUOTED_TOKENS = 1;
        public static final int SINGLE_QUOTED_TOKENS = 2;
        public static final int ROUND_BRACKET_TOKENS = 4;
        public static final int EDGE_BRACKET_TOKENS = 8;
        public static final int CURLY_BRACKET_TOKENS = 16;
        public static final int CRLF_MATTERS = 32;
        private final String delim;
        private final int mode;
        private int pos;
        private final String mine;

        public tokenizer(String m, String delim, int mode) {
            this.mine = m;
            this.delim = delim;
            this.mode = mode;
            this.pos = 0;
        }

        public List<String> tokenize() throws IOException {
            ArrayList<String> ret = new ArrayList<String>();
            StringBuffer token = new StringBuffer();
            while (this.pos < this.mine.length()) {
                char c;
                if (this.delim.indexOf(c = this.mine.charAt(this.pos++)) != -1) {
                    ret.add(token.toString());
                    token.setLength(0);
                    continue;
                }
                token.append(c);
                switch (c) {
                    case '\"': {
                        if ((this.mode & 1) == 0) break;
                        token.append(this.readToMatching('\"', '\"'));
                        break;
                    }
                    case '\'': {
                        if ((this.mode & 2) == 0) break;
                        token.append(this.readToMatching('\'', '\''));
                        break;
                    }
                    case '(': {
                        if ((this.mode & 4) == 0) break;
                        token.append(this.readToMatching('(', ')'));
                        break;
                    }
                    case ')': {
                        if ((this.mode & 4) == 0) break;
                        throw new IOException("unmatched bracket");
                    }
                    case '[': {
                        if ((this.mode & 8) == 0) break;
                        token.append(this.readToMatching('[', ']'));
                        break;
                    }
                    case ']': {
                        if ((this.mode & 8) == 0) break;
                        throw new IOException("unmatched bracket");
                    }
                    case '{': {
                        if ((this.mode & 0x10) == 0) break;
                        token.append(this.readToMatching('{', '}'));
                        break;
                    }
                    case '}': {
                        if ((this.mode & 0x10) == 0) break;
                        throw new IOException("unmatched bracket");
                    }
                }
            }
            ret.add(token.toString());
            return ret;
        }

        private StringBuffer readToMatching(char open, char close) throws IOException {
            StringBuffer ret = new StringBuffer();
            int level = 1;
            while (this.pos < this.mine.length()) {
                char c = this.mine.charAt(this.pos++);
                ret.append(c);
                if (c == close) {
                    if (--level != 0) continue;
                    return ret;
                }
                if (c == open) {
                    ++level;
                    continue;
                }
                if (c != '\r' || (this.mode & 0x20) == 0) continue;
                throw new IOException("Unexpected end of line while looking for " + close);
            }
            throw new IOException("Unexpected end of line while looking for " + close);
        }
    }
}

