/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v26;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ED;
import ca.uhn.hl7v2.model.v26.datatype.FT;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.ORU_R01_PATIENT;
import ca.uhn.hl7v2.model.v26.message.ORU_R01;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ch.elexis.hl7.HL7Writer;
import ch.elexis.hl7.data.HL7LaborItem;
import ch.elexis.hl7.data.HL7LaborWert;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.StringData;
import ch.elexis.hl7.model.TextData;
import ch.elexis.hl7.v26.ElexisValidation;
import ch.elexis.hl7.v26.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import org.apache.commons.codec.binary.Base64;

public class HL7_ORU_R01
extends HL7Writer {
    public static final String CODINGSYSTEM_DORNER_GROUP_CODE = "99DGC";
    public static final String CODINGSYSTEM_DORNER_GROUP_POSITION = "99DGP";
    final String uniqueMessageControlID;
    final String uniqueProcessingID;
    final HL7Mandant mandant;

    public HL7_ORU_R01() {
        this.uniqueMessageControlID = null;
        this.uniqueProcessingID = null;
        this.mandant = null;
    }

    public HL7_ORU_R01(String sendingApplication1, String sendingApplication3, String receivingApplication1, String receivingApplication3, String receivingFacility, String uniqueMessageControlID, String uniqueProcessingID, HL7Mandant mandant) {
        super(sendingApplication1, sendingApplication3, receivingApplication1, receivingApplication3, receivingFacility);
        this.uniqueMessageControlID = uniqueMessageControlID;
        this.uniqueProcessingID = uniqueProcessingID;
        this.mandant = mandant;
    }

    public ORU_R01 read(String text) throws HL7Exception {
        PipeParser p = new PipeParser();
        p.setValidationContext((ValidationContext)new ElexisValidation());
        Message hl7Msg = p.parse(text);
        if (hl7Msg instanceof ORU_R01) {
            return (ORU_R01)hl7Msg;
        }
        this.addError(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongMsgType, hl7Msg.getName()));
        return null;
    }

    public ObservationMessage readObservation(String text) throws IOException, EncodingNotSupportedException, HL7Exception, ParseException {
        this.clearMessages();
        ObservationMessage observation = null;
        ORU_R01 oru = this.read(text);
        if (oru != null) {
            String msh3_sendingApplication = oru.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue();
            String msh4_sendingFacility = oru.getMSH().getMsh4_SendingFacility().getHd1_NamespaceID().getValue();
            String msh7_dateTimeOfMessage = oru.getMSH().getMsh7_DateTimeOfMessage().getValue();
            PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
            String pid2_patientId = pid.getPid2_PatientID().getCx1_IDNumber().getValue();
            String pid4_alternatePatientId = pid.getPid4_AlternatePatientIDPID(0).getCx1_IDNumber().getValue();
            String tmp1 = "";
            String tmp2 = "";
            if (pid.getPid5_PatientName(0).getName() != null) {
                tmp1 = pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue();
            }
            if (pid.getPid5_PatientName(0).getFamilyName() != null) {
                tmp2 = pid.getPid5_PatientName(0).getGivenName().getValue();
            }
            String pid5_patientName = String.valueOf(tmp1) + " " + tmp2;
            String nteAfterPid_patientNotesAndComments = this.readPatientNotesAndComments(oru.getPATIENT_RESULT().getPATIENT());
            String orc2_placerOrderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PlacerOrderNumber().getEi1_EntityIdentifier().getValue();
            observation = new ObservationMessage(msh3_sendingApplication, msh4_sendingFacility, msh7_dateTimeOfMessage, pid2_patientId, pid5_patientName, nteAfterPid_patientNotesAndComments, pid4_alternatePatientId, orc2_placerOrderNumber);
            int obscount = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            int j = 0;
            while (j < obscount) {
                String appendedTX = "";
                OBR obr = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBR();
                String obrDateOfObservation = obr.getObr7_ObservationDateTime().getValue();
                String orderCommentNTE = null;
                int n = 0;
                while (n < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getNTEReps()) {
                    NTE nte = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getNTE(n);
                    FT comment = nte.getNte3_Comment(0);
                    if (comment != null) {
                        orderCommentNTE = orderCommentNTE != null ? String.valueOf(orderCommentNTE) + "\n" : "";
                        orderCommentNTE = String.valueOf(orderCommentNTE) + comment.getValue();
                    }
                    ++n;
                }
                if (orderCommentNTE != null) {
                    observation.add(new TextData("Kommentar", orderCommentNTE, obrDateOfObservation, "00 Kommentar", null));
                }
                int i = 0;
                while (i < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATIONReps()) {
                    String commentNTE = null;
                    int n2 = 0;
                    while (n2 < oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getNTEReps()) {
                        NTE nte = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getNTE(n2);
                        FT comment = nte.getNte3_Comment(0);
                        if (comment != null) {
                            commentNTE = commentNTE != null ? String.valueOf(commentNTE) + "\n" : "";
                            commentNTE = String.valueOf(commentNTE) + comment.getValue();
                        }
                        ++n2;
                    }
                    String group = null;
                    String sequence = null;
                    int k = 0;
                    while (k < 2) {
                        CWE cwe = obr.getObr47_FillerSupplementalServiceInformation(k);
                        if (cwe != null) {
                            String code = "";
                            if (cwe.getCwe3_NameOfCodingSystem() != null) {
                                code = cwe.getCwe3_NameOfCodingSystem().getValue();
                            }
                            if (CODINGSYSTEM_DORNER_GROUP_CODE.equalsIgnoreCase(code) && cwe.getCwe2_Text() != null) {
                                group = cwe.getCwe2_Text().getValue();
                            }
                            if (CODINGSYSTEM_DORNER_GROUP_POSITION.equalsIgnoreCase(code) && cwe.getCwe1_Identifier() != null) {
                                sequence = cwe.getCwe1_Identifier().getValue();
                            }
                        }
                        ++k;
                    }
                    OBX obx = oru.getPATIENT_RESULT().getORDER_OBSERVATION(j).getOBSERVATION(i).getOBX();
                    String valueType = obx.getObx2_ValueType().getValue();
                    if ("ED".equals(valueType)) {
                        String observationId = obx.getObx3_ObservationIdentifier().getCwe1_Identifier().getValue();
                        if (!"DOCUMENT".equals(observationId)) {
                            this.addWarning(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongObsIdentifier, observationId));
                        }
                        ED ed = (ED)obx.getObx5_ObservationValue(0).getData();
                        String filename = ed.getEd3_DataSubtype().getValue();
                        String encoding = ed.getEd4_Encoding().getValue();
                        String data = ed.getEd5_Data().getValue();
                        dateOfObservation = obx.getObx14_DateTimeOfTheObservation().getValue();
                        observation.add(new EncapsulatedData(filename, encoding, data, dateOfObservation, commentNTE, group, sequence));
                    } else if ("ST".equals(valueType)) {
                        String name = obx.getObx4_ObservationSubID().getValue();
                        String valueST = "";
                        Type value = obx.getObx5_ObservationValue(0).getData();
                        if (value instanceof ST) {
                            valueST = ((ST)obx.getObx5_ObservationValue(0).getData()).getValue();
                        }
                        String unit = obx.getObx6_Units().getCwe1_Identifier().getValue();
                        String range = obx.getObx7_ReferencesRange().getValue();
                        dateOfObservation = obx.getObx14_DateTimeOfTheObservation().getValue();
                        observation.add(new StringData(name, unit, valueST, range, dateOfObservation, commentNTE, group, sequence));
                    } else if ("TX".equals(valueType)) {
                        String valueTX = "";
                        value = obx.getObx5_ObservationValue(0).getData();
                        if (value instanceof TX) {
                            valueTX = ((TX)obx.getObx5_ObservationValue(0).getData()).getValue();
                        }
                        appendedTX = String.valueOf(appendedTX) + valueTX + "\n";
                    } else if ("FT".equals(valueType)) {
                        String valueFT = "";
                        value = obx.getObx5_ObservationValue(0).getData();
                        if (value instanceof FT) {
                            valueFT = ((FT)obx.getObx5_ObservationValue(0).getData()).getValue();
                        }
                        appendedTX = String.valueOf(appendedTX) + this.parseTextValue(valueFT) + "\n";
                    } else {
                        this.addError(MessageFormat.format("Value type {0} is not implemented!", valueType));
                    }
                    ++i;
                }
                if (appendedTX.length() > 0) {
                    String name = null;
                    CWE cweIdentifier = obr.getObr4_UniversalServiceIdentifier();
                    if (cweIdentifier.getCwe2_Text() != null) {
                        name = cweIdentifier.getCwe2_Text().getValue();
                    }
                    if (name == null || name.trim().length() == 0) {
                        name = cweIdentifier.getCwe1_Identifier().getValue();
                    }
                    observation.add(new TextData(name, appendedTX, obrDateOfObservation, null, null));
                }
                ++j;
            }
        }
        return observation;
    }

    public String parseTextValue(String value) {
        String text = value;
        text = text.replaceAll("\\\\.br\\\\", "\n");
        if ((text = text.replaceAll("\\\\.BR\\\\", "\n")) != null && !text.isEmpty()) {
            return text;
        }
        return value;
    }

    private String readPatientNotesAndComments(ORU_R01_PATIENT patient) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < patient.getNTEReps()) {
            FT comment = patient.getNTE(i).getComment(0);
            sb.append(comment.toString());
            if (patient.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String createText(HL7Patient patient, HL7LaborItem labItem, HL7LaborWert labwert) throws DataTypeException, HL7Exception {
        ORU_R01 oru = new ORU_R01();
        this.fillMSH(oru.getMSH(), "ORU", "R01", this.mandant, this.uniqueMessageControlID, this.uniqueProcessingID, patient);
        PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
        this.fillPID(pid, patient);
        ORU_R01_ORDER_OBSERVATION orderObservation = oru.getPATIENT_RESULT().getORDER_OBSERVATION();
        this.fillORC(orderObservation.getORC(), "RE", null);
        this.addResultInternal(oru, patient, labItem, labwert, 0);
        PipeParser parser = new PipeParser();
        return parser.encode((Message)oru);
    }

    public String addResult(ORU_R01 oru, HL7Patient patient, HL7LaborItem labItem, HL7LaborWert labwert) throws DataTypeException, HL7Exception {
        int reps = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
        return this.addResultInternal(oru, patient, labItem, labwert, reps);
    }

    private String addResultInternal(ORU_R01 oru, HL7Patient patient, HL7LaborItem labItem, HL7LaborWert labwert, int orderObservationIndex) throws DataTypeException, HL7Exception {
        ORU_R01_ORDER_OBSERVATION orderObservation = oru.getPATIENT_RESULT().getORDER_OBSERVATION(orderObservationIndex);
        this.fillOBR(orderObservation.getOBR(), orderObservationIndex, labItem);
        this.fillOBX(orderObservation.getOBSERVATION().getOBX(), patient, labItem, labwert);
        if (labwert.getKommentar() != null && labwert.getKommentar().length() > 0) {
            this.fillNTE(orderObservation.getNTE(), labwert);
        }
        PipeParser parser = new PipeParser();
        return parser.encode((Message)oru);
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    private void fillCWE(CWE cwe, HL7LaborItem laborItem, HL7LaborWert laborWert) throws DataTypeException {
        cwe.getCwe1_Identifier().setValue(laborWert.getId());
        cwe.getCwe2_Text().setValue(laborItem.getKuerzel());
        cwe.getCwe9_OriginalText().setValue(laborItem.getTitel());
    }

    private void fillOBR(OBR obr, int index, HL7LaborItem labItem) throws DataTypeException, HL7Exception {
        obr.getObr1_SetIDOBR().setValue(Integer.valueOf(index + 1).toString());
        CWE cwe4 = obr.getObr4_UniversalServiceIdentifier();
        cwe4.getCwe1_Identifier().setValue(labItem.getId());
        cwe4.getCwe2_Text().setValue(labItem.getKuerzel());
        cwe4.getCwe9_OriginalText().setValue(labItem.getTitel());
        CWE egc = obr.getFillerSupplementalServiceInformation(0);
        egc.getCwe2_Text().setValue(labItem.getGruppe());
        egc.getCwe3_NameOfCodingSystem().setValue("99EGC");
        CWE egp = obr.getFillerSupplementalServiceInformation(1);
        egp.getCwe1_Identifier().setValue(labItem.getPrio());
        egp.getCwe3_NameOfCodingSystem().setValue("99EGP");
    }

    private void fillOBX_TX(OBX obx, int index, String text) throws DataTypeException, HL7Exception {
        obx.getObx1_SetIDOBX().setValue(Integer.valueOf(index + 1).toString());
        obx.getObx2_ValueType().setValue("TX");
        TX textType = new TX(null);
        textType.setValue(text);
        obx.getObx5_ObservationValue(0).setData((Type)textType);
    }

    private String getAbnormalFlag(HL7Patient patient, HL7LaborItem labItem, HL7LaborWert laborWert) {
        String resultat = laborWert.getResultat();
        String refValue = labItem.getRefFrau();
        if (patient.isMale().booleanValue()) {
            refValue = labItem.getRefMann();
        }
        if (refValue == null) {
            return "";
        }
        if (refValue == "") {
            return "";
        }
        if (resultat != null) {
            Double doubleObj = null;
            try {
                doubleObj = Double.parseDouble(resultat);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (doubleObj != null) {
                if (refValue == null) {
                    return "N";
                }
                if (refValue.trim().startsWith("<")) {
                    try {
                        double ref = Double.parseDouble(refValue.substring(1).trim());
                        if (doubleObj <= ref) {
                            return "N";
                        }
                        return "H";
                    }
                    catch (NumberFormatException ref) {}
                } else if (refValue.trim().startsWith(">")) {
                    try {
                        double ref = Double.parseDouble(refValue.substring(1).trim());
                        if (doubleObj >= ref) {
                            return "N";
                        }
                        return "L";
                    }
                    catch (NumberFormatException ref) {}
                } else {
                    String[] range = refValue.split("\\s*-\\s*");
                    if (range.length == 2) {
                        double upper;
                        block25: {
                            try {
                                double lower = Double.parseDouble(range[0]);
                                upper = Double.parseDouble(range[1]);
                                if (!(doubleObj < lower)) break block25;
                                return "L";
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (doubleObj > upper) {
                            return "H";
                        }
                        return "N";
                    }
                }
            } else if (laborWert.getFlags() == 0) {
                return "N";
            }
        }
        return "A";
    }

    private void fillOBX(OBX obx, HL7Patient patient, HL7LaborItem laborItem, HL7LaborWert laborWert) throws DataTypeException, HL7Exception {
        obx.getObx1_SetIDOBX().setValue("1");
        TX type = null;
        if (laborItem.getTyp().equals((Object)HL7LaborItem.Typ.NUMERIC)) {
            obx.getObx2_ValueType().setValue("NM");
            doubleObj = null;
            try {
                doubleObj = Double.parseDouble(laborWert.getResultat());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (doubleObj != null) {
                NM numericType = new NM(null);
                numericType.setValue(laborWert.getResultat().trim());
                type = numericType;
            } else {
                obx.getObx2_ValueType().setValue("TX");
                TX textType = new TX(null);
                textType.setValue(laborWert.getResultat());
                type = textType;
            }
        } else if (laborItem.getTyp().equals((Object)HL7LaborItem.Typ.TEXT)) {
            obx.getObx2_ValueType().setValue("TX");
            textType = new TX(null);
            textType.setValue(laborWert.getResultat());
            type = textType;
        } else if (laborItem.getTyp().equals((Object)HL7LaborItem.Typ.ABSOLUTE)) {
            String trimLowercaseResult;
            obx.getObx2_ValueType().setValue("CWE");
            CWE codedEntryType = new CWE(null);
            String labResult = Messages.HL7_ORU_R01_LabResult_Abs_Neg;
            if (laborWert.getResultat() != null && ((trimLowercaseResult = laborWert.getResultat().trim().toLowerCase()).startsWith("pos") || trimLowercaseResult.startsWith("+"))) {
                labResult = Messages.Literal_One;
            }
            codedEntryType.getCwe1_Identifier().setValue(labResult);
            codedEntryType.getCwe2_Text().setValue(laborWert.getResultat());
            type = codedEntryType;
        } else if (laborItem.getTyp().equals((Object)HL7LaborItem.Typ.FORMULA)) {
            doubleObj = null;
            try {
                doubleObj = Double.parseDouble(laborWert.getResultat());
            }
            catch (NumberFormatException labResult) {
                // empty catch block
            }
            if (doubleObj != null) {
                obx.getObx2_ValueType().setValue("NM");
                NM numericType = new NM(null);
                numericType.setValue(laborWert.getResultat());
                type = numericType;
            } else {
                obx.getObx2_ValueType().setValue("TX");
                TX textType = new TX(null);
                textType.setValue(laborWert.getResultat());
                type = textType;
            }
        } else if (laborItem.getTyp().equals((Object)HL7LaborItem.Typ.DOCUMENT)) {
            if (laborWert.getDocData() != null) {
                obx.getObx2_ValueType().setValue("ED");
                ED encapsulatedType = new ED(null);
                encapsulatedType.getEd2_TypeOfData().setValue("application");
                encapsulatedType.getEd4_Encoding().setValue("BASE64");
                String base64Value = new String(Base64.encodeBase64((byte[])laborWert.getResultat().getBytes()));
                encapsulatedType.getEd5_Data().setValue(base64Value);
                type = encapsulatedType;
            } else {
                obx.getObx2_ValueType().setValue("TX");
                textType = new TX(null);
                textType.setValue(laborWert.getResultat());
                type = textType;
            }
        }
        this.fillCWE(obx.getObx3_ObservationIdentifier(), laborItem, laborWert);
        obx.getObx5_ObservationValue(0).setData((Type)type);
        obx.getObx6_Units().getCwe1_Identifier().setValue(laborItem.getEinheit());
        String refRange = "";
        refRange = patient.isMale() != false ? laborItem.getRefMann() : laborItem.getRefFrau();
        if (refRange != null) {
            obx.getObx7_ReferencesRange().setValue(refRange.trim());
        }
        obx.getObx8_AbnormalFlags(0).setValue(this.getAbnormalFlag(patient, laborItem, laborWert));
        obx.getObx11_ObservationResultStatus().setValue("F");
        obx.getObx14_DateTimeOfTheObservation().setValue(laborWert.getZeitpunkt());
    }

    private void fillNTE(NTE nte, HL7LaborWert laborWert) throws DataTypeException, HL7Exception {
        nte.getNte1_SetIDNTE().setValue("1");
        nte.getNte3_Comment(0).setValue(laborWert.getKommentar().replace("\n", ";"));
    }
}

