/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.ui.dbcheck.contributions.dialogs.SelectBillingStrategyDialog;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class BillAllOpenCons
extends ExternalMaintenance {
    private SelectBillingStrategyDialog dialog;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Integer count = 0;
        List<String> problems = null;
        boolean presetBillingStrict = ConfigServiceHolder.getUser((String)"billing/strict", (boolean)false);
        ConfigServiceHolder.setUser((String)"billing/strict", (boolean)false);
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(() -> {
                this.dialog = new SelectBillingStrategyDialog(display.getActiveShell());
                this.dialog.open();
            });
            IBillStrategy strategy = this.dialog.getStrategy();
            if (strategy != null) {
                count = strategy.start(pm);
                problems = strategy.getProblems();
            }
        }
        ConfigServiceHolder.setUser((String)"billing/strict", (boolean)presetBillingStrict);
        return "[" + count + "] F\u00e4lle abgerechnet" + this.getProblemsString(problems);
    }

    private String getProblemsString(List<String> problems) {
        if (problems != null && !problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(String.valueOf(problem) + "\n");
            });
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getMaintenanceDescription() {
        return "Alle offenen Konsutlationen abrechnen und F\u00e4lle schliessen.";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BillStrategies implements IBillStrategy
    {
        DEFAULT{

            @Override
            public int start(IProgressMonitor monitor) {
                Integer count = 0;
                Query qbe = new Query(Fall.class);
                List qre = qbe.execute();
                monitor.beginTask("Offene Konsultationen abrechnen und F\u00e4lle schliessen", qre.size());
                TimeTool now = new TimeTool();
                for (Fall fall : qre) {
                    if (fall.isOpen()) {
                        InvoiceServiceHolder.get().invoice(NoPoUtil.loadAsIdentifiable(Arrays.asList(fall.getBehandlungen(false)), IEncounter.class));
                        fall.setEndDatum(now.toString(4));
                        count = count + 1;
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    return count;
                }
                monitor.done();
                return count;
            }

            @Override
            public List<String> getProblems() {
                return Collections.emptyList();
            }
        }
        ,
        VITODATA{
            private List<String> fallProblems;

            @Override
            public int start(IProgressMonitor monitor) {
                Integer count = 0;
                this.fallProblems = new ArrayList<String>();
                Query qbe = new Query(Fall.class);
                List faelle = qbe.execute();
                monitor.beginTask("Offene, von Vitodata importierte, Konsultationen abrechnen und F\u00e4lle schliessen", faelle.size());
                for (Fall fall : faelle) {
                    if (monitor.isCanceled()) {
                        return count;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.isEmpty(fall)) {
                        monitor.worked(1);
                        continue;
                    }
                    FallConsInfo info = this.getFallConsInfo(fall);
                    if (info.isVitoOnly()) {
                        if (!this.isBilled(fall)) {
                            this.createBill(fall);
                            count = count + 1;
                        }
                        monitor.worked(1);
                        continue;
                    }
                    if (info.isNonVitoOnly()) {
                        monitor.worked(1);
                        continue;
                    }
                    this.addFallProblem("Mixed cons in Fall", fall);
                    monitor.worked(1);
                }
                monitor.done();
                return count;
            }

            private void addFallProblem(String prefix, Fall fall) {
                this.fallProblems.add("[" + prefix + "]" + "[" + fall.getId() + "] - [" + fall.getLabel() + "] von [" + fall.getPatient().getLabel() + "]");
            }

            private void createBill(Fall fall) {
                LockResponse lr = LocalLockServiceHolder.get().acquireLockBlocking((Object)fall, 60, (IProgressMonitor)new NullProgressMonitor());
                if (lr.isOk()) {
                    HashMap<Rechnungssteller, List<Konsultation>> consByRechnungssteller = this.getConsultationByRechnungssteller(fall);
                    Set<Rechnungssteller> keys = consByRechnungssteller.keySet();
                    for (Rechnungssteller key : keys) {
                        InvoiceServiceHolder.get().invoice(NoPoUtil.loadAsIdentifiable(consByRechnungssteller.get(key), IEncounter.class));
                    }
                    fall.setEndDatum(new TimeTool().toString(4));
                    LocalLockServiceHolder.get().releaseLock((Object)fall);
                    if (!this.isBilled(fall)) {
                        this.addFallProblem("Billing failed", fall);
                    }
                } else {
                    this.addFallProblem("No lock", fall);
                }
            }

            private HashMap<Rechnungssteller, List<Konsultation>> getConsultationByRechnungssteller(Fall fall) {
                HashMap<Rechnungssteller, List<Konsultation>> ret = new HashMap<Rechnungssteller, List<Konsultation>>();
                List<Konsultation> fallConsultations = Arrays.asList(fall.getBehandlungen(false));
                for (Konsultation consultation : fallConsultations) {
                    Rechnungssteller rs = consultation.getMandant().getRechnungssteller();
                    List<Konsultation> list = ret.get(rs);
                    if (list == null) {
                        list = new ArrayList<Konsultation>();
                    }
                    list.add(consultation);
                    ret.put(rs, list);
                }
                return ret;
            }

            private boolean isBilled(Fall fall) {
                List<Konsultation> fallConsultations = Arrays.asList(fall.getBehandlungen(false));
                if (!fallConsultations.isEmpty()) {
                    String billId = fallConsultations.get(0).get("RechnungsID");
                    return billId != null && !billId.isEmpty();
                }
                return true;
            }

            private boolean isEmpty(Fall fall) {
                List<Konsultation> fallConsultations = Arrays.asList(fall.getBehandlungen(false));
                return fallConsultations.isEmpty();
            }

            private FallConsInfo getFallConsInfo(Fall fall) {
                List<Konsultation> fallConsultations = Arrays.asList(fall.getBehandlungen(false));
                FallConsInfo ret = new FallConsInfo();
                for (Konsultation consultation : fallConsultations) {
                    if (this.isVitoConsultation(consultation)) {
                        ++ret.vitoCount;
                        continue;
                    }
                    ++ret.nonVitoCount;
                }
                return ret;
            }

            private boolean isVitoConsultation(Konsultation consultation) {
                return !consultation.getXid("www.elexis.info/vitodata/import/consultation/id").isEmpty();
            }

            @Override
            public List<String> getProblems() {
                return this.fallProblems != null ? this.fallProblems : Collections.emptyList();
            }
        };

    }

    private static class FallConsInfo {
        int vitoCount = 0;
        int nonVitoCount = 0;

        private FallConsInfo() {
        }

        public boolean isVitoOnly() {
            return this.nonVitoCount == 0;
        }

        public boolean isNonVitoOnly() {
            return this.vitoCount == 0;
        }
    }

    public static interface IBillStrategy {
        public int start(IProgressMonitor var1);

        public List<String> getProblems();
    }
}

