/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts.controls;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.ui.tasks.parts.controls.AbstractTaskDescriptorConfigurationComposite;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RunContextTextWithDefaultValue
extends Text {
    public RunContextTextWithDefaultValue(Composite compAssisted, AbstractTaskDescriptorConfigurationComposite atdcc, String key, String defaultValue, String configuredValue, boolean enabled) {
        super(compAssisted, 2048);
        this.setMessage(defaultValue != null ? defaultValue : "");
        this.setEnabled(enabled);
        if (enabled) {
            this.setText(configuredValue != null ? configuredValue : "");
            this.addModifyListener(event -> {
                if (StringUtils.isNotBlank((CharSequence)this.getText())) {
                    abstractTaskDescriptorConfigurationComposite.taskDescriptor.setRunContextParameter(key, (Serializable)((Object)this.getText().trim()));
                } else {
                    abstractTaskDescriptorConfigurationComposite.taskDescriptor.setRunContextParameter(key, null);
                }
                atdcc.saveTaskDescriptor();
            });
        }
        this.addMenuDetectListener(evmdl -> {
            IVirtualFilesystemService vfsService = OsgiServiceUtil.getService(IVirtualFilesystemService.class).orElse(null);
            try {
                IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = vfsService.of(this.getText());
                evmdl.doit = false;
                Menu menu = new Menu((Decorations)evmdl.display.getActiveShell(), 8);
                MenuItem exit = new MenuItem(menu, 0);
                exit.setText("Test URL");
                exit.addListener(13, event -> {
                    boolean canRead = false;
                    boolean isDirectory = false;
                    try {
                        canRead = vfsHandle.canRead();
                        isDirectory = vfsHandle.isDirectory();
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"VFS Test", (String)e.getLocalizedMessage());
                        return;
                    }
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"VFS Test", (String)("canRead: " + canRead + ", isDirectory: " + isDirectory));
                });
                menu.setVisible(true);
            }
            catch (IOException ex) {
                return;
            }
        });
    }

    protected void checkSubclass() {
    }
}

