/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text.docx.util;

import ch.elexis.core.text.docx.util.DocxUtil;
import jakarta.xml.bind.JAXBException;
import java.math.BigInteger;
import java.util.List;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.jvnet.jaxb2_commons.ppp.Child;

public class TableUtil {
    static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();

    public static P pTable() {
        return null;
    }

    public static Tbl insertTable(R r, int properties, String[][] contents, int[] columnSizes, int totalWidthTwips, boolean columnSizesPercent) {
        Tbl table = TableUtil.createTable(contents.length, contents[0].length, columnSizes, totalWidthTwips, columnSizesPercent);
        if (properties == 1) {
            Tr headerRow = (Tr)table.getContent().get(0);
            int columnIndex = 0;
            while (columnIndex < contents[0].length) {
                Tc column = (Tc)headerRow.getContent().get(columnIndex);
                P columnPara = (P)column.getContent().get(0);
                Text text = wmlObjectFactory.createText();
                text.setValue(contents[0][columnIndex]);
                R run = wmlObjectFactory.createR();
                run.setRPr(r.getRPr());
                run.getContent().add(text);
                columnPara.getContent().add(run);
                ++columnIndex;
            }
        }
        int rowIndex = properties == 1 ? 1 : 0;
        while (rowIndex < contents.length) {
            Tr row = (Tr)table.getContent().get(rowIndex);
            int columnIndex = 0;
            while (columnIndex < contents[0].length) {
                Tc column = (Tc)row.getContent().get(columnIndex);
                P columnPara = (P)column.getContent().get(0);
                Text text = wmlObjectFactory.createText();
                text.setValue(contents[rowIndex][columnIndex]);
                R run = wmlObjectFactory.createR();
                run.setRPr(r.getRPr());
                run.getContent().add(text);
                columnPara.getContent().add(run);
                ++columnIndex;
            }
            ++rowIndex;
        }
        P p = DocxUtil.getParentP((Child)r);
        if (p != null) {
            ContentAccessor parent = DocxUtil.getParentContentAccessor((Child)p);
            List parentContent = parent.getContent();
            int index = parentContent.indexOf(p);
            parentContent.add(index, table);
        }
        return table;
    }

    private static Tbl createTable(int rows, int cols, int[] columnSizes, int totalWidthTwips, boolean columnSizesPercent) {
        Tbl tbl = Context.getWmlObjectFactory().createTbl();
        if (columnSizesPercent && columnSizes != null) {
            columnSizes = TableUtil.get100Percentages(columnSizes);
        }
        String strTblPr = "<w:tblPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:tblStyle w:val=\"TableGrid\"/><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblLook w:val=\"04A0\"/></w:tblPr>";
        TblPr tblPr = null;
        try {
            tblPr = (TblPr)XmlUtils.unmarshalString((String)strTblPr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        tbl.setTblPr(tblPr);
        TblGrid tblGrid = Context.getWmlObjectFactory().createTblGrid();
        tbl.setTblGrid(tblGrid);
        int i = 1;
        while (i <= cols) {
            TblGridCol gridCol = null;
            if (columnSizes != null) {
                if (columnSizesPercent && columnSizes[i - 1] > 0) {
                    gridCol = Context.getWmlObjectFactory().createTblGridCol();
                    gridCol.setW(TableUtil.getPercentageTwips(totalWidthTwips, columnSizes[i - 1]));
                } else if (columnSizes[i - 1] > 0) {
                    gridCol = Context.getWmlObjectFactory().createTblGridCol();
                    gridCol.setW(BigInteger.valueOf(UnitsOfMeasurement.mmToTwip((float)columnSizes[i - 1])));
                }
            } else {
                gridCol = Context.getWmlObjectFactory().createTblGridCol();
                gridCol.setW(TableUtil.getPercentageTwips(totalWidthTwips, 100 / cols));
            }
            if (gridCol != null) {
                tblGrid.getGridCol().add(gridCol);
            }
            ++i;
        }
        int j = 1;
        while (j <= rows) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            tbl.getContent().add(tr);
            int i2 = 1;
            while (i2 <= cols) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getContent().add(tc);
                TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr);
                TblWidth cellWidth = Context.getWmlObjectFactory().createTblWidth();
                tcPr.setTcW(cellWidth);
                cellWidth.setType("dxa");
                if (columnSizes != null) {
                    if (columnSizesPercent) {
                        cellWidth.setW(TableUtil.getPercentageTwips(totalWidthTwips, columnSizes[i2 - 1]));
                    } else {
                        cellWidth.setW(BigInteger.valueOf(UnitsOfMeasurement.mmToTwip((float)columnSizes[i2 - 1])));
                    }
                } else {
                    cellWidth.setW(TableUtil.getPercentageTwips(totalWidthTwips, 100 / cols));
                }
                tc.getContent().add(Context.getWmlObjectFactory().createP());
                ++i2;
            }
            ++j;
        }
        return tbl;
    }

    private static int[] get100Percentages(int[] columnSizes) {
        int[] ret = new int[columnSizes.length];
        System.arraycopy(columnSizes, 0, ret, 0, columnSizes.length);
        int sum = 0;
        int[] nArray = columnSizes;
        int n = columnSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            sum += size;
            ++n2;
        }
        int diff = 100 - sum;
        int n3 = columnSizes.length - 1;
        ret[n3] = ret[n3] + diff;
        return ret;
    }

    private static BigInteger getPercentageTwips(int totalWidth, int percentage) {
        return BigInteger.valueOf(totalWidth / 100 * percentage);
    }

    public static void addBorders(Tbl table, int width) {
        table.setTblPr(new TblPr());
        CTBorder border = new CTBorder();
        border.setColor("auto");
        border.setSz(BigInteger.valueOf(width));
        border.setSpace(new BigInteger("0"));
        border.setVal(STBorder.SINGLE);
        TblBorders borders = new TblBorders();
        borders.setBottom(border);
        borders.setLeft(border);
        borders.setRight(border);
        borders.setTop(border);
        borders.setInsideH(border);
        borders.setInsideV(border);
        table.getTblPr().setTblBorders(borders);
    }
}

