/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text.docx;

import ch.elexis.core.text.ITextPlugin;
import ch.elexis.core.text.ReplaceCallback;
import ch.elexis.core.text.docx.stax.RegexFindStAXHandler;
import ch.elexis.core.text.docx.stax.TextFindStAXHandler;
import ch.elexis.core.text.docx.util.DocxUtil;
import ch.elexis.core.text.docx.util.FindTextVisitor;
import ch.elexis.core.text.docx.util.RegexTextVisitor;
import ch.elexis.core.text.docx.util.StyleInfo;
import ch.elexis.core.text.docx.util.TableUtil;
import ch.elexis.core.text.docx.util.TextBoxUtil;
import ch.elexis.core.text.docx.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.StAXHandlerInterface;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.slf4j.LoggerFactory;

public class DocxTextPlugin
implements ITextPlugin {
    private ITextPlugin.PageFormat format = ITextPlugin.PageFormat.USER;
    private ITextPlugin.Parameter parameter;
    private StyleInfo currentStyleInfo = new StyleInfo();
    private WordprocessingMLPackage currentDocument;

    public ITextPlugin.PageFormat getFormat() {
        return this.format;
    }

    public void setFormat(ITextPlugin.PageFormat f) {
        this.format = f;
    }

    public void setParameter(ITextPlugin.Parameter parameter) {
        this.parameter = parameter;
    }

    public boolean createEmptyDocument() {
        try {
            this.currentDocument = WordprocessingMLPackage.createPackage();
        }
        catch (InvalidFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("Erro creating document", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        try {
            this.currentDocument = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(bs));
        }
        catch (Docx4JException docx4JException) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading from byte array [" + bs + "] size [" + bs.length + "]");
            return false;
        }
        return true;
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        try {
            this.currentDocument = WordprocessingMLPackage.load((InputStream)is);
        }
        catch (Docx4JException docx4JException) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading from stream [" + is + "]");
            return false;
        }
        return true;
    }

    public boolean findOrReplace(String pattern, ReplaceCallback callBack) {
        if (this.getCurrentDocument() != null) {
            this.prepare();
            MainDocumentPart documentPart = this.currentDocument.getMainDocumentPart();
            RegexTextVisitor visitor = new RegexTextVisitor(this.currentDocument, pattern);
            TraversalUtil.visit((Object)documentPart, (TraversalUtilVisitor)visitor);
            visitor.replaceMatchingTexts(callBack);
            RelationshipsPart relationshipPart = documentPart.getRelationshipsPart();
            List relationships = relationshipPart.getRelationships().getRelationship();
            for (Relationship relationship : relationships) {
                if (!relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                JaxbXmlPart part = (JaxbXmlPart)relationshipPart.getPart(relationship);
                RegexTextVisitor partVisitor = new RegexTextVisitor(this.currentDocument, pattern);
                TraversalUtil.visit((Object)part, (TraversalUtilVisitor)partVisitor);
                partVisitor.replaceMatchingTexts(callBack);
            }
        }
        return false;
    }

    public List<String> findMatching(String pattern) {
        if (this.currentDocument != null) {
            try {
                this.prepare();
                RegexFindStAXHandler stAXHAndler = new RegexFindStAXHandler(pattern);
                MainDocumentPart documentPart = this.currentDocument.getMainDocumentPart();
                RelationshipsPart relationshipPart = documentPart.getRelationshipsPart();
                List relationships = relationshipPart.getRelationships().getRelationship();
                for (Relationship relationship : relationships) {
                    if (!relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                    JaxbXmlPart part = (JaxbXmlPart)relationshipPart.getPart(relationship);
                    part.pipe((StAXHandlerInterface)stAXHAndler);
                }
                documentPart.pipe((StAXHandlerInterface)stAXHAndler);
                return stAXHAndler.getFoundList();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Error finding text [" + pattern + "]", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    public int findCount(String text) {
        if (this.currentDocument != null) {
            try {
                this.prepare();
                TextFindStAXHandler stAXHAndler = new TextFindStAXHandler(text);
                MainDocumentPart documentPart = this.currentDocument.getMainDocumentPart();
                RelationshipsPart relationshipPart = documentPart.getRelationshipsPart();
                List relationships = relationshipPart.getRelationships().getRelationship();
                for (Relationship relationship : relationships) {
                    if (!relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !relationship.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                    JaxbXmlPart part = (JaxbXmlPart)relationshipPart.getPart(relationship);
                    part.pipe((StAXHandlerInterface)stAXHAndler);
                }
                documentPart.pipe((StAXHandlerInterface)stAXHAndler);
                return stAXHAndler.getCount();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Error finding text [" + text + "]", (Throwable)e);
            }
        }
        return 0;
    }

    protected void prepare() {
        if (this.currentDocument != null) {
            try {
                VariablePrepare.prepare((WordprocessingMLPackage)this.currentDocument);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Error preparing document", (Throwable)e);
            }
        }
    }

    public byte[] storeToByteArray() {
        if (this.currentDocument != null) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    Docx4J.save((OpcPackage)this.currentDocument, (OutputStream)out, (int)1);
                    return out.toByteArray();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | Docx4JException throwable) {
                LoggerFactory.getLogger(this.getClass()).error("Error writing to byte array");
                return null;
            }
        }
        return null;
    }

    public boolean insertTable(String text, int properties, String[][] contents, int[] columnSizes) {
        if (this.currentDocument != null) {
            FindTextVisitor visitor = new FindTextVisitor(text);
            TraversalUtil.visit((Object)this.currentDocument.getMainDocumentPart(), (TraversalUtilVisitor)visitor);
            List<Text> found = visitor.getFound();
            if (!found.isEmpty()) {
                for (Text foundText : found) {
                    foundText.setValue("");
                    R r = (R)foundText.getParent();
                    if (contents.length <= 0) continue;
                    Tbl table = TableUtil.insertTable(r, properties, contents, columnSizes, DocxUtil.getDocumentWidth(this.currentDocument), true);
                    TableUtil.addBorders(table, 1);
                }
                return true;
            }
        }
        return false;
    }

    public Object insertTextAt(int posx, int posy, int width, int height, String text, int align) {
        if (this.currentDocument != null) {
            return TextBoxUtil.createTextBox(this.currentDocument, posx - 3, posy, width, height, text, align, this.currentStyleInfo);
        }
        return null;
    }

    public boolean setFont(String name, int style, float size) {
        this.currentStyleInfo.setFontName(name);
        this.currentStyleInfo.setFontStyle(style);
        this.currentStyleInfo.setFontSize(size);
        return true;
    }

    public boolean setStyle(int style) {
        this.currentStyleInfo.setFontStyle(style);
        return true;
    }

    public Object insertText(String marke, String text, int align) {
        if (this.currentDocument != null) {
            FindTextVisitor visitor = new FindTextVisitor(marke);
            TraversalUtil.visit((Object)this.currentDocument.getMainDocumentPart(), (TraversalUtilVisitor)visitor);
            List<Text> found = visitor.getFound();
            if (!found.isEmpty()) {
                Object ret = null;
                for (Text foundText : found) {
                    foundText.setValue("");
                    R r = (R)foundText.getParent();
                    ret = TextUtil.insertText(r, text, align, this.currentStyleInfo);
                }
                return ret;
            }
        }
        return null;
    }

    public Object insertText(Object pos, String text, int align) {
        return TextUtil.insertText(pos, text, align, this.currentStyleInfo);
    }

    public boolean clear() {
        return false;
    }

    public String getMimeType() {
        return "docx";
    }

    public Object getCurrentDocument() {
        return this.currentDocument;
    }
}

