/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter.internal;

import ch.elexis.core.jpa.model.adapter.PredicateGroup;
import java.util.Iterator;
import java.util.Stack;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;

public class PredicateGroupStack {
    private CriteriaBuilder criteriaBuilder;
    private Stack<PredicateGroup> predicateGroups;

    public PredicateGroupStack(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
        this.predicateGroups = new Stack();
    }

    public PredicateGroup getCurrentPredicateGroup() {
        PredicateGroup ret = null;
        if (!this.predicateGroups.isEmpty()) {
            return this.predicateGroups.peek();
        }
        ret = this.createPredicateGroup();
        return ret;
    }

    public PredicateGroup createPredicateGroup() {
        PredicateGroup ret = new PredicateGroup(this.criteriaBuilder);
        this.predicateGroups.push(ret);
        return ret;
    }

    public PredicateGroup andPredicateGroups() {
        this.removeInvalidGroups();
        if (this.predicateGroups.size() > 1) {
            PredicateGroup top = this.predicateGroups.pop();
            PredicateGroup join = this.predicateGroups.pop();
            return this.predicateGroups.push(new PredicateGroup(this.criteriaBuilder, this.criteriaBuilder.and((Expression)join.getPredicate(), (Expression)top.getPredicate())));
        }
        throw new IllegalStateException("At least 2 groups required for and operation");
    }

    private void removeInvalidGroups() {
        Iterator iterator = this.predicateGroups.iterator();
        while (iterator.hasNext()) {
            PredicateGroup predicateGroup = (PredicateGroup)iterator.next();
            if (predicateGroup.getPredicate() != null) continue;
            iterator.remove();
        }
    }

    public PredicateGroup orPredicateGroups() {
        this.removeInvalidGroups();
        if (this.predicateGroups.size() > 1) {
            PredicateGroup top = this.predicateGroups.pop();
            PredicateGroup join = this.predicateGroups.pop();
            return this.predicateGroups.push(new PredicateGroup(this.criteriaBuilder, this.criteriaBuilder.or((Expression)join.getPredicate(), (Expression)top.getPredicate())));
        }
        throw new IllegalStateException("At least 2 groups required for or operation");
    }

    public int getPredicateGroupsSize() {
        return this.predicateGroups.size();
    }
}

