/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.importer.div.importers.AbstractHL7PatientResolver;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;

public class ImporterPatientResolver
extends AbstractHL7PatientResolver {
    private TimeTool convertTool = new TimeTool();

    public IPatient resolvePatient(String firstname, String lastname, String birthDate, String sender, String patid) {
        Patient pat = KontaktMatcher.findPatient((String)lastname, (String)firstname, (String)birthDate, (String)"", (String)"", (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL);
        if (pat == null) {
            String shortLastname = lastname;
            String shortFirstname = firstname;
            if (lastname.length() > 3) {
                shortLastname = lastname.substring(0, 3);
            }
            if (firstname.length() > 3) {
                shortFirstname = firstname.substring(0, 3);
            }
            pat = KontaktMatcher.findPatient((String)shortLastname, (String)shortFirstname, (String)birthDate, (String)"", (String)"", (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL);
        }
        if (pat == null) {
            this.convertTool.set(birthDate);
            String birthStr = this.convertTool.toString(4);
            pat = sender != null ? (Patient)KontaktSelektor.showInSync(Patient.class, (String)Messages.Core_Select_Patient, (String)(String.valueOf(Messages.HL7_WhoIs) + lastname + " " + firstname + " ," + birthStr + "\t\t PID: " + patid + " ?\n" + Messages.HL7_Lab + " " + sender)) : (Patient)KontaktSelektor.showInSync(Patient.class, (String)Messages.Core_Select_Patient, (String)(String.valueOf(Messages.HL7_WhoIs) + lastname + " " + firstname + " ," + birthStr + "?"));
        }
        if (pat != null) {
            return CoreModelServiceHolder.get().load(pat.getId(), IPatient.class).orElse(null);
        }
        return null;
    }
}

