/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Stock;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="STOCK_ENTRY")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
@NamedQueries(value={@NamedQuery(name="StockEntry.articleId.articleType", query="SELECT se FROM StockEntry se WHERE se.articleId = :articleId AND se.articleType = :articleType AND se.deleted = false"), @NamedQuery(name="StockEntry_SumCurrentStock.articleId.articleType", query="SELECT SUM(se.currentStock) FROM StockEntry se WHERE se.articleId = :articleId AND se.articleType = :articleType AND se.deleted = false", hints={@QueryHint(name="eclipselink.cache-usage", value="DoNotCheckCache")}), @NamedQuery(name="StockEntry_AvailableCurrentStock.articleId.articleType", query="SELECT MAX(CASE WHEN se.currentStock <= 0 THEN 0 WHEN (ABS(se.minimumStock)-se.currentStock) >=0 THEN 1 ELSE 2 END) FROM StockEntry se WHERE se.articleId = :articleId AND se.articleType = :articleType AND se.deleted = false", hints={@QueryHint(name="eclipselink.cache-usage", value="DoNotCheckCache")}), @NamedQuery(name="StockEntry_AvailableCurrentBelowStock.articleId.articleType", query="SELECT MAX(CASE WHEN se.currentStock <= 0 THEN 0 WHEN (ABS(se.minimumStock)-se.currentStock) >0 THEN 1 ELSE 2 END) FROM StockEntry se WHERE se.articleId = :articleId AND se.articleType = :articleType AND se.deleted = false", hints={@QueryHint(name="eclipselink.cache-usage", value="DoNotCheckCache")})})
public class StockEntry
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @OneToOne
    @JoinColumn(name="STOCK", insertable=true)
    Stock stock;
    @Column(name="article_type", length=255, nullable=false)
    String articleType;
    @Column(name="article_id", length=25, nullable=false)
    String articleId;
    @Column(name="min")
    int minimumStock;
    @Column(name="current")
    int currentStock;
    @Column(name="max")
    int maximumStock;
    @Column
    int fractionUnits;
    @OneToOne
    @JoinColumn(name="PROVIDER", insertable=false)
    Kontakt provider;
    static final long serialVersionUID = 5790965759338378448L;

    public StockEntry() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " articleId=[" + this.getArticleId() + "]  min=[" + this.getMinimumStock() + "] current=[" + this.getCurrentStock() + "]";
    }

    public Stock getStock() {
        return this._persistence_get_stock();
    }

    public void setStock(Stock stock) {
        this._persistence_set_stock(stock);
    }

    public String getArticleType() {
        return this._persistence_get_articleType();
    }

    public void setArticleType(String articleType) {
        this._persistence_set_articleType(articleType);
    }

    public String getArticleId() {
        return this._persistence_get_articleId();
    }

    public void setArticleId(String articleId) {
        this._persistence_set_articleId(articleId);
    }

    public Kontakt getProvider() {
        return this._persistence_get_provider();
    }

    public void setProvider(Object provider) {
        this._persistence_set_provider((Kontakt)provider);
    }

    public int getCurrentStock() {
        return this._persistence_get_currentStock();
    }

    public void setCurrentStock(int currentStock) {
        this._persistence_set_currentStock(currentStock);
    }

    public int getMinimumStock() {
        return this._persistence_get_minimumStock();
    }

    public void setMinimumStock(int minimumStock) {
        this._persistence_set_minimumStock(minimumStock);
    }

    public int getMaximumStock() {
        return this._persistence_get_maximumStock();
    }

    public void setMaximumStock(int maximumStock) {
        this._persistence_set_maximumStock(maximumStock);
    }

    public int getFractionUnits() {
        return this._persistence_get_fractionUnits();
    }

    public void setFractionUnits(int fractionUnits) {
        this._persistence_set_fractionUnits(fractionUnits);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new StockEntry(persistenceObject);
    }

    public StockEntry(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "articleType") {
            return this.articleType;
        }
        if (string == "provider") {
            return this.provider;
        }
        if (string == "articleId") {
            return this.articleId;
        }
        if (string == "currentStock") {
            return this.currentStock;
        }
        if (string == "minimumStock") {
            return this.minimumStock;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "fractionUnits") {
            return this.fractionUnits;
        }
        if (string == "stock") {
            return this.stock;
        }
        if (string == "maximumStock") {
            return this.maximumStock;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "articleType") {
            this.articleType = (String)object;
            return;
        }
        if (string == "provider") {
            this.provider = (Kontakt)object;
            return;
        }
        if (string == "articleId") {
            this.articleId = (String)object;
            return;
        }
        if (string == "currentStock") {
            this.currentStock = (Integer)object;
            return;
        }
        if (string == "minimumStock") {
            this.minimumStock = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "fractionUnits") {
            this.fractionUnits = (Integer)object;
            return;
        }
        if (string == "stock") {
            this.stock = (Stock)object;
            return;
        }
        if (string == "maximumStock") {
            this.maximumStock = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_articleType() {
        this._persistence_checkFetched("articleType");
        return this.articleType;
    }

    public void _persistence_set_articleType(String string) {
        this._persistence_checkFetchedForSet("articleType");
        this._persistence_propertyChange("articleType", this.articleType, string);
        this.articleType = string;
    }

    public Kontakt _persistence_get_provider() {
        this._persistence_checkFetched("provider");
        return this.provider;
    }

    public void _persistence_set_provider(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("provider");
        this._persistence_propertyChange("provider", this.provider, kontakt);
        this.provider = kontakt;
    }

    public String _persistence_get_articleId() {
        this._persistence_checkFetched("articleId");
        return this.articleId;
    }

    public void _persistence_set_articleId(String string) {
        this._persistence_checkFetchedForSet("articleId");
        this._persistence_propertyChange("articleId", this.articleId, string);
        this.articleId = string;
    }

    public int _persistence_get_currentStock() {
        this._persistence_checkFetched("currentStock");
        return this.currentStock;
    }

    public void _persistence_set_currentStock(int n) {
        this._persistence_checkFetchedForSet("currentStock");
        this._persistence_propertyChange("currentStock", new Integer(this.currentStock), new Integer(n));
        this.currentStock = n;
    }

    public int _persistence_get_minimumStock() {
        this._persistence_checkFetched("minimumStock");
        return this.minimumStock;
    }

    public void _persistence_set_minimumStock(int n) {
        this._persistence_checkFetchedForSet("minimumStock");
        this._persistence_propertyChange("minimumStock", new Integer(this.minimumStock), new Integer(n));
        this.minimumStock = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public int _persistence_get_fractionUnits() {
        this._persistence_checkFetched("fractionUnits");
        return this.fractionUnits;
    }

    public void _persistence_set_fractionUnits(int n) {
        this._persistence_checkFetchedForSet("fractionUnits");
        this._persistence_propertyChange("fractionUnits", new Integer(this.fractionUnits), new Integer(n));
        this.fractionUnits = n;
    }

    public Stock _persistence_get_stock() {
        this._persistence_checkFetched("stock");
        return this.stock;
    }

    public void _persistence_set_stock(Stock stock) {
        this._persistence_checkFetchedForSet("stock");
        this._persistence_propertyChange("stock", this.stock, stock);
        this.stock = stock;
    }

    public int _persistence_get_maximumStock() {
        this._persistence_checkFetched("maximumStock");
        return this.maximumStock;
    }

    public void _persistence_set_maximumStock(int n) {
        this._persistence_checkFetchedForSet("maximumStock");
        this._persistence_propertyChange("maximumStock", new Integer(this.maximumStock), new Integer(n));
        this.maximumStock = n;
    }
}

