/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Role;
import ch.rgw.tools.PasswordEncryptionService;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;

public class User
extends PersistentObject {
    public static final String TABLENAME = "USER_";
    public static final String USERNAME_ADMINISTRATOR = "Administrator";
    public static final String FLD_IS_ACTIVE = "IS_ACTIVE";
    public static final String FLD_IS_ADMINISTRATOR = "IS_ADMINISTRATOR";
    public static final String FLD_ALLOW_EXTERNAL = "ALLOW_EXTERNAL";
    public static final String FLD_ASSOC_CONTACT = "KONTAKT_ID";
    public static final String FLD_HASHED_PASSWORD = "HASHED_PASSWORD";
    public static final String FLD_SALT = "SALT";
    public static final String FLD_KEYSTORE = "KEYSTORE";
    public static final String FLD_TOTP = "TOTP";
    public static final String FLD_JOINT_ROLES = "Roles";
    private static PasswordEncryptionService pes = new PasswordEncryptionService();

    static {
        User.addMapping(TABLENAME, "id", FLD_IS_ACTIVE, FLD_IS_ADMINISTRATOR, FLD_ASSOC_CONTACT, FLD_HASHED_PASSWORD, FLD_SALT, FLD_KEYSTORE, FLD_TOTP, FLD_ALLOW_EXTERNAL, "Roles=LIST:USER_ID:USER_ROLE_JOINT");
        User.initTables();
    }

    @Deprecated(forRemoval=true)
    protected static void initTables() {
        if (!User.tableExists(TABLENAME)) {
            User.executeDBInitScriptForClass(User.class, null);
            User.migrateToNewStructure();
        }
    }

    public User() {
    }

    public User(Anwender anw, String username, String password) {
        this.create(username);
        this.setAssignedContact(anw);
        if (password == null || password.length() == 0) {
            password = ElexisIdGenerator.generateId();
        }
        this.setPassword(password);
        this.setAssignedRole(Role.load("user"), true);
    }

    protected User(String id) {
        super(id);
    }

    @NonNull
    public static User load(String id) {
        return new User(id);
    }

    @Deprecated(forRemoval=true)
    private static void migrateToNewStructure() {
        Role.initTables();
        log.info("Starting migration to new user structure");
        Query qbe = new Query(Anwender.class);
        List users = qbe.execute();
        for (Anwender anwender : users) {
            User u;
            String username = anwender.get("Bezeichnung3");
            if (username == null || username.length() == 0) {
                log.warn("Username for Anwender " + anwender.getLabel() + " not set. Skipping user creation.");
                continue;
            }
            String password = (String)anwender.getExtInfoStoredObjectByKey("UsrPwd");
            boolean setActive = true;
            if (password == null || password.length() == 0) {
                password = "pass";
                log.warn("Password for Anwender " + anwender.getLabel() + " is empty, setting 'pass' and deactivating user.");
                setActive = false;
            }
            if (username.equals(USERNAME_ADMINISTRATOR)) {
                u = User.load(USERNAME_ADMINISTRATOR);
                u.setAssignedContact(anwender);
                u.setPassword(password);
                log.info("Overriding Administrator password with password from anwender [{}]", (Object)anwender.getLabel());
            } else {
                u = new User(anwender, username, password);
            }
            u.setActive(setActive);
            boolean isMandator = anwender.getBoolean("istMandant");
            if (isMandator) {
                u.setAssignedRole(Role.load("medical-practitioner"), true);
                u.setAssignedRole(Role.load("mandator"), true);
            }
            log.info("Migrated anwender [{}] to new user structure with id [{}]", (Object)anwender.getLabel(), (Object)u.getId());
        }
    }

    public String getTotp() {
        String totp = this.get(FLD_TOTP);
        if (StringUtils.isEmpty((CharSequence)totp)) {
            this.resetTotp();
        }
        return totp;
    }

    public boolean verifyTotp(String otp) {
        return false;
    }

    public void resetTotp() {
        throw new UnsupportedOperationException();
    }

    public List<Role> getAssignedRoles() {
        List<String> roles = this.getList(FLD_JOINT_ROLES, false);
        return roles.stream().map((? super T p) -> Role.load(p)).collect(Collectors.toList());
    }

    public void setAssignedRole(Role role, boolean isAssigned) {
        List<Role> assignedRoles = this.getAssignedRoles();
        if (isAssigned) {
            if (assignedRoles.contains(role)) {
                return;
            }
            this.addToList(FLD_JOINT_ROLES, role.getId(), new String[0]);
        } else {
            if (!assignedRoles.contains(role)) {
                return;
            }
            this.removeFromList(FLD_JOINT_ROLES, role.getId());
        }
    }

    public boolean verifyPassword(char[] attemptedPassword) {
        boolean ret = false;
        String[] values = this.get(false, FLD_HASHED_PASSWORD, FLD_SALT);
        try {
            ret = pes.authenticate(attemptedPassword, values[0], values[1]);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            log.error("Error verifying password", e);
        }
        return ret;
    }

    public String getUsername() {
        return this.get("id");
    }

    public static boolean verifyUsernameNotTaken(String username) {
        Query qbe = new Query(User.class);
        qbe.clear(true);
        qbe.add("id", "=", username);
        return qbe.execute().size() == 0;
    }

    @Nullable
    public User setUsername(String username) {
        if (User.verifyUsernameNotTaken(username)) {
            List<Role> assignedRoles = this.getAssignedRoles();
            assignedRoles.stream().forEachOrdered(r -> this.setAssignedRole((Role)r, false));
            this.set("id", username);
            User u = User.load(username);
            assignedRoles.stream().forEachOrdered(r -> u.setAssignedRole((Role)r, true));
            return u;
        }
        return null;
    }

    public void setPassword(@NonNull String pwd) {
        try {
            String salt = pes.generateSaltAsHexString();
            String hashed_pw = pes.getEncryptedPasswordAsHexString(pwd, salt);
            this.set(new String[]{FLD_SALT, FLD_HASHED_PASSWORD}, salt, hashed_pw);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            log.error("Error setting password for contact", e);
        }
    }

    public void setAssignedContact(@Nullable Kontakt contact) {
        if (contact == null) {
            return;
        }
        this.set(FLD_ASSOC_CONTACT, contact.getId());
    }

    @Nullable
    public String getAssignedContactId() {
        return this.get(FLD_ASSOC_CONTACT);
    }

    public boolean isAdministrator() {
        return this.getBoolean(FLD_IS_ADMINISTRATOR);
    }

    public void setAdministrator(boolean val) {
        this.set(FLD_IS_ADMINISTRATOR, User.ts(val));
    }

    @Override
    public String getLabel() {
        return this.getUsername();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Nullable
    public Anwender getAssignedContact() {
        String assocId = this.getAssignedContactId();
        if (assocId != null && assocId.length() > 1) {
            return Anwender.load(assocId);
        }
        return null;
    }

    public boolean isActive() {
        return this.getBoolean(FLD_IS_ACTIVE);
    }

    public void setActive(boolean val) {
        this.set(FLD_IS_ACTIVE, User.ts(val));
    }

    @Override
    public boolean delete() {
        this.getAssignedRoles().stream().forEachOrdered(r -> this.setAssignedRole((Role)r, false));
        return super.delete();
    }
}

