/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IRole;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import java.util.List;
import java.util.Locale;

public class Role
extends PersistentObject {
    public static final String TABLENAME = "ROLE";
    public static final String FLD_SYSTEM_ROLE = "ISSYSTEMROLE";
    public static final String FLD_EXT_I18N_LABEL = "LAB_" + Locale.getDefault().getLanguage();
    public static final String FLD_JOINT_RIGHTS = "Rights";

    static {
        Role.addMapping(TABLENAME, "id", FLD_SYSTEM_ROLE, "ExtInfo", "Rights=LIST:ROLE_ID:ROLE_RIGHT_JOINT");
        Role.initTables();
    }

    public Role() {
    }

    @Deprecated(forRemoval=true)
    protected static void initTables() {
        if (!Role.tableExists(TABLENAME)) {
            Role.executeDBInitScriptForClass(Role.class, null);
        }
    }

    public Role(boolean isSystemRole) {
        this.create(null);
        this.setSystemRole(false);
    }

    protected Role(String id) {
        super(id);
    }

    public static Role load(String id) {
        return new Role(id);
    }

    @Override
    public String getLabel() {
        return this.get("id");
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public boolean isSystemRole() {
        return this.getBoolean(FLD_SYSTEM_ROLE);
    }

    public void setSystemRole(boolean val) {
    }

    public String getRoleName() {
        return this.get("id");
    }

    public static boolean verifyRoleNameNotTaken(String rolename) {
        return new Query(Role.class, "id", rolename).execute().size() == 0;
    }

    public String getTranslatedLabel() {
        return (String)this.getExtInfoStoredObjectByKey(FLD_EXT_I18N_LABEL);
    }

    public void setTranslatedLabel(String translatedLabel) {
        this.setExtInfoStoredObjectByKey(FLD_EXT_I18N_LABEL, translatedLabel);
    }

    private List<String> getAssignedRightsIds() {
        return this.getList(FLD_JOINT_RIGHTS, false);
    }

    public void revokeAllRightsForRole() {
        JdbcLink.Stm stm = Role.getConnection().getStatement();
        stm.exec("DELETE FROM ROLE_RIGHT_JOINT WHERE ROLE_ID=" + this.getWrappedId());
        Role.getConnection().releaseStatement(stm);
    }

    public IRole toIRole() {
        return (IRole)CoreModelServiceHolder.get().load(this.getId(), IRole.class).orElseThrow(() -> new IllegalStateException("Could not convert contact [" + this.getId() + "]"));
    }
}

