/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.tools.JdbcLink;
import java.util.Objects;

public class Mandant
extends Anwender {
    public static final String BILLER = "Rechnungssteller";
    public static final String FLD_EXT_IS_INACTIVE = "isInactive";

    static {
        Mandant.addMapping("KONTAKT", "ExtInfo", "istMandant", "Label=Bezeichnung3");
    }

    @Override
    public boolean isValid() {
        if (this.get("istMandant").equals("0")) {
            return false;
        }
        return super.isValid();
    }

    public Rechnungssteller getRechnungssteller() {
        Rechnungssteller ret = Rechnungssteller.load(this.getInfoString(BILLER));
        return ret.isValid() ? ret : Rechnungssteller.load(this.getId());
    }

    public void setRechnungssteller(Kontakt rs) {
        this.setInfoElement(BILLER, rs.getId());
    }

    public boolean isInactive() {
        Object value = this.getExtInfoStoredObjectByKey(FLD_EXT_IS_INACTIVE);
        return Objects.equals(Boolean.TRUE, value);
    }

    public void setInactive(boolean value) {
        this.setExtInfoStoredObjectByKey(FLD_EXT_IS_INACTIVE, value);
    }

    protected Mandant(String id) {
        super(id);
    }

    public Mandant(String Name, String Vorname, String Geburtsdatum, String s) {
        super(Name, Vorname, Geburtsdatum, s);
    }

    protected Mandant() {
    }

    public static Mandant load(String id) {
        Mandant ret = new Mandant(id);
        return ret;
    }

    public Mandant(String name, String pwd) {
        super(name, pwd, true);
    }

    public Mandant(String name, String pwd, String email) {
        super(name, pwd, true);
        this.set(new String[]{"E-Mail"}, email);
    }

    @Override
    protected String getConstraint() {
        return "istMandant" + "=" + JdbcLink.wrap((String)"1");
    }

    @Override
    protected void setConstraint() {
        this.set(new String[]{"istMandant", "istAnwender", "istPerson"}, "1", "1", "1");
    }

    public String getMandantLabel() {
        return String.valueOf(this.getName()) + " " + this.getVorname() + " (" + this.getLabel() + ")";
    }

    @Override
    protected String getTableName() {
        return "KONTAKT";
    }

    public PersistentObject getReferencedObject(String fieldl) {
        String responsibleId;
        if (fieldl != null && "Responsible".equals(fieldl) && (responsibleId = (String)this.getExtInfoStoredObjectByKey("ch.elexis.tarmedprefs.responsible")) != null && !responsibleId.isEmpty()) {
            return Mandant.load(responsibleId);
        }
        return null;
    }
}

