/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.data.interfaces.ILabOrder;
import ch.elexis.core.data.interfaces.ILabResult;
import ch.elexis.core.data.interfaces.IPatient;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LabOrder
extends PersistentObject
implements Comparable<LabOrder>,
ILabOrder {
    public static final String FLD_USER = "userid";
    public static final String FLD_MANDANT = "mandant";
    public static final String FLD_PATIENT = "patient";
    public static final String FLD_ITEM = "item";
    public static final String FLD_RESULT = "result";
    public static final String FLD_TIME = "time";
    public static final String FLD_OBSERVATIONTIME = "observationtime";
    public static final String FLD_STATE = "state";
    public static final String FLD_ORDERID = "orderid";
    public static final String FLD_GROUPNAME = "groupname";
    public static final String VERSIONID = "VERSION";
    private static final String TABLENAME = "LABORDER";

    static {
        LabOrder.addMapping(TABLENAME, "id", FLD_USER, FLD_MANDANT, FLD_PATIENT, FLD_ITEM, FLD_RESULT, FLD_ORDERID, FLD_GROUPNAME, FLD_TIME, FLD_STATE, FLD_OBSERVATIONTIME);
    }

    public static String getStateLabel(State state) {
        switch (state) {
            case ORDERED: {
                return Messages.LabOrder_stateOrdered;
            }
            case DONE: {
                return Messages.ProcessStatus_CLOSED;
            }
            case DONE_IMPORT: {
                return Messages.LabOrder_stateImported;
            }
        }
        return "???";
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public LabOrder() {
    }

    public LabOrder(String id) {
        super(id);
    }

    public static LabOrder load(String id) {
        return new LabOrder(id);
    }

    public LabOrder(Anwender user, Mandant mandant, Patient patient, LabItem item, LabResult result, String orderId, String groupname, TimeTool time) {
        this.create(null);
        this.set(new String[]{FLD_USER, FLD_MANDANT, FLD_PATIENT, FLD_ITEM, FLD_TIME, FLD_OBSERVATIONTIME, FLD_ORDERID, FLD_GROUPNAME}, user.getId(), mandant.getId(), patient.getId(), item.getId(), time.toString(13), time.toString(13), orderId, groupname);
        this.setState(State.ORDERED);
        if (result != null) {
            this.set(FLD_RESULT, result.getId());
        }
        if (item.getTyp() == LabItemTyp.FORMULA) {
            this.createResult();
            this.setState(State.DONE);
        }
    }

    public LabOrder(String userId, String mandatorId, String patientId, ILabItem item, String labResultId, String orderId, String groupname, TimeTool time) {
        this.create(null);
        this.set(FLD_USER, userId);
        this.set(FLD_MANDANT, mandatorId);
        this.set(FLD_PATIENT, patientId);
        this.set(FLD_ITEM, item.getId());
        this.set(FLD_TIME, time.toString(13));
        this.set(FLD_OBSERVATIONTIME, time.toString(13));
        this.set(FLD_ORDERID, orderId);
        this.set(FLD_GROUPNAME, groupname);
        this.setState(State.ORDERED);
        if (labResultId != null) {
            this.set(FLD_RESULT, labResultId);
        }
        if (item.getTyp() == LabItemTyp.FORMULA) {
            this.createResult();
            this.setState(State.DONE);
        }
    }

    public LabResult createResult() {
        LabResult result = new LabResult(this.getPatient(), null, this.getLabItem(), "", null);
        result.setObservationTime(this.getObservationTime());
        this.setLabResult(result);
        return result;
    }

    public LabResult createResult(Kontakt origin) {
        LabResult result = new LabResult(this.getPatient(), null, this.getLabItem(), "", null, origin);
        result.setObservationTime(this.getObservationTime());
        this.setLabResult(result);
        return result;
    }

    public void setState(State state) {
        this.set(FLD_STATE, Integer.toString(state.ordinal()));
        if (state != State.ORDERED && this.isOrderDone()) {
            this.closeOrderReminder();
        }
    }

    public void setObservationTime(TimeTool time) {
        this.set(FLD_OBSERVATIONTIME, time.toString(13));
    }

    public void setObservationTimeWithResults(TimeTool time) {
        List<ILabOrder> orders = LabOrder.getLabOrdersByOrderId(this.get(FLD_ORDERID));
        for (ILabOrder iLabOrder : orders) {
            ((LabOrder)iLabOrder).setObservationTime(time);
        }
        List<ILabResult> results = this.getLabResults();
        for (ILabResult labResult : results) {
            labResult.setObservationTime(time);
        }
    }

    private boolean isOrderDone() {
        return LabOrder.getLabOrders(this.getPatient(), null, null, null, this.get(FLD_ORDERID), null, State.ORDERED) != null;
    }

    private void closeOrderReminder() {
        List<Reminder> reminders = Reminder.findForPatient(this.getPatient(), null);
        for (Reminder reminder : reminders) {
            String[] parts;
            String params = reminder.get("Params");
            if (!params.startsWith(FLD_ORDERID) || (parts = params.split("=")).length != 2 || !parts[1].equals(this.get(FLD_ORDERID))) continue;
            reminder.setStatus(ProcessStatus.CLOSED);
        }
    }

    public State getState() {
        String stateStr = LabOrder.checkNull(this.get(FLD_STATE));
        if (stateStr.isEmpty()) {
            return State.ORDERED;
        }
        return State.values()[Integer.parseInt(stateStr.trim())];
    }

    public TimeTool getObservationTime() {
        String string = this.get(FLD_OBSERVATIONTIME);
        if (string != null && !string.isEmpty()) {
            return new TimeTool(string);
        }
        return null;
    }

    @Override
    public LabItem getLabItem() {
        LabItem ret = new LabItem(this.get(FLD_ITEM));
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    @Override
    public void setLabItem(ILabItem item) {
        this.set(FLD_ITEM, item.getId());
    }

    @Override
    public ILabResult getLabResult() {
        LabResult ret = new LabResult(this.get(FLD_RESULT));
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    @Override
    public void setLabResult(ILabResult result) {
        if (result != null) {
            this.set(FLD_RESULT, result.getId());
        } else {
            this.set(FLD_RESULT, null);
        }
    }

    public void setLabResultIdAsString(String labresultId) {
        if (labresultId != null) {
            this.set(FLD_RESULT, labresultId);
        } else {
            this.set(FLD_RESULT, null);
        }
    }

    public TimeTool getTime() {
        String string = this.get(FLD_TIME);
        if (string != null && !string.isEmpty()) {
            return new TimeTool(string);
        }
        return null;
    }

    public Patient getPatient() {
        return Patient.load(this.get(FLD_PATIENT));
    }

    @Override
    public int compareTo(LabOrder other) {
        State otherState = other.getState();
        if (otherState.ordinal() < this.getState().ordinal()) {
            return -1;
        }
        if (otherState.ordinal() > this.getState().ordinal()) {
            return 1;
        }
        return this.getLabItem().getLabel().compareTo(other.getLabItem().getLabel());
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.get(FLD_ORDERID) + "] - ");
        sb.append(LabOrder.getStateLabel(this.getState()));
        sb.append(" - ");
        sb.append(this.getLabItem().getLabel());
        if (this.getLabResult() != null) {
            sb.append(" - ");
            sb.append(this.getLabResult().getResult());
        }
        return sb.toString();
    }

    public List<ILabResult> getLabResults() {
        ArrayList<ILabResult> ret = new ArrayList<ILabResult>();
        List<ILabOrder> orders = LabOrder.getLabOrdersByOrderId(this.get(FLD_ORDERID));
        if (orders != null) {
            for (ILabOrder labOrder : orders) {
                if (labOrder.getLabResult() == null) continue;
                ret.add(labOrder.getLabResult());
            }
        }
        return ret;
    }

    public static Kontakt getOrCreateManualLabor() {
        String identifier = Messages.LabOrder_contactOwnLabName;
        Labor labor = null;
        Query qbe = new Query(Labor.class);
        qbe.add("Kuerzel", "LIKE", "%" + identifier + "%");
        qbe.or();
        qbe.add("Bezeichnung1", "LIKE", "%" + identifier + "%");
        List results = qbe.execute();
        labor = results.isEmpty() ? new Labor(identifier, "Labor " + identifier) : (Labor)results.get(0);
        return labor;
    }

    public static List<LabOrder> getLabOrders(Patient patient, Mandant mandant, ILabItem labItem, LabResult result, String orderId, TimeTool time, State state) {
        return LabOrder.getLabOrders(patient.getId(), mandant != null ? mandant.getId() : null, labItem, result, orderId, time, state);
    }

    public static List<ILabOrder> getLabOrdersByOrderId(String orderId) {
        Query qlo = new Query(LabOrder.class);
        qlo.add(FLD_ORDERID, "=", orderId);
        qlo.add("id", "<>", VERSIONID);
        List<ILabOrder> orders = qlo.execute();
        if (orders.isEmpty()) {
            return null;
        }
        return orders;
    }

    public static List<LabOrder> getLabOrdersByLabItem(ILabItem item) {
        Query qlo = new Query(LabOrder.class);
        qlo.add(FLD_ITEM, "=", item.getId());
        List<LabOrder> orders = qlo.execute();
        if (orders.isEmpty()) {
            return null;
        }
        return orders;
    }

    public static List<LabOrder> getLabOrders(String patientId, String mandantId, ILabItem labItem, LabResult result, String orderId, TimeTool time, State state) {
        List<LabOrder> orders;
        Query qlo = new Query(LabOrder.class);
        qlo.add("id", "<>", VERSIONID);
        if (patientId != null) {
            qlo.add(FLD_PATIENT, "=", patientId);
        }
        if (mandantId != null) {
            qlo.add(FLD_MANDANT, "=", mandantId);
        }
        if (labItem != null) {
            qlo.add(FLD_ITEM, "=", labItem.getId());
        }
        if (result != null) {
            qlo.add(FLD_RESULT, "=", result.getId());
        }
        if (orderId != null && !orderId.isEmpty()) {
            qlo.add(FLD_ORDERID, "=", orderId);
        }
        if (time != null) {
            qlo.add(FLD_TIME, "LIKE", String.valueOf(time.toString(9)) + "%");
        }
        if (state != null) {
            qlo.add(FLD_STATE, "=", Integer.toString(state.ordinal()));
        }
        if ((orders = qlo.execute()).isEmpty()) {
            return Collections.emptyList();
        }
        return orders;
    }

    public static Map<String, List<LabOrder>> getMapByOrderId() {
        HashMap<String, List<LabOrder>> ret = new HashMap<String, List<LabOrder>>();
        Query qlo = new Query(LabOrder.class);
        List orders = qlo.execute();
        for (LabOrder labOrder : orders) {
            List<LabOrder> groupedList = ret.get(labOrder.get(FLD_ORDERID));
            if (groupedList != null) {
                groupedList.add(labOrder);
                continue;
            }
            groupedList = new ArrayList<LabOrder>();
            groupedList.add(labOrder);
            ret.put(labOrder.get(FLD_ORDERID), groupedList);
        }
        return ret;
    }

    public static synchronized String getNextOrderId() {
        LabOrder version = LabOrder.load(VERSIONID);
        String orderId = version.get(FLD_ORDERID);
        String nextOrderId = "-1";
        if (orderId != null && !orderId.isEmpty()) {
            int intNextOrderId = Integer.parseInt(orderId) + 1;
            List<ILabOrder> existing = LabOrder.getLabOrdersByOrderId(Integer.toString(intNextOrderId));
            while (existing != null) {
                existing = LabOrder.getLabOrdersByOrderId(Integer.toString(++intNextOrderId));
            }
            nextOrderId = Integer.toString(intNextOrderId);
        } else {
            nextOrderId = LabOrder.getNextOrderIdOld();
        }
        version.set(FLD_ORDERID, nextOrderId);
        return nextOrderId;
    }

    private static String getNextOrderIdOld() {
        int numberOfIds;
        block7: {
            JdbcLink link = PersistentObject.getConnection();
            JdbcLink.Stm statement = link.getStatement();
            ResultSet result = statement.query("SELECT COUNT(DISTINCT orderid) AS total FROM LABORDER");
            numberOfIds = 0;
            try {
                try {
                    if (result.next()) {
                        numberOfIds = result.getInt("total");
                    }
                }
                catch (SQLException ex) {
                    ExHandler.handle((Throwable)ex);
                    link.releaseStatement(statement);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                link.releaseStatement(statement);
                throw throwable;
            }
            link.releaseStatement(statement);
        }
        int orderId = numberOfIds + 1;
        List<ILabOrder> existing = LabOrder.getLabOrdersByOrderId(Integer.toString(orderId));
        while (existing != null) {
            existing = LabOrder.getLabOrdersByOrderId(Integer.toString(++orderId));
        }
        return Integer.toString(orderId);
    }

    @Override
    public IPatient getPatientContact() {
        Patient patient = this.getPatient();
        if (patient == null) {
            return null;
        }
        return new ContactBean(patient);
    }

    @Override
    public void setPatientContact(IPatient value) {
        this.set(FLD_PATIENT, value.getId());
    }

    public static enum State {
        ORDERED,
        DONE,
        DONE_IMPORT;

    }
}

