/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.data.Anschrift;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.BezugsKontaktRelation;
import ch.elexis.data.Labor;
import ch.elexis.data.Messages;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.elexis.data.Xid;
import ch.elexis.data.ZusatzAdresse;
import ch.elexis.util.MFUList;
import ch.rgw.tools.StringTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Kontakt
extends PersistentObject {
    public static final String FLD_E_MAIL = "E-Mail";
    public static final String FLD_E_MAIL2 = "email2";
    public static final String FLD_WEBSITE = "Website";
    public static final String FLD_MOBILEPHONE = "NatelNr";
    public static final String FLD_FAX = "Fax";
    public static final String FLD_IS_LAB = "istLabor";
    public static final String FLD_IS_MANDATOR = "istMandant";
    public static final String FLD_IS_USER = "istAnwender";
    public static final String FLD_SHORT_LABEL = "Kuerzel";
    public static final String FLD_IS_ORGANIZATION = "istOrganisation";
    public static final String FLD_IS_PATIENT = "istPatient";
    public static final String FLD_IS_PERSON = "istPerson";
    public static final String FLD_ANSCHRIFT = "Anschrift";
    public static final String FLD_COUNTRY = "Land";
    public static final String FLD_PLACE = "Ort";
    public static final String FLD_ZIP = "Plz";
    public static final String FLD_STREET = "Strasse";
    public static final String FLD_PHONE2 = "Telefon2";
    public static final String FLD_PHONE1 = "Telefon1";
    public static final String FLD_REMARK = "Bemerkung";
    public static final String FLD_NAME3 = "Bezeichnung3";
    public static final String FLD_NAME2 = "Bezeichnung2";
    public static final String FLD_NAME1 = "Bezeichnung1";
    public static final String TABLENAME = "KONTAKT";
    public static final String[] DEFAULT_SORT = new String[]{"Bezeichnung1", "Bezeichnung2", "Strasse", "Ort"};
    volatile String Bezug;

    static {
        Kontakt.addMapping(TABLENAME, "BezugsKontakte = JOINT:myID:otherID:KONTAKT_ADRESS_JOINT", "MyReminders\t\t= LIST:IdentID:REMINDERS", FLD_NAME1, FLD_NAME2, FLD_NAME3, "Kuerzel= PatientNr", FLD_REMARK, FLD_PHONE1, FLD_PHONE2, "E-Mail=EMail", FLD_E_MAIL2, FLD_WEBSITE, "ExtInfo", FLD_IS_ORGANIZATION, FLD_IS_PERSON, FLD_IS_PATIENT, FLD_IS_USER, FLD_IS_MANDATOR, FLD_IS_LAB, FLD_STREET, FLD_ZIP, FLD_PLACE, FLD_COUNTRY, FLD_FAX, FLD_ANSCHRIFT, FLD_MOBILEPHONE, "PatientNr");
        AccessControlServiceHolder.get().doPrivileged(() -> {
            Xid.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/anrede", "Anrede", 2);
            Xid.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/kanton", "Kanton", 2);
            Xid.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/spez", "Spezialit\u00e4t", 2);
            Xid.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/rolle", "Rolle", 2);
            Xid.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/lab/sendingfacility", "Sendende Institution", 2);
            Xid.getDomain("www.elexis.ch/xid/kontakt/anrede").addDisplayOption(Person.class);
            Xid.getDomain("www.elexis.ch/xid/kontakt/kanton").addDisplayOption(Person.class);
            Xid.getDomain("www.elexis.ch/xid/kontakt/spez").addDisplayOption(Person.class);
            Xid.getDomain("www.elexis.ch/xid/kontakt/lab/sendingfacility").addDisplayOption(Labor.class);
        });
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Override
    public String getLabel() {
        return this.getLabel(false);
    }

    public String getLabel(boolean shortLabel) {
        StringBuilder bld = new StringBuilder();
        if (shortLabel) {
            bld.append(this.get(FLD_NAME1));
            String bez3 = this.get(FLD_NAME3);
            if (!StringTool.isNothing((Object)bez3)) {
                bld.append("(").append(bez3).append(")");
            }
        } else {
            String[] ret = new String[6];
            this.get(new String[]{FLD_NAME1, FLD_NAME2, FLD_NAME3, FLD_STREET, FLD_ZIP, FLD_PLACE}, ret);
            bld.append(ret[0]).append(" ").append(Kontakt.checkNull(ret[1]));
            if (!StringTool.isNothing((Object)ret[2])) {
                bld.append("(").append(ret[2]).append(")");
            }
            bld.append(", ").append(Kontakt.checkNull(ret[3])).append(", ").append(Kontakt.checkNull(ret[4])).append(" ").append(Kontakt.checkNull(ret[5]));
        }
        return bld.toString();
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    public List<BezugsKontakt> getBezugsKontakte() {
        Query qbe = new Query(BezugsKontakt.class);
        qbe.add("myID", "=", this.getId());
        return qbe.execute();
    }

    public List<ZusatzAdresse> getZusatzAdressen() {
        Query qbe = new Query(ZusatzAdresse.class);
        qbe.add("Kontakt_Id", "=", this.getId());
        qbe.orderBy(false, "Typ", "lastupdate");
        return qbe.execute();
    }

    public Anschrift getAnschrift() {
        return new Anschrift(this);
    }

    public String getTelephoneLabel() {
        String mobile;
        String t2;
        ArrayList<String> phoneData = new ArrayList<String>();
        String t1 = this.get(FLD_PHONE1);
        if (StringUtils.isNotBlank((CharSequence)t1)) {
            phoneData.add("T1: " + t1);
        }
        if (StringUtils.isNotBlank((CharSequence)(t2 = this.get(FLD_PHONE2)))) {
            phoneData.add("T2: " + t2);
        }
        if (StringUtils.isNotBlank((CharSequence)(mobile = this.get(FLD_MOBILEPHONE)))) {
            phoneData.add("M: " + mobile);
        }
        return StringUtils.join(phoneData, (String)", ");
    }

    public void setAnschrift(Anschrift adr) {
        if (adr != null) {
            this.set(new String[]{FLD_STREET, FLD_ZIP, FLD_PLACE, FLD_COUNTRY}, adr.getStrasse(), adr.getPlz(), adr.getOrt(), adr.getLand());
        }
    }

    public String getPostAnschrift() {
        return this.getPostAnschrift(false);
    }

    public String getPostAnschrift(boolean multiline) {
        String an = this.get(FLD_ANSCHRIFT);
        if (StringTool.isNothing((Object)an)) {
            an = this.createStdAnschrift();
        }
        an = an.replaceAll("[\\r\\n]\\n", "\n");
        return multiline ? an : an.replaceAll("\\n", " ");
    }

    public String createStdAnschrift() {
        Anschrift an = this.getAnschrift();
        String ret = String.valueOf(this.getSalutation()) + an.getEtikette(false, true);
        String old = this.get(FLD_ANSCHRIFT);
        if (StringTool.isNothing((Object)old)) {
            this.set(FLD_ANSCHRIFT, ret);
        }
        return ret;
    }

    public String getSalutation() {
        StringBuilder sb = new StringBuilder();
        if (this.istPerson()) {
            Person p = Person.load(this.getId());
            String salutation = p.getGeschlecht().equals("m") ? Messages.Contact_SalutationM : Messages.Contact_SalutationF;
            sb.append(salutation);
            sb.append("\n");
            String titel = p.get("Titel");
            if (!StringTool.isNothing((Object)titel)) {
                sb.append(titel).append(" ");
            }
            sb.append(p.getVorname()).append(" ").append(p.getName()).append("\n");
        } else {
            Organisation o = Organisation.load(this.getId());
            String[] rx = new String[2];
            o.get(new String[]{FLD_NAME1, FLD_NAME2}, rx);
            sb.append(rx[0]).append(" ").append(Kontakt.checkNull(rx[1])).append("\n");
        }
        return sb.toString();
    }

    public String getPostAnschriftPhoneFaxEmail(boolean multiline, boolean including_phone) {
        String thisAddressFLD_E_MAIL;
        String thisAddressFLD_FAX;
        StringBuffer thisAddress = new StringBuffer();
        thisAddress.append(this.getPostAnschrift(true).trim());
        thisAddress.append(System.getProperty("line.separator"));
        if (including_phone) {
            String thisAddressFLD_MOBILEPHONE;
            String thisAddressFLD_PHONE2;
            String thisAddressFLD_PHONE1 = this.get(FLD_PHONE1);
            if (!StringTool.isNothing((Object)thisAddressFLD_PHONE1)) {
                thisAddress.append(String.valueOf(thisAddressFLD_PHONE1) + System.getProperty("line.separator"));
            }
            if (!StringTool.isNothing((Object)(thisAddressFLD_PHONE2 = this.get(FLD_PHONE2)))) {
                thisAddress.append(String.valueOf(thisAddressFLD_PHONE2) + System.getProperty("line.separator"));
            }
            if (!StringTool.isNothing((Object)(thisAddressFLD_MOBILEPHONE = this.get(FLD_MOBILEPHONE)))) {
                thisAddress.append("NatelNr: " + thisAddressFLD_MOBILEPHONE + System.getProperty("line.separator"));
            }
        }
        if (!StringTool.isNothing((Object)(thisAddressFLD_FAX = this.get(FLD_FAX)))) {
            thisAddress.append("Fax: " + thisAddressFLD_FAX + System.getProperty("line.separator"));
        }
        if (!StringTool.isNothing((Object)(thisAddressFLD_E_MAIL = this.get(FLD_E_MAIL)))) {
            thisAddress.append(String.valueOf(thisAddressFLD_E_MAIL) + System.getProperty("line.separator"));
        }
        String an = thisAddress.toString();
        an = an.replaceAll("[\\r\\n]\\n", "\n");
        return multiline ? an : an.replaceAll("\\n", " ");
    }

    public BezugsKontakt addBezugsKontakt(Kontakt adr, BezugsKontaktRelation bezugsKontaktRelation) {
        if (adr != null && bezugsKontaktRelation != null) {
            return new BezugsKontakt(this, adr, bezugsKontaktRelation);
        }
        return null;
    }

    @Deprecated
    public BezugsKontakt addBezugsKontakt(Kontakt adr, String sBezug) {
        if (adr != null && sBezug != null) {
            return new BezugsKontakt(this, adr, sBezug);
        }
        return null;
    }

    protected Kontakt(String id) {
        super(id);
    }

    public static Kontakt load(String id) {
        return new Kontakt(id);
    }

    protected Kontakt() {
    }

    public String getMailAddress() {
        return Kontakt.checkNull(this.get(FLD_E_MAIL));
    }

    public Reminder[] getRelatedReminders() {
        List<String> l = this.getList("MyReminders", false);
        Reminder[] ret = new Reminder[l.size()];
        int i = 0;
        for (String id : l) {
            ret[i++] = Reminder.load(id);
        }
        return ret;
    }

    @Override
    public boolean delete() {
        Reminder[] reminderArray = this.getRelatedReminders();
        int n = reminderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Reminder r = reminderArray[n2];
            r.delete();
            ++n2;
        }
        for (BezugsKontakt bk : this.getBezugsKontakte()) {
            bk.delete();
        }
        return super.delete();
    }

    @Deprecated
    public Object getInfoElement(String elem) {
        return this.getMap("ExtInfo").get(elem);
    }

    public String getInfoString(String elem) {
        return Kontakt.checkNull(this.getExtInfoStoredObjectByKey(elem));
    }

    @Deprecated
    public void setInfoElement(String elem, Object val) {
        Map extinfos = this.getMap("ExtInfo");
        if (extinfos != null) {
            extinfos.put(elem, val);
            this.setMap("ExtInfo", extinfos);
        }
    }

    @Deprecated
    public void flushInfoStore(Map store) {
        this.setMap("ExtInfo", store);
    }

    @Deprecated
    public static Kontakt findKontaktfromInfoStore(Class clazz, String field, String value) {
        Query qbe = new Query(clazz);
        List list = qbe.execute();
        for (Kontakt k : list) {
            String i = (String)k.getInfoElement(field);
            if (i == null || !i.equals(value)) continue;
            return k;
        }
        return null;
    }

    public List<String> getStatForItem(String typ) {
        Map exi = this.getMap("ExtInfo");
        ArrayList al = (ArrayList)exi.get(typ);
        ArrayList<String> ret = new ArrayList<String>(al == null ? 1 : al.size());
        if (al != null) {
            for (statL sl : al) {
                ret.add(sl.v);
            }
        }
        return ret;
    }

    public void statForItem(PersistentObject lst) {
        String typ = lst.getClass().getName();
        String ident = lst.storeToString();
        this.statForItem(typ, ident);
    }

    public void statForItem(ICodeElement lst) {
        if (lst instanceof PersistentObject) {
            String ident = String.valueOf(lst.getClass().getName()) + "::" + ((PersistentObject)lst).getId();
            this.statForItem(lst.getClass().getName(), ident);
        }
    }

    private void statForItem(String typ, String storeToString) {
        Map exi = this.getMap("ExtInfo");
        ArrayList<statL> l = (ArrayList<statL>)exi.get(typ);
        if (l == null) {
            l = new ArrayList<statL>();
        }
        while (l.size() > 40) {
            l.remove(l.size() - 1);
        }
        boolean found = false;
        for (statL c : l) {
            if (!c.v.equals(storeToString)) continue;
            ++c.c;
            found = true;
            break;
        }
        if (!found) {
            l.add(new statL(storeToString));
        }
        Collections.sort(l);
        exi.put(typ, l);
        this.setMap("ExtInfo", exi);
    }

    public void statForString(String typ, String toStat) {
        Map exi = this.getMap("ExtInfo");
        MFUList<String> l = (MFUList<String>)exi.get(typ);
        if (l == null) {
            l = new MFUList<String>(5, 15);
        }
        l.count(toStat);
        exi.put(typ, l);
        this.setMap("ExtInfo", exi);
    }

    public List<String> getStatForString(String typ) {
        Map exi = this.getMap("ExtInfo");
        MFUList al = (MFUList)exi.get(typ);
        if (al == null) {
            al = new MFUList(5, 15);
        }
        return al.getAll();
    }

    public MFUList<String> getMFU(String typ) {
        Map exi = this.getMap("ExtInfo");
        MFUList l = (MFUList)exi.get(typ);
        if (l == null) {
            l = new MFUList(5, 15);
        }
        return l;
    }

    public void setMFU(String typ, MFUList<String> mfu) {
        Map exi = this.getMap("ExtInfo");
        exi.put(typ, mfu);
        this.setMap("ExtInfo", exi);
    }

    public String getKuerzel() {
        return this.get(FLD_SHORT_LABEL);
    }

    public String getBemerkung() {
        return this.get(FLD_REMARK);
    }

    public void setBemerkung(String b) {
        this.set(FLD_REMARK, b);
    }

    public boolean istMandant() {
        return Kontakt.checkNull(this.get(FLD_IS_MANDATOR)).equals("1");
    }

    public boolean istPerson() {
        return Kontakt.checkNull(this.get(FLD_IS_PERSON)).equals("1");
    }

    public boolean istPatient() {
        return Kontakt.checkNull(this.get(FLD_IS_PATIENT)).equals("1");
    }

    public boolean istOrganisation() {
        return Kontakt.checkNull(this.get(FLD_IS_ORGANIZATION)).equals("1");
    }

    public boolean istAnwender() {
        return Kontakt.checkNull(this.get(FLD_IS_USER)).equals("1");
    }

    public IContact toIContact() {
        return (IContact)CoreModelServiceHolder.get().load(this.getId(), IContact.class).orElseThrow(() -> new IllegalStateException("Could not convert contact [" + this.getId() + "]"));
    }

    public static class statL
    implements Comparable<statL>,
    Serializable {
        private static final long serialVersionUID = 10455663346456L;
        public String v;
        public int c;

        public statL() {
        }

        public statL(String vv) {
            this.v = vv;
            this.c = 1;
        }

        @Override
        public int compareTo(statL ot) {
            return ot.c - this.c;
        }
    }
}

