/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.data.Mandant;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.elexis.data.Role;
import ch.elexis.data.User;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Anwender
extends Person {
    public static final String ADMINISTRATOR = "Administrator";
    public static final String FLD_LABEL = "Label";
    public static final String FLD_JOINT_REMINDERS = "Reminders";
    public static final String FLD_EXTINFO_MANDATORS = "Mandant";
    public static final String FLD_EXTINFO_STDMANDATOR = "StdMandant";

    static {
        Anwender.addMapping("KONTAKT", "ExtInfo", "istAnwender", "Label=Bezeichnung3", "Reminders=JOINT:ReminderID:ResponsibleID:REMINDERS_RESPONSIBLE_LINK");
    }

    public Anwender(String Username, String Password) {
        this(Username, Password, false);
    }

    public Anwender(String username, String password, boolean isExecutiveDoctor) {
        this.create(null);
        User user = new User(this, username, password);
        if (isExecutiveDoctor) {
            user.setAssignedRole(Role.load("medical-practitioner"), true);
        }
    }

    public Anwender(String Name, String Vorname, String Geburtsdatum, String s) {
        super(Name, Vorname, Geburtsdatum, s);
    }

    public static Anwender load(String id) {
        Anwender ret = new Anwender(id);
        if (ret.state() > 1) {
            return ret;
        }
        return null;
    }

    @Override
    public String getLabel(boolean shortLabel) {
        String l = this.get(FLD_LABEL);
        if (StringTool.isNothing((Object)l) && StringTool.isNothing((Object)(l = String.valueOf(Anwender.checkNull(this.get("Name"))) + " " + Anwender.checkNull(this.get("Vorname"))))) {
            l = "unbekannt";
        }
        return l;
    }

    public void setLabel(String label) {
        String oldlabel = this.getLabel();
        if (!label.equals(oldlabel)) {
            this.set(FLD_LABEL, label);
        }
    }

    public SortedSet<Reminder> getReminders() {
        TreeSet<Reminder> ret = new TreeSet<Reminder>();
        List<String[]> rem = this.getList(FLD_JOINT_REMINDERS, null);
        if (rem != null) {
            for (String[] l : rem) {
                ret.add(Reminder.load(l[0]));
            }
        }
        return ret;
    }

    @NonNull
    public List<Mandant> getExecutiveDoctorsWorkingFor() {
        List<Mandant> mandantenList = CoreHub.getMandantenList();
        String mandators = (String)this.getExtInfoStoredObjectByKey(FLD_EXTINFO_MANDATORS);
        if (mandators == null) {
            return Collections.emptyList();
        }
        List<String> man = Arrays.asList(mandators.split(","));
        return mandantenList.stream().filter(p -> man.contains(p.getLabel())).collect(Collectors.toList());
    }

    public void addOrRemoveExecutiveDoctorWorkingFor(Mandant m, boolean checked) {
        HashSet<Mandant> hashSet = new HashSet<Mandant>(this.getExecutiveDoctorsWorkingFor());
        if (checked) {
            hashSet.add(m);
        } else {
            hashSet.remove(m);
        }
        List edList = hashSet.stream().map((? super T p) -> p.getLabel()).collect(Collectors.toList());
        this.setExtInfoStoredObjectByKey(FLD_EXTINFO_MANDATORS, edList.isEmpty() ? "" : Anwender.ts(edList));
    }

    public void setStdExecutiveDoctorWorkingFor(Mandant m) {
        if (m == null) {
            this.setExtInfoStoredObjectByKey(FLD_EXTINFO_STDMANDATOR, null);
        } else {
            this.setExtInfoStoredObjectByKey(FLD_EXTINFO_STDMANDATOR, m.getLabel());
        }
    }

    public Mandant getStdExecutiveDoctorWorkingFor() {
        String stdMandator = (String)this.getExtInfoStoredObjectByKey(FLD_EXTINFO_STDMANDATOR);
        if (stdMandator != null && !stdMandator.isEmpty()) {
            List<Mandant> mandantenList = CoreHub.getMandantenList();
            for (Mandant mandant : mandantenList) {
                if (!mandant.getLabel().equals(stdMandator)) continue;
                return mandant;
            }
        }
        return null;
    }

    @Override
    protected String getConstraint() {
        return "istAnwender=" + JdbcLink.wrap((String)"1");
    }

    @Override
    protected void setConstraint() {
        this.set(new String[]{"istAnwender", "istPerson"}, "1", "1");
    }

    protected Anwender() {
    }

    protected Anwender(String id) {
        super(id);
    }

    protected static void initializeAdministratorUser() {
        new User();
        Anwender admin = new Anwender();
        admin.create(null);
        admin.set(new String[]{"Name", FLD_LABEL, "istAnwender"}, ADMINISTRATOR, ADMINISTRATOR, "1");
        AccessControlServiceHolder.get().doPrivileged(() -> {
            Optional user = CoreModelServiceHolder.get().load(ADMINISTRATOR, IUser.class);
            if (!user.isPresent()) {
                throw new IllegalStateException("Incorrect DB state - No admin user found!");
            }
            ((IUser)user.get()).setAssignedContact((IContact)CoreModelServiceHolder.get().load(admin.getId(), IContact.class).orElse(null));
        });
    }

    public static void logoff() {
        CoreHub.logoffAnwender();
    }

    public void setInitialMandator() {
        Mandant initialMandator = null;
        List<Mandant> workingFor = this.getExecutiveDoctorsWorkingFor();
        if (workingFor != null && !workingFor.isEmpty()) {
            Mandant stdWorkingFor = this.getStdExecutiveDoctorWorkingFor();
            initialMandator = workingFor.get(0);
            for (Mandant mandant : workingFor) {
                if (mandant.equals(this)) {
                    initialMandator = mandant;
                    break;
                }
                if (stdWorkingFor == null || !mandant.equals(stdWorkingFor)) continue;
                initialMandator = stdWorkingFor;
                break;
            }
        }
        if (initialMandator != null) {
            CoreHub.setMandant(initialMandator);
        } else {
            Mandant m = Mandant.load(CoreHub.getLoggedInContact().getId());
            if (m != null && m.isValid()) {
                CoreHub.setMandant(m);
            } else {
                List ml = new Query(Mandant.class).execute();
                if (ml != null && ml.size() > 0) {
                    m = (Mandant)ml.get(0);
                    CoreHub.setMandant(m);
                } else {
                    MessageEvent.fireError((String)"Kein Mandant definiert", (String)"Sie k\u00f6nnen Elexis erst normal benutzen, wenn Sie mindestens einen Mandanten definiert haben");
                }
            }
        }
    }

    public boolean isExecutiveDoctor() {
        Mandant m = Mandant.load(this.getId());
        return m.exists() && m.isValid();
    }

    public void setExecutiveDoctor(boolean value) {
        this.set("istMandant", Anwender.ts(value));
    }
}

