/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.PatFilterImpl;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.elexis.scripting.CSVWriter;
import ch.elexis.scripting.ScriptingException;
import ch.rgw.io.FileTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.FileDialog;

public class DocumentExport {
    Sticker sticker = null;
    PatFilterImpl pf = new PatFilterImpl();

    public String doExport(String destination, String stickerName) {
        IDocumentManager mgr;
        if (stickerName != null) {
            List ls = new Query(Sticker.class, "Name", stickerName).execute();
            if (ls != null && ls.size() > 0) {
                this.sticker = (Sticker)ls.get(0);
            } else {
                return "Sticker " + stickerName + " nicht gefunden.";
            }
        }
        if ((mgr = (IDocumentManager)Extensions.findBestService((String)"DocumentManagement", null)) == null) {
            return "Keine Dokumente gefunden";
        }
        try {
            if (destination == null) {
                FileDialog fd = new FileDialog(UiDesk.getTopShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.csv"});
                fd.setFilterNames(new String[]{"Comma Separated Values (CVS)"});
                fd.setOverwrite(true);
                destination = fd.open();
            }
            if (destination != null) {
                File csv = new File(destination);
                File parent = csv.getParentFile();
                File dir = new File(parent, FileTool.getNakedFilename((String)destination));
                dir.mkdirs();
                CSVWriter writer = new CSVWriter(new FileWriter(csv));
                String[] header = new String[]{"Patient", "Name", "Kategorie", "Datum", "Stichw\u00f6rter", "Pfad"};
                List dox = mgr.listDocuments(null, null, null, null, null, null);
                writer.writeNext(header);
                for (IOpaqueDocument doc : dox) {
                    String subdirname;
                    Patient pat = doc.getPatient();
                    if (pat == null || this.sticker != null && this.pf.accept(pat, (PersistentObject)this.sticker) != 1 || (subdirname = pat.get("PatientNr")) == null) continue;
                    File subdir = new File(dir, subdirname);
                    subdir.mkdirs();
                    String[] line = new String[header.length];
                    line[0] = pat.getId();
                    line[1] = doc.getTitle();
                    line[2] = doc.getCategory();
                    line[3] = doc.getCreationDate();
                    line[4] = doc.getKeywords();
                    String docfilename = String.valueOf(doc.getGUID()) + "." + doc.getMimeType();
                    line[5] = String.valueOf(dir.getName()) + File.separator + subdir.getName() + File.separator + docfilename;
                    byte[] bin = doc.getContentsAsBytes();
                    if (bin == null) continue;
                    File f = new File(subdir, docfilename);
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(bin);
                    fos.close();
                    writer.writeNext(line);
                }
                return "Export ok";
            }
            return "Abgebrochen.";
        }
        catch (Exception e) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, "Fehler beim Export: " + e.getMessage(), e);
            throw new ScriptingException((IStatus)status);
        }
    }
}

