/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.dialogs.ResultDialog;
import ch.elexis.core.ui.dialogs.StatusDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockDeniedNoActionLockHandler;
import ch.elexis.core.ui.util.CoreCommandUiUtil;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.controls.InteractionLink;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerrechnungsDisplay
extends Composite
implements IUnlockable {
    private Text billedLabel;
    private InteractionLink interactionLink;
    private Table table;
    private TableViewer viewer;
    private MenuManager contextMenuManager;
    private IEncounter actEncounter;
    private String defaultRGB;
    private IWorkbenchPage page;
    private final GenericObjectDropTarget dropTarget;
    private IAction applyMedicationAction;
    private IAction chPriceAction;
    private IAction chCountAction;
    private IAction chTextAction;
    private IAction removeAction;
    private IAction removeAllAction;
    private TableColumnLayout tableLayout;
    private static final String INDICATED_MEDICATION = Messages.VerrechnungsDisplay_indicatedMedication;
    private static final String APPLY_MEDICATION = Messages.VerrechnungsDisplay_applyMedication;
    private static final String CHPRICE = Messages.VerrechnungsDisplay_changePrice;
    private static final String CHCOUNT = Messages.Core_Change_Number;
    private static final String REMOVE = Messages.VerrechnungsDisplay_removeElements;
    private static final String CHTEXT = Messages.VerrechnungsDisplay_changeText;
    private static final String REMOVEALL = Messages.VerrechnungsDisplay_removeAll;
    static Logger logger = LoggerFactory.getLogger(VerrechnungsDisplay.class);
    private ToolBarManager toolBarManager;
    private TableViewerColumn partDisposalColumn;

    @Optional
    @Inject
    public void udpateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (encounter != null && encounter.equals(this.actEncounter) && this.isViewerCreated()) {
            this.setEncounter(this.actEncounter);
        }
    }

    @Optional
    @Inject
    public void udpateBilled(@UIEventTopic(value="info/elexis/model/update") IBilled billed) {
        if (billed != null && this.isViewerCreated()) {
            this.viewer.update((Object)billed, null);
        }
    }

    public VerrechnungsDisplay(IWorkbenchPage p, Composite parent, int style) {
        super(parent, style);
        int columns_for_each_drug = 4;
        this.setLayout((Layout)new GridLayout(4, false));
        this.page = p;
        this.defaultRGB = UiDesk.createColor(new RGB(255, 255, 255));
        Label label = new Label((Composite)this, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        label.setFont(boldFont);
        label.setText(Messages.Invoice_amount_billed);
        this.billedLabel = new Text((Composite)this, 64);
        this.billedLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.interactionLink = new InteractionLink(this, 0);
        this.interactionLink.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.toolBarManager = new ToolBarManager(131072);
        Action newAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                try {
                    if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                        SWTHelper.alert(Messages.Core_Error, "LeistungenView.ID");
                    }
                    VerrechnungsDisplay.this.page.showView("ch.elexis.LeistungenView");
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget(VerrechnungsDisplay.this.dropTarget);
                }
                catch (Exception ex) {
                    ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, String.valueOf(Messages.VerrechnungsDisplay_errorStartingCodeWindow) + ex.getMessage(), ex, 2);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }

            public boolean isEnabled() {
                return VerrechnungsDisplay.this.actEncounter != null && VerrechnungsDisplay.this.actEncounter.isBillable();
            }
        };
        newAction.setToolTipText(Messages.VerrechnungsDisplay_AddItem);
        this.toolBarManager.add((IAction)newAction);
        this.toolBarManager.add((IAction)new Action("", 2){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NOBILLING.getImageDescriptor();
            }

            public String getText() {
                return Messages.VerrechnungsDisplay_no_invoice;
            }

            public void run() {
                VerrechnungsDisplay.this.actEncounter.setBillable(!VerrechnungsDisplay.this.actEncounter.isBillable());
                CoreModelServiceHolder.get().save((Identifiable)VerrechnungsDisplay.this.actEncounter);
                VerrechnungsDisplay.this.updateUi();
            }

            public boolean isChecked() {
                if (VerrechnungsDisplay.this.actEncounter != null) {
                    return !VerrechnungsDisplay.this.actEncounter.isBillable();
                }
                return false;
            }

            public boolean isEnabled() {
                return VerrechnungsDisplay.this.actEncounter != null && !this.isBilled(VerrechnungsDisplay.this.actEncounter);
            }

            private boolean isBilled(IEncounter encounter) {
                if (encounter != null) {
                    return encounter.getInvoice() != null;
                }
                return false;
            }
        });
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.toolBarManager, "toolbar:ch.elexis.VerrechnungsDisplay");
        ToolBar toolBar = this.toolBarManager.createControl((Composite)this);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.makeActions();
        this.tableLayout = new TableColumnLayout();
        Composite tableComposite = new Composite((Composite)this, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        tableComposite.setLayout((Layout)this.tableLayout);
        this.viewer = new TableViewer(tableComposite, 68354);
        this.table = this.viewer.getTable();
        this.table.setMenu(this.createVerrMenu());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createColumns();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IBilled) {
                    ContextServiceHolder.get().getRootContext().setTyped(selection.getFirstElement());
                    CoreUiUtil.setCommandSelection((String)"ch.elexis.VerrechnungsDisplay", (List)selection.toList());
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && VerrechnungsDisplay.this.table.getSelectionIndices().length >= 1 && VerrechnungsDisplay.this.removeAction != null) {
                    VerrechnungsDisplay.this.removeAction.run();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int clickedIndex = -1;
                int width = 0;
                TableColumn[] columns = VerrechnungsDisplay.this.table.getColumns();
                int i = 0;
                while (i < columns.length) {
                    TableColumn tc = columns[i];
                    if (width < e.x && e.x < width + tc.getWidth()) {
                        clickedIndex = i;
                        break;
                    }
                    width += tc.getWidth();
                    ++i;
                }
                if (clickedIndex != -1) {
                    if (clickedIndex == 1) {
                        VerrechnungsDisplay.this.chCountAction.run();
                    } else if (clickedIndex == 4) {
                        VerrechnungsDisplay.this.chPriceAction.run();
                    } else if (clickedIndex == 5) {
                        VerrechnungsDisplay.this.removeAction.run();
                    }
                }
            }
        });
        this.dropTarget = new GenericObjectDropTarget(Messages.VerrechnungsDisplay_doBill, (Control)this.table, new DropReceiver()){

            @Override
            protected Control getHighLightControl() {
                return VerrechnungsDisplay.this;
            }
        };
    }

    private void createColumns() {
        String[] titles = new String[]{"", Messages.Display_Column_Number, Messages.Core_Code, Messages.Core_Description, Messages.Core_Price, ""};
        int[] nArray = new int[6];
        nArray[1] = 8;
        nArray[2] = 20;
        nArray[3] = 50;
        nArray[4] = 15;
        nArray[5] = 7;
        int[] weights = nArray;
        this.partDisposalColumn = this.createTableViewerColumn(titles[0], weights[0], 0, 16384);
        this.partDisposalColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                IBilled billed;
                if (element instanceof IBilled && VerrechnungsDisplay.this.isPartDisposal(billed = (IBilled)element)) {
                    return Images.IMG_BLOCKS_SMALL.getImage();
                }
                return super.getImage(element);
            }
        });
        TableViewerColumn col = this.createTableViewerColumn(titles[1], weights[1], 1, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    return Double.toString(billed.getAmount());
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[2], weights[2], 2, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    return VerrechnungsDisplay.this.getServiceCode(billed);
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[3], weights[3], 3, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    return billed.getText();
                }
                return "";
            }

            public Color getBackground(Object element) {
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    return VerrechnungsDisplay.this.getBackgroundColor(billed);
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(titles[4], weights[4], 4, 131072);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    Money price = billed.getTotal();
                    return price.getAmountAsString();
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[5], weights[5], 5, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return Images.IMG_DELETE.getImage();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, int colNumber, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        this.tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private Color getBackgroundColor(IBilled billed) {
        IBillable billable = billed.getBillable();
        if (billable != null) {
            Color color = UiDesk.getColorFromRGB(this.defaultRGB);
            String codeName = billable.getCodeSystemName();
            if (codeName != null) {
                String rgbColor = ConfigServiceHolder.getGlobal((String)("billing/color/" + codeName), (String)this.defaultRGB);
                color = UiDesk.getColorFromRGB(rgbColor);
            }
            return color;
        }
        return null;
    }

    public void clear() {
        this.actEncounter = null;
        this.setEncounter(this.actEncounter);
    }

    private boolean isViewerCreated() {
        return this.viewer != null && this.viewer.getTable() != null && !this.viewer.getTable().isDisposed();
    }

    private void updateBilledLabel() {
        ArrayList<IArticle> gtins = new ArrayList<IArticle>();
        if (this.actEncounter != null) {
            int sumMinutes = 0;
            Money sum = new Money(0);
            for (IBilled billed : this.actEncounter.getBilled()) {
                Money preis = billed.getTotal();
                sum.addMoney(preis);
                IBillable billable = billed.getBillable();
                if (billable instanceof IService) {
                    sumMinutes = (int)((double)sumMinutes + (double)((IService)billable).getMinutes() * billed.getAmount());
                }
                if (!(billable instanceof IArticle)) continue;
                IArticle art = (IArticle)billable;
                gtins.add(art);
            }
            this.interactionLink.updateAtcs(gtins);
            this.billedLabel.setText(String.format("%s %s / %s %s", Messages.Core_Amount, sum.getAmountAsString(), Messages.Core_Time, sumMinutes));
        } else {
            this.billedLabel.setText("");
        }
        this.layout();
    }

    @Deprecated
    public void addPersistentObject(PersistentObject o) {
        if (this.actEncounter != null) {
            if (o instanceof Leistungsblock) {
                Leistungsblock block = (Leistungsblock)o;
                List elements = block.getElements();
                for (ICodeElement element : elements) {
                    if (!(element instanceof PersistentObject)) continue;
                    this.addPersistentObject((PersistentObject)element);
                }
                List diff = block.getDiffToReferences(elements);
                if (!diff.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    diff.forEach(r -> {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(r);
                    });
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
                }
            }
            if (o instanceof Prescription) {
                Prescription presc = (Prescription)o;
                o = presc.getArtikel();
            }
            if (o instanceof IVerrechenbar) {
                if (!AccessControlServiceHolder.get().evaluate(EvACEs.LSTG_VERRECHNEN)) {
                    SWTHelper.alert(Messages.Core_Missing_rights, Messages.VerrechnungsDisplay_missingRightsBody);
                } else {
                    Result result = Konsultation.load((String)this.actEncounter.getId()).addLeistung((IVerrechenbar)o);
                    if (!result.isOK()) {
                        SWTHelper.alert(Messages.VerrechnungsDisplay_imvalidBilling, result.toString());
                    }
                }
            } else if (o instanceof IDiagnose) {
                Konsultation.load((String)this.actEncounter.getId()).addDiagnose((IDiagnose)o);
            }
            this.actEncounter.getBilled().forEach(b -> CoreModelServiceHolder.get().refresh((Identifiable)b));
            this.setEncounter(this.actEncounter);
        }
    }

    private void updatePartDisposalColumn(List<IBilled> list) {
        boolean hasDisposal = false;
        for (IBilled billed : list) {
            if (!this.isPartDisposal(billed)) continue;
            hasDisposal = true;
            break;
        }
        if (hasDisposal) {
            this.partDisposalColumn.getColumn().setWidth(18);
        } else {
            this.partDisposalColumn.getColumn().setWidth(0);
        }
    }

    private boolean isPartDisposal(IBilled billed) {
        IArticle a;
        int abgabeEinheit;
        IBillable billable = billed.getBillable();
        return billable instanceof IArticle && (abgabeEinheit = (a = (IArticle)billable).getSellingSize()) > 0 && abgabeEinheit < a.getPackageSize();
    }

    public void setEncounter(IEncounter encounter) {
        CoreUiUtil.removeCommandSelection((String)"ch.elexis.VerrechnungsDisplay");
        this.actEncounter = encounter;
        if (this.actEncounter != null) {
            this.viewer.setInput((Object)this.actEncounter.getBilled());
            this.updatePartDisposalColumn(this.actEncounter.getBilled());
            this.updateBilledLabel();
            this.updateUi();
        } else {
            this.viewer.setInput(Collections.emptyList());
            this.updateBilledLabel();
            this.updateUi();
        }
    }

    private void updateUi() {
        if (this.toolBarManager != null) {
            IContributionItem[] iContributionItemArray = this.toolBarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem contribution = iContributionItemArray[n2];
                contribution.update();
                ++n2;
            }
            this.toolBarManager.update(true);
        }
        this.viewer.getTable().setEnabled(this.actEncounter != null && this.actEncounter.isBillable());
    }

    private String getServiceCode(IBilled billed) {
        String ret = billed.getCode();
        IBillable billable = billed.getBillable();
        if (billable != null && (billable instanceof ICustomService || billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL) && billable.getId().equals(ret)) {
            ret = "";
        }
        return ret;
    }

    private Menu createVerrMenu() {
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                if (selection.size() > 1) {
                    manager.add(VerrechnungsDisplay.this.removeAction);
                } else {
                    if (!selection.isEmpty()) {
                        final IBilled billed = (IBilled)selection.getFirstElement();
                        IBillable billable = billed.getBillable();
                        manager.add(VerrechnungsDisplay.this.chPriceAction);
                        manager.add(VerrechnungsDisplay.this.chCountAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add(VerrechnungsDisplay.this.chTextAction);
                        manager.add(VerrechnungsDisplay.this.removeAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add(VerrechnungsDisplay.this.removeAllAction);
                        if (billable instanceof IArticle) {
                            manager.add((IContributionItem)new Separator());
                            manager.add(VerrechnungsDisplay.this.applyMedicationAction);
                            manager.add((IAction)new Action(INDICATED_MEDICATION, 2){

                                public void run() {
                                    IStructuredSelection selection = (this).VerrechnungsDisplay.this.viewer.getStructuredSelection();
                                    for (Object selected : selection.toList()) {
                                        if (!(selected instanceof IBilled)) continue;
                                        final IBilled billed2 = (IBilled)selected;
                                        AcquireLockUi.aquireAndRun((Identifiable)billed2, (ILockHandler)new LockDeniedNoActionLockHandler(){

                                            @Override
                                            public void lockAcquired() {
                                                if (this.isIndicated(billed2)) {
                                                    billed2.setExtInfo((Object)"indicated", (Object)"false");
                                                } else {
                                                    billed2.setExtInfo((Object)"indicated", (Object)"true");
                                                }
                                                CoreModelServiceHolder.get().save((Identifiable)billed2);
                                            }
                                        });
                                    }
                                }

                                private boolean isIndicated(IBilled billed2) {
                                    String value = (String)billed2.getExtInfo((Object)"indicated");
                                    return "true".equalsIgnoreCase(value);
                                }

                                public boolean isChecked() {
                                    return this.isIndicated(billed);
                                }
                            });
                        }
                    }
                    CoreCommandUiUtil.addCommandContributions((IMenuManager)VerrechnungsDisplay.this.contextMenuManager, selection.toArray(), "popup:ch.elexis.VerrechnungsDisplay");
                }
            }
        });
        return this.contextMenuManager.createContextMenu((Control)this.table);
    }

    private void makeActions() {
        this.applyMedicationAction = new Action(APPLY_MEDICATION){

            public void run() {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof IBilled)) continue;
                    final IBilled billed = (IBilled)selected;
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Prescription prescription;
                            billed.setExtInfo((Object)"vat_scale", (Object)Double.toString(0.0));
                            int packageSize = ((IArticle)billed.getBillable()).getPackageSize();
                            String proposal = packageSize > 0 ? "1/" + packageSize : "1";
                            VerrechnungsDisplay.this.changeQuantityDialog(proposal, billed);
                            Object prescriptionId = billed.getExtInfo((Object)"prescriptionId");
                            if (prescriptionId instanceof String && (prescription = Prescription.load((String)((String)prescriptionId))).getEntryType() == EntryType.SELF_DISPENSED) {
                                prescription.setApplied(Boolean.valueOf(true));
                            }
                        }
                    });
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_SYRINGE.getImageDescriptor();
            }
        };
        this.removeAction = new Action(REMOVE){

            public void run() {
                Result editable = BillingServiceHolder.get().isEditable(VerrechnungsDisplay.this.actEncounter);
                if (!editable.isOK()) {
                    ResultDialog.show(editable);
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof IBilled)) continue;
                    final IBilled billed = (IBilled)selected;
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            BillingServiceHolder.get().removeBilled(billed, (this).VerrechnungsDisplay.this.actEncounter);
                        }
                    });
                }
                VerrechnungsDisplay.this.setEncounter(VerrechnungsDisplay.this.actEncounter);
            }
        };
        this.removeAllAction = new Action(REMOVEALL){

            public void run() {
                Result editable = BillingServiceHolder.get().isEditable(VerrechnungsDisplay.this.actEncounter);
                if (!editable.isOK()) {
                    ResultDialog.show(editable);
                    return;
                }
                List allBilled = VerrechnungsDisplay.this.actEncounter.getBilled();
                for (final IBilled billed : allBilled) {
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            (this).VerrechnungsDisplay.this.actEncounter.removeBilled(billed);
                        }
                    });
                }
                VerrechnungsDisplay.this.setEncounter(VerrechnungsDisplay.this.actEncounter);
            }
        };
        this.chPriceAction = new Action(CHPRICE){

            public void run() {
                Result editable = BillingServiceHolder.get().isEditable(VerrechnungsDisplay.this.actEncounter);
                if (!editable.isOK()) {
                    ResultDialog.show(editable);
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof IBilled)) continue;
                    final IBilled billed = (IBilled)selected;
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Money oldPrice = billed.getPrice();
                            String p = oldPrice.getAmountAsString();
                            InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changePriceForService, Messages.VerrechnungsDisplay_enterNewPrice, p, null);
                            if (dlg.open() == 0) {
                                try {
                                    String val = dlg.getValue().trim();
                                    Money newPrice = null;
                                    if (val.endsWith("%") && val.length() > 1) {
                                        val = val.substring(0, val.length() - 1);
                                        double percent = Double.parseDouble(val);
                                        double factor = 1.0 + percent / 100.0;
                                        newPrice = billed.getPrice().multiply(factor);
                                    } else {
                                        newPrice = new Money(val);
                                    }
                                    if (newPrice != null) {
                                        billed.setPrice(newPrice);
                                        CoreModelServiceHolder.get().save((Identifiable)billed);
                                        (this).VerrechnungsDisplay.this.viewer.update((Object)billed, null);
                                    }
                                }
                                catch (ParseException ex) {
                                    SWTHelper.showError(Messages.VerrechnungsDisplay_badAmountCaption, Messages.VerrechnungsDisplay_badAmountBody);
                                }
                            }
                        }
                    });
                }
                VerrechnungsDisplay.this.updateBilledLabel();
            }
        };
        this.chCountAction = new Action(CHCOUNT){

            public void run() {
                Result editable = BillingServiceHolder.get().isEditable(VerrechnungsDisplay.this.actEncounter);
                if (!editable.isOK()) {
                    ResultDialog.show(editable);
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof IBilled)) continue;
                    final IBilled billed = (IBilled)selected;
                    final String p = Double.toString(billed.getAmount());
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            VerrechnungsDisplay.this.changeQuantityDialog(p, billed);
                        }
                    });
                }
                VerrechnungsDisplay.this.updateBilledLabel();
            }
        };
        this.chTextAction = new Action(CHTEXT){

            public void run() {
                Result editable = BillingServiceHolder.get().isEditable(VerrechnungsDisplay.this.actEncounter);
                if (!editable.isOK()) {
                    ResultDialog.show(editable);
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof IBilled)) continue;
                    final IBilled billed = (IBilled)selected;
                    AcquireLockUi.aquireAndRun((Identifiable)billed, (ILockHandler)new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            String oldText = billed.getText();
                            InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changeTextCaption, Messages.VerrechnungsDisplay_changeTextBody, oldText, null);
                            if (dlg.open() == 0) {
                                String input = dlg.getValue();
                                if (input.matches("[0-9\\.,]+") && !SWTHelper.askYesNo(Messages.VerrechnungsDisplay_confirmChangeTextCaption, Messages.VerrechnungsDisplay_confirmChangeTextBody)) {
                                    return;
                                }
                                billed.setText(input);
                                CoreModelServiceHolder.get().save((Identifiable)billed);
                                (this).VerrechnungsDisplay.this.viewer.update((Object)billed, null);
                            }
                        }
                    });
                }
            }
        };
    }

    private void changeQuantityDialog(String p, IBilled billed) {
        InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changeNumberCaption, Messages.VerrechnungsDisplay_changeNumberBody, p, null);
        if (dlg.open() == 0) {
            try {
                String val = dlg.getValue();
                if (!StringTool.isNothing((Object)val)) {
                    double changeAnzahl;
                    IBillable billable = billed.getBillable();
                    String text = billable.getText();
                    if (val.indexOf("/") > 0) {
                        String[] frac = val.split("/");
                        changeAnzahl = Double.parseDouble(frac[0]) / Double.parseDouble(frac[1]);
                        text = String.valueOf(billed.getText()) + " (" + val + Messages.VerrechnungsDisplay_Orininalpackungen;
                    } else {
                        changeAnzahl = val.indexOf(46) > 0 ? Double.parseDouble(val) : (double)Integer.parseInt(dlg.getValue());
                    }
                    IStatus status = BillingServiceHolder.get().changeAmountValidated(billed, changeAnzahl);
                    if (!status.isOK()) {
                        StatusDialog.show(status);
                    }
                    CoreModelServiceHolder.get().refresh((Identifiable)billed);
                    billed.setText(text);
                    CoreModelServiceHolder.get().save((Identifiable)billed);
                    this.viewer.update((Object)billed, null);
                }
            }
            catch (NumberFormatException ne) {
                SWTHelper.showError(Messages.VerrechnungsDisplay_invalidEntryCaption, Messages.VerrechnungsDisplay_invalidEntryBody);
            }
        }
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.setEnabled(unlocked);
        this.redraw();
    }

    public MenuManager getMenuManager() {
        return this.contextMenuManager;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void adaptMenus() {
        if (CoreUiUtil.isActiveControl((Control)this.table)) {
            this.table.getMenu().setEnabled(AccessControlServiceHolder.get().evaluate(EvACEs.LSTG_VERRECHNEN));
        }
    }

    private final class DropReceiver
    implements GenericObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        public boolean accept(PersistentObject o) {
            if (ElexisEventDispatcher.getSelectedPatient() != null) {
                if (o instanceof Artikel) {
                    return !((Artikel)o).isProduct();
                }
                if (o instanceof IVerrechenbar) {
                    return true;
                }
                if (o instanceof IDiagnose) {
                    return true;
                }
                if (o instanceof Leistungsblock) {
                    return true;
                }
                if (o instanceof Prescription) {
                    Prescription p = (Prescription)o;
                    return p.getArtikel() != null && !p.getArtikel().isProduct();
                }
            }
            return false;
        }

        private boolean accept(ch.elexis.core.model.ICodeElement codeElement) {
            if (codeElement instanceof IArticle) {
                return !((IArticle)codeElement).isProduct();
            }
            if (codeElement instanceof IService) {
                return true;
            }
            if (codeElement instanceof IDiagnosis) {
                return true;
            }
            if (codeElement instanceof ICodeElementBlock) {
                return true;
            }
            return codeElement instanceof IBillable;
        }

        @Override
        public void dropped(List<Object> list, DropTargetEvent e) {
            if (VerrechnungsDisplay.this.actEncounter != null && this.accept(list)) {
                for (Object object : list) {
                    if (object instanceof IPrescription) {
                        object = ((IPrescription)object).getArticle();
                    }
                    if (object instanceof PersistentObject) {
                        VerrechnungsDisplay.this.addPersistentObject((PersistentObject)object);
                        continue;
                    }
                    if (object instanceof IBillable) {
                        IBillable billable = (IBillable)object;
                        Result billResult = BillingServiceHolder.get().bill(billable, VerrechnungsDisplay.this.actEncounter, 1.0);
                        if (!billResult.isOK()) {
                            ResultDialog.show(billResult);
                            continue;
                        }
                        CoreModelServiceHolder.get().refresh((Identifiable)VerrechnungsDisplay.this.actEncounter, true);
                        continue;
                    }
                    if (object instanceof ICodeElementBlock) {
                        ICodeElementBlock block = (ICodeElementBlock)object;
                        List elements = block.getElements();
                        StringJoiner notOkResults = new StringJoiner("\n");
                        for (ch.elexis.core.model.ICodeElement element : elements) {
                            if (element instanceof IBillable) {
                                Result billResult = BillingServiceHolder.get().bill((IBillable)element, VerrechnungsDisplay.this.actEncounter, 1.0);
                                if (billResult.isOK()) continue;
                                String message = String.valueOf(element.getCode()) + " - " + ResultDialog.getResultMessage(billResult);
                                if (notOkResults.toString().contains(message)) continue;
                                notOkResults.add(message);
                                continue;
                            }
                            if (!(element instanceof IDiagnosis)) continue;
                            VerrechnungsDisplay.this.actEncounter.addDiagnosis((IDiagnosis)element);
                            CoreModelServiceHolder.get().save((Identifiable)VerrechnungsDisplay.this.actEncounter);
                        }
                        if (!notOkResults.toString().isEmpty()) {
                            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)VerrechnungsDisplay.this.getShell(), (String)Messages.Core_Warning, (String)notOkResults.toString()));
                        }
                        CoreModelServiceHolder.get().refresh((Identifiable)VerrechnungsDisplay.this.actEncounter, true);
                        List diff = block.getDiffToReferences(elements);
                        if (diff.isEmpty()) continue;
                        StringBuilder sb = new StringBuilder();
                        diff.forEach(r -> {
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(r);
                        });
                        MessageDialog.openWarning((Shell)VerrechnungsDisplay.this.getShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
                        continue;
                    }
                    if (!(object instanceof IDiagnosis)) continue;
                    VerrechnungsDisplay.this.actEncounter.addDiagnosis((IDiagnosis)object);
                    CoreModelServiceHolder.get().save((Identifiable)VerrechnungsDisplay.this.actEncounter);
                }
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)VerrechnungsDisplay.this.actEncounter);
            }
        }

        @Override
        public boolean accept(List<Object> list) {
            for (Object object : list) {
                if (object instanceof PersistentObject) {
                    if (this.accept((PersistentObject)object)) continue;
                    return false;
                }
                if (!(object instanceof ch.elexis.core.model.ICodeElement)) continue;
                return this.accept((ch.elexis.core.model.ICodeElement)object);
            }
            return true;
        }
    }
}

