/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SearchView
extends ViewPart {
    public static final String ID = "ch.elexis.views.SearchView";
    TableViewer viewer;
    TabFolder tabFolder;
    TabItem mainTabItem;
    Text mainSearchText;
    Button searchButton;
    Button mainCaseCheckbox;
    Button consultationRadio;
    Button consultationTextRadio;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        this.tabFolder = new TabFolder(main, 0);
        this.tabFolder.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.mainTabItem = new TabItem(this.tabFolder, 0);
        this.mainTabItem.setText(Messages.Core_Common);
        Composite mainSearchArea = new Composite((Composite)this.tabFolder, 0);
        this.mainTabItem.setControl((Control)mainSearchArea);
        mainSearchArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        mainSearchArea.setLayout((Layout)new GridLayout(1, false));
        Composite mainInputArea = new Composite(mainSearchArea, 0);
        mainInputArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        mainInputArea.setLayout((Layout)new GridLayout(2, false));
        Label searchTextLabel = new Label(mainInputArea, 0);
        searchTextLabel.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        searchTextLabel.setText(Messages.SearchView_textToSearch);
        this.mainSearchText = new Text(mainInputArea, 2048);
        this.mainSearchText.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.mainCaseCheckbox = new Button(mainInputArea, 32);
        this.mainCaseCheckbox.setText(Messages.SearchView_honorCase);
        Composite mainOptionsArea = new Composite(mainSearchArea, 0);
        mainOptionsArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        mainOptionsArea.setLayout((Layout)new GridLayout(2, true));
        Group typeGroup = new Group(mainOptionsArea, 8);
        typeGroup.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        typeGroup.setLayout((Layout)new RowLayout());
        typeGroup.setText(Messages.SearchView_dosearch);
        this.consultationRadio = new Button((Composite)typeGroup, 16);
        this.consultationRadio.setText(Messages.Core_Consultations);
        this.consultationRadio.setSelection(true);
        Group optionsGroup = new Group(mainOptionsArea, 8);
        optionsGroup.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        optionsGroup.setLayout((Layout)new RowLayout());
        optionsGroup.setText(Messages.SearchView_limitTo);
        this.consultationTextRadio = new Button((Composite)optionsGroup, 16);
        this.consultationTextRadio.setText(Messages.SearchView_entry);
        this.consultationTextRadio.setSelection(true);
        this.searchButton = new Button(mainSearchArea, 8);
        this.searchButton.setText(Messages.Core_DoSearch);
        GridData gd = SWTHelper.getFillGridData(1, true, 1, false);
        gd.horizontalAlignment = 3;
        this.searchButton.setLayoutData((Object)gd);
        this.searchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer = new TableViewer(main);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SearchView.this.mainSearch();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PersistentObject) {
                    PersistentObject po = (PersistentObject)element;
                    String type = "?";
                    String label = "";
                    if (po instanceof Konsultation) {
                        type = Messages.Core_Consultation;
                        Konsultation konsultation = (Konsultation)po;
                        Fall fall = konsultation.getFall();
                        Patient pat = fall.getPatient();
                        label = String.valueOf(pat.getLabel()) + " - " + fall.getLabel() + " - " + konsultation.getLabel();
                    } else {
                        label = po.getLabel();
                    }
                    return String.valueOf(type) + " - " + label;
                }
                return super.getText(element);
            }
        });
        this.viewer.setInput((Object)this.getSite());
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private Object[] mainSearch() {
        String searchString = this.mainSearchText.getText();
        if (!StringTool.isNothing((Object)searchString)) {
            return this.searchForKonsultationText(searchString).toArray();
        }
        return new Object[0];
    }

    private List<Konsultation> searchForKonsultationText(String searchString) {
        ArrayList<Konsultation> result = new ArrayList<Konsultation>();
        boolean considerCases = this.mainCaseCheckbox.getSelection();
        if (!considerCases) {
            searchString = searchString.toLowerCase();
        }
        Query query = new Query(Konsultation.class);
        query.orderBy(false, new String[]{Messages.Core_Date});
        List konsultationen = query.execute();
        if (konsultationen != null) {
            for (Konsultation konsultation : konsultationen) {
                String eintrag = konsultation.getEintrag().getHead();
                if (eintrag == null) continue;
                if (!considerCases) {
                    eintrag = eintrag.toLowerCase();
                }
                if (!eintrag.contains(searchString)) continue;
                result.add(konsultation);
            }
        }
        return result;
    }
}

