/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Script;
import ch.elexis.scripting.ScriptEditor;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ScriptView
extends ViewPart {
    public static final String ID = "ch.elexis.scriptsView";
    private IAction newScriptAction;
    private IAction editScriptAction;
    private IAction removeScriptAction;
    private IAction execScriptAction;
    private IAction exportScriptAction;
    private IAction importScriptAction;
    TableViewer tv;
    ScrolledForm form;

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.form.getBody().setLayout((Layout)new FillLayout());
        this.tv = new TableViewer(this.form.getBody(), 65540);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                SortedList sortedScripts = new SortedList((Comparator)new ScriptComparator());
                List scripts = Script.getScripts();
                int i = 0;
                while (i < scripts.size()) {
                    Script script = (Script)scripts.get(i);
                    sortedScripts.add((Object)script);
                    ++i;
                }
                return sortedScripts.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Script) {
                    return ((Script)element).getLabel();
                }
                return element.toString();
            }
        });
        new PersistentObjectDragSource((StructuredViewer)this.tv);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(this.newScriptAction);
        menu.createViewerContextMenu((StructuredViewer)this.tv, this.editScriptAction, this.execScriptAction, null, this.exportScriptAction, this.removeScriptAction);
        menu.createMenu(this.importScriptAction, this.newScriptAction);
        this.tv.setInput((Object)this);
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.exportScriptAction = new Action("export script"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("export script into a text file");
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)ScriptView.this.tv.getSelection();
                if (sel != null && sel.size() != 0) {
                    FileDialog fd = new FileDialog(ScriptView.this.getViewSite().getShell(), 8192);
                    Script script = (Script)sel.getFirstElement();
                    fd.setFileName(script.getLabel());
                    String filename = fd.open();
                    if (filename != null) {
                        try {
                            File file = new File(filename);
                            FileWriter fw = new FileWriter(file);
                            fw.write(script.getString());
                            fw.close();
                        }
                        catch (IOException ex) {
                            SWTHelper.showError("IO Error", "Could not write file " + filename + " : " + ex.getMessage());
                        }
                    }
                }
            }
        };
        this.importScriptAction = new RestrictedAction((EvaluatableACE)EvACE.of(Script.class, (Right)Right.UPDATE), "Import Script"){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText("Import script from a text file");
            }

            @Override
            public void doRun() {
                FileDialog fd = new FileDialog(ScriptView.this.getViewSite().getShell(), 4096);
                String filename = fd.open();
                if (fd != null) {
                    try {
                        Script.importFromFile((String)filename);
                        ScriptView.this.tv.refresh();
                    }
                    catch (ElexisException e) {
                        SWTHelper.showError("IO Error", e.getMessage());
                    }
                }
            }
        };
        this.newScriptAction = new RestrictedAction((EvaluatableACE)EvACE.of(Script.class, (Right)Right.UPDATE), Messages.ScriptView_newScriptAction){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.ScriptView_newScriptTooltip);
            }

            @Override
            public void doRun() {
                InputDialog inp = new InputDialog(ScriptView.this.getSite().getShell(), Messages.ScriptView_enterNameCaption, Messages.ScriptView_enterNameBody, null, null);
                if (inp.open() == 0) {
                    try {
                        Script.create((String)inp.getValue(), (String)"");
                    }
                    catch (ElexisException e) {
                        ExHandler.handle((Throwable)e);
                        SWTHelper.showError("Fehler bei Scripterstellung", e.getMessage());
                    }
                    ScriptView.this.tv.refresh();
                }
            }
        };
        this.editScriptAction = new RestrictedAction((EvaluatableACE)EvACE.of(Script.class, (Right)Right.UPDATE), Messages.Core_Edit_Script){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.Core_Edit_Script);
            }

            @Override
            public void doRun() {
                IStructuredSelection sel = (IStructuredSelection)ScriptView.this.tv.getSelection();
                if (sel != null && sel.size() != 0) {
                    Script script = (Script)sel.getFirstElement();
                    ScriptEditor sce = new ScriptEditor(ScriptView.this.getSite().getShell(), script.getString(), script.getLabel());
                    if (sce.open() == 0) {
                        script.putString(sce.getScript());
                    }
                }
            }
        };
        this.removeScriptAction = new RestrictedAction((EvaluatableACE)EvACE.of(Script.class, (Right)Right.UPDATE), Messages.ScriptView_deleteScriptAction){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.ScriptView_deleteScriptTooltip);
            }

            @Override
            public void doRun() {
                IStructuredSelection sel = (IStructuredSelection)ScriptView.this.tv.getSelection();
                if (sel != null && sel.size() != 0) {
                    Script script = (Script)sel.getFirstElement();
                    script.delete();
                    ScriptView.this.tv.refresh();
                }
            }
        };
        this.execScriptAction = new RestrictedAction((EvaluatableACE)EvACE.of(Script.class, (Right)Right.EXECUTE), Messages.Core_Execute_Script){
            {
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
                this.setToolTipText(Messages.Core_Execute_Script);
            }

            @Override
            public void doRun() {
                IStructuredSelection sel = (IStructuredSelection)ScriptView.this.tv.getSelection();
                if (sel != null && sel.size() != 0) {
                    Script script = (Script)sel.getFirstElement();
                    try {
                        SetVarsDlg dlg;
                        String contents = script.getString();
                        ArrayList<String> vars = new ArrayList<String>();
                        Pattern var = Pattern.compile("\\$[0-9a-z]+", 2);
                        Matcher m = var.matcher(contents);
                        while (m.find()) {
                            String varname = m.group();
                            if (vars.contains(varname)) continue;
                            vars.add(varname);
                        }
                        String varString = null;
                        if (vars.size() > 0 && (dlg = new SetVarsDlg(ScriptView.this.getViewSite().getShell(), vars)).open() == 0) {
                            varString = dlg.getResult();
                        }
                        Object ret = script.execute(varString, new PersistentObject[0]);
                        SWTHelper.showInfo(Messages.ScriptView_ScriptOutput, ret.toString());
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.showError("Fehler beim Ausf\u00fchren des Scripts", ex.getMessage());
                    }
                }
            }
        };
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    class ScriptComparator
    implements Comparator<Script> {
        ScriptComparator() {
        }

        @Override
        public int compare(Script script0, Script script1) {
            String script0_ID = script0.getId().toUpperCase();
            String script1_ID = script1.getId().toUpperCase();
            return script0_ID.compareTo(script1_ID);
        }
    }

    class SetVarsDlg
    extends TitleAreaDialog {
        List<String> myVars;
        List<Text> inputs;
        String result;

        SetVarsDlg(Shell shell, List<String> vars) {
            super(shell);
            this.myVars = vars;
            this.inputs = new ArrayList<Text>(vars.size());
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            Composite cVars = new Composite(ret, 0);
            cVars.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            cVars.setLayout((Layout)new GridLayout(2, false));
            for (String v : this.myVars) {
                new Label(cVars, 0).setText(v);
                Text text = new Text(cVars, 2048);
                text.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                text.setData("varname", (Object)v);
                this.inputs.add(text);
            }
            return ret;
        }

        public void create() {
            super.create();
            this.setMessage("Folgende Variablen sollten gesetzt werden:");
            this.setTitle("Bitte vervollst\u00e4ndigen");
            this.getShell().setText("Script Ausf\u00fchrung");
        }

        protected void okPressed() {
            StringBuilder sb = new StringBuilder();
            for (Text text : this.inputs) {
                String varname = (String)text.getData("varname");
                String varcontents = text.getText();
                sb.append(varname).append("=").append(varcontents).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            this.result = sb.toString();
            super.okPressed();
        }

        String getResult() {
            return this.result;
        }
    }
}

