/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.ReminderDetailDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.ReminderFilter;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Reminder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.LoggerFactory;

public class ReminderListsView
extends ViewPart
implements Heartbeat.HeartListener,
IRefreshable,
ISelectionProvider {
    public static final String ID = "ch.elexis.core.ui.views.reminderlistsview";
    private int filterDueDateDays = ConfigServiceHolder.getUser((String)"reminder/filterDueDays", (int)-1);
    private boolean autoSelectPatient = ConfigServiceHolder.getUser((String)"reminder/autoSelectPatient", (boolean)false);
    private boolean showOnlyDueReminders = ConfigServiceHolder.getUser((String)"reminder/onlyopen", (boolean)false);
    private boolean showAllReminders = ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW));
    private boolean showSelfCreatedReminders = ConfigServiceHolder.getUser((String)"reminder/originator", (boolean)false);
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private Composite viewParent;
    private Text txtSearch;
    private ReminderFilter filter = new ReminderFilter();
    private ViewerSelectionComposite viewerSelectionComposite;
    private Composite viewersParent;
    private ScrolledComposite viewersScrolledComposite;
    private HeaderComposite currentPatientHeader;
    private TableViewer currentPatientViewer;
    private HeaderComposite generalPatientHeader;
    private TableViewer generalPatientViewer;
    private HeaderComposite generalHeader;
    private TableViewer generalViewer;
    private Font boldFont;
    private Color colorInProgress;
    private Color colorDue;
    private Color colorOverdue;
    private Color colorOpen;
    private List<IReminder> currentSelection = new ArrayList<IReminder>();
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private Patient actPatient;
    private long cvHighestLastUpdate;
    private Action reloadAction = new Action(Messages.Core_Reload){
        {
            this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            this.setToolTipText(Messages.Core_Reread_List);
        }

        public void run() {
            ReminderListsView.this.refresh();
        }
    };
    private Action deleteReminderAction = new Action(Messages.Core_Delete){
        {
            this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_deleteToolTip);
        }

        public void run() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            if (sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder) {
                IReminder r = (IReminder)sel.getFirstElement();
                LockResponse lockResponse = LocalLockServiceHolder.get().acquireLock((Object)r);
                if (lockResponse.isOk()) {
                    CoreModelServiceHolder.get().delete((Deleteable)r);
                    LocalLockServiceHolder.get().releaseLock((Object)r);
                } else {
                    LockResponseHelper.showInfo(lockResponse, r, null);
                }
                ReminderListsView.this.refreshKeepLabels();
            }
        }

        public boolean isEnabled() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            return sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder;
        }
    };
    private Action newReminderAction = new Action(Messages.Core_New_ellipsis){
        {
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_newReminderToolTip);
        }

        public void run() {
            ReminderDetailDialog erd = null;
            erd = new ReminderDetailDialog(ReminderListsView.this.getViewSite().getShell());
            int retVal = erd.open();
            if (retVal == 0) {
                Reminder reminder = erd.getReminder();
                LocalLockServiceHolder.get().acquireLock((Object)reminder);
                LocalLockServiceHolder.get().releaseLock((Object)reminder);
            }
            ReminderListsView.this.refresh();
        }
    };
    private Action toggleAutoSelectPatientAction = new Action(Messages.ReminderView_activatePatientAction, 2){
        {
            this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_toggleSelectPatientActionTooltip);
            this.setChecked(ReminderListsView.this.autoSelectPatient);
        }

        public void run() {
            ReminderListsView.this.autoSelectPatient = ReminderListsView.this.toggleAutoSelectPatientAction.isChecked();
            ConfigServiceHolder.setUser((String)"reminder/autoSelectPatient", (boolean)ReminderListsView.this.autoSelectPatient);
        }
    };
    private Action showOthersRemindersAction = new RestrictedAction((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW), Messages.Core_All, 2){
        {
            this.setToolTipText(Messages.ReminderView_foreignTooltip);
            this.setImageDescriptor(Images.IMG_ACHTUNG.getImageDescriptor());
        }

        @Override
        public void doRun() {
            ReminderListsView.this.showAllReminders = ReminderListsView.this.showOthersRemindersAction.isChecked();
            ConfigServiceHolder.setUser((String)"reminder/others", (boolean)ReminderListsView.this.showAllReminders);
            ReminderListsView.this.refresh();
        }
    };
    private Action showSelfCreatedReminderAction = new Action(Messages.ReminderView_myRemindersAction, 2){
        {
            this.setToolTipText(Messages.ReminderView_myRemindersToolTip);
        }

        public void run() {
            ReminderListsView.this.showSelfCreatedReminders = ReminderListsView.this.showSelfCreatedReminderAction.isChecked();
            ConfigServiceHolder.setUser((String)"reminder/originator", (boolean)ReminderListsView.this.showSelfCreatedReminders);
            ReminderListsView.this.refresh();
        }
    };
    private Action showOnlyOwnDueReminderToggleAction = new Action(Messages.ReminderView_onlyDueAction, 2){
        {
            this.setToolTipText(Messages.ReminderView_onlyDueToolTip);
        }

        public void run() {
            ReminderListsView.this.showOnlyDueReminders = ReminderListsView.this.showOnlyOwnDueReminderToggleAction.isChecked();
            ConfigServiceHolder.setUser((String)"reminder/onlyopen", (boolean)ReminderListsView.this.showOnlyDueReminders);
            ReminderListsView.this.refresh();
        }
    };
    private RestrictedAction selectPatientAction = new RestrictedAction((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.VIEW), Messages.ReminderView_activatePatientAction, 0){
        {
            this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_activatePatientTooltip);
        }

        @Override
        public void doRun() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            if (sel != null && sel.size() != 1) {
                SWTHelper.showInfo(Messages.ReminderView_onePatOnly, Messages.ReminderView_onlyOnePatientForActivation);
            } else if (sel != null && sel.size() > 0) {
                IReminder reminder = (IReminder)sel.getFirstElement();
                IContact patient = reminder.getContact();
                IContact creator = reminder.getCreator();
                if (patient != null && patient.isPatient() && !patient.getId().equals(creator.getId())) {
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)CoreModelServiceHolder.get().load(patient.getId(), IPatient.class).get())));
                }
            }
        }

        public boolean isEnabled() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            if (sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder) {
                IReminder reminder = (IReminder)sel.getFirstElement();
                return reminder.getContact() != null && reminder.getCreator() != null ? !reminder.getContact().getId().equals(reminder.getCreator().getId()) : false;
            }
            return false;
        }
    };
    private static String SELECTIONCOMP_CURRENTPATIENT_ID = "reminderlistsview.selection.currentpatient";
    private static String SELECTIONCOMP_GENERALPATIENT_ID = "reminderlistsview.selection.generalpatient";
    private static String SELECTIONCOMP_GENERAL_ID = "reminderlistsview.selection.general";

    @Optional
    @Inject
    void activePatient(IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            final Patient selectedPatient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            if (selectedPatient.equals((Object)this.actPatient)) {
                return;
            }
            this.actPatient = selectedPatient;
            this.clearSelection();
            this.patientRefresh();
            if (!ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)true)) {
                UiDesk.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        List list = Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, (Patient)selectedPatient, (boolean)true);
                        if (list.size() != 0) {
                            StringBuilder sb = new StringBuilder();
                            for (Reminder r : list) {
                                sb.append(String.valueOf(r.getSubject()) + "\n");
                                sb.append(String.valueOf(r.getMessage()) + "\n\n");
                            }
                            SWTHelper.alert(Messages.ReminderView_importantRemindersCaption, sb.toString());
                        }
                    }
                });
            }
        }, (Object)this.viewersParent);
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.viewersScrolledComposite != null && !this.viewersScrolledComposite.isDisposed()) {
                this.adaptForUser(user);
            }
        });
    }

    private void adaptForUser(IUser user) {
        this.refreshUserConfiguration();
        this.refresh();
    }

    @Optional
    @Inject
    void crudFinding(@UIEventTopic(value="info/elexis/model/*") IReminder reminder) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)((Object)this.viewerSelectionComposite));
    }

    public void createPartControl(Composite parent) {
        this.viewParent = new Composite(parent, 0);
        this.viewParent.setLayout((Layout)new GridLayout());
        this.txtSearch = new Text(this.viewParent, 128);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtSearch.setMessage(Messages.ReminderView_txtSearch_message);
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.filter.setFilterText(ReminderListsView.this.txtSearch.getText());
                ReminderListsView.this.refreshKeepLabels();
            }
        });
        this.boldFont = SWTResourceManager.getBoldFont(this.txtSearch.getFont());
        this.viewerSelectionComposite = new ViewerSelectionComposite(this.viewParent, 0);
        this.viewerSelectionComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.viewersScrolledComposite = new ScrolledComposite(this.viewParent, 512);
        this.viewersScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewersScrolledComposite.setExpandVertical(true);
        this.viewersScrolledComposite.setExpandHorizontal(true);
        this.viewersScrolledComposite.addListener(11, event -> {
            int width = this.viewersScrolledComposite.getClientArea().width;
            this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
        });
        this.viewersParent = new Composite((Composite)this.viewersScrolledComposite, 0);
        this.viewersParent.setBackground(UiDesk.getColor("weiss"));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewersParent.setLayout((Layout)layout);
        this.viewersScrolledComposite.setContent((Control)this.viewersParent);
        this.currentPatientHeader = new HeaderComposite(this.viewersParent, 0);
        this.currentPatientHeader.setTextFont(this.boldFont);
        this.currentPatientHeader.setText("aktueller Patient");
        this.currentPatientViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.currentPatientViewer.getTable().setHeaderVisible(true);
        this.currentPatientViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 100;
        this.currentPatientViewer.getTable().setLayoutData((Object)gd);
        this.currentPatientViewer.setComparator((ViewerComparator)new ReminderComparator());
        this.currentPatientViewer.addFilter((ViewerFilter)this.filter);
        this.currentPatientViewer.addSelectionChangedListener(this.getSelectionListener());
        this.currentPatientViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createTypeColumn(this.currentPatientViewer, 20, 0);
        this.createDateColumn(this.currentPatientViewer, 80, 1);
        this.createResponsibleColumn(this.currentPatientViewer, 80, 2);
        this.createDescriptionColumn(this.currentPatientViewer, 400, 3);
        this.generalPatientHeader = new HeaderComposite(this.viewersParent, 0);
        this.generalPatientHeader.setTextFont(this.boldFont);
        this.generalPatientHeader.setText("alle Patienten");
        this.generalPatientViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.generalPatientViewer.getTable().setHeaderVisible(true);
        this.generalPatientViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 100;
        this.generalPatientViewer.getTable().setLayoutData((Object)gd);
        this.generalPatientViewer.setComparator((ViewerComparator)new ReminderComparator());
        this.generalPatientViewer.addFilter((ViewerFilter)this.filter);
        this.generalPatientViewer.addSelectionChangedListener(this.getSelectionListener());
        this.generalPatientViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createTypeColumn(this.generalPatientViewer, 20, 0);
        this.createDateColumn(this.generalPatientViewer, 80, 1);
        this.createResponsibleColumn(this.generalPatientViewer, 80, 2);
        this.createPatientColumn(this.generalPatientViewer, 150, 3);
        this.createDescriptionColumn(this.generalPatientViewer, 400, 4);
        this.generalHeader = new HeaderComposite(this.viewersParent, 0);
        this.generalHeader.setTextFont(this.boldFont);
        this.generalHeader.setText("allgemein");
        this.generalViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.generalViewer.getTable().setHeaderVisible(true);
        this.generalViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 100;
        this.generalViewer.getTable().setLayoutData((Object)gd);
        this.generalViewer.setComparator((ViewerComparator)new ReminderComparator());
        this.generalViewer.addFilter((ViewerFilter)this.filter);
        this.generalViewer.addSelectionChangedListener(this.getSelectionListener());
        this.generalViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createTypeColumn(this.generalViewer, 20, 0);
        this.createDateColumn(this.generalViewer, 80, 1);
        this.createResponsibleColumn(this.generalViewer, 80, 2);
        this.createDescriptionColumn(this.generalViewer, 400, 3);
        this.viewerSelectionComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ReminderListsView.this.updateViewerSelection(selection);
                ReminderListsView.this.refresh();
            }
        });
        this.actPatient = ElexisEventDispatcher.getSelectedPatient();
        this.viewerSelectionComposite.loadSelection();
        this.updateViewerSelection((StructuredSelection)this.viewerSelectionComposite.getSelection());
        this.refreshUserConfiguration();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.reloadAction, this.newReminderAction, this.toggleAutoSelectPatientAction});
        MenuManager timeFilterSubMenu = new MenuManager("Zeitraum Anzeige");
        FilterTimeAction action30 = new FilterTimeAction(30);
        FilterTimeAction action60 = new FilterTimeAction(60);
        FilterTimeAction action90 = new FilterTimeAction(90);
        action30.setOthers(Arrays.asList(action60, action90));
        action60.setOthers(Arrays.asList(action30, action90));
        action90.setOthers(Arrays.asList(action30, action60));
        timeFilterSubMenu.add((IAction)action30);
        timeFilterSubMenu.add((IAction)action60);
        timeFilterSubMenu.add((IAction)action90);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new ReminderStatusSubMenu());
        menuManager.add((IAction)this.deleteReminderAction);
        menuManager.add((IContributionItem)timeFilterSubMenu);
        menuManager.add((IAction)this.showOnlyOwnDueReminderToggleAction);
        menuManager.add((IAction)this.showSelfCreatedReminderAction);
        menuManager.add((IAction)this.showOthersRemindersAction);
        this.currentPatientViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.currentPatientViewer.getTable()));
        this.generalPatientViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.generalPatientViewer.getTable()));
        this.generalViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.generalViewer.getTable()));
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    private void updateViewerSelection(StructuredSelection selection) {
        this.viewersParent.setRedraw(false);
        this.hideControl((Control)this.currentPatientHeader);
        this.hideControl((Control)this.currentPatientViewer.getTable());
        this.hideControl((Control)this.generalPatientHeader);
        this.hideControl((Control)this.generalPatientViewer.getTable());
        this.hideControl((Control)this.generalHeader);
        this.hideControl((Control)this.generalViewer.getTable());
        if (selection != null && !selection.isEmpty()) {
            for (Object selected : selection.toList()) {
                if (!(selected instanceof String)) continue;
                if (SELECTIONCOMP_CURRENTPATIENT_ID.equals(selected)) {
                    this.showControl((Control)this.currentPatientHeader);
                    this.showControl((Control)this.currentPatientViewer.getTable());
                    continue;
                }
                if (SELECTIONCOMP_GENERALPATIENT_ID.equals(selected)) {
                    this.showControl((Control)this.generalPatientHeader);
                    this.showControl((Control)this.generalPatientViewer.getTable());
                    continue;
                }
                if (!SELECTIONCOMP_GENERAL_ID.equals(selected)) continue;
                this.showControl((Control)this.generalHeader);
                this.showControl((Control)this.generalViewer.getTable());
            }
        }
        this.viewersParent.setRedraw(true);
        int width = this.viewersScrolledComposite.getClientArea().width;
        this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
        this.viewParent.layout(true, true);
    }

    private void showControl(Control control) {
        if (control != null && control.getLayoutData() != null) {
            control.setVisible(true);
            ((GridData)control.getLayoutData()).exclude = false;
        }
    }

    private void hideControl(Control control) {
        if (control != null && control.getLayoutData() != null) {
            control.setVisible(false);
            ((GridData)control.getLayoutData()).exclude = true;
        }
    }

    public void setFocus() {
        this.viewersParent.setFocus();
    }

    private void refreshKeepLabels() {
        if (this.generalViewer.getTable().isVisible()) {
            this.generalViewer.refresh(false);
        }
        if (this.generalPatientViewer.getTable().isVisible()) {
            this.generalPatientViewer.refresh(false);
        }
        if (this.currentPatientViewer.getTable().isVisible()) {
            this.currentPatientViewer.refresh(false);
        }
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(() -> {
            this.patientRefresh();
            this.generalRefresh();
            int width = this.viewersScrolledComposite.getClientArea().width;
            this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
            this.viewParent.layout(true, true);
        });
    }

    private void patientRefresh() {
        if (this.actPatient != null) {
            if (this.currentPatientViewer.getTable().isVisible()) {
                this.refreshCurrentPatientInput();
            }
        } else {
            this.currentPatientViewer.setInput(Collections.emptyList());
        }
    }

    private void generalRefresh() {
        if (this.generalViewer.getTable().isVisible()) {
            this.refreshGeneralInput();
        }
        if (this.generalPatientViewer.getTable().isVisible()) {
            this.refreshGeneralPatientInput();
        }
    }

    private void refreshCurrentPatientInput() {
        if (this.actPatient != null) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new CurrentPatientSupplier(this.actPatient).showAll(this.showAllReminders && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.showOnlyDueReminders).showSelfCreated(this.showSelfCreatedReminders));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (this.currentPatientViewer != null && !this.currentPatientViewer.getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        this.currentPatientViewer.setInput((Object)input);
                        this.viewerSelectionComposite.setCount(SELECTIONCOMP_CURRENTPATIENT_ID, this.currentPatientViewer.getTable().getItemCount());
                        if (input.size() < 5) {
                            if (((GridData)this.currentPatientViewer.getTable().getLayoutData()).heightHint != 125) {
                                ((GridData)this.currentPatientViewer.getTable().getLayoutData()).heightHint = 125;
                                this.currentPatientViewer.getTable().getParent().layout(true, true);
                            }
                        } else if (((GridData)this.currentPatientViewer.getTable().getLayoutData()).heightHint != 300) {
                            ((GridData)this.currentPatientViewer.getTable().getLayoutData()).heightHint = 300;
                            this.currentPatientViewer.getTable().getParent().layout(true, true);
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void refreshGeneralPatientInput() {
        CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new GeneralPatientSupplier(this.actPatient).showAll(this.showAllReminders && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.showOnlyDueReminders).showSelfCreated(this.showSelfCreatedReminders));
        currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
            if (this.generalPatientViewer != null && !this.generalPatientViewer.getTable().isDisposed()) {
                try {
                    List input = (List)currentLoader.get();
                    this.generalPatientViewer.setInput((Object)input);
                    this.viewerSelectionComposite.setCount(SELECTIONCOMP_GENERALPATIENT_ID, this.generalPatientViewer.getTable().getItemCount());
                    if (input.size() < 5) {
                        if (((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint != 125) {
                            ((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint = 125;
                            this.generalPatientViewer.getTable().getParent().layout(true, true);
                        }
                    } else if (((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint != 300) {
                        ((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint = 300;
                        this.generalPatientViewer.getTable().getParent().layout(true, true);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                }
            }
        }));
    }

    private void refreshGeneralInput() {
        CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new GeneralSupplier().showAll(this.showAllReminders && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.showOnlyDueReminders).showSelfCreated(this.showSelfCreatedReminders));
        currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
            if (this.generalViewer != null && !this.generalViewer.getTable().isDisposed()) {
                try {
                    List input = (List)currentLoader.get();
                    this.generalViewer.setInput((Object)input);
                    this.viewerSelectionComposite.setCount(SELECTIONCOMP_GENERAL_ID, this.generalViewer.getTable().getItemCount());
                    if (input.size() < 5) {
                        if (((GridData)this.generalViewer.getTable().getLayoutData()).heightHint != 125) {
                            ((GridData)this.generalViewer.getTable().getLayoutData()).heightHint = 125;
                            this.generalViewer.getTable().getParent().layout(true, true);
                        }
                    } else if (((GridData)this.generalViewer.getTable().getLayoutData()).heightHint != 300) {
                        ((GridData)this.generalViewer.getTable().getLayoutData()).heightHint = 300;
                        this.generalViewer.getTable().getParent().layout(true, true);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                }
            }
        }));
    }

    private void applyDueDateFilter(IQuery<IReminder> query, boolean includeNoDue) {
        LocalDate dueDateDays = LocalDate.now();
        dueDateDays.plusDays(this.filterDueDateDays);
        if (!includeNoDue) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.NOT_EQUALS, null);
        }
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)dueDateDays);
    }

    private void refreshUserConfiguration() {
        this.showOnlyOwnDueReminderToggleAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/onlyopen", (boolean)true));
        this.showSelfCreatedReminderAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/originator", (boolean)false));
        this.toggleAutoSelectPatientAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/autoSelectPatient", (boolean)false));
        this.colorInProgress = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.IN_PROGRESS.name()), (String)"FFFFFF"));
        this.colorDue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.DUE.name()), (String)"FFFFFF"));
        this.colorOverdue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OVERDUE.name()), (String)"FF0000"));
        this.colorOpen = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OPEN.name()), (String)"00FF00"));
    }

    private TableViewerColumn createTypeColumn(TableViewer viewer, int width, int columnIndex) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof IReminder) {
                    IReminder reminder = (IReminder)element;
                    Type actionType = reminder.getType();
                    switch (actionType) {
                        case PRINT: 
                        case PRINT_DRUG_STICKER: {
                            return Images.IMG_PRINTER.getImage();
                        }
                        case MAKE_APPOINTMENT: {
                            return Images.IMG_CALENDAR.getImage();
                        }
                        case DISPENSE_MEDICATION: {
                            return Images.IMG_PILL.getImage();
                        }
                        case PROCESS_SERVICE_RECORDING: {
                            return Images.IMG_MONEY.getImage();
                        }
                        case READ_DOCUMENT: 
                        case CHECK_LAB_RESULT: {
                            return Images.IMG_EYE_WO_SHADOW.getImage();
                        }
                        case SEND_DOCUMENT: {
                            return Images.IMG_MAIL_SEND.getImage();
                        }
                    }
                    return null;
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createDateColumn(TableViewer viewer, int width, int columnIndex) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Datum");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                if (reminder.getDue() != null) {
                    return this.defaultDateFormatter.format(reminder.getDue());
                }
                return "";
            }

            public Color getBackground(Object element) {
                IReminder reminder = (IReminder)element;
                LocalDate now = LocalDate.now();
                if (reminder.getDue() != null) {
                    if (reminder.getDue().equals(now)) {
                        return ReminderListsView.this.colorDue;
                    }
                    if (reminder.getDue().isBefore(now)) {
                        return ReminderListsView.this.colorOverdue;
                    }
                    ProcessStatus processStatus = reminder.getStatus();
                    if (ProcessStatus.OPEN == processStatus) {
                        return ReminderListsView.this.colorOpen;
                    }
                    if (ProcessStatus.IN_PROGRESS == processStatus) {
                        return ReminderListsView.this.colorInProgress;
                    }
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createPatientColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Patient");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                IContact contact = reminder.getContact();
                return contact != null ? contact.getLabel() : "";
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createDescriptionColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Betreff");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                return StringUtils.isEmpty((CharSequence)reminder.getSubject()) ? reminder.getMessage() : reminder.getSubject();
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }

            public Font getFont(Object element) {
                IReminder reminder = (IReminder)element;
                Priority prio = reminder.getPriority();
                if (Priority.HIGH == prio) {
                    return ReminderListsView.this.boldFont;
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createResponsibleColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Zust.");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                if (reminder.isResponsibleAll()) {
                    return "Alle";
                }
                List responsibles = reminder.getResponsible();
                if (responsibles != null) {
                    StringJoiner sj = new StringJoiner("| ");
                    responsibles.forEach(r -> {
                        if (r.isMandator()) {
                            sj.add(r.getDescription3());
                        } else {
                            sj.add(r.getLabel());
                        }
                    });
                    return sj.toString();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        return viewerColumn;
    }

    private ISelectionChangedListener getSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReminderListsView.this.selectionChanged(selection.toList());
                ReminderListsView.this.selectPatientAction.setEnabled(selection.size() <= 1);
                ReminderListsView.this.selectPatientAction.reflectRight();
                if (ReminderListsView.this.autoSelectPatient && ReminderListsView.this.selectPatientAction.isEnabled()) {
                    ReminderListsView.this.selectPatientAction.doRun();
                }
            }
        };
    }

    private IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    final IReminder reminder = (IReminder)selection.getFirstElement();
                    AcquireLockBlockingUi.aquireAndRun((Identifiable)reminder, new ILockHandler(){

                        @Override
                        public void lockAcquired() {
                            ReminderDetailDialog rdd = new ReminderDetailDialog(UiDesk.getTopShell(), (Reminder)NoPoUtil.loadAsPersistentObject((Identifiable)reminder));
                            int retVal = rdd.open();
                            if (retVal == 0) {
                                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)reminder, this.getClass(), 4)});
                            }
                        }

                        @Override
                        public void lockFailed() {
                            ReminderListsView.this.refreshKeepLabels();
                        }
                    });
                }
            }
        };
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer viewer, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReminderComparator comparator = (ReminderComparator)viewer.getComparator();
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                viewer.getTable().setSortColumn(column);
                viewer.getTable().setSortDirection(dir);
                viewer.refresh(true);
            }
        };
        return selectionAdapter;
    }

    public void heartbeat() {
        long highestLastUpdate = PersistentObject.getHighestLastUpdate((String)"REMINDERS");
        if (highestLastUpdate > this.cvHighestLastUpdate) {
            this.refresh();
            this.cvHighestLastUpdate = highestLastUpdate;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.currentSelection);
    }

    public void setSelection(ISelection arg0) {
    }

    private void clearSelection() {
        StructuredSelection clear = new StructuredSelection();
        this.currentPatientViewer.setSelection((ISelection)clear);
        this.generalPatientViewer.setSelection((ISelection)clear);
        this.generalViewer.setSelection((ISelection)clear);
    }

    private void selectionChanged(List<IReminder> list) {
        this.currentSelection.clear();
        this.currentSelection.addAll(list);
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            listener.selectionChanged(event);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private class CurrentPatientSupplier
    implements Supplier<List<IReminder>> {
        private IPatient patient;
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;

        public CurrentPatientSupplier(Patient actPatient) {
            this.patient = NoPoUtil.loadAsIdentifiable((PersistentObject)actPatient, IPatient.class).orElse(null);
        }

        @Override
        public List<IReminder> get() {
            if (this.patient != null) {
                IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
                if (this.showOnlyDue) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
                }
                if (!this.showAll) {
                    if (this.showSelfCreated) {
                        ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                            query.startGroup();
                            ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                            subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                            subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                            query.exists(subQuery);
                            query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                            query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m);
                            query.andJoinGroups();
                        });
                    } else {
                        ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                            query.startGroup();
                            ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                            subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                            subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                            query.exists(subQuery);
                            query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                            query.andJoinGroups();
                        });
                    }
                }
                if (this.filterDue) {
                    ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
                }
                return query.execute();
            }
            return Collections.emptyList();
        }

        public CurrentPatientSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public CurrentPatientSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public CurrentPatientSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public CurrentPatientSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }
    }

    private class FilterTimeAction
    extends Action {
        private List<FilterTimeAction> others;
        private int days;

        public FilterTimeAction(int days) {
            super(String.format("n\u00e4chste %d Tage", days), 2);
            this.days = days;
            if (ReminderListsView.this.filterDueDateDays == days) {
                this.setChecked(true);
            }
        }

        public void setOthers(List<FilterTimeAction> list) {
            this.others = list;
        }

        public void run() {
            if (this.isChecked()) {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)this.days);
                ReminderListsView.this.filterDueDateDays = this.days;
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.refresh();
            } else {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)-1);
                ReminderListsView.this.filterDueDateDays = -1;
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.refresh();
            }
            if (this.others != null) {
                for (FilterTimeAction other : this.others) {
                    other.setChecked(false);
                }
            }
        }
    }

    private class GeneralPatientSupplier
    implements Supplier<List<IReminder>> {
        private IPatient patient;
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;

        public GeneralPatientSupplier(Patient actPatient) {
            this.patient = NoPoUtil.loadAsIdentifiable((PersistentObject)actPatient, IPatient.class).orElse(null);
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.NOT_EQUALS, (EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (!this.showAll) {
                if (this.showSelfCreated) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        query.startGroup();
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m);
                        query.andJoinGroups();
                    });
                } else {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        query.startGroup();
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                        query.andJoinGroups();
                    });
                }
            }
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public GeneralPatientSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public GeneralPatientSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public GeneralPatientSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public GeneralPatientSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }
    }

    private class GeneralSupplier
    implements Supplier<List<IReminder>> {
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;

        private GeneralSupplier() {
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, (EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (!this.showAll) {
                if (this.showSelfCreated) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        query.startGroup();
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m);
                        query.andJoinGroups();
                    });
                } else {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        query.startGroup();
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                        query.andJoinGroups();
                    });
                }
            }
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public GeneralSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public GeneralSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public GeneralSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public GeneralSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }
    }

    private class HeaderComposite
    extends Composite {
        private Label header;
        private ToolBarManager toolbarManager;

        public HeaderComposite(Composite parent, int style) {
            super(parent, style);
            this.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.header = new Label((Composite)this, 0);
            this.header.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.header.setBackground(this.getBackground());
            this.toolbarManager = new ToolBarManager();
            ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
            toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            toolbar.setBackground(this.getBackground());
        }

        public void setTextFont(Font font) {
            this.header.setFont(font);
        }

        public void setText(String text) {
            this.header.setText(text);
            ReminderListsView.this.viewParent.layout(true, true);
        }
    }

    private class ReminderComparator
    extends ViewerComparator
    implements Comparator<IReminder> {
        private int column = -1;
        private int direction = 1024;

        @Override
        public int compare(IReminder r1, IReminder r2) {
            if (r1.getDue() != null && r2.getDue() != null) {
                if (this.direction == 128) {
                    return r2.getDue().compareTo(r1.getDue());
                }
                return r1.getDue().compareTo(r2.getDue());
            }
            if (r1.getDue() == null && r2.getDue() == null) {
                return 0;
            }
            if (r1.getDue() == null) {
                return this.direction == 128 ? 1 : -1;
            }
            if (r2.getDue() == null) {
                return this.direction == 128 ? -1 : 1;
            }
            if (this.direction == 128) {
                return r2.getLastupdate().compareTo(r1.getLastupdate());
            }
            return r1.getLastupdate().compareTo(r2.getLastupdate());
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare((IReminder)e1, (IReminder)e2);
        }

        public void setColumn(int index) {
            if (this.column == index) {
                this.direction = this.direction == 1024 ? 128 : 1024;
            } else {
                this.column = index;
                this.direction = 1024;
            }
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private class ReminderStatusSubMenu
    extends MenuManager {
        public ReminderStatusSubMenu() {
            super("Status...");
            this.setRemoveAllWhenShown(true);
            this.addMenuListener(new ReminderStatusSubMenuListener());
        }

        private class ReminderStatusSubMenuListener
        implements IMenuListener {
            private ReminderStatusSubMenuListener() {
            }

            public void menuAboutToShow(IMenuManager manager) {
                StructuredSelection selection = (StructuredSelection)ReminderListsView.this.getSelection();
                if (selection != null && selection.size() == 1) {
                    if (selection.getFirstElement() instanceof IReminder) {
                        IReminder reminder = (IReminder)selection.getFirstElement();
                        manager.add((IAction)new StatusAction(ProcessStatus.OPEN, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.IN_PROGRESS, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.CLOSED, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.ON_HOLD, reminder));
                    }
                } else {
                    manager.add((IAction)new Action("Multiple selection"){

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                }
            }

            private class StatusAction
            extends LockRequestingAction<IReminder> {
                private final ProcessStatus representedStatus;
                private IReminder reminder;

                public StatusAction(ProcessStatus representedStatus, IReminder reminder) {
                    super(representedStatus.getLocaleText(), 16);
                    this.representedStatus = representedStatus;
                    this.reminder = reminder;
                    ProcessStatus status = reminder.getStatus();
                    if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                        this.setChecked(representedStatus == ProcessStatus.OPEN);
                    } else {
                        this.setChecked(representedStatus == status);
                    }
                }

                public boolean isChecked() {
                    ProcessStatus status = this.reminder.getStatus();
                    if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                        return this.representedStatus == ProcessStatus.OPEN;
                    }
                    return this.representedStatus == this.reminder.getStatus();
                }

                public String getText() {
                    String text = super.getText();
                    ProcessStatus status = this.reminder.getStatus();
                    if ((ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) && ProcessStatus.OPEN == this.representedStatus) {
                        return String.valueOf(text) + " (" + status.getLocaleText() + ")";
                    }
                    return text;
                }

                @Override
                public IReminder getTargetedObject() {
                    return this.reminder;
                }

                @Override
                public void doRun(IReminder element) {
                    element.setStatus(this.representedStatus);
                    CoreModelServiceHolder.get().save((Identifiable)element);
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)NoPoUtil.loadAsPersistentObject((Identifiable)element), Reminder.class, 4)});
                }
            }
        }
    }

    private class ViewerSelectionComposite
    extends Composite
    implements ISelectionProvider {
        private List<Action> currentSelection;
        private ListenerList<ISelectionChangedListener> selectionChangedListeners;
        private ToolBarManager manager;

        public ViewerSelectionComposite(Composite parent, int style) {
            super(parent, style);
            this.currentSelection = new ArrayList<Action>();
            this.selectionChangedListeners = new ListenerList();
            this.createContent();
        }

        public void setCount(String id, int itemCount) {
            IContributionItem[] iContributionItemArray = this.manager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item.getId().equals(id)) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    String text = action.getText();
                    if (text.indexOf(" (") != -1) {
                        text = text.substring(0, text.indexOf(" ("));
                    }
                    action.setText(String.valueOf(text) + " (" + itemCount + ")");
                    item.update();
                }
                ++n2;
            }
            this.manager.update(true);
            this.layout();
        }

        private void createContent() {
            this.setBackground(UiDesk.getColor("weiss"));
            this.setLayout((Layout)new FillLayout());
            this.manager = new ToolBarManager(64);
            this.manager.add((IAction)new Action("aktueller Patient", 2){

                public String getId() {
                    return SELECTIONCOMP_CURRENTPATIENT_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.add((IAction)new Action("alle Patienten", 2){

                public String getId() {
                    return SELECTIONCOMP_GENERALPATIENT_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.add((IAction)new Action("allgemein", 2){

                public String getId() {
                    return SELECTIONCOMP_GENERAL_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.createControl((Composite)this);
        }

        private void saveSelection() {
            List<String> selectedIds = this.currentSelection.stream().map(action -> action.getId()).collect(Collectors.toList());
            StringJoiner sj = new StringJoiner(",");
            selectedIds.forEach(id -> {
                StringJoiner stringJoiner2 = sj.add((CharSequence)id);
            });
            ConfigServiceHolder.setUser((String)"reminder/viewerSelection", (String)sj.toString());
        }

        public void loadSelection() {
            String[] loadedIds;
            this.currentSelection.clear();
            String[] stringArray = loadedIds = ConfigServiceHolder.getUser((String)"reminder/viewerSelection", (String)"").split(",");
            int n = loadedIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IContributionItem[] iContributionItemArray = this.manager.getItems();
                int n3 = iContributionItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContributionItem item = iContributionItemArray[n4];
                    if (item.getId().equals(id)) {
                        IAction action = ((ActionContributionItem)item).getAction();
                        action.setChecked(true);
                        this.currentSelection.add((Action)action);
                    }
                    ++n4;
                }
                this.fireSelectionChanged();
                this.manager.update(true);
                this.layout();
                ++n2;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return new StructuredSelection(this.currentSelection.stream().map(action -> action.getId()).collect(Collectors.toList()));
        }

        public void setSelection(ISelection selection) {
        }

        private void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                listener.selectionChanged(event);
            }
        }
    }
}

