/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.interfaces.INumericEnum;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.WithExtInfo;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.FilterNonPrintableModifyListener;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.TristateCheckbox;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabeledInputField
extends Composite {
    static final Logger logger = LoggerFactory.getLogger(LabeledInputField.class);
    Label lbl;
    Control ctl;
    StructuredViewer viewer;
    FormToolkit tk = UiDesk.getToolkit();
    Typ inputFieldType;

    public LabeledInputField(Composite parent, String label) {
        this(parent, label, Typ.TEXT, Text.LIMIT);
    }

    public LabeledInputField(Composite parent, String label, Typ typ) {
        this(parent, label, typ, Text.LIMIT);
    }

    public LabeledInputField(Composite parent, String label, int limit) {
        this(parent, label, Typ.TEXT, limit);
    }

    public LabeledInputField(Composite parent, String label, Typ typ, int limit) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.inputFieldType = typ;
        this.lbl = new Label((Composite)this, 1);
        switch (typ) {
            case CHECKBOX: 
            case CHECKBOXTRISTATE: {
                break;
            }
            default: {
                this.lbl.setText(label);
            }
        }
        switch (typ) {
            case LINK: {
                this.lbl.setForeground(UiDesk.getColorRegistry().get("blau"));
                this.ctl = this.tk.createText((Composite)this, "", 0);
                this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                break;
            }
            case TEXT: 
            case MONEY: {
                this.ctl = this.tk.createText((Composite)this, "", 2048);
                ((Text)this.ctl).setTextLimit(limit);
                this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                break;
            }
            case LIST: {
                this.ctl = new List((Composite)this, 2050);
                this.ctl.setLayoutData((Object)new GridData(1808));
                break;
            }
            case OBSOLETE_DATE: {
                logger.error("Please use nebula CDateTime instead!");
                break;
            }
            case COMBO: {
                this.ctl = new Combo((Composite)this, 2052);
                this.ctl.setLayoutData((Object)new GridData(1808));
                break;
            }
            case COMBO_VIEWER: {
                this.viewer = new ComboViewer((Composite)this, 2052);
                this.ctl = this.viewer.getControl();
                this.ctl.setLayoutData((Object)new GridData(1808));
                break;
            }
            case CHECKBOX: {
                this.ctl = this.tk.createButton((Composite)this, label, 32);
                ((Button)this.ctl).setText(label);
                this.ctl.setBackground(this.getBackground());
                this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                break;
            }
            case CHECKBOXTRISTATE: {
                this.ctl = new TristateCheckbox(this, 0, true);
                ((Button)this.ctl).setText(label);
                this.ctl.setBackground(this.getBackground());
                this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                break;
            }
            case EXECLINK: {
                this.lbl.setForeground(UiDesk.getColorRegistry().get("blau"));
                this.ctl = this.tk.createText((Composite)this, "", 2048);
                this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                break;
            }
        }
        if (this.ctl instanceof Text) {
            FilterNonPrintableModifyListener.addTo((Text)this.ctl);
        }
        this.lbl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
    }

    public void setText(String text) {
        if (this.viewer != null) {
            return;
        }
        if (this.ctl instanceof Text) {
            ((Text)this.ctl).setText(text);
        } else if (this.ctl instanceof List) {
            List list = (List)this.ctl;
            list.deselectAll();
            if (!StringTool.isNothing((Object)text)) {
                String[] sel = text.split(",");
                int[] selidx = new int[sel.length];
                String[] items = list.getItems();
                int i = 0;
                while (i < sel.length) {
                    int idx = StringTool.getIndex((String[])items, (String)sel[i]);
                    if (idx != -1) {
                        selidx[i] = idx;
                    }
                    ++i;
                }
                list.select(selidx);
            }
        } else if (this.ctl instanceof Combo) {
            int idx;
            Combo combo = (Combo)this.ctl;
            if (!StringTool.isNothing((Object)text) && (idx = StringTool.getIndex((String[])combo.getItems(), (String)text)) != -1) {
                combo.select(idx);
            }
        } else if (this.ctl instanceof Button) {
            ((Button)this.ctl).setText(text);
        }
    }

    public String getText() {
        if (this.viewer != null) {
            StructuredSelection ss = (StructuredSelection)this.viewer.getSelection();
            Object firstElement = ss.getFirstElement();
            if (firstElement == null) {
                return "";
            }
            if (firstElement instanceof INumericEnum) {
                return Integer.toString(((INumericEnum)firstElement).numericValue());
            }
            return ss.getFirstElement().toString();
        }
        if (this.ctl instanceof Text) {
            return ((Text)this.ctl).getText();
        }
        if (this.ctl instanceof List) {
            List list = (List)this.ctl;
            String[] sel = list.getSelection();
            if (sel.length == 0) {
                return "";
            }
            return StringTool.join((String[])sel, (String)",");
        }
        if (this.ctl instanceof Combo) {
            return ((Combo)this.ctl).getText();
        }
        if (this.ctl instanceof Button) {
            return ((Button)this.ctl).getText();
        }
        return "";
    }

    public void setLabel(String text) {
        switch (this.inputFieldType) {
            case CHECKBOX: {
                ((Button)this.ctl).setText(text);
            }
            case CHECKBOXTRISTATE: {
                ((TristateCheckbox)this.ctl).setText(text);
                break;
            }
            default: {
                this.lbl.setText(text);
            }
        }
    }

    public String getLabel() {
        switch (this.inputFieldType) {
            case CHECKBOX: {
                return ((Button)this.ctl).getText();
            }
            case CHECKBOXTRISTATE: {
                return ((TristateCheckbox)this.ctl).getText();
            }
        }
        return this.lbl.getText();
    }

    public Label getLabelComponent() {
        return this.lbl;
    }

    public Control getControl() {
        return this.ctl;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void setEnabled(boolean enabled) {
        if (this.ctl != null && !this.ctl.isDisposed()) {
            this.ctl.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public static class AutoForm
    extends Tableau
    implements IUnlockable {
        InputData[] def;
        Control[] cFields;
        Object act;
        DecimalFormat df = new DecimalFormat(Messages.LabeledInputField_7);
        LabeledInputField ltf;

        public AutoForm(Composite parent, InputData[] fields) {
            this(parent, fields, 1, 5);
        }

        public AutoForm(Composite parent, InputData[] fields, int minColumns, int maxColumns) {
            super(parent, minColumns, maxColumns);
            this.def = fields;
            this.cFields = new Control[this.def.length];
            int i = 0;
            while (i < this.def.length) {
                this.ltf = null;
                InputData.Typ typ = this.def[i].tFeldTyp;
                if (typ == InputData.Typ.LIST) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.LIST);
                    ((List)this.ltf.getControl()).setItems((String[])this.def[i].ext);
                } else if (typ == InputData.Typ.COMBO) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.COMBO);
                    ((Combo)this.ltf.getControl()).setItems((String[])this.def[i].ext);
                } else if (typ == InputData.Typ.CHECKBOX) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.CHECKBOX);
                } else if (typ == InputData.Typ.CHECKBOXTRISTATE) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.CHECKBOXTRISTATE);
                } else if (typ == InputData.Typ.EXECSTRING) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.EXECLINK);
                    this.ltf.lbl.setData((Object)i);
                    this.ltf.lbl.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            Label l = (Label)e.getSource();
                            int i = (Integer)l.getData();
                            ((IExecLinkProvider)def[i].ext).executeString(def[i]);
                            super.mouseDown(e);
                        }
                    });
                } else if (typ == InputData.Typ.COMBO_VIEWER) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.COMBO_VIEWER);
                    this.ltf.getViewer().setContentProvider(this.def[i].contentProvider);
                    this.ltf.getViewer().setLabelProvider((IBaseLabelProvider)this.def[i].labelProvider);
                    this.ltf.getViewer().setInput(this.def[i].ext);
                } else if (typ == InputData.Typ.HYPERLINK) {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, Typ.LINK);
                    this.ltf.lbl.setData((Object)i);
                    this.ltf.lbl.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            Label l = (Label)e.getSource();
                            int i = (Integer)l.getData();
                            ((IContentProvider)def[i].ext).reloadContent(act, def[i]);
                            super.mouseDown(e);
                        }
                    });
                    ((Text)this.ltf.ctl).setEditable(false);
                } else {
                    this.ltf = this.addComponent(this.def[i].sAnzeige, this.def[i].sLimit);
                }
                this.def[i].setParent(this.ltf);
                this.cFields[i] = this.ltf.getControl();
                this.cFields[i].addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        if (act != null) {
                            Control src = (Control)e.getSource();
                            InputData inp = (InputData)src.getData();
                            this.save(inp);
                        }
                    }
                });
                this.cFields[i].setData((Object)this.def[i]);
                ++i;
            }
        }

        public void save() {
            InputData[] inputDataArray = this.def;
            int n = this.def.length;
            int n2 = 0;
            while (n2 < n) {
                InputData id = inputDataArray[n2];
                this.save(id);
                ++n2;
            }
        }

        protected void save(InputData inp) {
            if (this.act == null) {
                return;
            }
            String val = "";
            switch (inp.tFeldTyp) {
                case STRING: 
                case INT: 
                case DATE: 
                case COMBO: 
                case EXECSTRING: 
                case COMBO_VIEWER: {
                    val = inp.getText();
                    break;
                }
                case CURRENCY: {
                    try {
                        Money money = new Money(inp.getText());
                        val = money.getCentsAsString();
                    }
                    catch (ParseException e1) {
                        ExHandler.handle((Throwable)e1);
                        val = "";
                    }
                    break;
                }
                case LIST: {
                    val = inp.getText();
                    break;
                }
                case CHECKBOX: {
                    val = ((Button)inp.mine.getControl()).getSelection() ? "1" : "0";
                    break;
                }
                case CHECKBOXTRISTATE: {
                    val = ((TristateCheckbox)inp.mine.getControl()).getTristateDbValue();
                    break;
                }
                case HYPERLINK: {
                    return;
                }
            }
            if (inp.sHashname == null) {
                try {
                    this.set(this.act, inp.sFeldname, val);
                }
                catch (PersistenceException pe) {
                    logger.error("Could not persist [" + val + "] for field [" + inp.sAnzeige + "]\nCause: " + pe.getCause().getMessage(), (Throwable)pe);
                    if (inp.tFeldTyp.equals((Object)InputData.Typ.STRING)) {
                        PersistentObject.clearCache();
                        inp.mine.setText((String)this.get(this.act, inp.sFeldname));
                    }
                }
            } else if (val != null) {
                if (this.act instanceof WithExtInfo) {
                    if (!val.equals(((WithExtInfo)this.act).getExtInfo((Object)inp.sHashname))) {
                        ((WithExtInfo)this.act).setExtInfo((Object)inp.sHashname, (Object)val);
                    }
                } else {
                    Map ext = this.getMap(this.act, inp.sFeldname);
                    if (!val.equals(ext.get(inp.sHashname))) {
                        ext.put(inp.sHashname, val);
                        this.setMap(this.act, inp.sFeldname, ext);
                    }
                }
            }
            if (this.act instanceof Identifiable && this.modelService != null) {
                this.modelService.save((Identifiable)this.act);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", this.act);
            } else if (this.act instanceof PersistentObject) {
                ElexisEventDispatcher.update((PersistentObject)((PersistentObject)this.act));
            }
        }

        private void set(Object object, String field, Object value) {
            if (object instanceof PersistentObject) {
                ((PersistentObject)object).set(field, (String)value);
            } else {
                try {
                    BeanUtils.setProperty((Object)object, (String)field, (Object)value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error setting property [" + field + "] of [" + object + "]", (Throwable)e);
                }
            }
        }

        private Object get(Object object, String field) {
            if (object instanceof PersistentObject) {
                return ((PersistentObject)object).get(field);
            }
            try {
                return BeanUtils.getProperty((Object)object, (String)field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting property [" + field + "] of [" + object + "]", (Throwable)e);
                return null;
            }
        }

        private Map getMap(Object object, String field) {
            if (object instanceof PersistentObject) {
                return ((PersistentObject)object).getMap(field);
            }
            try {
                Object value = PropertyUtils.getProperty((Object)object, (String)field);
                if (value instanceof Map) {
                    return (Map)value;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting map property [" + field + "] of [" + object + "]", (Throwable)e);
            }
            return null;
        }

        private void setMap(Object object, String field, Map value) {
            if (object instanceof PersistentObject) {
                ((PersistentObject)object).setMap(field, value);
            } else {
                try {
                    PropertyUtils.setProperty((Object)object, (String)field, (Object)value);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error setting map property [" + field + "] of [" + object + "]", (Throwable)e);
                }
            }
        }

        public void reload(PersistentObject o) {
            this.act = o;
            if (o == null) {
                int i = 0;
                while (i < this.def.length) {
                    this.def[i].setText("");
                    ++i;
                }
                return;
            }
            this.act = o;
            String val = "";
            int i = 0;
            while (i < this.def.length) {
                if (this.def[i].tFeldTyp == InputData.Typ.HYPERLINK) {
                    ((IContentProvider)this.def[i].ext).displayContent(o, this.def[i]);
                } else {
                    if (this.def[i].sHashname == null) {
                        val = o.get(this.def[i].sFeldname);
                    } else {
                        Map ext = o.getMap(this.def[i].sFeldname);
                        val = (String)ext.get(this.def[i].sHashname);
                        if (val == null && (val = o.get(this.def[i].sHashname)).startsWith("**ERROR:")) {
                            val = null;
                        }
                    }
                    switch (this.def[i].tFeldTyp) {
                        case STRING: 
                        case INT: 
                        case LIST: 
                        case DATE: 
                        case COMBO: 
                        case EXECSTRING: {
                            if (StringTool.isNothing((Object)val)) {
                                val = "";
                            }
                            this.def[i].setText(val);
                            break;
                        }
                        case CURRENCY: {
                            Money money = new Money(PersistentObject.checkZero((Object)val));
                            this.def[i].setText(money.getAmountAsString());
                            break;
                        }
                        case CHECKBOX: {
                            val = StringTool.unNull((String)val);
                            ((Button)this.def[i].mine.getControl()).setSelection(val.equalsIgnoreCase("1"));
                            break;
                        }
                        case CHECKBOXTRISTATE: {
                            val = StringTool.unNull((String)val);
                            ((TristateCheckbox)this.def[i].mine.getControl()).setTristateDbValue(val);
                            break;
                        }
                        case COMBO_VIEWER: {
                            StructuredSelection selection = this.def[i].selectionResolver.resolveStructuredSelection(val);
                            this.def[i].mine.getViewer().setSelection((ISelection)selection);
                        }
                    }
                }
                ++i;
            }
        }

        public void reload(Identifiable o) {
            this.act = o;
            if (o == null) {
                int i = 0;
                while (i < this.def.length) {
                    this.def[i].setText("");
                    ++i;
                }
                return;
            }
            this.act = o;
            String val = "";
            int i = 0;
            while (i < this.def.length) {
                if (this.def[i].tFeldTyp == InputData.Typ.HYPERLINK) {
                    ((IContentProvider)this.def[i].ext).displayContent(o, this.def[i]);
                } else {
                    if (this.def[i].sHashname == null) {
                        val = (String)this.get(o, this.def[i].sFeldname);
                    } else if (this.act instanceof WithExtInfo) {
                        val = (String)((WithExtInfo)this.act).getExtInfo((Object)this.def[i].sHashname);
                    } else {
                        Map ext = this.getMap(o, this.def[i].sFeldname);
                        val = (String)ext.get(this.def[i].sHashname);
                        if (val == null && (val = (String)this.get(o, this.def[i].sHashname)).startsWith("**ERROR:")) {
                            val = null;
                        }
                    }
                    switch (this.def[i].tFeldTyp) {
                        case STRING: 
                        case INT: 
                        case LIST: 
                        case DATE: 
                        case COMBO: 
                        case EXECSTRING: {
                            if (StringTool.isNothing((Object)val)) {
                                val = "";
                            }
                            this.def[i].setText(val);
                            break;
                        }
                        case CURRENCY: {
                            Money money;
                            if (val != null && (val.contains(",") || val.contains("."))) {
                                val = val.replaceAll(",", ".");
                                money = new Money(PersistentObject.checkZeroDouble((String)val));
                                this.def[i].setText(money.getAmountAsString());
                                break;
                            }
                            money = new Money(PersistentObject.checkZero((Object)val));
                            this.def[i].setText(money.getAmountAsString());
                            break;
                        }
                        case CHECKBOX: {
                            val = StringTool.unNull((String)val);
                            ((Button)this.def[i].mine.getControl()).setSelection(val.equalsIgnoreCase("1"));
                            break;
                        }
                        case CHECKBOXTRISTATE: {
                            val = StringTool.unNull((String)val);
                            ((TristateCheckbox)this.def[i].mine.getControl()).setTristateDbValue(val);
                            break;
                        }
                        case COMBO_VIEWER: {
                            StructuredSelection selection = this.def[i].selectionResolver.resolveStructuredSelection(val);
                            this.def[i].mine.getViewer().setSelection((ISelection)selection);
                        }
                    }
                }
                ++i;
            }
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            InputData[] inputDataArray = this.def;
            int n = this.def.length;
            int n2 = 0;
            while (n2 < n) {
                InputData id = inputDataArray[n2];
                id.setEditable(unlocked);
                ++n2;
            }
        }
    }

    public static interface IContentProvider {
        public void displayContent(Object var1, InputData var2);

        public void reloadContent(Object var1, InputData var2);
    }

    public static interface IExecLinkProvider {
        public void executeString(InputData var1);
    }

    public static interface IStructuredSelectionResolver {
        public StructuredSelection resolveStructuredSelection(String var1);
    }

    public static class InputData {
        String sAnzeige;
        String sFeldname;
        String sHashname;
        Typ tFeldTyp;
        Object ext;
        LabeledInputField mine;
        int sLimit;
        private org.eclipse.jface.viewers.IContentProvider contentProvider;
        private ILabelProvider labelProvider;
        private IStructuredSelectionResolver selectionResolver;

        public InputData(String anzeige, String feldname, Typ feldtyp, String hashname) {
            this(anzeige, feldname, feldtyp, hashname, Text.LIMIT);
        }

        public InputData(String anzeige, String feldname, Typ feldtyp, String hashname, int limit) {
            this.sAnzeige = anzeige;
            this.sFeldname = feldname;
            this.tFeldTyp = feldtyp;
            this.sHashname = hashname;
            this.sLimit = limit;
        }

        public InputData(String all) {
            this(all, all, Typ.STRING, null, Text.LIMIT);
        }

        public InputData(String anzeige, String feldname, IContentProvider cp) {
            this.sAnzeige = anzeige;
            this.sFeldname = feldname;
            this.ext = cp;
            this.tFeldTyp = Typ.HYPERLINK;
            this.sLimit = Text.LIMIT;
        }

        public InputData(String anzeige, String feldname, String hashname, Typ typ, org.eclipse.jface.viewers.IContentProvider contentProvider, ILabelProvider labelProvider, IStructuredSelectionResolver selectionResolver, Object input) {
            this.sAnzeige = anzeige;
            this.sFeldname = feldname;
            this.sHashname = hashname;
            this.ext = input;
            this.tFeldTyp = typ;
            this.contentProvider = contentProvider;
            this.labelProvider = labelProvider;
            this.selectionResolver = selectionResolver;
        }

        public InputData(String anzeige, String feldname, IExecLinkProvider cp) {
            this(anzeige, feldname, Typ.EXECSTRING, null, Text.LIMIT);
            this.ext = cp;
        }

        public InputData(String anzeige, String feldname, String hashname, String[] choices) {
            this(anzeige, feldname, Typ.LIST, hashname, Text.LIMIT);
            this.ext = choices;
        }

        public InputData(String anzeige, String feldname, String hashname, String[] comboItems, boolean bDropDown) {
            this(anzeige, feldname, Typ.COMBO, hashname, Text.LIMIT);
            this.ext = comboItems;
        }

        public void setParent(LabeledInputField p) {
            this.mine = p;
        }

        public void setLabel(String lbl) {
            if (this.mine != null) {
                this.mine.setLabel(lbl);
            }
        }

        public String getLabel() {
            return this.mine == null ? "" : this.mine.getLabel();
        }

        public String getText() {
            return this.mine == null ? "" : this.mine.getText();
        }

        public void setText(String t) {
            if (this.mine != null) {
                this.mine.setText(t);
            }
        }

        public LabeledInputField getWidget() {
            return this.mine;
        }

        public void setEditable(boolean ed) {
            this.mine.lbl.setEnabled(ed);
            if (this.tFeldTyp == Typ.EXECSTRING || this.tFeldTyp == Typ.HYPERLINK) {
                this.mine.lbl.setEnabled(true);
                ((Text)this.mine.ctl).setEnabled(ed);
                return;
            }
            if (this.mine.ctl instanceof Text) {
                ((Text)this.mine.ctl).setEditable(ed);
            } else {
                this.mine.ctl.setEnabled(ed);
            }
        }

        public void setChoices(String ... strings) {
            this.ext = strings;
        }

        public void setTooltipText(String label) {
            if (this.mine != null && this.mine.ctl != null) {
                this.mine.ctl.setToolTipText(label);
            }
        }

        public static enum Typ {
            STRING,
            INT,
            CURRENCY,
            LIST,
            HYPERLINK,
            DATE,
            COMBO,
            EXECSTRING,
            CHECKBOX,
            CHECKBOXTRISTATE,
            COMBO_VIEWER;

        }
    }

    public static class Tableau
    extends Composite {
        protected IModelService modelService;

        public Tableau(Composite parent, int minColumns, int maxColumns) {
            super(parent, 2048);
            ColumnLayout cl = new ColumnLayout();
            cl.maxNumColumns = maxColumns;
            cl.minNumColumns = minColumns;
            this.setLayout((Layout)cl);
        }

        public Tableau(Composite parent) {
            this(parent, 1, 5);
        }

        public LabeledInputField addComponent(String l) {
            return new LabeledInputField(this, l);
        }

        public LabeledInputField addComponent(String l, Typ typ) {
            return new LabeledInputField((Composite)this, l, typ);
        }

        public LabeledInputField addComponent(String l, int limit) {
            return new LabeledInputField((Composite)this, l, limit);
        }

        public void setModelService(IModelService modelService) {
            this.modelService = modelService;
        }
    }

    public static enum Typ {
        TEXT,
        CHECKBOX,
        CHECKBOXTRISTATE,
        LIST,
        LINK,
        OBSOLETE_DATE,
        MONEY,
        COMBO,
        EXECLINK,
        COMBO_VIEWER;

    }
}

