/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.exchange.ExchangeException;
import ch.elexis.core.ui.exchange.IDataReceiver;
import ch.elexis.core.ui.exchange.IExchangeContributor;
import ch.elexis.core.ui.exchange.XChangeContainer;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.util.Log;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class XChangeImporter
implements IDataReceiver {
    private final XChangeContainer container = new XChangeContainer();
    private final Log log = Log.get("xChange Importer");

    @Override
    public Result finalizeImport() {
        return null;
    }

    @Override
    public Result<Object> load(Element input, Object context) {
        return null;
    }

    public IExchangeContributor findImportHandler(XChangeElement el) {
        int matchedRestrictions = 0;
        IConfigurationElement cand = null;
        for (IConfigurationElement ice : this.container.getXChangeContributors()) {
            String restriction;
            String datatype = ice.getAttribute("ElementType");
            if (!datatype.equalsIgnoreCase(el.getXMLName())) continue;
            if (cand == null) {
                cand = ice;
            }
            if ((restriction = ice.getAttribute("restrictions")) != null) {
                String[] restrictions = restriction.split(",");
                int matches = 0;
                String[] stringArray = restrictions;
                int n = restrictions.length;
                int n2 = 0;
                while (n2 < n) {
                    String r = stringArray[n2];
                    try {
                        XPath xpath = XPath.newInstance((String)r);
                        List nodes = xpath.selectNodes((Object)el);
                        if (nodes.size() > 0) {
                            if (++matches > matchedRestrictions) {
                                cand = ice;
                                matchedRestrictions = matches;
                            } else if (matches == matchedRestrictions && this.compareValues(ice, cand) == -1) {
                                cand = ice;
                            }
                        }
                    }
                    catch (JDOMException e) {
                        ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.ui", 0, "Parse error JDOM: " + e.getMessage(), (Exception)((Object)e), 3);
                        throw new ExchangeException((IStatus)status);
                    }
                    ++n2;
                }
                continue;
            }
            if (this.compareValues(ice, cand) != -1) continue;
            cand = ice;
        }
        if (cand != null) {
            try {
                return (IExchangeContributor)cand.createExecutableExtension("Actor");
            }
            catch (CoreException ce) {
                ExHandler.handle((Throwable)ce);
            }
        }
        return null;
    }

    int compareValues(IConfigurationElement ic1, IConfigurationElement ic2) {
        int r1 = 0;
        int r2 = 0;
        String v1 = ic1.getAttribute("value");
        String v2 = ic2.getAttribute("value");
        if (v1 != null && v1.matches("[0-9]+")) {
            r1 = Integer.parseInt(v1);
        }
        if (v2 != null && v2.matches("[0-9]+")) {
            r2 = Integer.parseInt(v2);
        }
        if (r1 == r2) {
            return 0;
        }
        return r1 > r2 ? -1 : 1;
    }

    public void addBinary(String id, byte[] cnt) {
        this.container.binFiles.put(id, cnt);
    }

    public XChangeContainer getContainer() {
        return this.container;
    }

    public boolean load(String input) {
        SAXBuilder builder = new SAXBuilder();
        try {
            CharArrayReader car = new CharArrayReader(input.toCharArray());
            this.container.setDocument(builder.build((Reader)car));
            this.container.setValid(true);
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            this.container.setValid(false);
        }
        return this.container.isValid();
    }
}

